/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.cidr.cpp.lexer;

import fleet.com.intellij.lexer.LexerBase;
import fleet.com.intellij.lexer.StringLiteralLexer;
import fleet.com.intellij.openapi.diagnostic.Logger;
import fleet.com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrPrefixStringLiteralLexer
extends LexerBase {
    private static final Logger LOG = Logger.getInstance(StringLiteralLexer.class);
    private static final short PREFIX = 99;
    private static final short AFTER_PREFIX = 100;
    public static final char NO_QUOTE_CHAR = '\uffff';
    private CharSequence myBuffer;
    private int myStart;
    private int myEnd;
    private int myState;
    private int myLastState;
    private int myBufferEnd;
    private final char myPrefixStopChar;
    private final LexerBase myRestLexer;
    private final IElementType myPrefixLiteralToken;

    public CidrPrefixStringLiteralLexer(char prefixStopChar, @NotNull IElementType prefixLiteralToken, @NotNull LexerBase restLexer) {
        this.myPrefixStopChar = prefixStopChar;
        this.myPrefixLiteralToken = prefixLiteralToken;
        this.myRestLexer = restLexer;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer.length() < endOffset) {
            LOG.error("buffer Length: " + buffer.length() + ", endOffset: " + endOffset, new Throwable(), new String[0]);
        }
        this.myBuffer = buffer;
        this.myStart = startOffset;
        this.myBufferEnd = endOffset;
        this.myLastState = initialState;
        this.myEnd = this.myStart;
        if (this.myPrefixStopChar != '\uffff') {
            while (this.myEnd < this.myBufferEnd && this.myBuffer.charAt(this.myEnd) != this.myPrefixStopChar) {
                ++this.myEnd;
            }
        }
        this.myState = 99;
        if (this.myEnd == this.myStart) {
            this.advance();
        }
    }

    public int getState() {
        return this.myState == 100 ? this.myRestLexer.getState() : this.myLastState;
    }

    @Nullable
    public IElementType getTokenType() {
        return this.myState == 100 ? this.myRestLexer.getTokenType() : this.myPrefixLiteralToken;
    }

    public int getTokenStart() {
        return this.myState == 100 ? this.myRestLexer.getTokenStart() : this.myStart;
    }

    public int getTokenEnd() {
        return this.myState == 100 ? this.myRestLexer.getTokenEnd() : this.myEnd;
    }

    public void advance() {
        if (this.myState == 100) {
            this.myRestLexer.advance();
        } else if (this.myState == 99) {
            this.myRestLexer.start(this.myBuffer, this.myEnd, this.myBufferEnd, this.myLastState);
            this.myState = 100;
        }
    }

    @NotNull
    public CharSequence getBufferSequence() {
        return this.myBuffer;
    }

    public int getBufferEnd() {
        return this.myBufferEnd;
    }
}

