/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.lang.enterHandler;

import fleet.frontend.lang.enterHandler.BraceEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB7\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\tj\u0002`\u0010J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c2\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c2\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c2\u0003J\t\u0010\u0014\u001a\u00020\tH\u00c6\u0003JC\u0010\u0015\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Lfleet/frontend/lang/enterHandler/BraceStorage;", "", "braces", "", "Lfleet/frontend/lang/enterHandler/BraceEvent;", "openingBalance", "", "closingBalance", "timestamp", "", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;J)V", "getTimestamp", "()J", "balanceAtOffset", "", "offset", "Lfleet/com/jetbrains/lang/syntax/CharOffset;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "fleet.frontend.lang"})
@SourceDebugExtension(value={"SMAP\nEnterAfterUnmatchedBraceHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnterAfterUnmatchedBraceHandler.kt\nfleet/frontend/lang/enterHandler/BraceStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,347:1\n1#2:348\n*E\n"})
final class BraceStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<BraceEvent> braces;
    @NotNull
    private final List<Byte> openingBalance;
    @NotNull
    private final List<Byte> closingBalance;
    private final long timestamp;
    @NotNull
    private static final BraceStorage Empty = new BraceStorage(CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), -1L);

    public BraceStorage(@NotNull List<BraceEvent> braces, @NotNull List<Byte> openingBalance, @NotNull List<Byte> closingBalance, long timestamp) {
        Intrinsics.checkNotNullParameter(braces, (String)"braces");
        Intrinsics.checkNotNullParameter(openingBalance, (String)"openingBalance");
        Intrinsics.checkNotNullParameter(closingBalance, (String)"closingBalance");
        this.braces = braces;
        this.openingBalance = openingBalance;
        this.closingBalance = closingBalance;
        this.timestamp = timestamp;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final int balanceAtOffset(long offset) {
        int n;
        if (this == Empty) {
            return -1;
        }
        int l = -1;
        int r = this.braces.size();
        while (r - l > 1) {
            int m = (l + r) / 2;
            if (this.braces.get(m).getOffset() >= offset) {
                r = m;
                continue;
            }
            l = m;
        }
        if (l == -1) {
            n = -1;
        } else {
            Byte by;
            int n2 = ((Number)this.openingBalance.get(l)).intValue();
            List<Byte> list = this.closingBalance;
            int n3 = l + 1;
            if (n3 >= 0 && n3 <= CollectionsKt.getLastIndex(list)) {
                by = list.get(n3);
            } else {
                int n4 = n3;
                int n5 = n2;
                boolean bl = false;
                Byte by2 = 0;
                n2 = n5;
                by = by2;
            }
            n = RangesKt.coerceAtLeast((int)(n2 - ((Number)by).intValue()), (int)0);
        }
        return n;
    }

    private final List<BraceEvent> component1() {
        return this.braces;
    }

    private final List<Byte> component2() {
        return this.openingBalance;
    }

    private final List<Byte> component3() {
        return this.closingBalance;
    }

    public final long component4() {
        return this.timestamp;
    }

    @NotNull
    public final BraceStorage copy(@NotNull List<BraceEvent> braces, @NotNull List<Byte> openingBalance, @NotNull List<Byte> closingBalance, long timestamp) {
        Intrinsics.checkNotNullParameter(braces, (String)"braces");
        Intrinsics.checkNotNullParameter(openingBalance, (String)"openingBalance");
        Intrinsics.checkNotNullParameter(closingBalance, (String)"closingBalance");
        return new BraceStorage(braces, openingBalance, closingBalance, timestamp);
    }

    public static /* synthetic */ BraceStorage copy$default(BraceStorage braceStorage, List list, List list2, List list3, long l, int n, Object object) {
        if ((n & 1) != 0) {
            list = braceStorage.braces;
        }
        if ((n & 2) != 0) {
            list2 = braceStorage.openingBalance;
        }
        if ((n & 4) != 0) {
            list3 = braceStorage.closingBalance;
        }
        if ((n & 8) != 0) {
            l = braceStorage.timestamp;
        }
        return braceStorage.copy(list, list2, list3, l);
    }

    @NotNull
    public String toString() {
        return "BraceStorage(braces=" + this.braces + ", openingBalance=" + this.openingBalance + ", closingBalance=" + this.closingBalance + ", timestamp=" + this.timestamp + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.braces).hashCode();
        result2 = result2 * 31 + ((Object)this.openingBalance).hashCode();
        result2 = result2 * 31 + ((Object)this.closingBalance).hashCode();
        result2 = result2 * 31 + Long.hashCode(this.timestamp);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BraceStorage)) {
            return false;
        }
        BraceStorage braceStorage = (BraceStorage)other;
        if (!Intrinsics.areEqual(this.braces, braceStorage.braces)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.openingBalance, braceStorage.openingBalance)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.closingBalance, braceStorage.closingBalance)) {
            return false;
        }
        return this.timestamp == braceStorage.timestamp;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lfleet/frontend/lang/enterHandler/BraceStorage$Companion;", "", "()V", "Empty", "Lfleet/frontend/lang/enterHandler/BraceStorage;", "getEmpty", "()Lfleet/frontend/lang/enterHandler/BraceStorage;", "fleet.frontend.lang"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BraceStorage getEmpty() {
            return Empty;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

