/*
 * Decompiled with CFR 0.152.
 */
package fleet.dock.bootstrap;

import java.nio.file.Path;

public class UserHome {
    private UserHome() {
    }

    public static Path getUserHome() {
        return CacheUserHome.cachedUserHome;
    }

    private static class CacheUserHome {
        private static final Path cachedUserHome = CacheUserHome.calculateUserHome();

        private CacheUserHome() {
        }

        private static Path calculateUserHome() {
            String userHomeProperty = System.getProperty("user.home");
            if (userHomeProperty != null) {
                return Path.of(userHomeProperty, new String[0]).normalize();
            }
            throw new RuntimeException("Cannot find `user.home` directory");
        }
    }
}

