/*
 * Decompiled with CFR 0.152.
 */
package fleet.dock.bootstrap;

import fleet.dock.bootstrap.FleetBootstrapFromSourcesPaths;
import fleet.dock.bootstrap.FleetBootstrapProperties;
import fleet.util.os.Os;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record FleetDistributionLayout(@Nullable Path installationDirectory, @Nullable Path appDirectory, @NotNull Path bootstrapDirectory, @NotNull Path bundledCodeCacheDirectory, @Nullable Path jnaLibraryFile, @NotNull Path librariesDirectory, @Nullable Path extensionsDirectory, @NotNull Path launcherFile, @NotNull Path printenvFile, @NotNull Path keymapFile) {
    @NotNull
    private final Path bootstrapDirectory;
    @NotNull
    private final Path bundledCodeCacheDirectory;
    @NotNull
    private final Path librariesDirectory;
    @NotNull
    private final Path launcherFile;
    @NotNull
    private final Path printenvFile;
    @NotNull
    private final Path keymapFile;

    public FleetDistributionLayout(@Nullable Path installationDirectory, @Nullable Path appDirectory, @NotNull Path bootstrapDirectory, @NotNull Path bundledCodeCacheDirectory, @Nullable Path jnaLibraryFile, @NotNull Path librariesDirectory, @Nullable Path extensionsDirectory, @NotNull Path launcherFile, @NotNull Path printenvFile, @NotNull Path keymapFile) {
        if (bootstrapDirectory == null) {
            FleetDistributionLayout.$$$reportNull$$$0(0);
        }
        if (bundledCodeCacheDirectory == null) {
            FleetDistributionLayout.$$$reportNull$$$0(1);
        }
        if (librariesDirectory == null) {
            FleetDistributionLayout.$$$reportNull$$$0(2);
        }
        if (launcherFile == null) {
            FleetDistributionLayout.$$$reportNull$$$0(3);
        }
        if (printenvFile == null) {
            FleetDistributionLayout.$$$reportNull$$$0(4);
        }
        if (keymapFile == null) {
            FleetDistributionLayout.$$$reportNull$$$0(5);
        }
    }

    @NotNull
    public static FleetDistributionLayout create() {
        Path appDirectory = FleetDistributionLayout.findAppDirectory();
        if (!FleetBootstrapFromSourcesPaths.isRunningFromSources() && appDirectory == null) {
            throw new IllegalArgumentException("Cannot run Fleet without distribution directory while running not from sources");
        }
        Path installationDirectory = FleetDistributionLayout.findInstallationDirectory(appDirectory);
        Path librariesDirectory = FleetDistributionLayout.findLibrariesDirectory(appDirectory);
        return new FleetDistributionLayout(installationDirectory, appDirectory, FleetDistributionLayout.findBootstrapDirectory(appDirectory), FleetDistributionLayout.findBundledCodeCacheDirectory(appDirectory), FleetDistributionLayout.findJnaLibraryFile(librariesDirectory), librariesDirectory, FleetDistributionLayout.findExtensionsDirectory(appDirectory), FleetDistributionLayout.findLauncherFile(appDirectory), FleetDistributionLayout.findPrintEnvFile(appDirectory), FleetDistributionLayout.findKeymapFile(appDirectory));
    }

    private static Path findAppDirectory() {
        String appDir = FleetBootstrapProperties.fleetProperty("fleet.distribution.app.directory");
        if (appDir != null) {
            return Path.of(appDir, new String[0]).toAbsolutePath().normalize();
        }
        if (FleetBootstrapProperties.isFleetDistributionMode()) {
            try {
                boolean isCrossPlatformDistribution;
                Path executablePath = Path.of(ProcessHandle.current().info().command().get(), new String[0]).toRealPath(new LinkOption[0]);
                String fileName = executablePath.getFileName().toString();
                boolean bl = isCrossPlatformDistribution = "java".equals(fileName) || "java.exe".equals(fileName);
                if (isCrossPlatformDistribution) {
                    URL classUrl = FleetDistributionLayout.class.getResource("/" + FleetDistributionLayout.class.getName().replace('.', '/') + ".class");
                    if (classUrl == null) {
                        throw new RuntimeException("Cannot find class in cross-platform distribution running with `" + executablePath + "`");
                    }
                    if (!"jar".equals(classUrl.getProtocol())) {
                        throw new RuntimeException("Cannot find jar for class $classUrl for cross-platform distribution running with `" + executablePath + "`");
                    }
                    String path = classUrl.getFile();
                    int exclamationOffset = path.indexOf(33);
                    URI uri = new URL(exclamationOffset != -1 ? path.substring(0, exclamationOffset) : path).toURI();
                    return Path.of(uri).getParent().getParent().getParent();
                }
                throw new RuntimeException("Cannot find dock distribution running with `" + executablePath + "`. Expected `java` binary to be used or `fleet.distribution.app.directory` system property to be set");
            }
            catch (IOException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Nullable
    private static Path findInstallationDirectory(@Nullable Path appDirectory) {
        if (FleetBootstrapFromSourcesPaths.isRunningFromSources() || appDirectory == null) {
            return null;
        }
        if (Os.INSTANCE.isWindows()) {
            return appDirectory.getParent();
        }
        return appDirectory.getParent().getParent();
    }

    private static Path findBootstrapDirectory(Path appDirectory) {
        String fromProperties = FleetBootstrapProperties.fleetProperty("fleet.bootstrap.path");
        if (fromProperties != null) {
            return Path.of(fromProperties, new String[0]).toAbsolutePath().normalize();
        }
        if (FleetBootstrapFromSourcesPaths.isRunningFromSources()) {
            return FleetBootstrapFromSourcesPaths.getBootstrapDirectory();
        }
        return appDirectory.resolve("bootstrap");
    }

    private static Path findBundledCodeCacheDirectory(Path appDirectory) {
        String fromProperties = FleetBootstrapProperties.fleetProperty("fleet.code.cache.path");
        if (fromProperties != null) {
            return Path.of(fromProperties, new String[0]).toAbsolutePath().normalize();
        }
        if (FleetBootstrapFromSourcesPaths.isRunningFromSources()) {
            return FleetBootstrapFromSourcesPaths.getBundledCodeCacheDirectory();
        }
        return appDirectory.resolve("code-cache");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static Path findJnaLibraryFile(Path libsDirectory) {
        try (DirectoryStream<Path> children = Files.newDirectoryStream(libsDirectory, entry -> {
            String name = entry.getFileName().toString();
            return name.startsWith("libjnidispatch") || name.startsWith("jnidispatch");
        });){
            Iterator<Path> iterator = children.iterator();
            if (iterator.hasNext()) {
                Path result = iterator.next();
                if (iterator.hasNext()) {
                    throw new RuntimeException("Distribution contains more than one jna library file [" + result.getFileName() + ", " + iterator.next().getFileName() + "]");
                }
                Path path2 = result;
                return path2;
            }
            if (!FleetBootstrapFromSourcesPaths.isRunningFromSources()) {
                throw new RuntimeException("Distribution doesn't contain jna library file: " + libsDirectory);
            }
            Path path = null;
            return path;
        }
        catch (IOException e) {
            if (!FleetBootstrapFromSourcesPaths.isRunningFromSources()) throw new RuntimeException("Cannot list libs directory: " + libsDirectory, e);
            return null;
        }
    }

    @NotNull
    private static Path findLibrariesDirectory(Path appDirectory) {
        String fromProperties = FleetBootstrapProperties.fleetProperty("fleet.libs.path");
        if (fromProperties != null) {
            Path path = Path.of(fromProperties, new String[0]).toAbsolutePath().normalize();
            if (path == null) {
                FleetDistributionLayout.$$$reportNull$$$0(6);
            }
            return path;
        }
        Path path = FleetBootstrapFromSourcesPaths.isRunningFromSources() ? FleetBootstrapFromSourcesPaths.getLibsDirectory() : appDirectory.resolve("libs");
        if (path == null) {
            FleetDistributionLayout.$$$reportNull$$$0(7);
        }
        return path;
    }

    @Nullable
    private static Path findExtensionsDirectory(@Nullable Path appDirectory) {
        return FleetBootstrapFromSourcesPaths.isRunningFromSources() || appDirectory == null || !Os.INSTANCE.isWindows() ? null : appDirectory.resolve("extensions");
    }

    private static Path findLauncherFile(Path appDirectory) {
        String fromProperties = FleetBootstrapProperties.fleetProperty("fleet.launcher.path");
        if (fromProperties != null) {
            return Path.of(fromProperties, new String[0]).toAbsolutePath().normalize();
        }
        if (FleetBootstrapFromSourcesPaths.isRunningFromSources()) {
            return FleetBootstrapFromSourcesPaths.getLauncherFile();
        }
        if (Os.INSTANCE.isWindows()) {
            return appDirectory.resolve("bin/fleet.exe");
        }
        return appDirectory.resolve("bin/fleet");
    }

    private static Path findPrintEnvFile(Path appDirectory) {
        String fromProperties = FleetBootstrapProperties.fleetProperty("fleet.printenv.path");
        if (fromProperties != null) {
            return Path.of(fromProperties, new String[0]).toAbsolutePath().normalize();
        }
        if (FleetBootstrapFromSourcesPaths.isRunningFromSources()) {
            return FleetBootstrapFromSourcesPaths.getPrintEnvFile();
        }
        if (Os.INSTANCE.isWindows()) {
            return appDirectory.resolve("bin/printenv.exe");
        }
        return appDirectory.resolve("bin/printenv");
    }

    private static Path findKeymapFile(Path appDirectory) {
        if (FleetBootstrapFromSourcesPaths.isRunningFromSources()) {
            return FleetBootstrapFromSourcesPaths.getKeymapFile();
        }
        return appDirectory.resolve("keymaps/keymap.pdf");
    }

    @NotNull
    public Path bootstrapDirectory() {
        Path path = this.bootstrapDirectory;
        if (path == null) {
            FleetDistributionLayout.$$$reportNull$$$0(8);
        }
        return path;
    }

    @NotNull
    public Path bundledCodeCacheDirectory() {
        Path path = this.bundledCodeCacheDirectory;
        if (path == null) {
            FleetDistributionLayout.$$$reportNull$$$0(9);
        }
        return path;
    }

    @NotNull
    public Path librariesDirectory() {
        Path path = this.librariesDirectory;
        if (path == null) {
            FleetDistributionLayout.$$$reportNull$$$0(10);
        }
        return path;
    }

    @NotNull
    public Path launcherFile() {
        Path path = this.launcherFile;
        if (path == null) {
            FleetDistributionLayout.$$$reportNull$$$0(11);
        }
        return path;
    }

    @NotNull
    public Path printenvFile() {
        Path path = this.printenvFile;
        if (path == null) {
            FleetDistributionLayout.$$$reportNull$$$0(12);
        }
        return path;
    }

    @NotNull
    public Path keymapFile() {
        Path path = this.keymapFile;
        if (path == null) {
            FleetDistributionLayout.$$$reportNull$$$0(13);
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bootstrapDirectory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundledCodeCacheDirectory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "librariesDirectory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcherFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printenvFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keymapFile";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fleet/dock/bootstrap/FleetDistributionLayout";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "fleet/dock/bootstrap/FleetDistributionLayout";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findLibrariesDirectory";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "bootstrapDirectory";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "bundledCodeCacheDirectory";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "librariesDirectory";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "launcherFile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "printenvFile";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "keymapFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 10, 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

