/*
 * Decompiled with CFR 0.152.
 */
package fleet.dock.bootstrap;

import fleet.dock.bootstrap.FleetBootstrapProperties;
import fleet.util.os.Os;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FleetBootstrapFromSourcesPaths {
    FleetBootstrapFromSourcesPaths() {
    }

    public static boolean isRunningFromSources() {
        return !FleetBootstrapProperties.isFleetDistributionMode() && Cache.repositoryRoot != null;
    }

    @NotNull
    private static Path getProjectRoot() {
        Path repositoryRoot = Cache.repositoryRoot;
        if (repositoryRoot == null) {
            throw new RuntimeException("Cannot find IntelliJ repository root");
        }
        Path path = repositoryRoot.toAbsolutePath().normalize().resolve("fleet");
        if (path == null) {
            FleetBootstrapFromSourcesPaths.$$$reportNull$$$0(0);
        }
        return path;
    }

    @NotNull
    public static Path getBootstrapDirectory() {
        Path path = FleetBootstrapFromSourcesPaths.getProjectRoot().resolve("build/build/localDistribution/bootstrap");
        if (path == null) {
            FleetBootstrapFromSourcesPaths.$$$reportNull$$$0(1);
        }
        return path;
    }

    @NotNull
    public static Path getBundledCodeCacheDirectory() {
        Path path = FleetBootstrapFromSourcesPaths.getProjectRoot().resolve("build/build/localDistribution/code-cache");
        if (path == null) {
            FleetBootstrapFromSourcesPaths.$$$reportNull$$$0(2);
        }
        return path;
    }

    @NotNull
    public static Path getLibsDirectory() {
        Path path = FleetBootstrapFromSourcesPaths.getProjectRoot().resolve("build/build/localDistribution/libs");
        if (path == null) {
            FleetBootstrapFromSourcesPaths.$$$reportNull$$$0(3);
        }
        return path;
    }

    @NotNull
    public static Path getLauncherFile() {
        String suffix = Os.INSTANCE.isWindows() ? ".exe" : "";
        Path path = FleetBootstrapFromSourcesPaths.getProjectRoot().resolve("build/build/localDistribution/bin/fleet" + suffix);
        if (path == null) {
            FleetBootstrapFromSourcesPaths.$$$reportNull$$$0(4);
        }
        return path;
    }

    @NotNull
    public static Path getPrintEnvFile() {
        String suffix = Os.INSTANCE.isWindows() ? ".exe" : "";
        Path path = FleetBootstrapFromSourcesPaths.getProjectRoot().resolve("build/build/localDistribution/bin/printenv" + suffix);
        if (path == null) {
            FleetBootstrapFromSourcesPaths.$$$reportNull$$$0(5);
        }
        return path;
    }

    @NotNull
    public static Path getKeymapFile() {
        String file = Os.INSTANCE.isMac() ? "macos.pdf" : "pc.pdf";
        Path path = FleetBootstrapFromSourcesPaths.getProjectRoot().resolve("resources/keymaps/" + file);
        if (path == null) {
            FleetBootstrapFromSourcesPaths.$$$reportNull$$$0(6);
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "fleet/dock/bootstrap/FleetBootstrapFromSourcesPaths";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectRoot";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBootstrapDirectory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundledCodeCacheDirectory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibsDirectory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLauncherFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrintEnvFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeymapFile";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class Cache {
        @Nullable
        private static final Path repositoryRoot = Cache.findRepositoryRoot();

        private Cache() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Nullable
        private static Path findRepositoryRoot() {
            Path directory = Cache.findFleetRootByClass();
            while (directory != null) {
                try (Stream<Path> children = Files.list(directory);){
                    Set names = children.map(Path::getFileName).map(Path::toString).collect(Collectors.toSet());
                    if (names.contains(".idea") && names.contains("fleet")) {
                        Path path = directory;
                        return path;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                directory = directory.getParent();
            }
            return null;
        }

        @Nullable
        private static Path findFleetRootByClass() {
            URL url = FleetBootstrapFromSourcesPaths.class.getResource("/" + FleetBootstrapFromSourcesPaths.class.getName().replace('.', '/') + ".class");
            if (url == null) {
                return null;
            }
            try {
                return switch (url.getProtocol()) {
                    case "file" -> Paths.get(url.toURI());
                    case "jar" -> {
                        String path = url.getFile();
                        int exclamationOffset = path.indexOf(33);
                        yield Path.of(new URL(exclamationOffset != -1 ? path.substring(0, exclamationOffset) : path).toURI());
                    }
                    default -> null;
                };
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

