/*
 * Decompiled with CFR 0.152.
 */
package noria.windowManagement.extensions;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import noria.windowManagement.api.Point;
import noria.windowManagement.api.Rectangle;
import noria.windowManagement.api.Size;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0086\u0002\u001a\u0015\u0010\u0003\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0086\u0002\u001a\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u001a\u001a\u0010\u0007\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006\u001a\u001a\u0010\u0007\u001a\u00020\n*\u00020\n2\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006\u001a\u0014\u0010\u0014\u001a\u0004\u0018\u00010\n*\u00020\n2\u0006\u0010\u0002\u001a\u00020\n\u001a\u0015\u0010\u0015\u001a\u00020\u0016*\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0001H\u0086\u0002\"\u0015\u0010\u000b\u001a\u00020\u0006*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0015\u0010\u000e\u001a\u00020\u0006*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\"\u0015\u0010\u0010\u001a\u00020\u0006*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\r\"\u0015\u0010\u0012\u001a\u00020\u0006*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\r\u00a8\u0006\u0018"}, d2={"plus", "Lnoria/windowManagement/api/Point;", "other", "minus", "times", "factor", "", "translate", "dx", "dy", "Lnoria/windowManagement/api/Rectangle;", "left", "getLeft", "(Lnoria/windowManagement/api/Rectangle;)F", "top", "getTop", "right", "getRight", "bottom", "getBottom", "intersect", "contains", "", "point", "fleet.noria.windowManagement.extensions"})
public final class PrimitivesKt {
    @NotNull
    public static final Point plus(@NotNull Point $this$plus, @NotNull Point other) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return $this$plus.getX() == 0.0f && $this$plus.getY() == 0.0f ? other : (other.getX() == 0.0f && other.getY() == 0.0f ? $this$plus : new Point($this$plus.getX() + other.getX(), $this$plus.getY() + other.getY()));
    }

    @NotNull
    public static final Point minus(@NotNull Point $this$minus, @NotNull Point other) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return other.getX() == 0.0f && other.getY() == 0.0f ? $this$minus : new Point($this$minus.getX() - other.getX(), $this$minus.getY() - other.getY());
    }

    @NotNull
    public static final Point times(@NotNull Point $this$times, float factor) {
        Intrinsics.checkNotNullParameter((Object)$this$times, (String)"<this>");
        return $this$times.copy($this$times.getX() * factor, $this$times.getY() * factor);
    }

    @NotNull
    public static final Point translate(@NotNull Point $this$translate, float dx, float dy) {
        Intrinsics.checkNotNullParameter((Object)$this$translate, (String)"<this>");
        return new Point($this$translate.getX() + dx, $this$translate.getY() + dy);
    }

    @NotNull
    public static final Rectangle translate(@NotNull Rectangle $this$translate, float dx, float dy) {
        Intrinsics.checkNotNullParameter((Object)$this$translate, (String)"<this>");
        return new Rectangle(PrimitivesKt.translate($this$translate.getOrigin(), dx, dy), $this$translate.getSize());
    }

    public static final float getLeft(@NotNull Rectangle $this$left) {
        Intrinsics.checkNotNullParameter((Object)$this$left, (String)"<this>");
        return $this$left.getOrigin().getX();
    }

    public static final float getTop(@NotNull Rectangle $this$top) {
        Intrinsics.checkNotNullParameter((Object)$this$top, (String)"<this>");
        return $this$top.getOrigin().getY();
    }

    public static final float getRight(@NotNull Rectangle $this$right) {
        Intrinsics.checkNotNullParameter((Object)$this$right, (String)"<this>");
        return $this$right.getOrigin().getX() + $this$right.getSize().getWidth();
    }

    public static final float getBottom(@NotNull Rectangle $this$bottom) {
        Intrinsics.checkNotNullParameter((Object)$this$bottom, (String)"<this>");
        return $this$bottom.getOrigin().getY() + $this$bottom.getSize().getHeight();
    }

    @Nullable
    public static final Rectangle intersect(@NotNull Rectangle $this$intersect, @NotNull Rectangle other) {
        Intrinsics.checkNotNullParameter((Object)$this$intersect, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        float left = Math.max(PrimitivesKt.getLeft($this$intersect), PrimitivesKt.getLeft(other));
        float top = Math.max(PrimitivesKt.getTop($this$intersect), PrimitivesKt.getTop(other));
        float bottom = Math.min(PrimitivesKt.getRight($this$intersect), PrimitivesKt.getRight(other));
        float right = Math.min(PrimitivesKt.getBottom($this$intersect), PrimitivesKt.getBottom(other));
        return left < right && top < bottom ? new Rectangle(new Point(left, top), new Size(right - left, bottom - top)) : null;
    }

    public static final boolean contains(@NotNull Rectangle $this$contains, @NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        float left = $this$contains.getOrigin().getX();
        float top = $this$contains.getOrigin().getY();
        float right = $this$contains.getOrigin().getX() + $this$contains.getSize().getWidth();
        float bottom = $this$contains.getOrigin().getY() + $this$contains.getSize().getHeight();
        return point.getX() >= left && point.getX() < right && point.getY() >= top && point.getY() < bottom;
    }
}

