/*
 * Decompiled with CFR 0.152.
 */
package fleet.language.go;

import andel.editor.Caret;
import andel.editor.CaretPosition;
import andel.editor.MutableDocument;
import andel.editor.MutableEditor;
import andel.operation.Operation;
import andel.operation.OperationKt;
import andel.text.Text;
import andel.text.TextLine;
import com.jetbrains.rhizomedb.DbContext;
import fleet.api.FileAddress;
import fleet.ast.AST;
import fleet.ast.NodeAspectId;
import fleet.ast.NodeAspectMap;
import fleet.ast.WhitespaceNodeAspect;
import fleet.com.goide.GoParserDefinition;
import fleet.com.goide.GoTypes;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import fleet.com.jetbrains.lang.syntax.SyntaxNodeExtKt;
import fleet.frontend.editor.editorconfig.EditorConfigExtKt;
import fleet.frontend.editor.editorconfig.EditorConfigs;
import fleet.frontend.lang.LanguageExtensionPointsKt;
import fleet.frontend.lang.aspects.AspectTreeWalkerUtilKt;
import fleet.language.go.GoKt;
import fleet.language.go.GoTypingHandler;
import fleet.language.go.GoUtilKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J.\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u001b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0004H\u0002\u00a8\u0006 "}, d2={"Lfleet/language/go/GoLParenTypingHandler;", "Lfleet/language/go/GoTypingHandler;", "()V", "findKeyword", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "text", "Landel/text/Text;", "wsAspectMap", "Lfleet/ast/NodeAspectMap;", "Lfleet/ast/WhitespaceNodeAspect;", "offset", "", "at", "findSpec", "getIndent", "", "getLastElementToInclude", "spec", "getNormalIndent", "editor", "Landel/editor/MutableEditor;", "handle", "", "caret", "Landel/editor/Caret;", "typedChar", "", "ast", "Lfleet/ast/AST;", "isApplicableFor", "isMissingRParen", "Companion", "fleet.plugins.go.frontend"})
@SourceDebugExtension(value={"SMAP\nGoTypingHandlers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoTypingHandlers.kt\nfleet/language/go/GoLParenTypingHandler\n+ 2 LanguageExtensionPoints.kt\nfleet/frontend/lang/LanguageExtensionPointsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,251:1\n56#2:252\n1#3:253\n*S KotlinDebug\n*F\n+ 1 GoTypingHandlers.kt\nfleet/language/go/GoLParenTypingHandler\n*L\n58#1:252\n*E\n"})
public final class GoLParenTypingHandler
extends GoTypingHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final TokenSet specTypes;
    @NotNull
    private static final TokenSet nextTypes;

    public GoLParenTypingHandler() {
        super(70.0);
    }

    @Override
    public boolean isApplicableFor(@NotNull MutableEditor editor, char typedChar) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (typedChar != '(') {
            return false;
        }
        return super.isApplicableFor(editor, typedChar);
    }

    @Override
    public boolean handle(@NotNull Caret caret, char typedChar, @NotNull MutableEditor editor, @Nullable AST<?> ast) {
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        long offset = caret.getOffset();
        Text text = editor.getDocument().getText();
        SyntaxNode syntaxNode = ast;
        if (syntaxNode == null || (syntaxNode = syntaxNode.root()) == null) {
            return false;
        }
        SyntaxNode root = syntaxNode;
        if (!DbContext.Companion.isBound()) {
            return false;
        }
        NodeAspectId aspect$iv = (NodeAspectId)WhitespaceNodeAspect.Id;
        boolean $i$f$getAspectMap = false;
        NodeAspectMap wsAspectMap = LanguageExtensionPointsKt.getAspectMap((NodeAspectId)aspect$iv, (KClass)Reflection.getOrCreateKotlinClass(WhitespaceNodeAspect.class));
        SyntaxNode syntaxNode2 = SyntaxNodeExtKt.leafByOffset((SyntaxNode)root, (long)offset);
        if (syntaxNode2 == null) {
            return false;
        }
        SyntaxNode leaf = syntaxNode2;
        SyntaxNode syntaxNode3 = this.findKeyword(text, (NodeAspectMap<WhitespaceNodeAspect>)wsAspectMap, offset, leaf);
        if (syntaxNode3 == null) {
            return false;
        }
        SyntaxNode keyword = syntaxNode3;
        String string = this.getIndent(text, keyword);
        if (string == null) {
            return false;
        }
        String indent = string;
        SyntaxNode syntaxNode4 = this.findSpec(leaf);
        if (syntaxNode4 == null) {
            return false;
        }
        SyntaxNode spec = syntaxNode4;
        if (!this.isMissingRParen(spec)) {
            editor.getDocument().edit(Operation.Companion.insertAt(offset, "(", text.charsCount()));
            editor.getMultiCaret().moveCarets(CollectionsKt.listOf((Object)Caret.move$default((Caret)caret, (CaretPosition)new CaretPosition(caret.getOffset() + 1L), null, (int)2, null)));
            return true;
        }
        SyntaxNode syntaxNode5 = this.getLastElementToInclude(spec);
        if (syntaxNode5 == null) {
            return false;
        }
        SyntaxNode lastElementToInclude = syntaxNode5;
        String normalIndent = this.getNormalIndent(editor);
        String openParenBlock = "(\n" + indent + normalIndent;
        editor.getDocument().edit(OperationKt.plus((Operation)Operation.Companion.replaceAt$default((Operation.Companion)Operation.Companion, (long)offset, (String)text.substring(offset, spec.getStartOffset()), (String)openParenBlock, (long)text.charsCount(), (boolean)false, (int)16, null), (Operation)Operation.Companion.insertAt(lastElementToInclude.getEndOffset(), "\n" + indent + ")", text.charsCount())));
        editor.getMultiCaret().moveCarets(CollectionsKt.listOf((Object)Caret.move$default((Caret)caret, (CaretPosition)new CaretPosition(caret.getOffset() + (long)openParenBlock.length()), null, (int)2, null)));
        return true;
    }

    private final SyntaxNode findKeyword(Text text, NodeAspectMap<WhitespaceNodeAspect> wsAspectMap, long offset, SyntaxNode at) {
        Object object;
        SyntaxNode syntaxNode = AspectTreeWalkerUtilKt.leafLeftSkipWhitespaces((SyntaxNode)at, wsAspectMap);
        if (syntaxNode != null) {
            Object object2;
            SyntaxNode syntaxNode2;
            SyntaxNode it = syntaxNode2 = syntaxNode;
            boolean bl = false;
            object = GoKt.getPAREN_BLOCK_KEYWORDS().contains((object2 = it.getType()) instanceof IElementType ? (IElementType)object2 : null) && !StringsKt.contains$default((CharSequence)((CharSequence)text.charSequence().subSequence(it.getEndOffset(), offset)), (char)'\n', (boolean)false, (int)2, null) ? syntaxNode2 : null;
        } else {
            object = null;
        }
        return object;
    }

    private final SyntaxNode findSpec(SyntaxNode at) {
        Object object;
        SyntaxNode next;
        SyntaxNode syntaxNode = next = GoUtilKt.skipWhitespacesAndCommentsForward(at, false);
        Object object2 = syntaxNode != null ? syntaxNode.getType() : null;
        if (!nextTypes.contains(object2 instanceof IElementType ? (IElementType)object2 : null)) {
            return null;
        }
        SyntaxNode syntaxNode2 = next;
        if (syntaxNode2 != null && (syntaxNode2 = GoUtilKt.findParent(syntaxNode2, specTypes)) != null) {
            SyntaxNode syntaxNode3;
            SyntaxNode it = syntaxNode3 = syntaxNode2;
            boolean bl = false;
            object = it.getStartOffset() == next.getStartOffset() ? syntaxNode3 : null;
        } else {
            object = null;
        }
        return object;
    }

    private final String getIndent(Text text, SyntaxNode at) {
        String string;
        TextLine line = Text.lineAtCharOffset$default((Text)text, (long)at.getStartOffset(), (boolean)false, (int)2, null);
        String it = string = text.substring(line.getFromChar(), at.getStartOffset());
        boolean bl = false;
        return StringsKt.isBlank((CharSequence)it) ? string : null;
    }

    private final boolean isMissingRParen(SyntaxNode spec) {
        SyntaxNode syntaxNode = GoUtilKt.skipWhitespacesAndCommentsForward(spec, true);
        return !Intrinsics.areEqual((Object)(syntaxNode != null ? syntaxNode.getType() : null), (Object)GoTypes.RPAREN);
    }

    private final SyntaxNode getLastElementToInclude(SyntaxNode spec) {
        SyntaxNode result = spec;
        for (SyntaxNode it : SyntaxNodeExtKt.sequenceRight((SyntaxNode)spec, (boolean)true)) {
            Object object = it.getType();
            IElementType type2 = object instanceof IElementType ? (IElementType)object : null;
            if (GoParserDefinition.Lazy.COMMENTS.contains(type2)) {
                result = it;
                if (!StringsKt.contains$default((CharSequence)it.getText(), (char)'\n', (boolean)false, (int)2, null)) continue;
                break;
            }
            if (Intrinsics.areEqual((Object)type2, (Object)GoParserDefinition.Lazy.WS)) {
                result = it;
                continue;
            }
            if (Intrinsics.areEqual((Object)type2, (Object)GoParserDefinition.Lazy.NLS) || Intrinsics.areEqual((Object)type2, (Object)GoTypes.SEMICOLON_SYNTHETIC)) break;
            return null;
        }
        return result;
    }

    private final String getNormalIndent(MutableEditor editor) {
        EditorConfigs editorConfig = EditorConfigExtKt.getEditorConfig((MutableDocument)editor.getDocument());
        return Intrinsics.areEqual((Object)EditorConfigExtKt.indentStyle((EditorConfigs)editorConfig, (FileAddress)EditorConfigExtKt.getFileAddress((MutableDocument)editor.getDocument())), (Object)"space") ? StringsKt.repeat((CharSequence)" ", (int)EditorConfigExtKt.indentSize((EditorConfigs)editorConfig, (FileAddress)EditorConfigExtKt.getFileAddress((MutableDocument)editor.getDocument()))) : "\t";
    }

    static {
        SpreadBuilder spreadBuilder = new SpreadBuilder[]{GoTypes.IMPORT_SPEC, GoTypes.TYPE_SPEC, GoTypes.CONST_SPEC, GoTypes.VAR_SPEC};
        TokenSet tokenSet = TokenSet.create((IElementType[])spreadBuilder);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        specTypes = tokenSet;
        spreadBuilder = new SpreadBuilder(3);
        spreadBuilder.add((Object)GoTypes.IDENTIFIER);
        spreadBuilder.add((Object)GoTypes.DOT);
        spreadBuilder.addSpread((Object)GoParserDefinition.Lazy.STRING_LITERALS.getTypes());
        TokenSet tokenSet2 = TokenSet.create((IElementType[])((IElementType[])spreadBuilder.toArray((Object[])new IElementType[spreadBuilder.size()])));
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"create(...)");
        nextTypes = tokenSet2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lfleet/language/go/GoLParenTypingHandler$Companion;", "", "()V", "nextTypes", "Lfleet/com/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "specTypes", "fleet.plugins.go.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

