/*
 * Decompiled with CFR 0.152.
 */
package fleet.language.go;

import fleet.com.goide.GoLanguage;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import fleet.lang.intellij.common.HighlightingNodeExtender;
import fleet.lang.intellij.common.HighlightingToken;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lfleet/language/go/GoJsonAssocNodeExtender;", "Lfleet/lang/intellij/common/HighlightingNodeExtender;", "()V", "extend", "", "Lfleet/lang/intellij/common/HighlightingToken;", "node", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "Companion", "fleet.plugins.go.frontend"})
public final class GoJsonAssocNodeExtender
implements HighlightingNodeExtender {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int FIELD_LEN = 4;
    @NotNull
    private static final IElementType JSON_LABEL = new IElementType("JSON_LABEL", GoLanguage.INSTANCE);
    @NotNull
    private static final IElementType JSON_DELIM = new IElementType("JSON_DELIM", GoLanguage.INSTANCE);
    @NotNull
    private static final IElementType JSON_FIELD_ASSOC = new IElementType("JSON_FIELD_ASSOC", GoLanguage.INSTANCE);
    @NotNull
    private static final IElementType RAW_OMIT_SEQUENCE = new IElementType("RAW_OMIT_SEQUENCE", GoLanguage.INSTANCE);
    @NotNull
    private static final IElementType RAW_STRING_QUOTE = new IElementType("RAW_STRING_QUOTE", GoLanguage.INSTANCE);
    @NotNull
    private static final Regex jsonLabelPattern = new Regex("`json:\"([a-zA-Z0-9_]+)\"[^`]*`");

    @NotNull
    public List<HighlightingToken> extend(@NotNull SyntaxNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        MatchResult matchResult = Regex.find$default((Regex)jsonLabelPattern, (CharSequence)node.getText(), (int)0, (int)2, null);
        if (matchResult == null) {
            return CollectionsKt.emptyList();
        }
        MatchResult match = matchResult;
        MatchGroup matchGroup = match.getGroups().get(1);
        if (matchGroup == null) {
            return CollectionsKt.emptyList();
        }
        MatchGroup labelMatch = matchGroup;
        HighlightingToken firstQuote = new HighlightingToken(RAW_STRING_QUOTE, (CharSequence)"`", node.getStartOffset(), node.getStartOffset() + 1L);
        HighlightingToken jsonLabel = new HighlightingToken(JSON_LABEL, (CharSequence)"json", node.getStartOffset() + 1L, node.getStartOffset() + (long)FIELD_LEN + 1L);
        HighlightingToken jsonDelim = new HighlightingToken(JSON_DELIM, (CharSequence)":", node.getStartOffset() + (long)FIELD_LEN + 1L, node.getStartOffset() + (long)FIELD_LEN + (long)2);
        HighlightingToken jsonField = new HighlightingToken(JSON_FIELD_ASSOC, (CharSequence)("\"" + labelMatch.getValue() + "\""), node.getStartOffset() + (long)FIELD_LEN + (long)2, node.getStartOffset() + (long)labelMatch.getRange().getLast() + 1L);
        CharSequence charSequence = node.getText();
        int n = labelMatch.getRange().getLast() + 1;
        int n2 = charSequence.length();
        HighlightingToken rest = new HighlightingToken(RAW_OMIT_SEQUENCE, (CharSequence)((Object)charSequence.subSequence(n, n2)).toString(), node.getStartOffset() + (long)labelMatch.getRange().getLast() + 1L, node.getEndOffset() - 1L);
        HighlightingToken lastQuote = new HighlightingToken(RAW_STRING_QUOTE, (CharSequence)"`", node.getStartOffset() + (long)labelMatch.getRange().getLast() + (long)2, node.getEndOffset());
        Object[] objectArray = new HighlightingToken[]{firstQuote, jsonLabel, jsonDelim, jsonField, rest, lastQuote};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u000f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0011\u0010\u0011\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lfleet/language/go/GoJsonAssocNodeExtender$Companion;", "", "()V", "FIELD_LEN", "", "getFIELD_LEN", "()I", "JSON_DELIM", "Lfleet/com/intellij/psi/tree/IElementType;", "getJSON_DELIM", "()Lfleet/com/intellij/psi/tree/IElementType;", "JSON_FIELD_ASSOC", "getJSON_FIELD_ASSOC", "JSON_LABEL", "getJSON_LABEL", "RAW_OMIT_SEQUENCE", "getRAW_OMIT_SEQUENCE", "RAW_STRING_QUOTE", "getRAW_STRING_QUOTE", "jsonLabelPattern", "Lkotlin/text/Regex;", "fleet.plugins.go.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public final int getFIELD_LEN() {
            return FIELD_LEN;
        }

        @NotNull
        public final IElementType getJSON_LABEL() {
            return JSON_LABEL;
        }

        @NotNull
        public final IElementType getJSON_DELIM() {
            return JSON_DELIM;
        }

        @NotNull
        public final IElementType getJSON_FIELD_ASSOC() {
            return JSON_FIELD_ASSOC;
        }

        @NotNull
        public final IElementType getRAW_OMIT_SEQUENCE() {
            return RAW_OMIT_SEQUENCE;
        }

        @NotNull
        public final IElementType getRAW_STRING_QUOTE() {
            return RAW_STRING_QUOTE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

