/*
 * Decompiled with CFR 0.152.
 */
package fleet.git.frontend;

import androidx.compose.foundation.layout.RowScope;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.CompositionLocal;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.unit.Dp;
import com.jetbrains.rhizomedb.EntityAttribute;
import com.jetbrains.rhizomedb.EntityAttributeKt;
import fleet.api.FileAddress;
import fleet.api.FileAddressKt;
import fleet.common.document.DocumentFileEntity;
import fleet.common.document.DocumentFileEntityKt;
import fleet.compose.theme.components.ItemCellColors;
import fleet.compose.theme.components.checkbox.CheckboxState;
import fleet.diff.frontend.ChangedFileItem;
import fleet.diff.frontend.ChangedItem;
import fleet.diff.frontend.ChangedItemDisplayOpts;
import fleet.frontend.KernelExtKt;
import fleet.frontend.VcsStatus;
import fleet.frontend.fsd.FileIconsKt;
import fleet.git.frontend.FileStatusEntity;
import fleet.git.frontend.FileStatusEntityKt;
import fleet.git.frontend.GitChangesDelta;
import fleet.git.frontend.GitCommitFilesViewKt;
import fleet.git.frontend.GitConflictKt;
import fleet.git.frontend.GitStageableFilesViewKt;
import fleet.git.frontend.RepositoryEntityKt;
import fleet.git.frontend.StageableItem;
import fleet.kernel.plugins.PluginScope;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import noria.ClosureContext;
import noria.NoriaContext;
import noria.impl.Runtime;
import noria.model.ThemeKey;
import noria.model.components.TreePath;
import noria.ui.components.tree.TreeItem;
import noria.ui.components.tree.TreeItemOpts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0082\b\u0018\u00002\u00020\u00012\u00020\u0002Be\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012$\u0010\u0005\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0006\u0012.\u0010\f\u001a*\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00100\r\u00a2\u0006\u0002\b\u0011\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014JD\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u001d\u0010\u001e\u001a\u0019\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u001d0\u001f\u00a2\u0006\u0002\b\u00112\u0006\u0010\"\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b#\u0010$J\u0016\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010'J\u000e\u0010(\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010)J$\u0010*\u001a\u00020\u0010*\u00020+2\u0006\u0010\"\u001a\u00020\t2\u0006\u0010,\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020.H\u0017J\t\u0010P\u001a\u00020\u0004H\u00c6\u0003J'\u0010Q\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0006H\u00c2\u0003J1\u0010R\u001a*\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00100\r\u00a2\u0006\u0002\b\u0011\u00a2\u0006\u0002\b\u0012H\u00c2\u0003Jm\u0010S\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042&\b\u0002\u0010\u0005\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u000620\b\u0002\u0010\f\u001a*\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00100\r\u00a2\u0006\u0002\b\u0011\u00a2\u0006\u0002\b\u0012H\u00c6\u0001J\u0013\u0010T\u001a\u00020\t2\b\u0010U\u001a\u0004\u0018\u00010=H\u00d6\u0003J\t\u0010V\u001a\u00020!H\u00d6\u0001J\t\u0010W\u001a\u000200H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R,\u0010\u0005\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\f\u001a*\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00100\r\u00a2\u0006\u0002\b\u0011\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010/\u001a\u0002008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u001e\u00103\u001a\f\u0012\u0004\u0012\u00020004j\u0002`58VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0014\u00108\u001a\u0002098VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0014\u0010<\u001a\u00020=X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u0014\u0010@\u001a\u00020A8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010CR\u0014\u0010D\u001a\u00020A8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bE\u0010CR\u0016\u0010F\u001a\u0004\u0018\u00010A8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010CR\u0014\u0010H\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bI\u0010JR\u0014\u0010K\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bL\u0010JR\u0014\u0010&\u001a\u00020M8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bN\u0010O\u00a8\u0006X"}, d2={"Lfleet/git/frontend/StageableFile;", "Lfleet/diff/frontend/ChangedFileItem;", "Lfleet/git/frontend/StageableItem;", "vcsStatus", "Lfleet/git/frontend/FileStatusEntity;", "makeModifier", "Lkotlin/Function3;", "Lnoria/ui/components/tree/TreeItem;", "Lfleet/diff/frontend/ChangedItem;", "", "Lfleet/kernel/plugins/PluginScope;", "Landroidx/compose/ui/Modifier;", "renderControls", "Lkotlin/Function4;", "Lnoria/NoriaContext;", "Lfleet/compose/theme/components/ItemCellColors;", "", "Lkotlin/ExtensionFunctionType;", "Landroidx/compose/runtime/Composable;", "<init>", "(Lfleet/git/frontend/FileStatusEntity;Lkotlin/jvm/functions/Function3;Lkotlin/jvm/functions/Function4;)V", "getVcsStatus", "()Lfleet/git/frontend/FileStatusEntity;", "delta", "Lfleet/git/frontend/GitChangesDelta;", "getDelta", "()Lfleet/git/frontend/GitChangesDelta;", "toTreeItem", "startPadding", "Landroidx/compose/ui/unit/Dp;", "offset", "Lkotlin/Function2;", "Lnoria/ClosureContext;", "", "showHint", "toTreeItem-8Feqmps", "(FLkotlin/jvm/functions/Function2;Z)Lnoria/ui/components/tree/TreeItem;", "setStaged", "staged", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "markResolved", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "render", "Landroidx/compose/foundation/layout/RowScope;", "colors", "opts", "Lnoria/ui/components/tree/TreeItemOpts;", "name", "", "getName", "()Ljava/lang/String;", "icon", "Lnoria/model/ThemeKey;", "Lnoria/model/IconKey;", "getIcon", "()Lnoria/model/ThemeKey;", "status", "Lfleet/frontend/VcsStatus;", "getStatus", "()Lfleet/frontend/VcsStatus;", "key", "", "getKey", "()Ljava/lang/Object;", "fileAddress", "Lfleet/api/FileAddress;", "getFileAddress", "()Lfleet/api/FileAddress;", "workspaceRoot", "getWorkspaceRoot", "oldFileAddress", "getOldFileAddress", "busy", "getBusy", "()Z", "enabled", "getEnabled", "Lfleet/compose/theme/components/checkbox/CheckboxState;", "getStaged", "()Lfleet/compose/theme/components/checkbox/CheckboxState;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "fleet.git.frontend"})
final class StageableFile
implements ChangedFileItem,
StageableItem {
    @NotNull
    private final FileStatusEntity vcsStatus;
    @NotNull
    private final Function3<TreeItem<? extends ChangedItem>, Boolean, PluginScope, Modifier> makeModifier;
    @NotNull
    private final Function4<NoriaContext, ItemCellColors, ChangedItem, Boolean, Unit> renderControls;
    @NotNull
    private final GitChangesDelta delta;
    @NotNull
    private final Object key;

    public StageableFile(@NotNull FileStatusEntity vcsStatus, @NotNull Function3<? super TreeItem<? extends ChangedItem>, ? super Boolean, ? super PluginScope, ? extends Modifier> makeModifier, @NotNull Function4<? super NoriaContext, ? super ItemCellColors, ? super ChangedItem, ? super Boolean, Unit> renderControls) {
        Intrinsics.checkNotNullParameter((Object)vcsStatus, (String)"vcsStatus");
        Intrinsics.checkNotNullParameter(makeModifier, (String)"makeModifier");
        Intrinsics.checkNotNullParameter(renderControls, (String)"renderControls");
        this.vcsStatus = vcsStatus;
        this.makeModifier = makeModifier;
        this.renderControls = renderControls;
        this.delta = new GitChangesDelta(this.vcsStatus);
        this.key = this.vcsStatus.getEid();
    }

    @NotNull
    public final FileStatusEntity getVcsStatus() {
        return this.vcsStatus;
    }

    @NotNull
    public GitChangesDelta getDelta() {
        return this.delta;
    }

    @NotNull
    public TreeItem<ChangedItem> toTreeItem-8Feqmps(float startPadding, @NotNull Function2<? super ClosureContext, ? super Integer, Dp> offset, boolean showHint) {
        TreeItem treeItem;
        Intrinsics.checkNotNullParameter(offset, (String)"offset");
        Ref.ObjectRef treeItem2 = new Ref.ObjectRef();
        Object object = this.getKey();
        String string = this.getName();
        Object[] objectArray = new Object[]{this, showHint, Dp.box-impl((float)startPadding)};
        treeItem2.element = new TreeItem(object, (Object)this, (Object)"item", false, false, false, false, false, offset, null, null, string, (Function3)Runtime.closure((Object[])objectArray, (Object)new Function3<NoriaContext, TreePath, TreeItemOpts, Unit>(this, showHint, startPadding, (Ref.ObjectRef<TreeItem<StageableFile>>)treeItem2){
            final /* synthetic */ StageableFile this$0;
            final /* synthetic */ boolean $showHint;
            final /* synthetic */ float $startPadding;
            final /* synthetic */ Ref.ObjectRef<TreeItem<StageableFile>> $treeItem;
            {
                this.this$0 = $receiver;
                this.$showHint = $showHint;
                this.$startPadding = $startPadding;
                this.$treeItem = $treeItem;
                super(3);
            }

            public final void invoke(NoriaContext $this$TreeItem, TreePath treePath, TreeItemOpts treeOpts) {
                TreeItem treeItem;
                Intrinsics.checkNotNullParameter((Object)$this$TreeItem, (String)"$this$TreeItem");
                Intrinsics.checkNotNullParameter((Object)treePath, (String)"treePath");
                Intrinsics.checkNotNullParameter((Object)treeOpts, (String)"treeOpts");
                Runtime.enterScope((NoriaContext)$this$TreeItem, (int)446);
                ChangedItem changedItem = (ChangedItem)this.this$0;
                ChangedItemDisplayOpts changedItemDisplayOpts = new ChangedItemDisplayOpts(false, this.$showHint, false, this.$startPadding, null);
                Function3 function3 = StageableFile.access$getMakeModifier$p(this.this$0);
                if (this.$treeItem.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"treeItem");
                    treeItem = null;
                } else {
                    treeItem = (TreeItem)this.$treeItem.element;
                }
                GitStageableFilesViewKt.access$StageableItem($this$TreeItem, treePath, treeOpts, changedItem, changedItemDisplayOpts, (Modifier)function3.invoke((Object)treeItem, (Object)treeOpts.isCursor(), $this$TreeItem.getCurrent((CompositionLocal)KernelExtKt.getLocalPluginScope())), StageableFile.access$getRenderControls$p(this.this$0));
                Unit unit = Unit.INSTANCE;
                Runtime.exitScope((NoriaContext)$this$TreeItem);
            }
        }), 1776, null);
        if (treeItem2.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"treeItem");
            treeItem = null;
        } else {
            treeItem = (TreeItem)treeItem2.element;
        }
        return treeItem;
    }

    @Override
    @Nullable
    public Object setStaged(boolean staged, @NotNull Continuation<? super Unit> $completion) {
        Object object = FileStatusEntityKt.toggleStatus$default(CollectionsKt.listOf((Object)this.vcsStatus), staged, false, $completion, 4, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object markResolved(@NotNull Continuation<? super Unit> $completion) {
        Object object = GitConflictKt.markFilesResolved(CollectionsKt.listOf((Object)this.vcsStatus), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Composable
    public void render(@NotNull RowScope $this$render, boolean showHint, @NotNull ItemCellColors colors, @NotNull TreeItemOpts opts) {
        Intrinsics.checkNotNullParameter((Object)$this$render, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        Intrinsics.checkNotNullParameter((Object)opts, (String)"opts");
        DocumentFileEntity documentFileEntity = (DocumentFileEntity)EntityAttributeKt.entity((EntityAttribute)((EntityAttribute)DocumentFileEntity.Companion.getFileAddressAttr()), (Object)this.vcsStatus.getAddress());
        boolean isDirty = documentFileEntity != null ? DocumentFileEntityKt.isDirty((DocumentFileEntity)documentFileEntity) : false;
        String prefix = isDirty ? "\u2022 " : "";
        Runtime.enterScope((NoriaContext)((NoriaContext)$this$render), (int)448);
        Object[] objectArray = new Object[]{this, opts, showHint, prefix};
        GitStageableFilesViewKt.renderBusyText((NoriaContext)$this$render, this.getBusy(), colors, (Function2<? super NoriaContext, ? super ItemCellColors, Unit>)((Function2)Runtime.closure((Object[])objectArray, (Object)new Function2<NoriaContext, ItemCellColors, Unit>($this$render, this, opts, showHint, prefix){
            final /* synthetic */ RowScope $this_render;
            final /* synthetic */ StageableFile this$0;
            final /* synthetic */ TreeItemOpts $opts;
            final /* synthetic */ boolean $showHint;
            final /* synthetic */ String $prefix;
            {
                this.$this_render = $receiver;
                this.this$0 = $receiver2;
                this.$opts = $opts;
                this.$showHint = $showHint;
                this.$prefix = $prefix;
                super(2);
            }

            public final void invoke(NoriaContext $this$renderBusyText, ItemCellColors busyColors) {
                Intrinsics.checkNotNullParameter((Object)$this$renderBusyText, (String)"$this$renderBusyText");
                Intrinsics.checkNotNullParameter((Object)busyColors, (String)"busyColors");
                RowScope rowScope = this.$this_render;
                Runtime.enterScope((NoriaContext)((NoriaContext)rowScope), (int)447);
                GitCommitFilesViewKt.renderNameAndMoved(rowScope, this.this$0.getDelta(), this.this$0.getWorkspaceRoot(), busyColors, this.$opts, this.$showHint, this.$prefix);
                Unit unit = Unit.INSTANCE;
                Runtime.exitScope((NoriaContext)((NoriaContext)rowScope));
            }
        })));
        Unit unit = Unit.INSTANCE;
        Runtime.exitScope((NoriaContext)((NoriaContext)$this$render));
    }

    @NotNull
    public String getName() {
        return FileAddressKt.getName((FileAddress)this.vcsStatus.getAddress());
    }

    @NotNull
    public ThemeKey<String> getIcon() {
        return FileIconsKt.fileIcon((FileAddress)this.vcsStatus.getAddress());
    }

    @NotNull
    public VcsStatus getStatus() {
        return FileStatusEntityKt.toVcsStatus(FileStatusEntityKt.toSimpleStatus(this.vcsStatus));
    }

    @NotNull
    public Object getKey() {
        return this.key;
    }

    @NotNull
    public FileAddress getFileAddress() {
        return this.vcsStatus.getAddress();
    }

    @NotNull
    public FileAddress getWorkspaceRoot() {
        return RepositoryEntityKt.getWorktree(this.vcsStatus.getRepo());
    }

    @Nullable
    public FileAddress getOldFileAddress() {
        return this.vcsStatus.getOldAddress();
    }

    @Override
    public boolean getBusy() {
        return this.vcsStatus.getBusy();
    }

    @Override
    public boolean getEnabled() {
        return !RepositoryEntityKt.getLocked(this.vcsStatus.getRepo());
    }

    @Override
    @NotNull
    public CheckboxState getStaged() {
        return FileStatusEntityKt.toCheckboxState(this.vcsStatus);
    }

    @NotNull
    public final FileStatusEntity component1() {
        return this.vcsStatus;
    }

    private final Function3<TreeItem<? extends ChangedItem>, Boolean, PluginScope, Modifier> component2() {
        return this.makeModifier;
    }

    private final Function4<NoriaContext, ItemCellColors, ChangedItem, Boolean, Unit> component3() {
        return this.renderControls;
    }

    @NotNull
    public final StageableFile copy(@NotNull FileStatusEntity vcsStatus, @NotNull Function3<? super TreeItem<? extends ChangedItem>, ? super Boolean, ? super PluginScope, ? extends Modifier> makeModifier, @NotNull Function4<? super NoriaContext, ? super ItemCellColors, ? super ChangedItem, ? super Boolean, Unit> renderControls) {
        Intrinsics.checkNotNullParameter((Object)vcsStatus, (String)"vcsStatus");
        Intrinsics.checkNotNullParameter(makeModifier, (String)"makeModifier");
        Intrinsics.checkNotNullParameter(renderControls, (String)"renderControls");
        return new StageableFile(vcsStatus, makeModifier, renderControls);
    }

    public static /* synthetic */ StageableFile copy$default(StageableFile stageableFile, FileStatusEntity fileStatusEntity, Function3 function3, Function4 function4, int n, Object object) {
        if ((n & 1) != 0) {
            fileStatusEntity = stageableFile.vcsStatus;
        }
        if ((n & 2) != 0) {
            function3 = stageableFile.makeModifier;
        }
        if ((n & 4) != 0) {
            function4 = stageableFile.renderControls;
        }
        return stageableFile.copy(fileStatusEntity, function3, function4);
    }

    @NotNull
    public String toString() {
        return "StageableFile(vcsStatus=" + this.vcsStatus + ", makeModifier=" + this.makeModifier + ", renderControls=" + this.renderControls + ")";
    }

    public int hashCode() {
        int result2 = this.vcsStatus.hashCode();
        result2 = result2 * 31 + this.makeModifier.hashCode();
        result2 = result2 * 31 + this.renderControls.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StageableFile)) {
            return false;
        }
        StageableFile stageableFile = (StageableFile)other;
        if (!Intrinsics.areEqual((Object)this.vcsStatus, (Object)stageableFile.vcsStatus)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.makeModifier, stageableFile.makeModifier)) {
            return false;
        }
        return Intrinsics.areEqual(this.renderControls, stageableFile.renderControls);
    }

    public static final /* synthetic */ Function3 access$getMakeModifier$p(StageableFile $this) {
        return $this.makeModifier;
    }

    public static final /* synthetic */ Function4 access$getRenderControls$p(StageableFile $this) {
        return $this.renderControls;
    }
}

