/*
 * Decompiled with CFR 0.152.
 */
package fleet.git.frontend;

import com.jetbrains.rhizomedb.Attributes;
import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.Entity;
import com.jetbrains.rhizomedb.EntityAttribute;
import com.jetbrains.rhizomedb.EntityAttributeKt;
import com.jetbrains.rhizomedb.EntityBuilder;
import com.jetbrains.rhizomedb.EntityType;
import fleet.git.frontend.GitBranchEntity;
import fleet.git.frontend.GitBranchesState;
import fleet.git.frontend.GitCommitEntity;
import fleet.git.frontend.GitRefEntity;
import fleet.git.frontend.GitRemoteBranch;
import fleet.git.frontend.RepositoryEntity;
import fleet.git.protocol.GitRef;
import fleet.git.protocol.Oid;
import fleet.git.protocol.VcsBranch;
import fleet.git.protocol.VcsBranchType;
import fleet.git.protocol.VcsCommitMeta;
import fleet.git.protocol.VcsRemoteBranch;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u001a@\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u001a\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u0001*\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0006\u001a\f\u0010\u0015\u001a\u00020\b*\u00020\u0016H\u0000\u001a\f\u0010\u0015\u001a\u00020\b*\u00020\u0018H\u0000\u001a\f\u0010\u0015\u001a\u00020\b*\u00020\u001bH\u0000\u001a\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\bH\u0000\u001aF\u0010\"\u001a\u00020\u001f*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\b2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u0017\u001a\u00020\u000e2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\u0016H\u0000\u001a\u001e\u0010(\u001a\u0004\u0018\u00010\u001f*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\bH\u0000\u001a\u0012\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00180\n*\u00020\u0004H\u0000\u001a\u0012\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00180\n*\u00020\u0004H\u0000\u001a\u0016\u0010+\u001a\u0004\u0018\u00010\u0018*\u00020\u00042\u0006\u0010#\u001a\u00020\bH\u0000\u001a\u0016\u0010,\u001a\u0004\u0018\u00010\u0018*\u00020\u00042\u0006\u0010\u001d\u001a\u00020\bH\u0000\u001a\f\u0010-\u001a\u00020\b*\u00020\bH\u0000\"\u0018\u0010\r\u001a\u00020\u000e*\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000f\"\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u0006*\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"\u0018\u0010\u0017\u001a\u00020\u000e*\u00020\u00188@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\"\u001a\u0010\u001e\u001a\u0004\u0018\u00010\b*\u00020\u001f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006."}, d2={"upsertCommit", "Lfleet/git/frontend/GitCommitEntity;", "Lcom/jetbrains/rhizomedb/ChangeScope;", "repository", "Lfleet/git/frontend/RepositoryEntity;", "id", "Lfleet/git/protocol/Oid;", "short", "", "parents", "", "meta", "Lfleet/git/protocol/VcsCommitMeta;", "isMergeCommit", "", "(Lfleet/git/frontend/GitCommitEntity;)Z", "previous", "getPrevious", "(Lfleet/git/frontend/GitCommitEntity;)Lfleet/git/protocol/Oid;", "findCommit", "oid", "presentable", "Lfleet/git/frontend/GitRemoteBranch;", "local", "Lfleet/git/protocol/VcsBranch;", "getLocal", "(Lfleet/git/protocol/VcsBranch;)Z", "Lfleet/git/protocol/VcsRemoteBranch;", "presentableBranchName", "refname", "upstreamName", "Lfleet/git/frontend/GitBranchEntity;", "getUpstreamName", "(Lfleet/git/frontend/GitBranchEntity;)Ljava/lang/String;", "upsertBranch", "name", "commit", "Lfleet/git/protocol/GitRef$Commit;", "commitMeta", "remote", "loadBranch", "localBranches", "remoteBranches", "findLocalBranch", "findBranch", "stripRefsPrefix", "fleet.git.frontend"})
@SourceDebugExtension(value={"SMAP\nGitLogEntities.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLogEntities.kt\nfleet/git/frontend/GitLogEntitiesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,248:1\n1#2:249\n295#3,2:250\n295#3,2:252\n*S KotlinDebug\n*F\n+ 1 GitLogEntities.kt\nfleet/git/frontend/GitLogEntitiesKt\n*L\n131#1:250,2\n145#1:252,2\n*E\n"})
public final class GitLogEntitiesKt {
    @NotNull
    public static final GitCommitEntity upsertCommit(@NotNull ChangeScope $this$upsertCommit, @NotNull RepositoryEntity repository2, @NotNull Oid id, @NotNull String string, @Nullable List<Oid> parents, @Nullable VcsCommitMeta meta) {
        Intrinsics.checkNotNullParameter((Object)$this$upsertCommit, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)string, (String)"short");
        GitCommitEntity gitCommitEntity = GitLogEntitiesKt.findCommit(repository2, id);
        if (gitCommitEntity == null) {
            gitCommitEntity = (GitCommitEntity)$this$upsertCommit.new((EntityType)GitCommitEntity.Companion, arg_0 -> GitLogEntitiesKt.upsertCommit$lambda$0(id, string, repository2, arg_0));
        }
        GitCommitEntity commit2 = gitCommitEntity;
        VcsCommitMeta vcsCommitMeta = meta;
        if (vcsCommitMeta != null) {
            VcsCommitMeta it = vcsCommitMeta;
            boolean bl = false;
            $this$upsertCommit.set((Entity)commit2, GitCommitEntity.Companion.getMetaAttr(), (Object)it);
        }
        if (!commit2.getParentsLoaded() && parents != null) {
            $this$upsertCommit.set((Entity)commit2, GitCommitEntity.Companion.getParentCommitIdsAttr(), parents);
            $this$upsertCommit.set((Entity)commit2, GitCommitEntity.Companion.getParentsLoadedAttr(), (Object)true);
        }
        return commit2;
    }

    public static /* synthetic */ GitCommitEntity upsertCommit$default(ChangeScope changeScope, RepositoryEntity repositoryEntity, Oid oid, String string, List list, VcsCommitMeta vcsCommitMeta, int n, Object object) {
        if ((n & 8) != 0) {
            list = null;
        }
        if ((n & 0x10) != 0) {
            vcsCommitMeta = null;
        }
        return GitLogEntitiesKt.upsertCommit(changeScope, repositoryEntity, oid, string, list, vcsCommitMeta);
    }

    public static final boolean isMergeCommit(@NotNull GitCommitEntity $this$isMergeCommit) {
        Intrinsics.checkNotNullParameter((Object)$this$isMergeCommit, (String)"<this>");
        return $this$isMergeCommit.getParentCommitIds().size() > 1;
    }

    @Nullable
    public static final Oid getPrevious(@NotNull GitCommitEntity $this$previous) {
        Intrinsics.checkNotNullParameter((Object)$this$previous, (String)"<this>");
        return (Oid)CollectionsKt.firstOrNull($this$previous.getParentCommitIds());
    }

    @Nullable
    public static final GitCommitEntity findCommit(@NotNull RepositoryEntity $this$findCommit, @NotNull Oid oid) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$findCommit, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)oid, (String)"oid");
            Iterable iterable = EntityAttributeKt.entities((EntityAttribute)((EntityAttribute)GitCommitEntity.Companion.getIdAttr()), (Object)oid);
            for (Object t : iterable) {
                GitCommitEntity it = (GitCommitEntity)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getRepository(), (Object)$this$findCommit)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public static final String presentable(@NotNull GitRemoteBranch $this$presentable) {
        Intrinsics.checkNotNullParameter((Object)$this$presentable, (String)"<this>");
        return $this$presentable.getRemoteName() + "/" + $this$presentable.getBranchName();
    }

    public static final boolean getLocal(@NotNull VcsBranch $this$local) {
        Intrinsics.checkNotNullParameter((Object)$this$local, (String)"<this>");
        return $this$local.getType() == VcsBranchType.Local;
    }

    @NotNull
    public static final String presentable(@NotNull VcsBranch $this$presentable) {
        Intrinsics.checkNotNullParameter((Object)$this$presentable, (String)"<this>");
        return GitLogEntitiesKt.presentableBranchName($this$presentable.getRefname());
    }

    @NotNull
    public static final String presentable(@NotNull VcsRemoteBranch $this$presentable) {
        Intrinsics.checkNotNullParameter((Object)$this$presentable, (String)"<this>");
        return GitLogEntitiesKt.presentableBranchName($this$presentable.getRef());
    }

    @NotNull
    public static final String presentableBranchName(@NotNull String refname) {
        Intrinsics.checkNotNullParameter((Object)refname, (String)"refname");
        return GitLogEntitiesKt.stripRefsPrefix(refname);
    }

    @Nullable
    public static final String getUpstreamName(@NotNull GitBranchEntity $this$upstreamName) {
        Intrinsics.checkNotNullParameter((Object)$this$upstreamName, (String)"<this>");
        Object object = $this$upstreamName.getRemote();
        return object != null && (object = ((GitRemoteBranch)object).getRef()) != null ? GitLogEntitiesKt.stripRefsPrefix((String)object) : null;
    }

    @NotNull
    public static final GitBranchEntity upsertBranch(@NotNull ChangeScope $this$upsertBranch, @NotNull RepositoryEntity repository2, @NotNull String name, @Nullable GitRef.Commit commit2, boolean local, @Nullable VcsCommitMeta commitMeta, @Nullable GitRemoteBranch remote) {
        GitBranchEntity ref;
        GitBranchEntity existing2;
        GitBranchEntity gitBranchEntity;
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$upsertBranch, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable $this$firstOrNull$iv = EntityAttributeKt.entities((EntityAttribute)((EntityAttribute)GitBranchEntity.Companion.getRefnameAttr()), (Object)name);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                GitBranchEntity it = (GitBranchEntity)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getRepository(), (Object)$this$upsertBranch)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        if ((gitBranchEntity = (existing2 = (GitBranchEntity)v0)) == null) {
            gitBranchEntity = ref = (GitBranchEntity)$this$upsertBranch.new((EntityType)GitBranchEntity.Companion, arg_0 -> GitLogEntitiesKt.upsertBranch$lambda$5(name, repository2, local, commit2, $this$upsertBranch, commitMeta, arg_0));
        }
        if (remote != null) {
            $this$upsertBranch.set((Entity)ref, GitBranchEntity.Companion.getRemoteAttr(), (Object)remote);
        }
        return ref;
    }

    public static /* synthetic */ GitBranchEntity upsertBranch$default(ChangeScope changeScope, RepositoryEntity repositoryEntity, String string, GitRef.Commit commit2, boolean bl, VcsCommitMeta vcsCommitMeta, GitRemoteBranch gitRemoteBranch, int n, Object object) {
        if ((n & 0x10) != 0) {
            vcsCommitMeta = null;
        }
        if ((n & 0x20) != 0) {
            gitRemoteBranch = null;
        }
        return GitLogEntitiesKt.upsertBranch(changeScope, repositoryEntity, string, commit2, bl, vcsCommitMeta, gitRemoteBranch);
    }

    @Nullable
    public static final GitBranchEntity loadBranch(@NotNull ChangeScope $this$loadBranch, @NotNull RepositoryEntity repository2, @NotNull String refname) {
        GitBranchEntity gitBranchEntity;
        Object v0;
        GitBranchEntity it;
        block6: {
            Intrinsics.checkNotNullParameter((Object)$this$loadBranch, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)refname, (String)"refname");
            Iterable $this$firstOrNull$iv = EntityAttributeKt.entities((EntityAttribute)((EntityAttribute)GitBranchEntity.Companion.getRefnameAttr()), (Object)refname);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (GitBranchEntity)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getRepository(), (Object)repository2)) continue;
                v0 = element$iv;
                break block6;
            }
            v0 = null;
        }
        GitBranchEntity existing2 = v0;
        if (existing2 != null) {
            gitBranchEntity = existing2;
        } else {
            GitRemoteBranch gitRemoteBranch;
            VcsBranch vcsBranch = GitLogEntitiesKt.findBranch(repository2, refname);
            if (vcsBranch == null) {
                return null;
            }
            VcsBranch branch = vcsBranch;
            VcsRemoteBranch vcsRemoteBranch = branch.getRemote();
            if (vcsRemoteBranch != null) {
                it = vcsRemoteBranch;
                boolean bl = false;
                gitRemoteBranch = new GitRemoteBranch((VcsRemoteBranch)it);
            } else {
                gitRemoteBranch = null;
            }
            GitRemoteBranch remote = gitRemoteBranch;
            GitRef.Commit commit2 = new GitRef.Commit(branch.getOid(), branch.getShortOid());
            gitBranchEntity = GitLogEntitiesKt.upsertBranch$default($this$loadBranch, repository2, branch.getRefname(), commit2, GitLogEntitiesKt.getLocal(branch), null, remote, 16, null);
        }
        return gitBranchEntity;
    }

    @NotNull
    public static final List<VcsBranch> localBranches(@NotNull RepositoryEntity $this$localBranches) {
        Intrinsics.checkNotNullParameter((Object)$this$localBranches, (String)"<this>");
        Object object = (GitBranchesState)EntityAttributeKt.entity((EntityAttribute)((EntityAttribute)GitBranchesState.Companion.getRepositoryAttr()), (Object)$this$localBranches);
        if (object == null || (object = ((GitBranchesState)object).getLocalBranches()) == null || (object = ((GitBranchesState.GitBranchesWithIndex)object).getBranches()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public static final List<VcsBranch> remoteBranches(@NotNull RepositoryEntity $this$remoteBranches) {
        Intrinsics.checkNotNullParameter((Object)$this$remoteBranches, (String)"<this>");
        Object object = (GitBranchesState)EntityAttributeKt.entity((EntityAttribute)((EntityAttribute)GitBranchesState.Companion.getRepositoryAttr()), (Object)$this$remoteBranches);
        if (object == null || (object = ((GitBranchesState)object).getRemoteBranches()) == null || (object = ((GitBranchesState.GitBranchesWithIndex)object).getBranches()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Nullable
    public static final VcsBranch findLocalBranch(@NotNull RepositoryEntity $this$findLocalBranch, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$findLocalBranch, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return GitLogEntitiesKt.findBranch($this$findLocalBranch, "refs/heads/" + name);
    }

    @Nullable
    public static final VcsBranch findBranch(@NotNull RepositoryEntity $this$findBranch, @NotNull String refname) {
        VcsBranch vcsBranch;
        Intrinsics.checkNotNullParameter((Object)$this$findBranch, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)refname, (String)"refname");
        GitBranchesState gitBranchesState = (GitBranchesState)EntityAttributeKt.entity((EntityAttribute)((EntityAttribute)GitBranchesState.Companion.getRepositoryAttr()), (Object)$this$findBranch);
        if (gitBranchesState != null) {
            GitBranchesState state2 = gitBranchesState;
            boolean bl = false;
            GitBranchesState.GitBranchesWithIndex branchesWithIndex = StringsKt.startsWith$default((String)refname, (String)"refs/heads/", (boolean)false, (int)2, null) ? state2.getLocalBranches() : state2.getRemoteBranches();
            Integer n = branchesWithIndex.getIndex().get(refname);
            if (n != null) {
                int index = ((Number)n).intValue();
                boolean bl2 = false;
                vcsBranch = branchesWithIndex.getBranches().get(index);
            } else {
                vcsBranch = null;
            }
        } else {
            vcsBranch = null;
        }
        return vcsBranch;
    }

    @NotNull
    public static final String stripRefsPrefix(@NotNull String $this$stripRefsPrefix) {
        Intrinsics.checkNotNullParameter((Object)$this$stripRefsPrefix, (String)"<this>");
        return StringsKt.removePrefix((String)StringsKt.removePrefix((String)$this$stripRefsPrefix, (CharSequence)"refs/heads/"), (CharSequence)"refs/remotes/");
    }

    private static final void upsertCommit$lambda$0(Oid $id, String $short, RepositoryEntity $repository, EntityBuilder.Target it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.set(GitCommitEntity.Companion.getIdAttr(), (Object)$id);
        it.set(GitCommitEntity.Companion.getShortAttr(), (Object)$short);
        it.set(GitRefEntity.Companion.getRepositoryAttr(), (Object)$repository);
        it.set(GitCommitEntity.Companion.getParentsLoadedAttr(), (Object)false);
        it.set(GitCommitEntity.Companion.getParentCommitIdsAttr(), (Object)CollectionsKt.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    private static final void upsertBranch$lambda$5(String $name, RepositoryEntity $repository, boolean $local, GitRef.Commit $commit, ChangeScope $this_upsertBranch, VcsCommitMeta $commitMeta, EntityBuilder.Target it) {
        GitCommitEntity gitCommitEntity;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.set(GitBranchEntity.Companion.getRefnameAttr(), (Object)$name);
        it.set(GitRefEntity.Companion.getRepositoryAttr(), (Object)$repository);
        it.set(GitBranchEntity.Companion.getLocalAttr(), (Object)$local);
        EntityBuilder.Target target = it;
        Attributes.Optional<GitCommitEntity> optional = GitBranchEntity.Companion.getCommitAttr();
        GitRef.Commit commit2 = $commit;
        if (commit2 != null) {
            void it2;
            GitRef.Commit commit3 = commit2;
            Attributes.Optional<GitCommitEntity> optional2 = optional;
            EntityBuilder.Target target2 = target;
            boolean bl = false;
            GitCommitEntity gitCommitEntity2 = GitLogEntitiesKt.upsertCommit$default($this_upsertBranch, $repository, it2.getOid(), it2.getShort(), null, $commitMeta, 8, null);
            target = target2;
            optional = optional2;
            gitCommitEntity = gitCommitEntity2;
        } else {
            gitCommitEntity = null;
        }
        target.set(optional, gitCommitEntity);
    }
}

