/*
 * Decompiled with CFR 0.152.
 */
package fleet.git.common;

import com.jetbrains.rhizomedb.EntityAttribute;
import com.jetbrains.rhizomedb.EntityAttributeKt;
import fleet.api.FileAddress;
import fleet.api.HostId;
import fleet.api.ProjectRootId;
import fleet.api.ProjectRootStatus;
import fleet.api.ProjectRootsHookApiKt;
import fleet.common.fs.SharedProjectRootEntity;
import fleet.common.fs.SharedProjectRootsKt;
import fleet.common.topology.Service;
import fleet.common.topology.ServiceProviderEntity;
import fleet.git.common.GitFeatureProvider;
import fleet.git.protocol.GitHostApi;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u001a&\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"GIT_STATUS_LABEL", "", "findGitHostService", "Lfleet/common/topology/Service;", "Lfleet/git/protocol/GitHostApi;", "host", "Lfleet/api/HostId;", "checkProjectRootIsReady", "Lfleet/api/ProjectRootId;", "service", "address", "Lfleet/api/FileAddress;", "label", "fleet.git.common"})
@SourceDebugExtension(value={"SMAP\nGitServices.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitServices.kt\nfleet/git/common/GitServicesKt\n+ 2 CollectionsUtil.kt\nfleet/util/CollectionsUtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,42:1\n37#2,12:43\n1#3:55\n*S KotlinDebug\n*F\n+ 1 GitServices.kt\nfleet/git/common/GitServicesKt\n*L\n36#1:43,12\n*E\n"})
public final class GitServicesKt {
    @NotNull
    public static final String GIT_STATUS_LABEL = "git_status_worker_cli";

    @Nullable
    public static final Service<GitHostApi> findGitHostService(@NotNull HostId host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        GitFeatureProvider gitFeatureProvider = GitFeatureProvider.Companion.lookup(host);
        return gitFeatureProvider != null ? gitFeatureProvider.getHostService() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final ProjectRootId checkProjectRootIsReady(@NotNull Service<GitHostApi> service, @NotNull FileAddress address, @NotNull String label) {
        Object object;
        void $this$singleOrNullOrThrow$iv;
        Intrinsics.checkNotNullParameter(service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Iterable iterable = EntityAttributeKt.entities((EntityAttribute)((EntityAttribute)SharedProjectRootEntity.Companion.getFileAddressAttr()), (Object)address);
        boolean $i$f$singleOrNullOrThrow = false;
        Object single$iv = null;
        boolean found$iv = false;
        ProjectRootId projectRootId = $this$singleOrNullOrThrow$iv.iterator();
        while (projectRootId.hasNext()) {
            Object element$iv = projectRootId.next();
            SharedProjectRootEntity it = (SharedProjectRootEntity)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getTag().getLabel(), (Object)label)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Collection contains more than one matching element: " + single$iv + ", " + element$iv);
            }
            single$iv = element$iv;
            found$iv = true;
        }
        SharedProjectRootEntity sharedProjectRootEntity = single$iv;
        if (sharedProjectRootEntity != null) {
            SharedProjectRootEntity root = sharedProjectRootEntity;
            boolean bl = false;
            ProjectRootStatus status = SharedProjectRootsKt.status((ServiceProviderEntity)service.getProvider(), (SharedProjectRootEntity)root);
            ProjectRootId it = projectRootId = root.getId();
            boolean bl2 = false;
            ProjectRootStatus projectRootStatus = status;
            object = (projectRootStatus != null ? ProjectRootsHookApiKt.isTerminal((ProjectRootStatus)projectRootStatus) : false) ? projectRootId : null;
        } else {
            object = null;
        }
        return object;
    }
}

