/*
 * Decompiled with CFR 0.152.
 */
package fleet.git.common;

import fleet.api.ExecApiKt;
import fleet.api.ExitStatus;
import fleet.git.common.GitExceptionKt;
import fleet.git.common.GitOutputKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00032\b\b\u0002\u0010\u0018\u001a\u00020\u0016J\u0006\u0010\u0019\u001a\u00020\u0000J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0015\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001c"}, d2={"Lfleet/git/common/GitOutput;", "", "command", "", "exitStatus", "Lfleet/api/ExitStatus;", "stdout", "stderr", "<init>", "(Ljava/lang/String;Lfleet/api/ExitStatus;Ljava/lang/String;Ljava/lang/String;)V", "getCommand", "()Ljava/lang/String;", "getExitStatus", "()Lfleet/api/ExitStatus;", "getStdout", "getStderr", "exitCode", "", "getExitCode", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "isErrorOrFatal", "", "combinedOutput", "removeProgressLines", "throwIfNonZero", "outputLines", "", "fleet.git.common"})
@SourceDebugExtension(value={"SMAP\nGitOutput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitOutput.kt\nfleet/git/common/GitOutput\n+ 2 Helpers.kt\nfleet/util/HelpersKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n13#2:88\n774#3:89\n865#3,2:90\n*S KotlinDebug\n*F\n+ 1 GitOutput.kt\nfleet/git/common/GitOutput\n*L\n21#1:88\n23#1:89\n23#1:90,2\n*E\n"})
public final class GitOutput {
    @NotNull
    private final String command;
    @NotNull
    private final ExitStatus exitStatus;
    @NotNull
    private final String stdout;
    @NotNull
    private final String stderr;
    @Nullable
    private final Integer exitCode;

    public GitOutput(@NotNull String command, @NotNull ExitStatus exitStatus, @NotNull String stdout, @NotNull String stderr) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)exitStatus, (String)"exitStatus");
        Intrinsics.checkNotNullParameter((Object)stdout, (String)"stdout");
        Intrinsics.checkNotNullParameter((Object)stderr, (String)"stderr");
        this.command = command;
        this.exitStatus = exitStatus;
        this.stdout = stdout;
        this.stderr = stderr;
        this.exitCode = ExecApiKt.getExitCode((ExitStatus)this.exitStatus);
    }

    @NotNull
    public final String getCommand() {
        return this.command;
    }

    @NotNull
    public final ExitStatus getExitStatus() {
        return this.exitStatus;
    }

    @NotNull
    public final String getStdout() {
        return this.stdout;
    }

    @NotNull
    public final String getStderr() {
        return this.stderr;
    }

    @Nullable
    public final Integer getExitCode() {
        return this.exitCode;
    }

    public final boolean isErrorOrFatal() {
        CharSequence charSequence = this.combinedOutput(false);
        return new Regex("(fatal|error): ").containsMatchIn(charSequence);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String combinedOutput(boolean removeProgressLines) {
        String string;
        String $this$letIf$iv = this.stdout + "\n" + this.stderr;
        boolean $i$f$letIf = false;
        if (removeProgressLines) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            String it = $this$letIf$iv;
            boolean bl = false;
            Iterable iterable = StringsKt.lines((CharSequence)it);
            boolean $i$f$filter = false;
            void var8_8 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String line = (String)element$iv$iv;
                boolean bl2 = false;
                if (!(GitOutputKt.matchProgress(line) == null && !StringsKt.isBlank((CharSequence)line))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        } else {
            void var2_2;
            string = var2_2;
        }
        return string;
    }

    public static /* synthetic */ String combinedOutput$default(GitOutput gitOutput, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return gitOutput.combinedOutput(bl);
    }

    @NotNull
    public final GitOutput throwIfNonZero() {
        Integer n = ExecApiKt.getExitCode((ExitStatus)this.exitStatus);
        if (n == null || n != 0) {
            GitExceptionKt.throwGitCommandException(this.command, GitOutput.combinedOutput$default(this, false, 1, null));
        }
        return this;
    }

    @NotNull
    public final List<String> outputLines() {
        return StringsKt.lines((CharSequence)this.stdout);
    }
}

