/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.utils;

import com.intellij.internal.statistic.eventLog.util.StringUtil;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.FUSRegexpAwareRule;
import com.intellij.internal.statistic.eventLog.validator.rules.FUSRule;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupContextData;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.EnumValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.ExpressionValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.RegexpValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.UtilValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.BooleanRuleProducer;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.EnumReferenceRuleProducer;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.EnumRuleProducer;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.RegexpReferenceRuleProducer;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.RegexpRuleProducer;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.RejectingUtilRuleProducer;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.UtilRuleProducer;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.ValidationRuleProducer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ValidationSimpleRuleFactory {
    public static final String UTIL_PREFIX = "util#";
    private static final String START = "{";
    private static final String END = "}";
    private static final List<ValidationRuleProducer<?>> RULE_PRODUCERS = Arrays.asList(new BooleanRuleProducer(), new EnumRuleProducer(), new EnumReferenceRuleProducer(), new RegexpRuleProducer(), new RegexpReferenceRuleProducer());
    public static final UtilRuleProducer REJECTING_UTIL_URL_PRODUCER = new RejectingUtilRuleProducer();
    private final List<ValidationRuleProducer<?>> myRuleProducers;
    public static final FUSRule UNPARSED_EXPRESSION = (s, c) -> ValidationResultType.INCORRECT_RULE;

    public ValidationSimpleRuleFactory(@NotNull UtilRuleProducer utilRuleProducer) {
        ArrayList producers = new ArrayList(RULE_PRODUCERS);
        producers.add(utilRuleProducer);
        this.myRuleProducers = producers;
    }

    public FUSRule @NotNull [] getRules(@Nullable Set<String> rules, @NotNull EventGroupContextData contextData) {
        if (rules == null) {
            return FUSRule.EMPTY_ARRAY;
        }
        ArrayList<FUSRule> fusRules = new ArrayList<FUSRule>();
        for (String rule : rules) {
            fusRules.add(this.createRule(rule, contextData));
        }
        fusRules.sort(ValidationSimpleRuleFactory.getRulesComparator());
        return fusRules.toArray(FUSRule.EMPTY_ARRAY);
    }

    @NotNull
    private static Comparator<FUSRule> getRulesComparator() {
        return (o1, o2) -> {
            if (o1 instanceof EnumValidationRule) {
                return o2 instanceof EnumValidationRule ? 0 : -1;
            }
            return o2 instanceof EnumValidationRule ? 1 : 0;
        };
    }

    @NotNull
    private FUSRule createRule(@NotNull String rule, @NotNull EventGroupContextData contextData) {
        FUSRule wlr = this.createSimpleRule(rule.trim(), contextData);
        return wlr != null ? wlr : this.createExpressionRule(rule.trim(), contextData);
    }

    @Nullable
    private FUSRule createSimpleRule(@NotNull String rule, @NotNull EventGroupContextData contextData) {
        for (ValidationRuleProducer<?> builder : this.myRuleProducers) {
            String value;
            String prefix = builder.getPrefix();
            if (!rule.startsWith(prefix) || StringUtil.isEmpty(value = rule.substring(prefix.length()))) continue;
            return builder.createValidationRule(value, contextData);
        }
        return null;
    }

    @NotNull
    private FUSRule createExpressionRule(@NotNull String rule, @NotNull EventGroupContextData contextData) {
        FUSRule simpleRule;
        String n;
        List<String> nodes = ValidationSimpleRuleFactory.parseSimpleExpression(rule);
        if (nodes.size() == 1 && (n = nodes.get(0)).contains(START) && (simpleRule = this.createSimpleRule(ValidationSimpleRuleFactory.unwrapRuleNode(n), contextData)) != null) {
            return simpleRule;
        }
        if (rule.contains(UTIL_PREFIX)) {
            return this.createExpressionUtilRule(nodes);
        }
        return this.createExpressionValidationRule(rule, contextData);
    }

    @NotNull
    private FUSRule createExpressionValidationRule(@NotNull String rule, @NotNull EventGroupContextData contextData) {
        StringBuilder sb = new StringBuilder();
        for (String node : ValidationSimpleRuleFactory.parseSimpleExpression(rule)) {
            if (ValidationSimpleRuleFactory.isExpressionNode(node)) {
                FUSRule fusRule = this.createRule(ValidationSimpleRuleFactory.unwrapRuleNode(node), contextData);
                if (fusRule instanceof FUSRegexpAwareRule) {
                    sb.append("(");
                    sb.append(((FUSRegexpAwareRule)fusRule).asRegexp());
                    sb.append(")");
                    continue;
                }
                return UNPARSED_EXPRESSION;
            }
            sb.append(RegexpValidationRule.escapeText(node));
        }
        return new RegexpValidationRule(sb.toString());
    }

    private FUSRule createExpressionUtilRule(@NotNull List<String> nodes) {
        FUSRule fusRule = null;
        String suffix = "";
        String prefix = "";
        boolean utilNodeFound = false;
        for (String string : nodes) {
            if (ValidationSimpleRuleFactory.isExpressionNode(string)) {
                if (!string.contains(UTIL_PREFIX)) {
                    return UNPARSED_EXPRESSION;
                }
                FUSRule simpleRule = this.createRule(ValidationSimpleRuleFactory.unwrapRuleNode(string), EventGroupContextData.EMPTY);
                if (!(simpleRule instanceof UtilValidationRule)) {
                    return UNPARSED_EXPRESSION;
                }
                fusRule = simpleRule;
                utilNodeFound = true;
                continue;
            }
            if (utilNodeFound) {
                suffix = string;
                continue;
            }
            prefix = string;
        }
        if (fusRule == null) {
            return UNPARSED_EXPRESSION;
        }
        return new ExpressionValidationRule(fusRule, prefix, suffix);
    }

    @NotNull
    public static List<String> parseSimpleExpression(@NotNull String s) {
        int currentRuleStart = s.indexOf(START);
        if (StringUtil.isEmptyOrSpaces(s)) {
            return Collections.emptyList();
        }
        if (currentRuleStart == -1) {
            return Collections.singletonList(s);
        }
        int lastRuleEnd = -1;
        ArrayList<String> nodes = new ArrayList<String>();
        if (currentRuleStart > 0) {
            ValidationSimpleRuleFactory.addNonEmpty(nodes, s.substring(0, currentRuleStart));
        }
        while (currentRuleStart >= 0) {
            int nextRule;
            int currentRuleEnd;
            if (s.startsWith("regexp:", currentRuleStart + START.length())) {
                currentRuleEnd = ValidationSimpleRuleFactory.getPairBracket(s, currentRuleStart);
                nextRule = s.indexOf(START, currentRuleEnd);
            } else {
                currentRuleEnd = s.indexOf(END, currentRuleStart);
                nextRule = s.indexOf(START, currentRuleStart + START.length());
            }
            if (currentRuleEnd == -1) {
                return Collections.emptyList();
            }
            lastRuleEnd = currentRuleEnd + END.length();
            if (nextRule > 0 && nextRule < lastRuleEnd) {
                return Collections.emptyList();
            }
            ValidationSimpleRuleFactory.addNonEmpty(nodes, s.substring(currentRuleStart, lastRuleEnd));
            currentRuleStart = s.indexOf(START, lastRuleEnd);
            if (currentRuleStart <= 0) continue;
            ValidationSimpleRuleFactory.addNonEmpty(nodes, s.substring(lastRuleEnd, currentRuleStart));
        }
        if (lastRuleEnd > 0) {
            ValidationSimpleRuleFactory.addNonEmpty(nodes, s.substring(lastRuleEnd));
        }
        return nodes;
    }

    private static int getPairBracket(String s, Integer index) {
        int opensStack = 0;
        for (int curIndex = index.intValue(); curIndex < s.length(); ++curIndex) {
            if (s.startsWith(START, curIndex)) {
                ++opensStack;
                continue;
            }
            if (!s.startsWith(END, curIndex) || --opensStack != 0) continue;
            return curIndex;
        }
        return -1;
    }

    private static void addNonEmpty(@NotNull List<? super String> nodes, @Nullable String s) {
        if (!StringUtil.isEmpty(s)) {
            nodes.add(s);
        }
    }

    private static boolean isExpressionNode(@NotNull String node) {
        return node.startsWith(START) && node.endsWith(END);
    }

    @NotNull
    private static String unwrapRuleNode(@NotNull String rule) {
        return ValidationSimpleRuleFactory.isExpressionNode(rule) ? rule.substring(START.length(), rule.length() - END.length()) : rule;
    }
}

