/*
 * Decompiled with CFR 0.152.
 */
package org.clank.support.aliases;

import java.io.PrintWriter;
import org.clank.support.AbstractArrayPointerType;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.char$ptr$array;
import org.clank.support.aliases.type$ptr;
import org.clank.support.aliases.type$ref;
import org.clank.support.void$ptr;

public final class type$ptr$array<T>
extends AbstractArrayPointerType<type$ptr<T>>
implements type$ptr<T> {
    T[] array;
    private static long nonConstInstances = 0L;
    private static long constPtrInstances = 0L;
    private static long constContentInstances = 0L;
    private static long fullyConstInstances = 0L;

    protected type$ptr$array(type$ptr$array<T> other, boolean makeConstPtr, boolean makeConstContent) {
        super(other, makeConstPtr, type$ptr$array.adjustImmutableContent(makeConstContent, other.array));
        this.array = other.array;
        type$ptr$array.trackInstance(makeConstPtr, makeConstContent);
    }

    public type$ptr$array() {
        this(null, 0, false, false);
    }

    public type$ptr$array(T[] arr) {
        this(arr, 0, false, false);
    }

    public type$ptr$array(T[] arr, int idx) {
        this(arr, idx, false, false);
    }

    public type$ptr$array(T[] arr, boolean makeConstPtr) {
        this(arr, 0, makeConstPtr, false);
    }

    public type$ptr$array(T[] arr, int idx, boolean makeConstPtr) {
        this(arr, idx, makeConstPtr, false);
    }

    public type$ptr$array(T[] arr, int idx, boolean makeConstPtr, boolean makeConstContent) {
        super(makeConstPtr, type$ptr$array.adjustImmutableContent(makeConstContent, arr));
        this.array = arr;
        assert (idx >= 0) : "can not be negative " + idx;
        this.index = idx;
        type$ptr$array.trackInstance(makeConstPtr, makeConstContent);
    }

    private static boolean adjustImmutableContent(boolean curConstValue, Object arrayToCheck) {
        if ($assertionsDisabled || !(curConstValue |= !NativeTrace.getArrayName(arrayToCheck).isEmpty())) {
            // empty if block
        }
        return curConstValue;
    }

    @Override
    public boolean $isNull() {
        return this.array == null;
    }

    @Override
    public T $star() {
        return this.array[this.index];
    }

    @Override
    public T $set(T value) {
        return this.$set(0, value);
    }

    @Override
    public T $at(int index) {
        return this.array[this.index + index];
    }

    @Override
    public int $sub(type$ptr<T> other) {
        assert (other instanceof type$ptr$array) : "unexpected object " + other;
        return this.index - ((type$ptr$array)other).index;
    }

    @Override
    public type$ptr$array<T> $add(int amount) {
        type$ptr$array<T> cloned = new type$ptr$array<T>(this, false, this._isConstContent());
        cloned.index += amount;
        return cloned;
    }

    @Override
    public type$ptr$array<T> $sub(int amount) {
        type$ptr$array<T> cloned = new type$ptr$array<T>(this, false, this._isConstContent());
        cloned.index -= amount;
        return cloned;
    }

    @Override
    public T $set(int index, T value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        T t = value;
        this.array[this.index + index] = t;
        return t;
    }

    @Override
    public type$ptr<T> $assign(type$ptr<T> value) {
        assert (!this._isConstPtr()) : "Cannot modify const object!";
        if (value == null) {
            this.array = null;
            this.index = 0;
            return this;
        }
        if (value instanceof type$ptr$array) {
            type$ptr$array val = (type$ptr$array)value;
            this.array = val.array;
            this.index = val.index;
            if (val._isConstContent()) {
                super.$toConstContent();
            }
            return this;
        }
        throw new IllegalArgumentException("Different pointer types: expected '" + this.getClass().getName() + "', but found '" + (value != null ? value.getClass() : "null") + "'");
    }

    @Override
    public boolean isComparableTo(void$ptr other) {
        return other instanceof type$ptr$array && ((type$ptr$array)other).array == this.array;
    }

    @Override
    public boolean $less(Object obj) {
        if (obj instanceof type$ptr$array) {
            type$ptr$array other = (type$ptr$array)obj;
            return other.array == this.array && this.index - other.index < 0;
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + this.getClass() + " and " + obj.getClass());
    }

    @Override
    public boolean $lesseq(Object obj) {
        if (obj instanceof type$ptr$array) {
            type$ptr$array other = (type$ptr$array)obj;
            return other.array == this.array && this.index - other.index <= 0;
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + this.getClass() + " and " + obj.getClass());
    }

    @Override
    public boolean $greater(Object obj) {
        if (obj instanceof type$ptr$array) {
            type$ptr$array other = (type$ptr$array)obj;
            return other.array == this.array && this.index - other.index > 0;
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + this.getClass() + " and " + obj.getClass());
    }

    @Override
    public boolean $greatereq(Object obj) {
        if (obj instanceof type$ptr$array) {
            type$ptr$array other = (type$ptr$array)obj;
            return other.array == this.array && this.index - other.index >= 0;
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + this.getClass() + " and " + obj.getClass());
    }

    @Override
    public boolean $eq(Object p) {
        if (p instanceof type$ptr$array) {
            type$ptr$array other = (type$ptr$array)p;
            return other.array == this.array && this.index == other.index;
        }
        return false;
    }

    @Override
    public boolean $noteq(Object p) {
        return !this.$eq(p);
    }

    @Override
    public type$ref<T> star$ref() {
        return new type$ref<T>(){
            type$ptr$array<T> localPtr;
            {
                this.localPtr = type$ptr$array.this;
            }

            @Override
            public T $deref() {
                return this.localPtr.$star();
            }

            @Override
            public T $set(T value) {
                return this.localPtr.$set(value);
            }

            @Override
            public type$ptr<T> deref$ptr() {
                if (this.localPtr == type$ptr$array.this) {
                    this.localPtr = this.localPtr.clone();
                }
                return this.localPtr;
            }
        };
    }

    @Override
    public int $hashcode() {
        return System.identityHashCode(this.array) ^ this.index;
    }

    @Override
    public type$ptr$array<T> clone() {
        return new type$ptr$array<T>(this, false, this._isConstContent());
    }

    @Override
    public type$ptr$array<T> const_clone() {
        return super._isConstPtr() ? this : new type$ptr$array<T>(this, true, this._isConstContent());
    }

    public String toString() {
        String arrName = NativeTrace.getArrayName(this.array);
        if (this.array == null || this.array.length == 0) {
            return arrName + "<EMPTY>";
        }
        StringBuilder sb = new StringBuilder(arrName + "\n" + char$ptr$array.class.getSimpleName() + "{range=[" + this.index + "-" + this.array.length + "]\n");
        String fmt = "%" + (int)Math.ceil(Math.log10(this.array.length + 1)) + "d";
        for (int i = this.index; i < this.array.length; ++i) {
            T b = this.array[i];
            sb.append(i == this.index ? "*[" : " [").append(String.format(fmt, i)).append("]");
            sb.append(b).append("\n");
            if (i - this.index <= 256) continue;
            sb.append("....");
            break;
        }
        sb.append("}").append(type$ptr$array.class.getSimpleName()).append("\n");
        return sb.toString();
    }

    public static void trackInstance(boolean constPtr, boolean constContent) {
        if (NativeTrace.STATISTICS) {
            if (constPtr && constContent) {
                ++fullyConstInstances;
            } else if (constPtr) {
                ++constPtrInstances;
            } else if (constContent) {
                ++constContentInstances;
            } else {
                ++nonConstInstances;
            }
        }
    }

    public static void clearStatistics() {
        fullyConstInstances = 0L;
        constPtrInstances = 0L;
        constContentInstances = 0L;
        nonConstInstances = 0L;
    }

    public static long printStatistics(PrintWriter out) {
        long totalInstances = nonConstInstances + fullyConstInstances + constPtrInstances + constContentInstances;
        out.printf("%30s created all:\t%s%n", type$ptr$array.class.getSimpleName(), NativeTrace.formatNumber(totalInstances));
        out.printf("%32s non const:\t%s%n", type$ptr$array.class.getSimpleName(), NativeTrace.formatNumber(nonConstInstances));
        out.printf("%32s const ptr:\t%s%n", type$ptr$array.class.getSimpleName(), NativeTrace.formatNumber(constPtrInstances));
        out.printf("%28s const content:\t%s%n", type$ptr$array.class.getSimpleName(), NativeTrace.formatNumber(constContentInstances));
        out.printf("%20s const ptr and content:\t%s%n", type$ptr$array.class.getSimpleName(), NativeTrace.formatNumber(fullyConstInstances));
        return totalInstances;
    }

    @Override
    public final T[] $array() {
        return this.array;
    }
}

