/*
 * Decompiled with CFR 0.152.
 */
package org.clank.support.aliases;

import java.io.PrintWriter;
import org.clank.support.AbstractArrayPointerType;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.bool$ptr;
import org.clank.support.aliases.bool$ref;
import org.clank.support.aliases.char$ptr$array;
import org.clank.support.void$ptr;

public final class bool$ptr$array
extends AbstractArrayPointerType<bool$ptr>
implements bool$ptr {
    boolean[] array;
    private static long nonConstInstances = 0L;
    private static long constPtrInstances = 0L;
    private static long constContentInstances = 0L;
    private static long fullyConstInstances = 0L;

    protected bool$ptr$array(bool$ptr$array other, boolean makeConstPtr, boolean makeConstContent) {
        super(other, makeConstPtr, bool$ptr$array.adjustImmutableContent(makeConstContent, other.array));
        this.array = other.array;
        bool$ptr$array.trackInstance(makeConstPtr, makeConstContent);
    }

    public bool$ptr$array() {
        this(null, 0, false, false);
    }

    public bool$ptr$array(boolean[] arr) {
        this(arr, 0, false, false);
    }

    public bool$ptr$array(boolean[] arr, int idx) {
        this(arr, idx, false, false);
    }

    public bool$ptr$array(boolean[] arr, boolean makeConstPtr) {
        this(arr, 0, makeConstPtr, false);
    }

    public bool$ptr$array(boolean[] arr, int idx, boolean makeConstPtr) {
        this(arr, idx, makeConstPtr, false);
    }

    public bool$ptr$array(boolean[] arr, int idx, boolean makeConstPtr, boolean makeConstContent) {
        super(makeConstPtr, bool$ptr$array.adjustImmutableContent(makeConstContent, arr));
        this.array = arr;
        assert (idx >= 0) : "can not be negative " + idx;
        this.index = idx;
        bool$ptr$array.trackInstance(makeConstPtr, makeConstContent);
    }

    private static boolean adjustImmutableContent(boolean curConstValue, Object arrayToCheck) {
        if ($assertionsDisabled || !(curConstValue |= !NativeTrace.getArrayName(arrayToCheck).isEmpty())) {
            // empty if block
        }
        return curConstValue;
    }

    @Override
    public boolean $isNull() {
        return this.array == null;
    }

    @Override
    public boolean $star() {
        return this.array[this.index];
    }

    @Override
    public boolean $set(boolean value) {
        return this.$set(0, value);
    }

    @Override
    public boolean $at(int index) {
        return this.array[this.index + index];
    }

    @Override
    public int $sub(bool$ptr other) {
        assert (other instanceof bool$ptr$array) : "unexpected object " + other;
        return this.index - ((bool$ptr$array)other).index;
    }

    @Override
    public bool$ptr$array $add(int amount) {
        bool$ptr$array cloned = new bool$ptr$array(this, false, this._isConstContent());
        cloned.index += amount;
        return cloned;
    }

    @Override
    public bool$ptr$array $sub(int amount) {
        bool$ptr$array cloned = new bool$ptr$array(this, false, this._isConstContent());
        cloned.index -= amount;
        return cloned;
    }

    @Override
    public boolean $set(int index, boolean value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        boolean bl = value;
        this.array[this.index + index] = bl;
        return bl;
    }

    @Override
    public boolean $set$andassign(int index, boolean value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        boolean bl = this.array[n] & value;
        this.array[n] = bl;
        return bl;
    }

    @Override
    public boolean $set$xorassign(int index, boolean value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        boolean bl = this.array[n] ^ value;
        this.array[n] = bl;
        return bl;
    }

    @Override
    public boolean $set$orassign(int index, boolean value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        boolean bl = this.array[n] | value;
        this.array[n] = bl;
        return bl;
    }

    @Override
    public bool$ptr $assign(bool$ptr value) {
        assert (!this._isConstPtr()) : "Cannot modify const object!";
        if (value == null) {
            this.array = null;
            this.index = 0;
            return this;
        }
        if (value instanceof bool$ptr$array) {
            bool$ptr$array val = (bool$ptr$array)value;
            this.array = val.array;
            this.index = val.index;
            if (val._isConstContent()) {
                super.$toConstContent();
            }
            return this;
        }
        throw new IllegalArgumentException("Different pointer types: expected '" + this.getClass().getName() + "', but found '" + (value != null ? value.getClass() : "null") + "'");
    }

    @Override
    public boolean isComparableTo(void$ptr other) {
        return other instanceof bool$ptr$array && ((bool$ptr$array)other).array == this.array;
    }

    @Override
    public boolean $less(Object obj) {
        if (obj instanceof bool$ptr$array) {
            bool$ptr$array other = (bool$ptr$array)obj;
            return other.array == this.array && this.index - other.index < 0;
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + this.getClass() + " and " + obj.getClass());
    }

    @Override
    public boolean $lesseq(Object obj) {
        if (obj instanceof bool$ptr$array) {
            bool$ptr$array other = (bool$ptr$array)obj;
            return other.array == this.array && this.index - other.index <= 0;
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + this.getClass() + " and " + obj.getClass());
    }

    @Override
    public boolean $greater(Object obj) {
        if (obj instanceof bool$ptr$array) {
            bool$ptr$array other = (bool$ptr$array)obj;
            return other.array == this.array && this.index - other.index > 0;
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + this.getClass() + " and " + obj.getClass());
    }

    @Override
    public boolean $greatereq(Object obj) {
        if (obj instanceof bool$ptr$array) {
            bool$ptr$array other = (bool$ptr$array)obj;
            return other.array == this.array && this.index - other.index >= 0;
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + this.getClass() + " and " + obj.getClass());
    }

    @Override
    public boolean $eq(Object p) {
        if (p instanceof bool$ptr$array) {
            bool$ptr$array other = (bool$ptr$array)p;
            return other.array == this.array && this.index == other.index;
        }
        return false;
    }

    @Override
    public boolean $noteq(Object p) {
        return !this.$eq(p);
    }

    @Override
    public bool$ref star$ref() {
        return new bool$ref(){
            bool$ptr$array localPtr;
            {
                this.localPtr = bool$ptr$array.this;
            }

            @Override
            public boolean $deref() {
                return this.localPtr.$star();
            }

            @Override
            public boolean $set(boolean value) {
                return this.localPtr.$set(value);
            }

            @Override
            public bool$ptr deref$ptr() {
                if (this.localPtr == bool$ptr$array.this) {
                    this.localPtr = this.localPtr.clone();
                }
                return this.localPtr;
            }
        };
    }

    @Override
    public int $hashcode() {
        return System.identityHashCode(this.array) ^ this.index;
    }

    @Override
    public bool$ptr$array clone() {
        return new bool$ptr$array(this, false, this._isConstContent());
    }

    @Override
    public bool$ptr$array const_clone() {
        return super._isConstPtr() ? this : new bool$ptr$array(this, true, this._isConstContent());
    }

    public String toString() {
        String arrName = NativeTrace.getArrayName(this.array);
        if (this.array == null || this.array.length == 0) {
            return arrName + "<EMPTY>";
        }
        StringBuilder sb = new StringBuilder(arrName + "\n" + char$ptr$array.class.getSimpleName() + "{range=[" + this.index + "-" + this.array.length + "]\n");
        String fmt = "%" + (int)Math.ceil(Math.log10(this.array.length + 1)) + "d";
        for (int i = this.index; i < this.array.length; ++i) {
            boolean b = this.array[i];
            sb.append(i == this.index ? "*[" : " [").append(String.format(fmt, i)).append("]");
            sb.append(b).append("\n");
            if (i - this.index <= 256) continue;
            sb.append("....");
            break;
        }
        sb.append("}").append(bool$ptr$array.class.getSimpleName()).append("\n");
        return sb.toString();
    }

    public static void trackInstance(boolean constPtr, boolean constContent) {
        if (NativeTrace.STATISTICS) {
            if (constPtr && constContent) {
                ++fullyConstInstances;
            } else if (constPtr) {
                ++constPtrInstances;
            } else if (constContent) {
                ++constContentInstances;
            } else {
                ++nonConstInstances;
            }
        }
    }

    public static void clearStatistics() {
        fullyConstInstances = 0L;
        constPtrInstances = 0L;
        constContentInstances = 0L;
        nonConstInstances = 0L;
    }

    public static long printStatistics(PrintWriter out) {
        long totalInstances = nonConstInstances + fullyConstInstances + constPtrInstances + constContentInstances;
        out.printf("%30s created all:\t%s%n", bool$ptr$array.class.getSimpleName(), NativeTrace.formatNumber(totalInstances));
        out.printf("%32s non const:\t%s%n", bool$ptr$array.class.getSimpleName(), NativeTrace.formatNumber(nonConstInstances));
        out.printf("%32s const ptr:\t%s%n", bool$ptr$array.class.getSimpleName(), NativeTrace.formatNumber(constPtrInstances));
        out.printf("%28s const content:\t%s%n", bool$ptr$array.class.getSimpleName(), NativeTrace.formatNumber(constContentInstances));
        out.printf("%20s const ptr and content:\t%s%n", bool$ptr$array.class.getSimpleName(), NativeTrace.formatNumber(fullyConstInstances));
        return totalInstances;
    }

    @Override
    public final boolean[] $array() {
        return this.array;
    }
}

