/*
 * Decompiled with CFR 0.152.
 */
package org.clank.support;

import java.util.Comparator;
import java.util.Locale;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.uint$ptr;
import org.clank.support.aliases.uint$ref;
import org.clank.support.aliases.ulong$ref;
import org.clank.support.aliases.ushort$ref;

public final class Unsigned {
    public static final Comparator<Integer> UINT_COMPARATOR = new Comparator<Integer>(){

        @Override
        public int compare(Integer u1, Integer u2) {
            return Unsigned.$compare_uint(u1, u2);
        }
    };
    public static final Comparator<Long> ULONG_COMPARATOR = new Comparator<Long>(){

        @Override
        public int compare(Long u1, Long u2) {
            return Unsigned.$compare_ulong(u1, u2);
        }
    };

    public static int $int2uint(int Val) {
        return Val;
    }

    public static int $uint2int(int Val) {
        return Val;
    }

    @Deprecated
    public static int $long2uint(int longVal) {
        NativeTrace.traceNotImplemented("[remove $long2uint(int) usage]");
        return longVal;
    }

    public static long $long2ulong(long longVal) {
        return longVal;
    }

    public static long $long2ullong(long longVal) {
        return longVal;
    }

    public static int $long2uint(long longVal) {
        assert ((longVal & 0xFFFFFFFF00000000L) == 0L) : "incorrect long value " + longVal + ":" + Long.toHexString(longVal);
        int out = (int)longVal;
        return out;
    }

    public static char $long2ushort(long longVal) {
        assert ((longVal & 0xFFFFFFFFFFFF0000L) == 0L) : "incorrect long value " + longVal + ":" + Long.toHexString(longVal);
        char out = (char)longVal;
        return out;
    }

    public static byte $long2uchar(long longVal) {
        assert ((longVal & 0xFFFFFFFFFFFFFF00L) == 0L) : "incorrect long value " + longVal + ":" + Long.toHexString(longVal);
        byte out = (byte)longVal;
        return out;
    }

    public static int $long2int(long longVal) {
        assert ((longVal & 0xFFFFFFFF00000000L) == 0L || (longVal & 0xFFFFFFFF00000000L) != 0L && (longVal & 0xFFFFFFFF00000000L) == -4294967296L) : "incorrect long value " + longVal + ":" + Long.toHexString(longVal);
        int out = (int)longVal;
        return out;
    }

    public static int $llong2int(long longVal) {
        return Unsigned.$long2int(longVal);
    }

    public static byte $int2uchar(int intVal) {
        assert ((intVal & 0xFFFFFF00) == 0 || (intVal & 0xFFFFFF) != 0 && (intVal & 0xFFFFFF00) == -256) : "incorrect int value " + intVal + ":" + Integer.toHexString(intVal);
        byte out = (byte)intVal;
        return out;
    }

    public static char $int2ushort(int intVal) {
        assert ((intVal & 0xFFFF0000) == 0 || (intVal & 0xFFFF) != 0 && (intVal & 0xFFFF0000) == -65536) : "incorrect int value " + intVal + ":" + Integer.toHexString(intVal);
        char out = (char)intVal;
        return out;
    }

    public static short $int2short(int intVal) {
        assert ((intVal & 0xFFFF0000) == 0 || (intVal & 0xFFFF) != 0 && (intVal & 0xFFFF0000) == -65536) : "incorrect int value " + intVal + ":" + Integer.toHexString(intVal);
        short out = (short)intVal;
        return out;
    }

    public static byte $int2char(int intVal) {
        assert ((intVal & 0xFFFFFF00) == 0 || (intVal & 0xFF) != 0 && (intVal & 0xFFFFFF00) == -256) : "incorrect int value " + intVal + ":" + Integer.toHexString(intVal);
        byte out = (byte)intVal;
        return out;
    }

    public static byte $int2schar(int intVal) {
        return Unsigned.$int2char(intVal);
    }

    public static byte $uint2uchar(boolean uintVal) {
        return Unsigned.$uint2uchar(uintVal ? 1 : 0);
    }

    public static byte $uint2uchar(int uintVal) {
        assert ((uintVal & 0xFFFFFF00) == 0) : "incorrect uint value " + uintVal + ":" + Integer.toHexString(uintVal);
        byte out = (byte)uintVal;
        return out;
    }

    public static byte $uint2schar(int uintVal) {
        byte out = (byte)uintVal;
        return out;
    }

    public static byte $uint2char(int uintVal) {
        assert ((uintVal & 0xFFFFFF00) == 0) : "incorrect uint value " + uintVal + ":" + Integer.toHexString(uintVal);
        byte out = (byte)uintVal;
        return out;
    }

    public static char $uint2UTF16(int uintVal) {
        return Unsigned.$uint2ushort(uintVal);
    }

    public static char $uint2ushort(int uintVal) {
        assert ((uintVal & 0xFFFF0000) == 0) : "incorrect uint value " + uintVal + ":" + Integer.toHexString(uintVal);
        char out = (char)uintVal;
        return out;
    }

    public static short $uint2short(int uintVal) {
        assert ((uintVal & 0xFFFF0000) == 0 || (uintVal & 0xFFFF0000) != 0 && (uintVal & 0xFFFF0000) == -65536) : "incorrect uint value " + uintVal + ":" + Integer.toHexString(uintVal);
        short out = (short)uintVal;
        return out;
    }

    public static long $ulong2long(long longVal) {
        return longVal;
    }

    public static long $ullong2long(long longVal) {
        return longVal;
    }

    public static int $ulong2uint(long longVal) {
        assert ((longVal & 0xFFFFFFFF00000000L) == 0L || (longVal & 0xFFFFFFFF00000000L) != 0L && (longVal & 0xFFFFFFFF00000000L) == -4294967296L) : "incorrect ulong value " + longVal + ":" + Long.toHexString(longVal);
        int out = (int)longVal;
        return out;
    }

    public static int $llong2uint(long longVal) {
        return Unsigned.$ulong2uint(longVal);
    }

    public static byte $ulong2uchar(long longVal) {
        assert ((longVal & 0xFFFFFFFFFFFFFF00L) == 0L) : "incorrect ulong value " + longVal + ":" + Long.toHexString(longVal);
        byte out = (byte)longVal;
        return out;
    }

    public static byte $ulong2char(long longVal) {
        byte out = (byte)longVal;
        return out;
    }

    public static char $ulong2ushort(long longVal) {
        assert ((longVal & 0xFFFFFFFFFFFF0000L) == 0L) : "incorrect ulong value " + longVal + ":" + Long.toHexString(longVal);
        char out = (char)longVal;
        return out;
    }

    public static char $ullong2ushort(long longVal) {
        assert ((longVal & 0xFFFFFFFFFFFF0000L) == 0L) : "incorrect ulong value " + longVal + ":" + Long.toHexString(longVal);
        char out = (char)longVal;
        return out;
    }

    public static int $ulong2int(ulong$ref ulongVal) {
        return Unsigned.$ulong2int(ulongVal.$deref());
    }

    public static int $ulong2int(long longVal) {
        assert ((longVal & 0xFFFFFFFF00000000L) == 0L || (longVal & 0xFFFFFFFF00000000L) != 0L && (longVal & 0xFFFFFFFF00000000L) == -4294967296L) : "incorrect ulong value " + longVal + ":" + Long.toHexString(longVal);
        int out = (int)longVal;
        return out;
    }

    public static Long $ullong2uintptr_t(long longVal) {
        return longVal;
    }

    public static int $ullong2uint(long longVal) {
        assert ((longVal & 0xFFFFFFFF00000000L) == 0L || (longVal & 0xFFFFFFFF00000000L) != 0L && (longVal & 0xFFFFFFFF00000000L) == -4294967296L) : "incorrect ullong value " + longVal + ":" + Long.toHexString(longVal);
        int out = (int)longVal;
        return out;
    }

    public static short $ullong2short(long longVal) {
        assert ((longVal & 0xFFFFFFFFFFFF0000L) == 0L || (longVal & 0xFFFFFFFFFFFF0000L) != 0L && (longVal & 0xFFFFFFFFFFFF0000L) == -65536L) : "incorrect ulong value " + longVal + ":" + Long.toHexString(longVal);
        short out = (short)longVal;
        return out;
    }

    public static int $ullong2int(long longVal) {
        assert ((longVal & 0xFFFFFFFF00000000L) == 0L || (longVal & 0xFFFFFFFF00000000L) != 0L && (longVal & 0xFFFFFFFF00000000L) == -4294967296L) : "incorrect ulong value " + longVal + ":" + Long.toHexString(longVal);
        int out = (int)longVal;
        return out;
    }

    public static byte $ullong2char(long longVal) {
        assert ((longVal & 0xFFFFFFFFFFFFFF00L) == 0L) : "incorrect ullong value " + longVal + ":" + Long.toHexString(longVal);
        byte out = (byte)longVal;
        return out;
    }

    public static byte $ullong2uchar(long longVal) {
        return Unsigned.$ullong2char(longVal);
    }

    public static long $ullong2ulong(long longVal) {
        return longVal;
    }

    public static long $ulong2ullong(long longVal) {
        return longVal;
    }

    public static long $int2ulong(int intVal) {
        long out = intVal;
        return out;
    }

    public static long $int2ullong(int intVal) {
        long out = intVal;
        return out;
    }

    public static long $uint2llong(int intVal) {
        long out = Integer.toUnsignedLong(intVal);
        assert (out >= 0L);
        return out;
    }

    public static long $uint2long(int intVal) {
        long out = Integer.toUnsignedLong(intVal);
        assert (out >= 0L);
        return out;
    }

    public static long $uint32_t2ulong(int intVal) {
        long out = Integer.toUnsignedLong(intVal);
        assert (out >= 0L);
        return out;
    }

    public static long $uid_t2ulong(int intVal) {
        long out = Integer.toUnsignedLong(intVal);
        assert (out >= 0L);
        return out;
    }

    public static long $uint2ulong(int intVal) {
        long out = Integer.toUnsignedLong(intVal);
        assert (out >= 0L);
        return out;
    }

    public static long $uint2ulong(boolean intVal) {
        return intVal ? 1L : 0L;
    }

    public static long $uint2ullong(int intVal) {
        long out = Integer.toUnsignedLong(intVal);
        assert (out >= 0L);
        return out;
    }

    public static long $uint2ullong(boolean intVal) {
        long out = intVal ? 1L : 0L;
        return out;
    }

    public static int $schar2uint(byte ubyteVal) {
        return Unsigned.$char2uint(ubyteVal);
    }

    public static int $char2uint(byte ubyteVal) {
        int out = Byte.toUnsignedInt(ubyteVal);
        assert (out >= 0);
        return out;
    }

    public static long $char2ullong(byte ubyteVal) {
        long out = Byte.toUnsignedLong(ubyteVal);
        assert (out >= 0L);
        return out;
    }

    public static long $char2ulong(byte ubyteVal) {
        long out = Byte.toUnsignedLong(ubyteVal);
        assert (out >= 0L);
        return out;
    }

    public static char $uchar2ushort(byte ubyteVal) {
        char out = (char)Byte.toUnsignedInt(ubyteVal);
        return out;
    }

    public static byte $int2uchar_3bits(int val) {
        assert (val >>> 3 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return (byte)(val & 7);
    }

    public static byte $int2uchar_7bits(int val) {
        assert (val >>> 7 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return (byte)(val & 0x7F);
    }

    public static byte $uint2uchar_3bits(int val) {
        return Unsigned.$int2uchar_3bits(val);
    }

    public static byte $uint2uchar_7bits(int val) {
        return Unsigned.$int2uchar_7bits(val);
    }

    public static byte $uchar2uchar_3bits(int val) {
        assert (val >>> 3 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return (byte)(val & 7);
    }

    public static byte $uchar2uchar_7bits(byte val) {
        assert (val >>> 7 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(Byte.toUnsignedInt(val));
        return (byte)(val & 0x7F);
    }

    public static byte $3bits_uchar2uchar(byte val) {
        assert (val >>> 3 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(Byte.toUnsignedInt(val));
        return val;
    }

    public static byte $7bits_uchar2uchar(byte val) {
        assert (val >>> 7 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(Byte.toUnsignedInt(val));
        return val;
    }

    public static int $uchar2int(char ubyteVal) {
        char out = ubyteVal;
        assert (out >= '\u0000');
        return out;
    }

    public static int $uchar2int(byte ubyteVal) {
        int out = Byte.toUnsignedInt(ubyteVal);
        assert (out >= 0);
        return out;
    }

    public static int $uchar2uint(byte ubyteVal) {
        int out = Byte.toUnsignedInt(ubyteVal);
        assert (out >= 0);
        return out;
    }

    public static long $uchar2long(byte ubyteVal) {
        long out = Byte.toUnsignedLong(ubyteVal);
        assert (out >= 0L);
        return out;
    }

    public static long $uchar2ulong(byte ubyteVal) {
        long out = Byte.toUnsignedLong(ubyteVal);
        assert (out >= 0L);
        return out;
    }

    public static long $uchar2ullong(byte ubyteVal) {
        long out = Byte.toUnsignedLong(ubyteVal);
        assert (out >= 0L);
        return out;
    }

    public static byte $ushort2schar(char ushortVal) {
        assert ((ushortVal & 0xFF00) == 0 || (ushortVal & 0xFF00) != 0 && (ushortVal & 0xFF00) == 65280) : "incorrect ushort value " + ushortVal + ":" + Integer.toHexString(ushortVal);
        byte out = (byte)ushortVal;
        return out;
    }

    public static byte $ushort2uchar(char ushortVal) {
        assert ((ushortVal & 0xFF00) == 0 || (ushortVal & 0xFF00) != 0 && (ushortVal & 0xFF00) == 65280) : "incorrect ushort value " + ushortVal + ":" + Integer.toHexString(ushortVal);
        byte out = (byte)ushortVal;
        return out;
    }

    public static int $ushort2int(char ushortVal) {
        char out = ushortVal;
        assert (out >= '\u0000');
        return out;
    }

    public static int $ushort2uint(char ushortVal) {
        char out = ushortVal;
        assert (out >= '\u0000');
        return out;
    }

    public static char $short2ushort(short shortVal) {
        return (char)shortVal;
    }

    public static int $short2uint(short shortVal) {
        return Short.toUnsignedInt(shortVal);
    }

    public static long $short2ulong(short shortVal) {
        return Short.toUnsignedLong(shortVal);
    }

    public static short $ushort2short(char ushortVal) {
        return (short)ushortVal;
    }

    public static long $ushort2long(char ushortVal) {
        long out = ushortVal;
        assert (out >= 0L);
        return out;
    }

    public static long $ushort2ulong(char ushortVal) {
        long out = ushortVal;
        assert (out >= 0L);
        return out;
    }

    public static boolean $less_char(byte u1, byte u2) {
        return u1 < u2;
    }

    public static boolean $lesseq_char(byte u1, byte u2) {
        return u1 <= u2;
    }

    public static int $compare_uchar(byte u1, byte u2) {
        return Integer.compare(Byte.toUnsignedInt(u1), Byte.toUnsignedInt(u2));
    }

    public static boolean $less_uchar(byte u1, byte u2) {
        return Unsigned.$compare_uchar(u1, u2) < 0;
    }

    public static boolean $less_uchar_uint(byte u1, int u2) {
        return Unsigned.$less_uint(Byte.toUnsignedInt(u1), u2);
    }

    public static boolean $lesseq_uchar(byte u1, byte u2) {
        return Unsigned.$compare_uchar(u1, u2) <= 0;
    }

    public static boolean $lesseq_uchar_uint(byte u1, int u2) {
        return Unsigned.$lesseq_uint(Byte.toUnsignedInt(u1), u2);
    }

    public static boolean $greatereq_uint_uchar(int u1, byte u2) {
        return Unsigned.$greatereq_uint(u1, Byte.toUnsignedInt(u2));
    }

    public static int $compare_int(int u1, int u2) {
        return Integer.compare(u1, u2);
    }

    public static boolean $less_int(int u1, int u2) {
        return Unsigned.$compare_int(u1, u2) < 0;
    }

    public static boolean $lesseq_int(int u1, int u2) {
        return Unsigned.$compare_int(u1, u2) <= 0;
    }

    public static boolean $greater_int(int u1, int u2) {
        return Unsigned.$compare_int(u1, u2) > 0;
    }

    public static boolean $greatereq_int(int u1, int u2) {
        return Unsigned.$compare_int(u1, u2) >= 0;
    }

    public static int $compare_ushort(char u1, char u2) {
        return u1 - u2;
    }

    public static boolean $less_ushort(char u1, char u2) {
        return Unsigned.$compare_ushort(u1, u2) < 0;
    }

    public static boolean $less_ushort(ushort$ref u1, char u2) {
        return Unsigned.$compare_ushort(u1.$deref(), u2) < 0;
    }

    public static boolean $lesseq_ushort(char u1, char u2) {
        return Unsigned.$compare_ushort(u1, u2) <= 0;
    }

    public static boolean $greater_ushort(char u1, char u2) {
        return Unsigned.$compare_ushort(u1, u2) > 0;
    }

    public static boolean $greater_ushort(ushort$ref u1, char u2) {
        return Unsigned.$compare_ushort(u1.$deref(), u2) > 0;
    }

    public static boolean $greatereq_ushort(char u1, char u2) {
        return Unsigned.$compare_ushort(u1, u2) >= 0;
    }

    public static boolean $greatereq_ushort(ushort$ref u1, char u2) {
        return Unsigned.$compare_ushort(u1.$deref(), u2) >= 0;
    }

    public static boolean $less_ushort_int(char u1, int u2) {
        return Unsigned.$less_int(Unsigned.$ushort2int(u1), u2);
    }

    public static boolean $less_ushort_uint(char u1, int u2) {
        return Unsigned.$less_uint(Unsigned.$ushort2uint(u1), u2);
    }

    public static String UIntToUnsignedString(char i, char radix) {
        return Integer.toUnsignedString(i, radix);
    }

    public static char $div_ushort(char dividend, char divisor) {
        return (char)(divisor / divisor);
    }

    public static char $rem_ushort(char dividend, char divisor) {
        return (char)(divisor % divisor);
    }

    public static int $compare_uint(int u1, int u2) {
        return Integer.compareUnsigned(u1, u2);
    }

    public static boolean $less_uint(int u1, int u2) {
        return Unsigned.$compare_uint(u1, u2) < 0;
    }

    public static boolean $less_uint(int u1, uint$ref u2) {
        return Unsigned.$compare_uint(u1, u2.$deref()) < 0;
    }

    public static boolean $less_uint(uint$ref u1, int u2) {
        return Unsigned.$compare_uint(u1.$deref(), u2) < 0;
    }

    public static boolean $less_uint(uint$ptr u1, int u2) {
        return Unsigned.$compare_uint(u1.$star(), u2) < 0;
    }

    public static boolean $less_uint(uint$ref u1, uint$ref u2) {
        return Unsigned.$compare_uint(u1.$deref(), u2.$deref()) < 0;
    }

    public static boolean $lesseq_uint(int u1, int u2) {
        return Unsigned.$compare_uint(u1, u2) <= 0;
    }

    public static boolean $lesseq_void_uint(int u1, int u2) {
        return Unsigned.$lesseq_uint(u1, u2);
    }

    public static boolean $lesseq_uint(int u1, uint$ref u2) {
        return Unsigned.$compare_uint(u1, u2.$deref()) <= 0;
    }

    public static boolean $greater_int_uint(int u1, int u2) {
        if (u2 < 0) {
            return false;
        }
        return Unsigned.$compare_int(u1, u2) > 0;
    }

    public static boolean $greatereq_int_uint(int u1, int u2) {
        if (u2 < 0) {
            return false;
        }
        return Unsigned.$compare_int(u1, u2) >= 0;
    }

    public static boolean $greater_uint_bool(int u1, boolean b2) {
        return Unsigned.$compare_uint(u1, b2 ? 1 : 0) > 0;
    }

    public static boolean $greater_uint(int u1, int u2) {
        return Unsigned.$compare_uint(u1, u2) > 0;
    }

    public static boolean $greater_uint(uint$ref u1, int u2) {
        return Unsigned.$compare_uint(u1.$deref(), u2) > 0;
    }

    public static boolean $greatereq_uint(int u1, int u2) {
        return Unsigned.$compare_uint(u1, u2) >= 0;
    }

    public static boolean $greatereq_uint(uint$ref u1, int u2) {
        return Unsigned.$compare_uint(u1.$deref(), u2) >= 0;
    }

    public static boolean $less_uint_uchar(int u1, byte u2) {
        if (u1 < 0) {
            return false;
        }
        return Unsigned.$less_uint(u1, Unsigned.$uchar2uint(u2));
    }

    public static String UIntToUnsignedString(int i, int radix) {
        return Integer.toUnsignedString(i, radix);
    }

    public static int $div_uint(int dividend, int divisor) {
        return Integer.divideUnsigned(dividend, divisor);
    }

    public static int $div_int_uint(int dividend, int divisor) {
        return Integer.divideUnsigned(dividend, divisor);
    }

    public static int $div_uint_int(int dividend, int divisor) {
        return Integer.divideUnsigned(dividend, divisor);
    }

    public static long $div_uint_ulong(int dividend, long divisor) {
        return Unsigned.$div_ulong(Unsigned.$uint2ulong(dividend), divisor);
    }

    public static int $rem_uint(int dividend, int divisor) {
        return Integer.remainderUnsigned(dividend, divisor);
    }

    public static int $rem_int_uint(int dividend, int divisor) {
        return Integer.remainderUnsigned(dividend, divisor);
    }

    public static int $rem_uint_int(int dividend, int divisor) {
        return Integer.remainderUnsigned(dividend, divisor);
    }

    public static int $compare_ulong(long u1, long u2) {
        return Long.compareUnsigned(u1, u2);
    }

    public static boolean $less_ulong(long u1, long u2) {
        return Unsigned.$compare_ulong(u1, u2) < 0;
    }

    public static boolean $lesseq_ulong(long u1, long u2) {
        return Unsigned.$compare_ulong(u1, u2) <= 0;
    }

    public static boolean $greater_ulong(long u1, long u2) {
        return Unsigned.$compare_ulong(u1, u2) > 0;
    }

    public static boolean $greatereq_ulong(long u1, long u2) {
        return Unsigned.$compare_ulong(u1, u2) >= 0;
    }

    public static String LongToSignedString(long i, int radix) {
        String out = Long.toString(i, radix);
        return radix == 16 ? out.toUpperCase(Locale.US) : out;
    }

    public static String LongToUnsignedString(long i, int radix) {
        String out = Long.toUnsignedString(i, radix);
        return radix == 16 ? out.toUpperCase(Locale.US) : out;
    }

    public static String ULongToSignedString(long i, int radix) {
        String out = Long.toString(i, radix);
        return radix == 16 ? out.toUpperCase(Locale.US) : out;
    }

    public static String ULongToUnsignedString(long i, int radix) {
        String out = Long.toUnsignedString(i, radix);
        return radix == 16 ? out.toUpperCase(Locale.US) : out;
    }

    public static long $div_ulong(long dividend, long divisor) {
        return Long.divideUnsigned(dividend, divisor);
    }

    public static long $div_ulong_uint(long dividend, int divisor) {
        return Long.divideUnsigned(dividend, Unsigned.$uint2ulong(divisor));
    }

    public static long $div_ulong_ullong(long dividend, long divisor) {
        return Long.divideUnsigned(dividend, divisor);
    }

    public static long $rem_ulong_uint(long dividend, int divisor) {
        return Long.remainderUnsigned(dividend, Unsigned.$uint2ulong(divisor));
    }

    public static long $rem_ulong_ullong(long dividend, long divisor) {
        return Long.remainderUnsigned(dividend, divisor);
    }

    public static long $rem_ullong_ulong(long dividend, long divisor) {
        return Long.remainderUnsigned(dividend, divisor);
    }

    public static long $div_ullong(long dividend, long divisor) {
        return Long.divideUnsigned(dividend, divisor);
    }

    public static long $rem_ullong(long dividend, long divisor) {
        return Long.remainderUnsigned(dividend, divisor);
    }

    public static long $div_ullong_uchar(long dividend, byte divisor) {
        return Long.divideUnsigned(dividend, Unsigned.$uchar2ullong(divisor));
    }

    public static long $div_ullong_uint(long dividend, int divisor) {
        return Long.divideUnsigned(dividend, Unsigned.$uint2ullong(divisor));
    }

    public static long $div_ullong_ulong(long dividend, long divisor) {
        return Long.divideUnsigned(dividend, Unsigned.$long2ulong(divisor));
    }

    public static long $div_ullong_int(long dividend, int divisor) {
        return Long.divideUnsigned(dividend, Unsigned.$int2ullong(divisor));
    }

    public static long $rem_ulong(long dividend, long divisor) {
        return Long.remainderUnsigned(dividend, divisor);
    }

    public static boolean $less_ullong(long u1, long u2) {
        return Long.compareUnsigned(u1, u2) < 0;
    }

    public static int $compare_ulong_ullong(long u1, long u2) {
        return Long.compareUnsigned(u1, u2);
    }

    public static boolean $less_ulong_ullong(long u1, long u2) {
        return Unsigned.$compare_ulong(u1, u2) < 0;
    }

    public static boolean $lesseq_ulong_ullong(long u1, long u2) {
        return Unsigned.$compare_ulong(u1, u2) <= 0;
    }

    public static boolean $lesseq_ulong_ullong(ulong$ref u1, long u2) {
        return Unsigned.$compare_ulong(u1.$deref(), u2) <= 0;
    }

    public static boolean $greater_ulong_ullong(long u1, long u2) {
        return Unsigned.$compare_ulong(u1, u2) > 0;
    }

    public static boolean $greater_ulong_ullong(ulong$ref u1, long u2) {
        return Unsigned.$compare_ulong(u1.$deref(), u2) > 0;
    }

    public static boolean $greatereq_ulong_ullong(long u1, long u2) {
        return Unsigned.$compare_ulong(u1, u2) >= 0;
    }

    public static boolean $greatereq_ulong_ullong(ulong$ref u1, long u2) {
        return Unsigned.$compare_ulong(u1.$deref(), u2) >= 0;
    }

    public static boolean $greater_ulong_int$C(long u1, int u2) {
        return Unsigned.$compare_ulong(u1, Unsigned.$uint2ulong(u2)) > 0;
    }

    public static int $compare_uint_ulong(int u1, long u2) {
        return Long.compareUnsigned(Unsigned.$uint2ulong(u1), u2);
    }

    public static boolean $less_uint_ulong(int u1, long u2) {
        return Unsigned.$compare_uint_ulong(u1, u2) < 0;
    }

    public static boolean $lesseq_uint_ulong(int u1, long u2) {
        return Unsigned.$compare_uint_ulong(u1, u2) <= 0;
    }

    public static boolean $greater_uint_ulong(int u1, long u2) {
        return Unsigned.$compare_uint_ulong(u1, u2) > 0;
    }

    public static boolean $greatereq_uint_ulong(int u1, long u2) {
        return Unsigned.$compare_uint_ulong(u1, u2) >= 0;
    }

    public static int $compare_uint_ushort(int u1, char u2) {
        return Integer.compareUnsigned(u1, Unsigned.$ushort2uint(u2));
    }

    public static boolean $less_uint_ushort(int u1, char u2) {
        return Unsigned.$compare_uint_ushort(u1, u2) < 0;
    }

    public static boolean $lesseq_uint_ushort(int u1, char u2) {
        return Unsigned.$compare_uint_ushort(u1, u2) <= 0;
    }

    public static boolean $lesseq_uint_char$C(int u1, char i2) {
        return Unsigned.$compare_uint_ushort(u1, i2) <= 0;
    }

    public static boolean $greater_uint_ushort(int u1, char u2) {
        return Unsigned.$compare_uint_ushort(u1, u2) > 0;
    }

    public static boolean $greatereq_uint_ushort(int u1, char u2) {
        return Unsigned.$compare_uint_ushort(u1, u2) >= 0;
    }

    public static int $compare_uint_int(int u1, int i2) {
        if (u1 < 0) {
            return 1;
        }
        return Unsigned.$compare_int(u1, i2);
    }

    public static boolean $less_uint_int(int u1, int i2) {
        return Unsigned.$compare_uint_int(u1, i2) < 0;
    }

    public static boolean $lesseq_uint_int(int u1, int i2) {
        return Unsigned.$compare_uint_int(u1, i2) <= 0;
    }

    public static boolean $greater_uint_int(int u1, int i2) {
        return Unsigned.$compare_uint_int(u1, i2) > 0;
    }

    public static boolean $greatereq_uint_int(int u1, int i2) {
        return Unsigned.$compare_uint_int(u1, i2) >= 0;
    }

    public static int $compare_ulong_uchar(long u1, byte u2) {
        return Long.compareUnsigned(u1, Unsigned.$uchar2ulong(u2));
    }

    public static boolean $less_ulong_uchar(long u1, byte u2) {
        return Unsigned.$compare_ulong_uchar(u1, u2) < 0;
    }

    public static boolean $lesseq_ulong_uchar(long u1, byte u2) {
        return Unsigned.$compare_ulong_uchar(u1, u2) <= 0;
    }

    public static boolean $greater_ulong_uchar(long u1, byte u2) {
        return Unsigned.$compare_ulong_uchar(u1, u2) > 0;
    }

    public static boolean $greatereq_ulong_uchar(long u1, byte u2) {
        return Unsigned.$compare_ulong_uchar(u1, u2) >= 0;
    }

    public static int $compare_ulong_uint(long u1, int u2) {
        return Long.compareUnsigned(u1, Unsigned.$uint2ulong(u2));
    }

    public static boolean $less_ulong_uint(long u1, int u2) {
        return Unsigned.$compare_ulong_uint(u1, u2) < 0;
    }

    public static boolean $lesseq_ulong_uint(long u1, int u2) {
        return Unsigned.$compare_ulong_uint(u1, u2) <= 0;
    }

    public static boolean $greater_ulong_uint(long u1, int u2) {
        return Unsigned.$compare_ulong_uint(u1, u2) > 0;
    }

    public static boolean $greatereq_ulong_uint(long u1, int u2) {
        return Unsigned.$compare_ulong_uint(u1, u2) >= 0;
    }

    public static int $compare_ullong_ulong(long u1, long u2) {
        return Long.compareUnsigned(u1, Unsigned.$ulong2ullong(u2));
    }

    public static boolean $less_ullong_ulong(long u1, long u2) {
        return Unsigned.$compare_ullong_ulong(u1, u2) < 0;
    }

    public static boolean $lesseq_ullong_ulong(long u1, long u2) {
        return Unsigned.$compare_ullong_ulong(u1, u2) <= 0;
    }

    public static boolean $lesseq_ullong(long u1, long u2) {
        return Unsigned.$compare_ullong_ulong(u1, u2) <= 0;
    }

    public static boolean $greater_ullong_ulong(long u1, long u2) {
        return Unsigned.$compare_ullong_ulong(u1, u2) > 0;
    }

    public static boolean $greatereq_ullong_ulong(long u1, long u2) {
        return Unsigned.$compare_ullong_ulong(u1, u2) >= 0;
    }

    public static boolean $greatereq_ullong_uint(long u1, int u2) {
        return Unsigned.$compare_ullong_ulong(u1, u2) >= 0;
    }

    public static int $compare_ullong_uint(long u1, int u2) {
        return Long.compareUnsigned(u1, Unsigned.$uint2ullong(u2));
    }

    public static boolean $less_ullong_uint(long u1, int u2) {
        return Unsigned.$compare_ullong_uint(u1, u2) < 0;
    }

    public static boolean $lesseq_ullong_uint(long u1, int u2) {
        return Unsigned.$compare_ullong_uint(u1, u2) <= 0;
    }

    public static boolean $greater_ullong_uint(long u1, int u2) {
        return Unsigned.$compare_ullong_uint(u1, u2) > 0;
    }

    public static boolean $greatereq_ullong_ulong(long u1, int u2) {
        return Unsigned.$compare_ullong_uint(u1, u2) >= 0;
    }

    public static boolean $greater_ullong(long u1, long u2) {
        return Unsigned.$compare_ullong_ulong(u1, u2) > 0;
    }

    public static boolean $bool2uint_1bit(boolean val) {
        return val;
    }

    public static int $bool2uint(boolean val) {
        return val ? 1 : 0;
    }

    public static boolean $bool2uint_1bit(int val) {
        return val != 0;
    }

    public static byte $bool2uint_4bits(boolean val) {
        return (byte)(val ? 1 : 0);
    }

    public static byte $bool2uint_5bits(boolean val) {
        return (byte)(val ? 1 : 0);
    }

    public static boolean $uint2uint_1bit(boolean val) {
        return val;
    }

    public static boolean $uint2uint_1bit(int val) {
        return val != 0;
    }

    public static boolean $bool2bool_1bit(boolean val) {
        return val;
    }

    public static byte $uint2uint_2bits(int val) {
        assert (val >>> 2 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return (byte)val;
    }

    public static byte $int2uint_2bits(int val) {
        assert (val >>> 2 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return (byte)val;
    }

    public static byte $int2int_2bits(int val) {
        assert (val >>> 2 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return (byte)val;
    }

    public static byte $uint2uint_3bits(int val) {
        assert (val >>> 3 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return (byte)val;
    }

    public static byte $int2uint_3bits(int val) {
        assert (val >>> 3 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return (byte)val;
    }

    public static byte $uint2uint_4bits(int val) {
        assert (val >>> 4 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return (byte)val;
    }

    public static byte $int2uint_4bits(int val) {
        assert (val >>> 4 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return (byte)val;
    }

    public static byte $uint2uint_5bits(int val) {
        assert (val >>> 5 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return (byte)val;
    }

    public static byte $int2uint_5bits(int val) {
        assert (val >>> 5 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return (byte)val;
    }

    public static byte $uint2uint_6bits(int val) {
        assert (val >>> 6 == 0 || val >>> 6 == 0x3FFFFFF) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return (byte)val;
    }

    public static byte $int2uint_6bits(int val) {
        assert (val >>> 6 == 0 || val >>> 6 == 0x3FFFFFF) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return (byte)val;
    }

    public static byte $uint2uint_7bits(int val) {
        assert (val >>> 7 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return (byte)val;
    }

    public static byte $int2uint_7bits(int val) {
        assert (val >>> 7 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return (byte)val;
    }

    public static byte $uint2uint_8bits(int val) {
        assert (val >>> 8 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return (byte)val;
    }

    public static byte $int2uint_8bits(int val) {
        assert (val >>> 8 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return (byte)val;
    }

    public static int $7bits_uint2uint(byte val) {
        assert (val >>> 7 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(Unsigned.$uchar2uint(val));
        return Unsigned.$uchar2uint(val);
    }

    public static int $8bits_uint2uint(byte val) {
        return Unsigned.$uchar2uint(val);
    }

    public static int $13bits_uint2uint(char val) {
        assert (val >>> 13 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return Unsigned.$ushort2uint(val);
    }

    public static int $14bits_uint2uint(char val) {
        assert (val >>> 14 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return Unsigned.$ushort2uint(val);
    }

    public static int $15bits_uint2uint(char val) {
        assert (val >>> 15 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return Unsigned.$ushort2uint(val);
    }

    public static int $16bits_uint2uint(char val) {
        assert (val >>> 16 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return Unsigned.$ushort2uint(val);
    }

    public static int $5bits_uint2uint(byte val) {
        assert (val >>> 5 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return Unsigned.$uchar2uint(val);
    }

    public static int $6bits_uint2uint(byte val) {
        assert (val >>> 6 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return Unsigned.$uchar2uint(val);
    }

    public static int $4bits_uint2uint(byte val) {
        assert (val >>> 4 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return Unsigned.$uchar2uint(val);
    }

    public static int $3bits_uint2uint(byte val) {
        assert (val >>> 3 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return Unsigned.$uchar2uint(val);
    }

    public static int $2bits_uint2uint(byte val) {
        assert (val >>> 2 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return Unsigned.$uchar2uint(val);
    }

    public static char $uint2uint_9bits(int val) {
        assert (val >>> 9 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return (char)val;
    }

    public static char $int2uint_9bits(int val) {
        assert (val >>> 9 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return (char)val;
    }

    public static char $uint2uint_10bits(int val) {
        assert (val >>> 10 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return (char)val;
    }

    public static char $int2uint_10bits(int val) {
        assert (val >>> 10 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return (char)val;
    }

    public static char $uint2uint_11bits(int val) {
        assert (val >>> 11 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return (char)val;
    }

    public static char $int2uint_11bits(int val) {
        assert (val >>> 11 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return (char)val;
    }

    public static char $uint2uint_12bits(int val) {
        assert (val >>> 12 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return (char)val;
    }

    public static char $int2uint_12bits(int val) {
        assert (val >>> 12 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return (char)val;
    }

    public static char $uint2uint_13bits(int val) {
        assert (val >>> 13 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return (char)val;
    }

    public static char $int2uint_13bits(int val) {
        assert (val >>> 13 == 0 || val >>> 13 == 524287) : "expected clean or all 1 left bits " + val + ":" + Integer.toBinaryString(val);
        return (char)val;
    }

    public static char $uint2uint_14bits(int val) {
        assert (val >>> 14 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return (char)val;
    }

    public static char $int2uint_14bits(int val) {
        assert (val >>> 14 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return (char)val;
    }

    public static char $uint2uint_15bits(int val) {
        assert (val >>> 15 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return (char)val;
    }

    public static char $int2uint_15bits(int val) {
        assert (val >>> 15 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return (char)val;
    }

    public static char $uint2uint_16bits(int val) {
        assert (val >>> 16 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return (char)val;
    }

    public static char $int2uint_16bits(int val) {
        assert (val >>> 16 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return (char)val;
    }

    public static int $int2uint_24bits(int val) {
        assert (val >>> 24 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return (char)val;
    }

    public static int $int2uint_29bits(int val) {
        assert (val >>> 29 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return (char)val;
    }

    public static int $int2uint_30bits(int val) {
        assert (val >>> 30 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return val;
    }

    public static int $int2uint_31bits(int val) {
        assert (val >>> 31 == 0) : "expected clean left bits " + val + ":" + Integer.toBinaryString(val);
        return val;
    }

    private Unsigned() {
    }
}

