/*
 * Decompiled with CFR 0.152.
 */
package org.clank.support;

import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.clank.java.std;
import org.clank.support.Casts;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.bool$ptr$array;
import org.clank.support.aliases.bool$ptr$single;
import org.clank.support.aliases.char$ptr;
import org.clank.support.aliases.char$ptr$array;
import org.clank.support.aliases.char$ptr$single;
import org.clank.support.aliases.char$ref;
import org.clank.support.aliases.int$ptr$array;
import org.clank.support.aliases.int$ptr$single;
import org.clank.support.aliases.int$ref;
import org.clank.support.aliases.llong$ptr$array;
import org.clank.support.aliases.llong$ptr$single;
import org.clank.support.aliases.long$ptr$array;
import org.clank.support.aliases.long$ptr$single;
import org.clank.support.aliases.long$ref;
import org.clank.support.aliases.short$ptr$array;
import org.clank.support.aliases.short$ptr$single;
import org.clank.support.aliases.type$ptr;
import org.clank.support.aliases.type$ptr$array;
import org.clank.support.aliases.type$ref$single;
import org.clank.support.aliases.uchar$ptr$array;
import org.clank.support.aliases.uchar$ptr$single;
import org.clank.support.aliases.uint$ptr$array;
import org.clank.support.aliases.uint$ptr$single;
import org.clank.support.aliases.uint$ref;
import org.clank.support.aliases.ullong$ptr$array;
import org.clank.support.aliases.ullong$ptr$single;
import org.clank.support.aliases.ushort$ptr$array;
import org.clank.support.aliases.ushort$ptr$single;
import org.clank.support.char$ptr$CharSequence;
import org.clank.support.type$ptr$single;

public class NativeType {
    public static final int BYTES_IN_BYTE = 1;
    public static final int BYTES_IN_UCHAR = 1;
    public static final int BYTES_IN_INT = 4;
    public static final int BYTES_IN_FLOAT = 4;
    public static final int BYTES_IN_DOUBLE = 8;
    public static final int BYTES_IN_UINT = 4;
    public static final int BYTES_IN_SHORT = 2;
    public static final int BYTES_IN_USHORT = 2;
    public static final int BYTES_IN_BOOL = 1;
    public static final int BYTES_IN_LONG = 8;
    public static final int BYTES_IN_ULONG = 8;
    public static final int BYTES_IN_LLINT = 8;
    public static final int BYTES_IN_ULINT = 8;
    public static final int BYTES_IN_ULLINT = 8;
    public static final int CHAR_BIT = 8;
    public static final int BITS_PER_WORD = 16;
    public static final int significandBits = 52;
    public static final int typeWidth = 32;
    public static final int exponentBits = -21;
    public static final int maxExponent = 2047;
    public static final int exponentBias = 1023;
    public static final long implicitBit = 0x10000000000000L;
    public static final long significandMask = 0xFFFFFFFFFFFFFL;
    public static final long signBit = 0x80000000L;
    public static final long absMask = Integer.MAX_VALUE;
    public static final long exponentMask = 0xFFFFF80000000L;
    public static final long oneRep = 0x3FF0000000000000L;
    public static final long infRep = 0xFFFFF80000000L;
    public static final long quietBit = 0x8000000000000L;
    public static final long qnanRep = 0xFFFFF80000000L;
    private static final int BYTES_IN_JAVA_32_OBJECT_HEADER = 8;
    private static final int BYTES_IN_JAVA_64_OBJECT_HEADER = 16;
    private static final int BYTES_IN_JAVA_64_COMPRESSED_OBJECT_HEADER = 12;
    private static final long MAX_COMPRESSED_OOPS_BYTES = 3670016000L;
    public static final int BYTES_IN_JAVA_OBJECT_HEADER;
    public static final int BYTES_IN_JAVA_ARRAY_HEADER = 12;
    public static final int BYTES_IN_JAVA_OBJECT_REF = 4;
    private static final Set<Class<?>> warnedSizeOf;
    private static final Map<String, Object> defaultValues;

    public static void clearStatistics() {
        char$ptr$array.clearStatistics();
        type$ptr$array.clearStatistics();
        ushort$ptr$array.clearStatistics();
        uint$ptr$array.clearStatistics();
        int$ptr$array.clearStatistics();
        bool$ptr$array.clearStatistics();
        long$ptr$array.clearStatistics();
        llong$ptr$array.clearStatistics();
        short$ptr$array.clearStatistics();
        uchar$ptr$array.clearStatistics();
        ullong$ptr$array.clearStatistics();
        char$ptr$single.clearStatistics();
        type$ptr$single.clearStatistics();
        type$ref$single.clearStatistics();
        ushort$ptr$single.clearStatistics();
        uint$ptr$single.clearStatistics();
        int$ptr$single.clearStatistics();
        bool$ptr$single.clearStatistics();
        long$ptr$single.clearStatistics();
        llong$ptr$single.clearStatistics();
        short$ptr$single.clearStatistics();
        uchar$ptr$single.clearStatistics();
        ullong$ptr$single.clearStatistics();
        char$ptr$CharSequence.clearStatistics();
        std.clearStatistics();
        Casts.clearStatistics();
        NativePointer.clearStatistics();
    }

    public static long printStatistics(PrintWriter out) {
        out.println("---Array based---");
        long ArrValue = 0L;
        ArrValue += char$ptr$array.printStatistics(out);
        ArrValue += type$ptr$array.printStatistics(out);
        ArrValue += uint$ptr$array.printStatistics(out);
        ArrValue += int$ptr$array.printStatistics(out);
        ArrValue += long$ptr$array.printStatistics(out);
        ArrValue += bool$ptr$array.printStatistics(out);
        ArrValue += ushort$ptr$array.printStatistics(out);
        ArrValue += short$ptr$array.printStatistics(out);
        ArrValue += uchar$ptr$array.printStatistics(out);
        ArrValue += llong$ptr$array.printStatistics(out);
        NativeTrace.dumpStatisticValue(out, "TotalArrayBasedPointers", ArrValue += ullong$ptr$array.printStatistics(out));
        out.println("---Single based---");
        long SglValue = 0L;
        SglValue += char$ptr$single.printStatistics(out);
        SglValue += type$ptr$single.printStatistics(out);
        SglValue += type$ref$single.printStatistics(out);
        SglValue += uint$ptr$single.printStatistics(out);
        SglValue += int$ptr$single.printStatistics(out);
        SglValue += long$ptr$single.printStatistics(out);
        SglValue += bool$ptr$single.printStatistics(out);
        SglValue += ushort$ptr$single.printStatistics(out);
        SglValue += short$ptr$single.printStatistics(out);
        SglValue += uchar$ptr$single.printStatistics(out);
        SglValue += llong$ptr$single.printStatistics(out);
        NativeTrace.dumpStatisticValue(out, "TotalSingleBasedPointers", SglValue += ullong$ptr$single.printStatistics(out));
        out.println("---Others---");
        long Value = ArrValue + SglValue;
        Value += char$ptr$CharSequence.printStatistics(out);
        Value += std.printPairsStatistics(out);
        Value += std.printSmartPtrsStatistics(out);
        Value += Casts.printStatistics(out);
        out.flush();
        NativeTrace.dumpStatisticValue(out, "TotalJavaMemoryValue", Value += NativePointer.printStatistics(out));
        return Value;
    }

    public static int sizeof(boolean b) {
        return 1;
    }

    public static int sizeof(byte b) {
        return 1;
    }

    public static int sizeof(char b) {
        return 2;
    }

    public static int sizeof(short b) {
        return 2;
    }

    public static int sizeof(int b) {
        return 4;
    }

    public static int sizeof(float b) {
        return 4;
    }

    public static int sizeof(long b) {
        return 8;
    }

    public static int sizeof(double b) {
        return 8;
    }

    public static int sizeof$null(Object nullPtr) {
        assert (nullPtr == null) : "must be used only for sizeof(null)";
        return 0;
    }

    public static int sizeof$str(String str) {
        if (str == null) {
            return 0;
        }
        assert (str == str.intern());
        return str.length() + 1;
    }

    public static int sizeof_array(byte[] o) {
        return o.length * 1;
    }

    public static int sizeof_not_null(Object o) {
        if (o == null) {
            return 0;
        }
        return NativeType.sizeof(o);
    }

    public static int sizeof(Class<?> cls) {
        if (cls == null) {
            return 0;
        }
        if (cls == Integer.TYPE) {
            return 4;
        }
        if (cls == Byte.TYPE) {
            return 1;
        }
        if (cls == Long.TYPE) {
            return 8;
        }
        if (cls == Float.TYPE) {
            return 4;
        }
        if (cls == Double.TYPE) {
            return 8;
        }
        if (cls == type$ptr.class) {
            return NativeType.sizeof$ptr();
        }
        if (cls == Object.class) {
            return 1;
        }
        NativeTrace.assertTrueInConsole(false, "Unexpected class ", cls);
        return NativeType.sizeof(cls);
    }

    public static int sizeof$uint8() {
        return 1;
    }

    public static int sizeof$uint16() {
        return 2;
    }

    public static int $sizeof_UInt() {
        return NativeType.sizeof$uint32();
    }

    public static int $sizeof_UIntptr_t() {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public static int $sizeof_ULong() {
        return NativeType.sizeof$uint64();
    }

    public static int $sizeof_Double() {
        return NativeType.sizeof$uint64();
    }

    public static int sizeof$uint32() {
        return 4;
    }

    public static int sizeof$uint64() {
        return 8;
    }

    public static int sizeof$ptr() {
        return 4;
    }

    public static int $sizeof_ptr() {
        return NativeType.sizeof$ptr();
    }

    public static int sizeof(byte[] array2) {
        return array2.length * 1;
    }

    public static int sizeof(Object o) {
        if (o == null) {
            return NativeType.sizeof$ptr();
        }
        if (o instanceof SizeofCapable) {
            return ((SizeofCapable)o).$sizeof();
        }
        Class<?> cls = null;
        cls = o instanceof Class ? (Class<?>)o : o.getClass();
        if (cls != null) {
            if (char$ptr.class.isAssignableFrom(cls)) {
                return NativeType.sizeof$ptr();
            }
            if (Byte.class.isAssignableFrom(cls) || Byte.TYPE.isAssignableFrom(cls) || char$ref.class.isAssignableFrom(cls)) {
                return 1;
            }
            if (Integer.class.isAssignableFrom(cls) || Integer.TYPE.isAssignableFrom(cls) || int$ref.class.isAssignableFrom(cls)) {
                return 4;
            }
            if (Long.class.isAssignableFrom(cls) || Long.TYPE.isAssignableFrom(cls) || long$ref.class.isAssignableFrom(cls)) {
                return 8;
            }
            if (uint$ref.class.isAssignableFrom(cls)) {
                return 4;
            }
            if (byte[].class.isAssignableFrom(cls)) {
                return NativeType.sizeof_array((byte[])o);
            }
            if (warnedSizeOf.add(cls)) {
                NativeTrace.traceNotImplemented("can not calculate SIZE_OF " + cls);
            }
        }
        return 4;
    }

    private static Class loadClass(String name) throws ClassNotFoundException {
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                return contextClassLoader.loadClass(name);
            }
            return Class.forName(name);
        }
        catch (Exception e) {
            return Class.forName(name);
        }
    }

    public static <T> T createNewInstance(Class<T> cls) {
        if (cls == null) {
            return null;
        }
        Object res = null;
        try {
            cls = NativeType.loadClass(cls.getName());
            Constructor constructor = cls.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            res = constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException | InvocationTargetException e) {
            Throwable ex = e;
            if (e.getCause() != null) {
                ex = e.getCause();
            } else {
                NativeTrace.assertTrueInConsole(false, "Can not create object of class" + cls.getName());
            }
            NativeTrace.printStackTraceOnce(ex);
            res = null;
        }
        catch (NoSuchMethodException e) {
            assert (false) : "Not defined constructor without parameters for " + cls;
        }
        catch (Exception ex) {
            NativeTrace.printStackTraceOnce(ex);
            res = null;
        }
        return res;
    }

    public static <T> T createDefaultValue(Class<T> cls) {
        if (cls == null) {
            return null;
        }
        String key = cls.getName();
        Object res = null;
        if (defaultValues.containsKey(key)) {
            res = defaultValues.get(key);
        } else {
            res = NativeType.createNewInstance(cls);
            if (res != null) {
                defaultValues.put(key, res);
                System.err.println("Instantiated Default Value for " + key);
            } else if (cls.isInterface() || Modifier.isAbstract(cls.getModifiers())) {
                defaultValues.put(key, null);
            } else assert (false) : "Not defined constructor without parameters for " + cls;
        }
        return (T)(res instanceof NativeCloneable ? ((NativeCloneable)res).clone() : res);
    }

    private NativeType() {
        throw new AssertionError();
    }

    static {
        int value = 16;
        int bits = Integer.getInteger("sun.arch.data.model", 64);
        Runtime runtime = Runtime.getRuntime();
        if (bits == 32) {
            value = 8;
        } else if (bits == 64 && runtime.maxMemory() <= 3670016000L) {
            value = 12;
        }
        if (NativeTrace.VERBOSE_MODE) {
            System.err.println("sun.arch.data.model=" + bits);
            System.err.println("Max memory " + NativeTrace.formatNumber(runtime.maxMemory()) + " vs. " + NativeTrace.formatNumber(3670016000L));
            System.err.println("Expected Class header size: " + value);
        }
        BYTES_IN_JAVA_OBJECT_HEADER = value;
        warnedSizeOf = new HashSet();
        defaultValues = new HashMap<String, Object>();
        defaultValues.put(Integer.class.getName(), 0);
        defaultValues.put(Long.class.getName(), 0L);
        defaultValues.put(Boolean.class.getName(), false);
    }

    public static interface ToByteArray {
        public byte[] toByteArray();

        public static byte get0(short x) {
            return (byte)(x & 0xFF);
        }

        public static byte get1(short x) {
            return (byte)(x >>> 8 & 0xFF);
        }

        public static byte get0(int x) {
            return (byte)(x & 0xFF);
        }

        public static byte get1(int x) {
            return (byte)(x >>> 8 & 0xFF);
        }

        public static byte get2(int x) {
            return (byte)(x >>> 16 & 0xFF);
        }

        public static byte get3(int x) {
            return (byte)(x >>> 24 & 0xFF);
        }

        public static byte get0(long x) {
            return (byte)(x & 0xFFL);
        }

        public static byte get1(long x) {
            return (byte)(x >>> 8 & 0xFFL);
        }

        public static byte get2(long x) {
            return (byte)(x >>> 16 & 0xFFL);
        }

        public static byte get3(long x) {
            return (byte)(x >>> 24 & 0xFFL);
        }

        public static byte get4(long x) {
            return (byte)(x >>> 32 & 0xFFL);
        }

        public static byte get5(long x) {
            return (byte)(x >>> 40 & 0xFFL);
        }

        public static byte get6(long x) {
            return (byte)(x >>> 48 & 0xFFL);
        }

        public static byte get7(long x) {
            return (byte)(x >>> 56 & 0xFFL);
        }
    }

    public static interface SizeofCapable {
        public int $sizeof();
    }
}

