/*
 * Decompiled with CFR 0.152.
 */
package org.clank.support;

import org.clank.support.aliases.char$ptr;
import org.clank.support.void$ptr;

public class NativeMemory {
    private static final int NATIVE_PAGE_SIZE = 4096;
    private static final int FALLBACK_PAGE_SIZE = 4096;

    static MemoryPoint unfoldMemoryPoint(MemoryPoint data) {
        MemoryPoint result = new MemoryPoint(data.memory, data.byteIndex);
        while (result.memory instanceof memproj) {
            result.byteIndex += ((memproj)result.memory).getByteShift();
            result.memory = ((memproj)result.memory).getOrigMemory();
        }
        return result;
    }

    static boolean areMemoryPointsComparable(MemoryPoint p1, MemoryPoint p2) {
        if (p1.memory.$noteq(p2.memory)) {
            p1 = NativeMemory.unfoldMemoryPoint(p1);
            p2 = NativeMemory.unfoldMemoryPoint(p2);
        }
        return p1.memory.$eq(p2.memory);
    }

    static int compareMemoryPoints(MemoryPoint p1, MemoryPoint p2) {
        if (p1.memory != p2.memory) {
            p1 = NativeMemory.unfoldMemoryPoint(p1);
            p2 = NativeMemory.unfoldMemoryPoint(p2);
        }
        if (p1.memory.$eq(p2.memory)) {
            return p1.byteIndex - p2.byteIndex;
        }
        throw new UnsupportedOperationException("Incomparable memory points!");
    }

    static long calcMemoryPointHashCode(MemoryPoint mp) {
        mp = NativeMemory.unfoldMemoryPoint(mp);
        return (long)System.identityHashCode(mp.memory) ^ (long)mp.byteIndex;
    }

    static int getMemoryPointsDistance(MemoryPoint p1, MemoryPoint p2) {
        int distBytes = NativeMemory.compareMemoryPoints(p1, p2);
        return distBytes / Math.max(p1.memory.sizeof(), p2.memory.sizeof());
    }

    static boolean areEqualMemoryPoints(MemoryPoint p1, MemoryPoint p2) {
        if (p1.memory != p2.memory) {
            p1 = NativeMemory.unfoldMemoryPoint(p1);
            p2 = NativeMemory.unfoldMemoryPoint(p2);
        }
        if (p1.memory.$noteq(p2.memory)) {
            return false;
        }
        return NativeMemory.compareMemoryPoints(p1, p2) == 0;
    }

    private NativeMemory() {
        throw new AssertionError();
    }

    static final class MemoryPoint {
        public memory memory;
        public int byteIndex;

        public MemoryPoint() {
        }

        public MemoryPoint(memory first, int byteIndex) {
            this.memory = first;
            this.byteIndex = byteIndex;
        }
    }

    public static interface memproj<M extends memory>
    extends memory {
        public M getOrigMemory();

        public int getByteShift();
    }

    public static interface memory {
        public int sizeof();

        public int size();

        public int toByteIndex(int var1);

        public int fromByteIndex(int var1);

        default public boolean $eq(memory other) {
            if (this == other) {
                return true;
            }
            throw new UnsupportedOperationException("Why not implemented in " + this.getClass());
        }

        default public boolean $noteq(memory other) {
            return !this.$eq(other);
        }
    }

    public static interface BumpAllocator
    extends Allocator {
        public int AllocateAndGetIndex(int var1, int var2);

        public int AllocateAndGetIndex(int var1);

        public byte[] GetLastAllocationStorage();
    }

    public static interface Allocator {
        public static final int MaxPageSize = Integer.getInteger("clank.max.page.size", 65536);
        public static final int PageSize = Integer.getInteger("clank.page.size", Math.min(MaxPageSize, 4096));

        default public void Reset() {
            throw new UnsupportedOperationException();
        }

        default public char$ptr Allocate(int Size, int Alignment) {
            throw new UnsupportedOperationException();
        }

        default public char$ptr Allocate(int Size) {
            return this.Allocate(Size, 1);
        }

        default public char$ptr Allocate$Chars(int Size) {
            return this.Allocate$Chars(Size, 1);
        }

        default public char$ptr Allocate$Chars(int Size, int Align) {
            return this.Allocate(Size, Align);
        }

        default public char$ptr AllocateSlab(int Size) {
            throw new UnsupportedOperationException();
        }

        default public <T> void$ptr Allocate(Class<T> cls, int Num) {
            throw new UnsupportedOperationException();
        }

        default public void Deallocate(Object Ptr) {
            throw new UnsupportedOperationException();
        }

        default public void Deallocate$NotSameRemoveCV(Object Ptr) {
            throw new UnsupportedOperationException();
        }

        default public void DeallocateSlab(char$ptr SlabStartPtr, int Size) {
            throw new UnsupportedOperationException();
        }

        default public void PrintStats() {
            throw new UnsupportedOperationException();
        }

        default public <T> T $RegisterCreated(T obj) {
            return obj;
        }

        default public long getTotalMemory() {
            throw new UnsupportedOperationException();
        }
    }
}

