/*
 * Decompiled with CFR 0.152.
 */
package org.clank.support;

import java.io.PrintWriter;
import java.util.Comparator;
import org.clank.java.std;
import org.clank.java.std_functional;
import org.clank.support.AbstractArrayPointerType;
import org.clank.support.Casts;
import org.clank.support.DebuggableAbstractPointerType;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativeCloneable;
import org.clank.support.NativeMemory;
import org.clank.support.NativeMoveable;
import org.clank.support.NativePointer;
import org.clank.support.NativePointerLike;
import org.clank.support.NativeTrace;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.AliasesAccessor;
import org.clank.support.aliases.char$iterator;
import org.clank.support.aliases.char$mem;
import org.clank.support.aliases.char$ptr;
import org.clank.support.aliases.char$ptr$array;
import org.clank.support.aliases.int$ptr;
import org.clank.support.aliases.long$ptr;
import org.clank.support.aliases.short$ptr;
import org.clank.support.aliases.type$iterator;
import org.clank.support.aliases.type$ptr;
import org.clank.support.aliases.type$ptr$array;
import org.clank.support.aliases.type$ref;
import org.clank.support.aliases.uchar$ptr;
import org.clank.support.aliases.uint$iterator;
import org.clank.support.aliases.uint$ptr;
import org.clank.support.aliases.ulong$ptr;
import org.clank.support.aliases.ushort$ptr;
import org.clank.support.void$ptr;

public final class Native {
    private static final int NUM_PARALLEL_THREADS = Runtime.getRuntime().availableProcessors();

    public static boolean $bitand(long Ptr, int i) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static boolean isKnownUnsignedType(Class<?> cls) {
        boolean out = NativeUnsignedTypeMarker.class.isAssignableFrom(cls);
        assert (!out || !NativeSignedTypeMarker.class.isAssignableFrom(cls)) : "can not be signed and unsigned";
        return out;
    }

    public static boolean isKnownSignedType(Class<?> cls) {
        boolean out = NativeSignedTypeMarker.class.isAssignableFrom(cls);
        assert (!out || !NativeUnsignedTypeMarker.class.isAssignableFrom(cls)) : "can not be signed and unsigned";
        return out;
    }

    public static <LHS, RHS> ComparatorLower<LHS, RHS> ComparatorLower(final NativeCallback.TwoTypes2Bool<LHS, RHS> comparator) {
        return new ComparatorLower<LHS, RHS>(){

            @Override
            public boolean $less(LHS one, RHS other) {
                return comparator.$call(one, other);
            }
        };
    }

    public static <T> T $new_uint_voidPtr(Object Mem, NativeCallback.New.ConstructorCallback<T> New$Ctr) {
        return New$Ctr.$call((type$ptr)Mem);
    }

    public static JavaCleaner $createJavaCleaner() {
        return JavaCleaner.create();
    }

    public static void destroy(boolean val) {
    }

    public static void destroy(byte val) {
    }

    public static void destroy(char val) {
    }

    public static void destroy(short val) {
    }

    public static void destroy(int val) {
    }

    public static void destroy(long val) {
    }

    public static void destroy(Destructors.ClassWithDestructor obj) {
        obj.$destroy();
        obj.$delete();
    }

    public static void destroy(Object obj) {
        if (obj instanceof Destructors.ClassWithDestructor) {
            Native.destroy((Destructors.ClassWithDestructor)obj);
        }
    }

    public static <T> void $delete_voidPtr(type$ptr<T> p) {
        Destructors.$delete_voidPtr(p);
    }

    public static boolean bool$ptr(Object o) {
        assert (!(o instanceof void$ptr)) : "unexpected class " + o.getClass();
        return o != null;
    }

    public static boolean bool$ptr(void$ptr o) {
        return Native.$bool(o);
    }

    public static boolean $bool(Object o) {
        if (o instanceof Native.Bool) {
            return ((Native.Bool)o).$bool();
        }
        return o != null;
    }

    public static boolean $not(Object o) {
        return !Native.$bool(o);
    }

    public static boolean $bool(Native.Bool o) {
        return o != null && o.$bool();
    }

    public static boolean $not(Native.Bool o) {
        return !Native.$bool(o);
    }

    public static boolean $bool(boolean o) {
        return o;
    }

    public static boolean $not(boolean o) {
        return !o;
    }

    public static boolean $bool(byte o) {
        return o != 0;
    }

    public static boolean $not(byte o) {
        return o == 0;
    }

    public static boolean $bool(char o) {
        return o != '\u0000';
    }

    public static boolean $not(char o) {
        return o == '\u0000';
    }

    public static boolean $bool(short o) {
        return o != 0;
    }

    public static boolean $not(short o) {
        return o == 0;
    }

    public static boolean $bool(int o) {
        return o != 0;
    }

    public static boolean $not(int o) {
        return o == 0;
    }

    public static boolean $bool(long o) {
        return o != 0L;
    }

    public static boolean $not(long o) {
        return o == 0L;
    }

    public static int $hashcode_ptr(Object P2) {
        if (P2 == null) {
            return 0;
        }
        if (P2 instanceof NativeHashable) {
            return ((NativeHashable)P2).$hashcode();
        }
        return System.identityHashCode(P2);
    }

    public static boolean $eq_ptr(Object primary, Object second) {
        if (primary == second) {
            return true;
        }
        if (primary instanceof NativePointerLike) {
            return ((NativePointerLike)primary).$eqPointerLike(second);
        }
        if (second instanceof NativePointerLike) {
            return ((NativePointerLike)second).$eqPointerLike(primary);
        }
        if (primary instanceof abstract_iterator) {
            return Native.$eq_iter((abstract_iterator)primary, (abstract_iterator)second);
        }
        assert (!Native.isIteratorLikeTypeName(primary)) : "All Iterators must be comparable " + primary.getClass();
        assert (!Native.isIteratorLikeTypeName(second)) : "All Iterators must be comparable " + second.getClass();
        return false;
    }

    public static <T extends void$ptr> boolean $eq_ptr(T primary, T second) {
        if (primary == second) {
            return true;
        }
        if (primary == null) {
            return false;
        }
        return primary.$eq((Object)second);
    }

    public static boolean $eq_iter(abstract_iterator primary, abstract_iterator second) {
        return std.$eq___normal_iterator(primary, second);
    }

    public static boolean $eq(abstract_iterator primary, abstract_iterator second) {
        throw new AssertionError((Object)"must use $eq_iter for iterators");
    }

    public static boolean $eq(void$ptr primary, void$ptr second) {
        throw new AssertionError((Object)"must use $eq_ptr for pointers");
    }

    public static boolean $eq(Object primary, Object second) {
        assert (!(primary instanceof void$ptr) || !(second instanceof void$ptr)) : "must use $eq_ptr for pointers";
        assert (!(primary instanceof abstract_iterator) || !(second instanceof abstract_iterator)) : "must use $eq_iter for iterators";
        return Native.$eq(primary, second, false);
    }

    public static boolean $eq(Object primary, Object second, boolean isDataPointerLike) {
        Boolean res;
        if (isDataPointerLike) {
            assert (!(primary instanceof void$ptr) || !(second instanceof void$ptr)) : "Real pointers should not be considered as 'pointer like'! use $eq_ptr instead";
            assert (!(primary instanceof abstract_iterator) || !(second instanceof abstract_iterator)) : "Real iterators should not be considered as 'pointer like'! use $noteq_iter instead";
            return primary == second;
        }
        if (primary == second) {
            return true;
        }
        if (primary instanceof OpCapable && (res = ((OpCapable)primary).$op(OpCapable.Op.EQ, second)) != null) {
            return res;
        }
        if (second instanceof OpCapable && (res = ((OpCapable)second).$op(OpCapable.Op.EQ, primary)) != null) {
            return res;
        }
        if (primary instanceof NativeComparable) {
            return ((NativeComparable)primary).$eq(second);
        }
        if (second instanceof NativeComparable) {
            return ((NativeComparable)second).$eq(primary);
        }
        if (primary == null || second == null) {
            return false;
        }
        assert (primary.getClass().isAssignableFrom(second.getClass()) || second.getClass().isAssignableFrom(primary.getClass())) : "Forgot to call conversion operator?";
        return primary.equals(second);
    }

    public static boolean $eq(byte primary, byte second) {
        return primary == second;
    }

    public static boolean $eq(byte primary, byte second, boolean isDataPointerLike) {
        return primary == second;
    }

    public static boolean $eq(char primary, char second) {
        return primary == second;
    }

    public static boolean $eq(char primary, byte second) {
        return primary == (0xFF & second);
    }

    public static boolean $eq(char primary, char second, boolean isDataPointerLike) {
        return primary == second;
    }

    public static boolean $eq(short primary, short second) {
        return primary == second;
    }

    public static boolean $eq(short primary, short second, boolean isDataPointerLike) {
        return primary == second;
    }

    public static boolean $eq(int primary, int second) {
        return primary == second;
    }

    public static boolean $eq(int primary, int second, boolean isDataPointerLike) {
        return primary == second;
    }

    public static boolean $eq(long primary, long second) {
        return primary == second;
    }

    public static boolean $eq(long primary, long second, boolean isDataPointerLike) {
        return primary == second;
    }

    public static boolean $eq(boolean primary, boolean second) {
        return primary == second;
    }

    public static boolean $eq(boolean primary, boolean second, boolean isDataPointerLike) {
        return primary == second;
    }

    public static boolean $less$JavaRef(Object LHS, Object RHS) {
        int R2;
        assert (!(LHS instanceof void$ptr)) : "must not be used for pointers";
        assert (!(RHS instanceof void$ptr)) : "must not be used for pointers";
        if (LHS == RHS) {
            return false;
        }
        int L = System.identityHashCode(LHS);
        if (L == (R2 = System.identityHashCode(RHS))) {
            throw new IllegalStateException("Don't support such compare yet, need weak-ref based global indexer to resolve collisions");
        }
        return L < R2;
    }

    public static int compare$JavaRef(Object LHS, Object RHS) {
        int R2;
        assert (!(LHS instanceof void$ptr)) : "must not be used for pointers";
        assert (!(RHS instanceof void$ptr)) : "must not be used for pointers";
        if (LHS == RHS) {
            return 0;
        }
        int L = System.identityHashCode(LHS);
        if (L == (R2 = System.identityHashCode(RHS))) {
            throw new IllegalStateException("Don't support such compare yet, need weak-ref based global indexer to resolve collisions");
        }
        return L < R2 ? -1 : 1;
    }

    public static int compare$less$Objects(Object LHS, Object RHS) {
        assert (!(LHS instanceof void$ptr)) : "must not be used for pointers";
        assert (!(RHS instanceof void$ptr)) : "must not be used for pointers";
        if (LHS == RHS) {
            return 0;
        }
        if (Native.$less(LHS, RHS)) {
            return -1;
        }
        if (Native.$less(RHS, LHS)) {
            return 1;
        }
        return 0;
    }

    public static <T> Comparator<T> Comparator$JavaRef() {
        return Native::compare$JavaRef;
    }

    public static boolean $less(ComparableLower primary, ComparableLower second) {
        return primary.$less(second);
    }

    public static boolean $less(Object primary, Object second) {
        Boolean res;
        if (primary == second) {
            return false;
        }
        if (primary instanceof OpCapable && (res = ((OpCapable)primary).$op(OpCapable.Op.LESS, second)) != null) {
            return res;
        }
        if (second instanceof OpCapable && (res = ((OpCapable)second).$op(OpCapable.Op.GREATER, primary)) != null) {
            return res;
        }
        if (primary instanceof Comparable && primary.getClass().isInstance(second)) {
            return ((Comparable)primary).compareTo(second) < 0;
        }
        if (second instanceof Comparable && second.getClass().isInstance(primary)) {
            return ((Comparable)second).compareTo(primary) > 0;
        }
        if (primary instanceof ComparableLower && primary.getClass().isInstance(second)) {
            return ((ComparableLower)primary).$less(second);
        }
        if (primary instanceof Number && second instanceof Number) {
            return ((Number)primary).longValue() < ((Number)second).longValue();
        }
        if (primary == null || second == null) {
            return false;
        }
        throw new AssertionError((Object)("not implementing ComparableLower/Comparable/OpCapable for LESS? for " + NativeTrace.getIdentityStr(primary) + " vs. " + NativeTrace.getIdentityStr(second)));
    }

    public static boolean $lesseq(Object first, Object second) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    public static boolean $lesseq_ptr(void$ptr first, void$ptr second) {
        return first.$lesseq(second);
    }

    public static boolean $greater(Object first, Object second) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    public static boolean $greatereq(Object first, Object second) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    public static boolean $greatereq_ptr(void$ptr first, void$ptr second) {
        return first.$greatereq(second);
    }

    public static boolean $noteq_ptr(Object primary, Object second) {
        return !Native.$eq_ptr(primary, second);
    }

    public static boolean $noteq_ptr(void$ptr primary, void$ptr second) {
        return !Native.$eq_ptr(primary, second);
    }

    public static boolean $noteq_iter(abstract_iterator primary, abstract_iterator second) {
        return !Native.$eq_iter(primary, second);
    }

    public static boolean $noteq(abstract_iterator primary, abstract_iterator second) {
        throw new AssertionError((Object)("must use $noteq_iter for iterators:" + NativeTrace.getIdentityStr(primary)));
    }

    public static boolean $noteq(void$ptr primary, void$ptr second) {
        throw new AssertionError((Object)("must use $noteq_ptr for pointers:" + NativeTrace.getIdentityStr(primary)));
    }

    public static boolean $noteq(Object primary, Object second) {
        assert (!(primary instanceof void$ptr) || !(second instanceof void$ptr)) : "must use $noteq_ptr for pointers:" + NativeTrace.getIdentityStr(primary);
        assert (!(primary instanceof abstract_iterator) || !(second instanceof abstract_iterator)) : "must use $noteq_iter for iterators: " + NativeTrace.getIdentityStr(primary);
        return Native.$noteq(primary, second, false);
    }

    public static boolean $noteq(Object primary, Object second, boolean isPointerLike) {
        if (isPointerLike) {
            assert (!(primary instanceof void$ptr) || !(second instanceof void$ptr)) : "Real pointers should not be considered as 'pointer like'! use $noteq_ptr instead: " + NativeTrace.getIdentityStr(primary);
            assert (!(primary instanceof abstract_iterator) || !(second instanceof abstract_iterator)) : "Real iterators should not be considered as 'pointer like'! use $noteq_iter instead:" + NativeTrace.getIdentityStr(primary);
            return primary != second;
        }
        if (primary == second) {
            return false;
        }
        if (primary instanceof NativeComparable) {
            return ((NativeComparable)primary).$noteq(second);
        }
        if (second instanceof NativeComparable) {
            return ((NativeComparable)second).$noteq(primary);
        }
        if (primary == null || second == null) {
            return true;
        }
        return !primary.equals(second);
    }

    public static boolean $noteq(byte primary, byte second) {
        return primary != second;
    }

    public static boolean $noteq(byte primary, byte second, boolean isPointerLike) {
        return primary != second;
    }

    public static boolean $noteq(char primary, char second) {
        return primary != second;
    }

    public static boolean $noteq(char primary, char second, boolean isPointerLike) {
        return primary != second;
    }

    public static boolean $noteq(int primary, int second) {
        return primary != second;
    }

    public static boolean $noteq(int primary, int second, boolean isPointerLike) {
        return primary != second;
    }

    public static boolean $noteq(long primary, long second) {
        return primary != second;
    }

    public static boolean $noteq(long primary, long second, boolean isPointerLike) {
        return primary != second;
    }

    public static boolean $noteq(boolean primary, boolean second) {
        return primary != second;
    }

    public static boolean $noteq(boolean primary, boolean second, boolean isPointerLike) {
        return primary != second;
    }

    public static boolean $less(int first, int second) {
        return first < second;
    }

    public static boolean $lesseq(int first, int second) {
        return first <= second;
    }

    public static boolean $greater(int first, int second) {
        return first > second;
    }

    public static boolean $greatereq(int first, int second) {
        return first >= second;
    }

    public static boolean $less(long first, long second) {
        return first < second;
    }

    public static boolean $lesseq(long first, long second) {
        return first <= second;
    }

    public static boolean $greater(long first, long second) {
        return first > second;
    }

    public static boolean $greatereq(long first, long second) {
        return first >= second;
    }

    public static <T> T $tryAssign(T dst, T src, boolean isPointerLike) {
        if (isPointerLike && !(src instanceof NativePointerLike) && !(dst instanceof NativePointerLike)) {
            return src;
        }
        if (dst instanceof assignable) {
            ((assignable)dst).$assign(src);
            return dst;
        }
        return Native.$tryClone(src);
    }

    public static <T> T $tryMoveStrong(T dst, T src, boolean isPointerLike) {
        assert (!isPointerLike);
        if (dst instanceof assignable) {
            ((assignable)dst).$assignMove(src);
            return dst;
        }
        assert (src instanceof NativeMoveable) : "expected NativeMoveable " + NativeTrace.getIdentityStr(src);
        return (T)Native.$Move((NativeMoveable)src);
    }

    public static <T> T $tryMove(T dst, T src, boolean isPointerLike) {
        if (isPointerLike && !(src instanceof NativePointerLike) && !(dst instanceof NativePointerLike)) {
            return src;
        }
        if (dst instanceof assignable) {
            ((assignable)dst).$assignMove(src);
            return dst;
        }
        return Native.$tryMove(src);
    }

    public static uchar$ptr $tryClone(uchar$ptr t) {
        if (t == null) {
            return null;
        }
        uchar$ptr out = (uchar$ptr)t.clone();
        assert (out.getClass() == t.getClass()) : "INVALID clone! Was " + t.getClass() + " became " + out.getClass();
        assert (out.$eq(t)) : "INVALID $eq in " + t.getClass();
        return out;
    }

    public static char$ptr $tryClone(char$ptr t) {
        if (t == null) {
            return null;
        }
        char$ptr out = (char$ptr)t.clone();
        assert (out.getClass() == t.getClass()) : "INVALID clone! Was " + t.getClass() + " became " + out.getClass();
        assert (out.$eq(t)) : "INVALID $eq in " + t.getClass();
        return out;
    }

    public static int $ptr_index(char$ptr ptr2) {
        return ptr2 != null ? ptr2.$index() : 0;
    }

    public static int $ptr_index(int$ptr ptr2) {
        return ptr2 != null ? ptr2.$index() : 0;
    }

    public static int $ptr_index(type$ptr ptr2) {
        return ptr2 != null ? ptr2.$index() : 0;
    }

    public static int $sub_ptr(char$ptr first, char$ptr second) {
        return first == second ? 0 : first.$sub(second);
    }

    public static int $sub_ptr(int$ptr first, int$ptr second) {
        return first == second ? 0 : first.$sub(second);
    }

    public static int $sub_ptr(type$ptr first, type$ptr second) {
        return first == second ? 0 : first.$sub(second);
    }

    public static <T> type$ptr<T> $add(type$ptr<T> ptr2, int val) {
        return val != 0 ? (type$ptr)ptr2.$add(val) : Native.$tryClone(ptr2);
    }

    public static <T> type$iterator<?, T> $add(type$iterator<?, T> ptr2, int val) {
        return val != 0 ? (type$iterator)ptr2.$add(val) : Native.$tryClone(ptr2);
    }

    public static int $add(int lhs, int rhs) {
        return lhs + rhs;
    }

    public static void $setIndex(char$ptr ptr2, char$ptr orig) {
        assert (ptr2.isComparableTo(orig)) : "ptr has different buffer? " + ptr2 + " vs. " + orig;
        Native.$setIndex(ptr2, orig.$index());
    }

    public static char$ptr $incConstIndex(char$ptr ptr2, int amount) {
        ptr2 = Native.$cleanConst(ptr2);
        if (amount != 0) {
            ptr2.$inc(amount);
        }
        return Native.$toConst(ptr2);
    }

    public static void $setIndex(char$ptr ptr2, int index) {
        int cur$index = ptr2.$index();
        if (cur$index != index) {
            ptr2.$inc(index - cur$index);
        }
        assert (ptr2.$index() == index);
    }

    public static void $setIndex(int$ptr ptr2, int index) {
        int cur$index = ptr2.$index();
        if (cur$index != index) {
            ptr2.$inc(index - cur$index);
        }
        assert (ptr2.$index() == index);
    }

    public static void $setIndex(uint$ptr ptr2, int index) {
        int cur$index = ptr2.$index();
        if (cur$index != index) {
            ptr2.$inc(index - cur$index);
        }
        assert (ptr2.$index() == index);
    }

    public static void $setIndex(type$ptr ptr2, int index) {
        int cur$index = ptr2.$index();
        if (cur$index != index) {
            ptr2.$inc(index - cur$index);
        }
        assert (ptr2.$index() == index);
    }

    public static void $setArrayAndIndex(type$ptr ptr2, Object[] array2, int index) {
        assert (Native.$is_array_based(ptr2));
        ((type$ptr$array)ptr2).index = index;
        AliasesAccessor.$setArray((type$ptr$array)ptr2, array2, index);
    }

    public static void $setArrayAndIndex(char$ptr ptr2, byte[] array2, int index) {
        assert (Native.$is_array_based(ptr2));
        ((char$ptr$array)ptr2).index = index;
        AliasesAccessor.$setArray((char$ptr$array)ptr2, array2, index);
    }

    public static void $setArrayAndIndex(char$ptr$array ptr2, byte[] array2, int index) {
        assert (Native.$is_array_based(ptr2));
        ptr2.index = index;
        AliasesAccessor.$setArray(ptr2, array2, index);
    }

    public static <T extends NativeMoveable<T>> T $tryMove(T t) {
        return Native.$Move(t);
    }

    public static <T> T $tryMove(T t) {
        if (t instanceof NativeMoveable) {
            return (T)Native.$Move((NativeMoveable)t);
        }
        return Native.$tryClone(t);
    }

    public static <T extends NativeMoveable> T $Move(T t) {
        return (T)(t == null ? null : (NativeMoveable)t.move());
    }

    public static boolean $tryMove(boolean val) {
        return val;
    }

    public static byte $tryMove(byte val) {
        return val;
    }

    public static short $tryMove(short val) {
        return val;
    }

    public static int $tryMove(int val) {
        return val;
    }

    public static long $tryMove(long val) {
        return val;
    }

    public static char $tryMove(char val) {
        return val;
    }

    private static <T> boolean assertEqualAfterClone(T val, T copy) {
        if (val instanceof NativeComparable && (val instanceof abstract_iterator || val.getClass().getSimpleName().contains("terator"))) {
            boolean res = ((NativeComparable)copy).$eq(val);
            if (!res) {
                res = ((NativeComparable)copy).$eq(val);
            }
            assert (res) : "INVALID $eq in class " + val.getClass();
        }
        return true;
    }

    public static <T extends NativeCloneable> T $tryClone(T t) {
        return Native.$Clone(t);
    }

    public static <T extends NativeCloneable> T $Clone(T t) {
        if (t == null) {
            return null;
        }
        NativeCloneable out = (NativeCloneable)t.clone();
        assert (out.getClass() == t.getClass() || "org.llvm.adt.StringRef$ConstStringRef".equals(t.getClass().getName())) : "INVALID clone! Was " + t.getClass() + " became " + out.getClass();
        assert (Native.assertEqualAfterClone(t, out));
        return (T)out;
    }

    public static <T> T $tryClone(T t) {
        if (t instanceof NativeCloneable) {
            return (T)Native.$Clone((NativeCloneable)t);
        }
        assert (!Native.isIteratorLikeTypeName(t)) : "All Iterators must be cloneable " + t.getClass();
        return t;
    }

    private static final boolean isIteratorLikeTypeName(Object o) {
        if (!NativeTrace.isDebugMode()) {
            throw new IllegalStateException("Only for calls from assert");
        }
        if (o == null) {
            return false;
        }
        String clsName = o.getClass().getSimpleName();
        if (clsName.contains("Iter")) {
            return true;
        }
        int indexOf = clsName.indexOf("iter");
        if (indexOf >= 0) {
            if (indexOf == 0) {
                return true;
            }
            char beforeI = clsName.charAt(indexOf - 1);
            if (beforeI == 'r') {
                return false;
            }
            return beforeI != 'L';
        }
        return false;
    }

    public static <T> T[] $tryClone(T[] val) {
        return (Object[])val.clone();
    }

    public static boolean $tryClone(boolean val) {
        return val;
    }

    public static byte $tryClone(byte val) {
        return val;
    }

    public static short $tryClone(short val) {
        return val;
    }

    public static int $tryClone(int val) {
        return val;
    }

    public static long $tryClone(long val) {
        return val;
    }

    public static char $tryClone(char val) {
        return val;
    }

    public static char$ptr $noClone(char$ptr t) {
        return t;
    }

    public static <T> T $noClone(T t) {
        return t;
    }

    public static boolean $is_array_based(type$ptr t) {
        return t instanceof type$ptr$array;
    }

    public static boolean $is_array_based(char$ptr t) {
        return t instanceof char$ptr$array;
    }

    public static boolean $is_array_based(uchar$ptr t) {
        return t instanceof uchar$ptr.array;
    }

    public static byte[] $extract_chars(NativeMemory.memory t) {
        return t instanceof char$mem ? ((char$mem)t).$array() : null;
    }

    public static boolean $is_array_based(ushort$ptr t) {
        return t instanceof ushort$ptr.array;
    }

    public static boolean $is_array_based(short$ptr t) {
        return t instanceof short$ptr.array;
    }

    public static boolean $is_array_based(uint$ptr t) {
        return t instanceof uint$ptr.array;
    }

    public static boolean $is_array_based(int$ptr t) {
        return t instanceof int$ptr.array;
    }

    public static boolean $is_array_based(ulong$ptr t) {
        return t instanceof ulong$ptr.array;
    }

    public static boolean $is_array_based(long$ptr t) {
        return t instanceof long$ptr.array;
    }

    public static boolean $assertConstPtr(char$ptr t) {
        if (NativeTrace.isDebugMode()) {
            assert (t == null || t instanceof DebuggableAbstractPointerType) : "unexpected class " + t.getClass();
            assert (t == null || ((DebuggableAbstractPointerType)((Object)t))._isConstPtr()) : "Required const pointer!";
        }
        return true;
    }

    public static char$ptr $cleanConst(char$ptr t) {
        if (NativeTrace.isDebugMode()) {
            assert (t == null || t instanceof AbstractArrayPointerType) : "unexpected class " + t.getClass();
            return t == null ? null : (char$ptr)((AbstractArrayPointerType)((Object)t)).$cleanConstPtr();
        }
        return t;
    }

    public static char$ptr $prepareCloneFor(char$ptr toPrepare, char$ptr orig) {
        if (toPrepare == orig) {
            return toPrepare;
        }
        if (toPrepare == null || toPrepare.getClass() != orig.getClass()) {
            toPrepare = Native.$tryClone(orig);
        } else {
            if (((DebuggableAbstractPointerType)((Object)toPrepare))._isConstPtr()) {
                toPrepare = Native.$cleanConst(toPrepare);
            }
            toPrepare.$assign(orig);
        }
        return toPrepare;
    }

    public static ulong$ptr $toConst(ulong$ptr t) {
        if (NativeTrace.isDebugMode()) {
            assert (t == null || t instanceof DebuggableAbstractPointerType) : "unexpected class " + t.getClass();
            return t == null ? null : (ulong$ptr)((DebuggableAbstractPointerType)((Object)t)).$toConstPtr();
        }
        return t;
    }

    public static uint$ptr $toConst(uint$ptr t) {
        if (NativeTrace.isDebugMode()) {
            assert (t == null || t instanceof DebuggableAbstractPointerType) : "unexpected class " + t.getClass();
            return t == null ? null : (uint$ptr)((DebuggableAbstractPointerType)((Object)t)).$toConstPtr();
        }
        return t;
    }

    public static char$ptr $toConst(char$ptr t) {
        if (NativeTrace.isDebugMode()) {
            assert (t == null || t instanceof DebuggableAbstractPointerType) : "unexpected class " + t.getClass();
            return t == null ? null : (char$ptr)((DebuggableAbstractPointerType)((Object)t)).$toConstPtr();
        }
        return t;
    }

    public static <T> type$ptr<T> $toConst(type$ptr<T> t) {
        if (NativeTrace.isDebugMode()) {
            assert (t == null || t instanceof DebuggableAbstractPointerType) : "unexpected class " + t.getClass();
            return t == null ? null : (type$ptr)((DebuggableAbstractPointerType)((Object)t)).$toConstPtr();
        }
        return t;
    }

    public static <T> type$ptr<T> $cleanConst(type$ptr<T> t) {
        if (NativeTrace.isDebugMode()) {
            assert (t == null || t instanceof DebuggableAbstractPointerType) : "unexpected class " + t.getClass();
            return t == null ? null : (type$ptr)((DebuggableAbstractPointerType)((Object)t)).$cleanConstPtr();
        }
        return t;
    }

    public static char$ptr $tryConstClone(char$ptr t) {
        assert (t == null || t instanceof DebuggableAbstractPointerType) : "unexpected class " + t.getClass();
        return t == null ? null : (char$ptr)t.const_clone();
    }

    public static char$ptr $tryDebugConstClone(char$ptr t) {
        if (NativeTrace.isDebugMode()) {
            return t == null ? null : (char$ptr)t.const_clone();
        }
        return t;
    }

    public static <T> T $tryConstClone(T t) {
        if (t == null) {
            return null;
        }
        if (t instanceof abstract_iterator) {
            return ((abstract_iterator)t).const_clone();
        }
        if (t instanceof DebuggableAbstractPointerType && ((DebuggableAbstractPointerType)t)._isConstPtr()) {
            return t;
        }
        if (t instanceof NativeCloneable) {
            return ((NativeCloneable)t).clone();
        }
        throw new AssertionError((Object)("Why not cloneable?" + t));
    }

    public static String $toString(char$ptr chars) {
        if (chars == null) {
            return null;
        }
        return Casts.toJavaString(chars);
    }

    public static String $toString(char$ptr chars, int length) {
        return Casts.toJavaString(chars, length);
    }

    public static String $toString(char$iterator<?> chars) {
        if (chars instanceof char$ptr) {
            return Native.$toString((char$ptr)chars);
        }
        return Native.$toString(chars, std.strlen(chars));
    }

    public static String $toString(char$iterator<?> chars, int length) {
        if (chars instanceof char$ptr) {
            return Native.$toString((char$ptr)chars, length);
        }
        chars = Native.$tryClone(chars);
        StringBuilder out = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            out.append((char)chars.$star());
            chars.$preInc();
        }
        return out.toString();
    }

    public static <T> T $star(type$iterator<?, T> ptr2) {
        return ptr2.$star();
    }

    public static <T> T $star(T o) {
        return o;
    }

    public static <T> T $addr(T o) {
        return o;
    }

    public static boolean N$assert(boolean Condition2) {
        assert (Condition2);
        return true;
    }

    public static boolean N$assert(boolean Condition2, String Msg) {
        assert (Condition2) : Msg;
        return true;
    }

    public static <T> T $Deref(T obj) {
        assert (obj != null) : "Should not deref nullptr";
        return obj;
    }

    public static <T> T $Deref(type$ref<T> obj) {
        assert (obj != null) : "Should not deref nullptr";
        return obj.$deref();
    }

    public static int $Deref(uint$iterator<?> obj) {
        assert (obj != null) : "Should not deref nullptr";
        return obj.$star();
    }

    public static <T> T $Deref(type$iterator<?, T> obj) {
        assert (obj != null) : "Should not deref nullptr";
        return obj.$star();
    }

    public static boolean $Deref(boolean val) {
        return val;
    }

    public static byte $Deref(byte val) {
        return val;
    }

    public static char $Deref(char val) {
        return val;
    }

    public static short $Deref(short val) {
        return val;
    }

    public static int $Deref(int val) {
        return val;
    }

    public static long $Deref(long val) {
        return val;
    }

    public static float $Deref(float val) {
        return val;
    }

    public static double $Deref(double val) {
        return val;
    }

    public static <T> T $AddrOf(T obj) {
        assert (obj != null) : "Can not take address of nullptr";
        return obj;
    }

    public static boolean $AddrOf(boolean val) {
        return val;
    }

    public static byte $AddrOf(byte val) {
        return val;
    }

    public static char $AddrOf(char val) {
        return val;
    }

    public static short $AddrOf(short val) {
        return val;
    }

    public static int $AddrOf(int val) {
        return val;
    }

    public static long $AddrOf(long val) {
        return val;
    }

    public static float $AddrOf(float val) {
        return val;
    }

    public static double $AddrOf(double val) {
        return val;
    }

    public static int $compare_type(Object o1, Object o2) {
        if (o1 instanceof ComparableLower) {
            if (((ComparableLower)o1).$less(o2)) {
                return -1;
            }
            return ((ComparableLower)o2).$less(o1) ? 1 : 0;
        }
        if (o1 instanceof Comparable) {
            return ((Comparable)o1).compareTo(o2);
        }
        throw new UnsupportedOperationException("NO ComparableLower: " + o1.getClass() + " vs. " + o2.getClass());
    }

    public static int $compare_ptr(Object o1, Object o2) {
        if (o1 instanceof NativePointerLike) {
            if (((ComparableLower)o1).$less(o2)) {
                return -1;
            }
            return ((ComparableLower)o2).$less(o1) ? 1 : 0;
        }
        if (Native.$less$JavaRef(o1, o2)) {
            return -1;
        }
        return Native.$less$JavaRef(o2, o1) ? 1 : 0;
    }

    public static int $compare_type_int(Integer o1, Integer o2) {
        return o1.compareTo(o2);
    }

    public static int $compare_type_uint(Integer o1, Integer o2) {
        return Unsigned.$compare_uint(o1, o2);
    }

    public static int $compare_type_long(Long o1, Long o2) {
        return o1.compareTo(o2);
    }

    public static int $compare_type_ulong(Long o1, Long o2) {
        return Unsigned.$compare_ulong(o1, o2);
    }

    public static <T> int $appendArray(T[] destination, int from, T[] source) {
        assert (from == 0 || destination[from - 1] != null) : "Why previous element is not initialized yet?";
        for (int i = 0; i < source.length; ++i) {
            destination[i + from] = source[i];
        }
        return from + source.length;
    }

    public static int $appendArray(byte[] destination, int from, byte[] source) {
        for (int i = 0; i < source.length; ++i) {
            destination[i + from] = source[i];
        }
        return from + source.length;
    }

    public static int $appendArray(type$ptr<char$ptr> destination, int From, char$ptr[] source) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static int availableProcessors() {
        return NUM_PARALLEL_THREADS;
    }

    private Native() {
    }

    static void clearStatistics() {
        JavaCleaner.clearStatistics();
    }

    static long printStatistics(PrintWriter out) {
        long Value = JavaCleaner.printStatistics(out);
        return Value;
    }

    public static final class CharPtrToCharSequenceConverter
    implements NativeCallback.Converter<char$ptr, CharSequence> {
        @Override
        public Class<CharSequence> getToClass() {
            return CharSequence.class;
        }

        @Override
        public CharSequence $call(char$ptr from) {
            return Native.$toString(from);
        }
    }

    public static final class CharPtrToStringConverter
    implements NativeCallback.Converter<char$ptr, String> {
        @Override
        public Class<String> getToClass() {
            return String.class;
        }

        @Override
        public String $call(char$ptr from) {
            return Native.$toString(from);
        }
    }

    public static final class CharSequenceToCharPtrConverter
    implements NativeCallback.Converter<CharSequence, char$ptr> {
        @Override
        public Class<char$ptr> getToClass() {
            return char$ptr.class;
        }

        @Override
        public char$ptr $call(CharSequence from) {
            return NativePointer.create_char$ptr(from);
        }
    }

    public static interface NativeHashable {
        public int $hashcode();
    }

    public static interface NativePOD<T>
    extends assignable<T>,
    NativeCloneable<T>,
    NativeComparable<T> {
    }

    public static interface assignable<T> {
        public T $assign(T var1);

        default public T $assignMove(T value) {
            return this.$assign(value);
        }
    }

    public static interface NativeReverseIterable<Iter> {
        public Iter rbegin();

        default public Iter rbegin$Const() {
            return this.rbegin();
        }

        public Iter rend();

        default public Iter rend$Const() {
            return this.rend();
        }
    }

    public static interface NativeIterable<Iter> {
        public Iter begin();

        default public Iter begin$Const() {
            return this.begin();
        }

        public Iter end();

        default public Iter end$Const() {
            return this.end();
        }
    }

    public static interface ComparableLowerGreater
    extends ComparableLower,
    ComparableGreater {
    }

    public static interface ComparableGreater {
        public boolean $greater(Object var1);

        default public boolean $greatereq(Object obj) {
            throw new UnsupportedOperationException();
        }
    }

    public static interface ComparableLower {
        public boolean $less(Object var1);

        default public boolean $lesseq(Object obj) {
            throw new UnsupportedOperationException();
        }
    }

    public static interface OpCapable {
        public Boolean $op(Op var1, Object var2);

        public static enum Op {
            EQ,
            LESS,
            LESSEQ,
            GREATER,
            GREATEREQ;

        }
    }

    public static interface NativeComparable<T> {
        default public boolean $noteq(T other) {
            return !this.$eq(other);
        }

        default public boolean $eq(T other) {
            throw new UnsupportedOperationException("Not yet implemented in " + this.getClass());
        }
    }

    public static interface ComparatorLower<LHS, RHS>
    extends std_functional.binary_functionArgArg2Bool<LHS, RHS> {
        public boolean $less(LHS var1, RHS var2);

        @Override
        default public boolean $call(LHS arg1, RHS arg2) {
            return this.$less(arg1, arg2);
        }
    }

    public static interface NativeBoolEnum
    extends NativeUnsignedTypeMarker {
        public boolean getValue();
    }

    public static interface NativeCharEnum
    extends NativeSignedTypeMarker {
        public byte getValue();
    }

    public static interface NativeUCharEnum
    extends ComparableLower,
    NativeUnsignedTypeMarker {
        public byte getValue();

        @Override
        default public boolean $less(Object obj) {
            return Unsigned.$less_uchar(this.getValue(), ((NativeUCharEnum)obj).getValue());
        }

        @Override
        default public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uchar(this.getValue(), ((NativeUCharEnum)obj).getValue());
        }
    }

    public static interface NativeUShortEnum
    extends ComparableLower,
    NativeUnsignedTypeMarker {
        public char getValue();

        @Override
        default public boolean $less(Object obj) {
            return Unsigned.$less_ushort(this.getValue(), ((NativeUShortEnum)obj).getValue());
        }

        @Override
        default public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_ushort(this.getValue(), ((NativeUShortEnum)obj).getValue());
        }
    }

    public static interface NativeIntEnum
    extends ComparableLower,
    NativeSignedTypeMarker {
        public int getValue();

        @Override
        default public boolean $less(Object obj) {
            return Unsigned.$less_int(this.getValue(), ((NativeIntEnum)obj).getValue());
        }

        @Override
        default public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_int(this.getValue(), ((NativeIntEnum)obj).getValue());
        }
    }

    public static interface NativeUIntEnum
    extends ComparableLower,
    NativeUnsignedTypeMarker {
        public int getValue();

        @Override
        default public boolean $less(Object obj) {
            return Unsigned.$less_uint(this.getValue(), ((NativeUIntEnum)obj).getValue());
        }

        @Override
        default public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint(this.getValue(), ((NativeUIntEnum)obj).getValue());
        }
    }

    public static interface NativeSignedTypeMarker {
    }

    public static interface NativeUnsignedTypeMarker {
    }
}

