/*
 * Decompiled with CFR 0.152.
 */
package org.clank.support;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.NativeTrace;

public final class JavaCleaner {
    private static final ThreadLocal<List<JavaCleaner>> cleanersStackStorage = new ThreadLocal<List<JavaCleaner>>(){

        @Override
        protected List<JavaCleaner> initialValue() {
            return new ArrayList<JavaCleaner>(2);
        }
    };
    private static final ThreadLocal<Pool> reusableCleaners = new ThreadLocal<Pool>(){

        @Override
        protected Pool initialValue() {
            Pool pool = new Pool();
            return pool;
        }
    };
    private final List<Object> temporaries = new ArrayList<Object>(4);
    Exception releaseStack = null;
    private static long reusableInstances = 0L;
    private static long instances = 0L;
    private static final boolean RECORD_TRACK = false;

    public static JavaCleaner JC$Push() {
        List<JavaCleaner> cleanersStack = cleanersStackStorage.get();
        JavaCleaner cleaner = JavaCleaner.create();
        cleanersStack.add(cleaner);
        return cleaner;
    }

    public static void JC$Pop() {
        List<JavaCleaner> cleanersStack = cleanersStackStorage.get();
        JavaCleaner cleaner = cleanersStack.remove(cleanersStack.size() - 1);
        cleaner.clean();
    }

    public static JavaCleaner JC$Top() {
        List<JavaCleaner> cleanersStack = cleanersStackStorage.get();
        return cleanersStack.get(cleanersStack.size() - 1);
    }

    static JavaCleaner create() {
        if (NativeTrace.REUSE_JAVA_CLEANER) {
            return reusableCleaners.get().takeOrCreate();
        }
        return new JavaCleaner(false);
    }

    private static void release(JavaCleaner cleaner) {
        assert (NativeTrace.REUSE_JAVA_CLEANER);
        reusableCleaners.get().release(cleaner);
    }

    JavaCleaner(boolean reusable) {
        JavaCleaner.trackInstance(reusable);
    }

    public <T> std_ptr.unique_ptr_with_deleter<T> track(std_ptr.unique_ptr_with_deleter<T> temporary) {
        this.trackImpl(temporary);
        return temporary;
    }

    public <T> std_ptr.unique_ptr_array<T> track(std_ptr.unique_ptr_array<T> temporary) {
        this.trackImpl(temporary);
        return temporary;
    }

    public <T> std_ptr.unique_ptr<T> track(std_ptr.unique_ptr<T> temporary) {
        this.trackImpl(temporary);
        return temporary;
    }

    public <T> T track(T temporary) {
        this.trackImpl(temporary);
        return temporary;
    }

    public <T> T[] track(T[] temporary) {
        this.trackArraryImpl(temporary);
        return temporary;
    }

    public <T> T clean(T exprValue) {
        this.doClean();
        return exprValue;
    }

    public byte clean(byte exprValue) {
        this.doClean();
        return exprValue;
    }

    public char clean(char exprValue) {
        this.doClean();
        return exprValue;
    }

    public short clean(short exprValue) {
        this.doClean();
        return exprValue;
    }

    public int clean(int exprValue) {
        this.doClean();
        return exprValue;
    }

    public long clean(long exprValue) {
        this.doClean();
        return exprValue;
    }

    public double clean(double exprValue) {
        this.doClean();
        return exprValue;
    }

    public boolean clean(boolean exprValue) {
        this.doClean();
        return exprValue;
    }

    public void clean() {
        this.doClean();
    }

    public <T> T forward(T exprValue) {
        return exprValue;
    }

    public byte forward(byte exprValue) {
        return exprValue;
    }

    public char forward(char exprValue) {
        return exprValue;
    }

    public short forward(short exprValue) {
        return exprValue;
    }

    public int forward(int exprValue) {
        return exprValue;
    }

    public long forward(long exprValue) {
        return exprValue;
    }

    public float forward(float exprValue) {
        return exprValue;
    }

    public double forward(double exprValue) {
        return exprValue;
    }

    public boolean forward(boolean exprValue) {
        return exprValue;
    }

    public final void $destroy() {
        if (NativeTrace.isDebugMode()) {
            for (Object tmp : this.temporaries) {
                String toString = NativeTrace.getIdentityStr(tmp);
                Exception ex = new Exception("JAVACLEANER ERROR: Uncleaned object (If in finally then check exception thrown in try/catch) ");
                NativeTrace.registerCleanupException(ex);
                NativeTrace.printDebuggingStackFrames("JAVACLEANER ERROR: Uncleaned object (If in finally then check exception thrown in try/catch) " + toString);
            }
        }
        if (NativeTrace.REUSE_JAVA_CLEANER) {
            JavaCleaner.release(this);
        }
    }

    private void doClean() {
        for (Object temporary : this.temporaries) {
            Destructors.$destroy(temporary);
        }
        this.temporaries.clear();
    }

    private static void trackInstance(boolean reusable) {
        if (NativeTrace.STATISTICS) {
            ++instances;
            if (reusable) {
                ++reusableInstances;
            }
        }
    }

    static void clearStatistics() {
        instances = 0L;
        reusableInstances = 0L;
    }

    static long printStatistics(PrintWriter out) {
        out.printf("%22s created:\t%s%n", JavaCleaner.class.getSimpleName(), NativeTrace.formatNumber(instances));
        out.printf("%22s +reused:\t%s%n", JavaCleaner.class.getSimpleName(), NativeTrace.formatNumber(reusableInstances));
        NativeTrace.dumpStatisticValue(JavaCleaner.class.getSimpleName(), instances);
        return instances;
    }

    private void trackImpl(Object temporary) {
        assert (temporary != null);
        assert (temporary instanceof Destructors.ClassWithDestructor) : "Why registering temporary without destructor?" + temporary.getClass().getName();
        this.temporaries.add(temporary);
    }

    private <T> void trackArraryImpl(T[] temporary) {
        assert (temporary != null);
        assert (temporary.length > 0);
        this.temporaries.add(new JavaTemporaryArrayWrapper(temporary));
    }

    private static final class JavaCleanerWrapper
    implements Destructors.ClassWithDestructor {
        private final Object wrapped;
        private final Exception trackStack;
        private final boolean array;

        public JavaCleanerWrapper(Object wrapped, boolean array2) {
            this.wrapped = wrapped;
            this.trackStack = new Exception("Non Freed " + wrapped);
            this.array = array2;
        }

        public String toString() {
            String out = "Wrap{" + (this.array ? Arrays.toString((Object[])this.wrapped) : this.wrapped.toString()) + "}";
            return out;
        }

        @Override
        public void $destroy() {
            if (this.array) {
                Destructors.$destroyArray((Object[])this.wrapped);
            } else {
                Destructors.$destroy(this.wrapped);
            }
        }
    }

    private static final class JavaTemporaryArrayWrapper
    implements Destructors.ClassWithDestructor {
        private final Object[] wrapped;

        public JavaTemporaryArrayWrapper(Object[] array2) {
            this.wrapped = array2;
        }

        @Override
        public void $destroy() {
            Destructors.$destroyArray(this.wrapped);
        }
    }

    private static final class Pool {
        private static final int MAX_INDEX = 31;
        int size = 0;
        JavaCleaner[] array = new JavaCleaner[32];

        Pool() {
        }

        JavaCleaner takeOrCreate() {
            JavaCleaner out;
            JavaCleaner javaCleaner = out = this.size == 0 ? new JavaCleaner(true) : this.array[this.size--];
            if (this.size < 0) {
                this.size = this.size;
            }
            assert (out.temporaries.isEmpty()) : "must be empty in the beginning " + JavaCleaner.access$000(out);
            return out;
        }

        void release(JavaCleaner released) {
            if (this.size < 0) {
                this.size = this.size;
            }
            assert (this.size >= 0);
            assert (released.temporaries.isEmpty()) : "must be empty on release " + JavaCleaner.access$000(released);
            if (NativeTrace.isDebugMode()) {
                for (int i = 0; i < this.size; ++i) {
                    assert (this.array[i] != released);
                }
            }
            if (this.size < 31) {
                this.array[++this.size] = released;
            }
        }

        void clear() {
            for (int i = 0; i < this.array.length; ++i) {
                this.array[i] = null;
            }
            this.size = 0;
        }
    }
}

