/*
 * Decompiled with CFR 0.152.
 */
package org.clank.java.stdimpl.aliases;

import java.util.Iterator;
import java.util.function.Supplier;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativeMoveable;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.NativeType;
import org.clank.support.Sequence;
import org.clank.support.aliases.JavaIterator;
import org.clank.support.aliases.NativeContainer;
import org.clank.support.aliases.type$iterator;
import org.clank.support.aliases.type$ptr;
import org.clank.support.aliases.type$ref;

public abstract class StdVector<T>
extends NativeTrace.CreateDestroy.Tracker
implements Native.NativePOD<std.vector<T>>,
NativeMoveable<std.vector<T>>,
Native.NativeComparable<std.vector<T>>,
Native.ComparableLower,
NativeType.SizeofCapable,
Iterable<T>,
Sequence<type$ref<T>>,
NativeContainer<T>,
Destructors.ClassWithDestructor {
    protected final Supplier<T> defaultValue;
    protected T[] array;
    private static final Object[] EMPTY = new Object[0];
    protected int end;

    protected StdVector(Supplier<T> defaultValue) {
        this.array = EMPTY;
        this.end = 0;
        assert (NativeTrace.assertDefaultValue(defaultValue));
        this.defaultValue = defaultValue;
    }

    protected StdVector(int initialSize, Supplier<T> defaultValue) {
        this(initialSize, defaultValue, defaultValue);
    }

    protected StdVector(int initialSize, Supplier<T> initialValue, Supplier<T> defaultValue) {
        this(defaultValue);
        super.assignWithSupplier(initialSize, initialValue);
    }

    protected StdVector(T[] array2, int length, Supplier<T> defaultValue) {
        this.array = array2;
        this.end = length;
        assert (NativeTrace.assertDefaultValue(defaultValue));
        this.defaultValue = defaultValue;
    }

    protected StdVector(type$iterator<?, T> iter, int length, Supplier<T> defaultValue) {
        this(iter, (type$iterator)iter.$add(length), defaultValue);
    }

    protected StdVector(type$iterator<?, T> begin, type$iterator<?, T> end, Supplier<T> defaultValue) {
        this(defaultValue);
        this.append(begin, end);
    }

    protected StdVector(std.vector<T> other) {
        this(other.defaultValue);
        assert (other.checkAlive());
        this.append((type$iterator<?, T>)other.begin(), (type$iterator<?, T>)other.end());
    }

    protected StdVector(JavaDifferentiators.JD.Move _dparam, std.vector<T> other) {
        this(other.defaultValue);
        this.$assignMove(other);
    }

    @Override
    public std.vector<T> $assign(std.vector<T> other) {
        assert (other.checkAlive());
        if (this == other) {
            return (std.vector)this;
        }
        assert (this.checkAlive());
        this.clear();
        this.array = EMPTY;
        this.append((type$iterator<?, T>)other.begin(), (type$iterator<?, T>)other.end());
        return (std.vector)this;
    }

    @Override
    public std.vector<T> $assignMove(std.vector<T> other) {
        assert (other.checkAlive());
        if (this == other) {
            return (std.vector)this;
        }
        assert (this.checkAlive());
        this.clear();
        this.array = other.array;
        this.end = other.end;
        other.array = EMPTY;
        other.end = 0;
        return (std.vector)this;
    }

    public boolean shrink_to_fit() {
        return false;
    }

    public void clear() {
        assert (this.checkAlive());
        this.destroy_range(0, this.size());
        this.setEnd(0);
    }

    @Override
    public void resize(int newSize) {
        this.resize(newSize, this.defaultValue);
    }

    public void resize(int newSize, T defaultValue) {
        assert (this.checkAlive());
        if (newSize < this.end) {
            this.destroy_range(newSize, this.end);
        } else if (newSize > this.end) {
            if (this.capacity() < newSize) {
                this.grow(newSize);
            }
            for (int i = this.end; i < newSize; ++i) {
                assert (NativeTrace.assertArrayHasMutableContent(this.array, this));
                this.array[i] = Native.$tryClone(defaultValue);
            }
        }
        this.setEnd(newSize);
    }

    public void resize(int newSize, Supplier<T> defaultValue) {
        if (newSize < this.end) {
            this.destroy_range(newSize, this.end);
        } else if (newSize > this.end) {
            if (this.capacity() < newSize) {
                this.grow(newSize);
            }
            for (int i = this.end; i < newSize; ++i) {
                assert (NativeTrace.assertArrayHasMutableContent(this.array, this));
                this.array[i] = this.$getDefaultVal();
            }
        }
        this.setEnd(newSize);
    }

    public void reserve(int N) {
        assert (this.checkAlive());
        if (this.capacity() < N) {
            this.grow(N);
        }
    }

    public void assign(int NumElts, T Elt) {
        assert (this.checkAlive());
        this.clear();
        if (this.capacity() < NumElts) {
            this.grow(NumElts);
        }
        this.setEnd(NumElts);
        for (int i = 0; i < this.size(); ++i) {
            this.$set(i, Elt);
        }
    }

    private void assignWithSupplier(int NumElts, Supplier<T> Supplier2) {
        assert (this.checkAlive());
        assert (NativeTrace.assertArrayHasMutableContent(this.array, this));
        this.clear();
        if (this.capacity() < NumElts) {
            this.grow(NumElts);
        }
        this.setEnd(NumElts);
        for (int i = 0; i < this.size(); ++i) {
            this.array[i] = Supplier2 == null ? null : Supplier2.get();
        }
    }

    public void assign$T(type$iterator<?, T> __first, type$iterator<?, T> __last) {
        this.clear();
        this.append(__first, __last);
    }

    public void swap(StdVector<T> RHS) {
        assert (RHS.checkAlive());
        assert (this.checkAlive());
        T[] arrTmp = this.array;
        this.array = RHS.array;
        RHS.array = arrTmp;
        int endTmp = this.end;
        this.end = RHS.end;
        RHS.end = endTmp;
    }

    public final int find(Object elem) {
        assert (this.checkAlive());
        return this.find(elem, 0);
    }

    public final int find(Object elem, int from) {
        assert (this.checkAlive());
        boolean isDataPointerLike = this.isDataPointerLike();
        for (int i = from; i < this.end; ++i) {
            if (!Native.$eq(this.array[i], elem, isDataPointerLike)) continue;
            return i;
        }
        return std.string.npos;
    }

    public final boolean contains(Object elem) {
        assert (this.checkAlive());
        return this.find(elem) != std.string.npos;
    }

    public final void remove_if(NativeCallback.BoolPredicate<T> predicate) {
        assert (this.checkAlive());
        if (this.empty()) {
            return;
        }
        for (int i = 0; i < this.end; ++i) {
            if (!predicate.$call(this.array[i])) continue;
            boolean res = this.erase_at(i);
            assert (res);
            --i;
        }
    }

    public final boolean erase(Object elem) {
        assert (this.checkAlive());
        int index = this.find(elem);
        return this.erase_at(index);
    }

    private final boolean erase_at(int index) {
        if (index == std.string.npos) {
            return false;
        }
        assert (this.checkIndex(index));
        this.destroy_range(index, index + 1);
        if (index < this.end - 1) {
            std.copy(this.array, index + 1, this.end - index - 1, this.array, index);
        }
        this.$set(this.end - 1, this.$getDefaultVal());
        --this.end;
        return true;
    }

    public iterator erase(iterator I) {
        assert (this.checkAlive());
        assert (I.$greatereq(this.begin())) : "Iterator to erase is out of bounds.";
        assert (I.$less(this.end())) : "Erasing at past-the-end iterator.";
        iterator N = I;
        std.move(I.$add(1), this.end(), I, this.isDataPointerLike());
        this.pop_back();
        return N;
    }

    public iterator erase(iterator S, iterator E) {
        assert (this.checkAlive());
        assert (S.$greatereq(this.begin())) : "Range to erase is out of bounds.";
        assert (S.$lesseq(E)) : "Trying to erase invalid range.";
        assert (E.$lesseq(this.end())) : "Trying to erase past the end.";
        iterator N = S;
        iterator I = std.move(E, this.end(), S, this.isDataPointerLike());
        this.destroy_range(I, this.end());
        this.setEnd(I);
        return N;
    }

    public iterator insert(iterator I, T Elt) {
        assert (this.checkAlive());
        if (((iterator)I).$eq(this.end())) {
            this.push_back(Elt);
            return this.end().$sub(1);
        }
        assert (((iterator)I).$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (((iterator)I).$lesseq(this.end())) : "Inserting past the end of the vector.";
        if (this.size() >= this.capacity()) {
            int EltNo = ((iterator)I).$sub(this.begin());
            this.grow();
            I = this.begin().$add(EltNo);
        }
        assert (this.size() < this.capacity());
        this.setEnd(this.size() + 1);
        std.copy_backward(I, this.end().$sub(1), this.end(), this.isDataPointerLike());
        ((iterator)I).star$ref().$set(Native.$tryAssign(((iterator)I).$star(), Elt, this.isDataPointerLike()));
        return I;
    }

    public iterator insert_T$RR(iterator I, T Elt) {
        assert (this.checkAlive());
        if (((iterator)I).$eq(this.end())) {
            this.push_back_T$RR(Elt);
            return this.end().$sub(1);
        }
        assert (((iterator)I).$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (((iterator)I).$lesseq(this.end())) : "Inserting past the end of the vector.";
        if (this.size() >= this.capacity()) {
            int EltNo = ((iterator)I).$sub(this.begin());
            this.grow();
            I = this.begin().$add(EltNo);
        }
        assert (this.size() < this.capacity());
        this.setEnd(this.size() + 1);
        std.copy_backward(I, this.end().$sub(1), this.end(), this.isDataPointerLike());
        ((iterator)I).star$ref().$set(Native.$tryMove(((iterator)I).$star(), Elt, this.isDataPointerLike()));
        return I;
    }

    public iterator insert(iterator I, int NumToInsert, T Elt) {
        assert (this.checkAlive());
        assert (NumToInsert >= 0);
        int InsertElt = I.$sub(this.begin());
        if (I.$eq(this.end())) {
            this.append(NumToInsert, Elt);
            return this.begin().$add(InsertElt);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        this.reserve(this.size() + NumToInsert);
        I = this.begin().$add(InsertElt);
        if (this.end().$sub((iterator<T>)I) >= NumToInsert) {
            iterator<T> OldEnd = this.end();
            this.append((type$iterator<?, T>)this.end().$sub(NumToInsert), (type$iterator<?, T>)this.end());
            std.copy_backward(I, OldEnd.$sub(NumToInsert), OldEnd, this.isDataPointerLike());
            std.fill_n(I, NumToInsert, Elt);
            return I;
        }
        iterator<T> OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        int NumOverwritten = OldEnd.$sub((iterator<T>)I);
        std.copy(I, OldEnd, this.end().$sub(NumOverwritten), this.isDataPointerLike());
        std.fill_n(I, NumOverwritten, Elt);
        std.fill_n(OldEnd, NumToInsert - NumOverwritten, Elt);
        return I;
    }

    public final iterator insert$T(iterator I, type$iterator<?, T> From, type$iterator<?, T> To) {
        assert (this.checkAlive());
        return this.insert(I, From, To);
    }

    public final <U> iterator insert$T(iterator I, type$iterator<?, U> From, type$iterator<?, U> To, NativeCallback.Converter<U, T> convertor) {
        throw new UnsupportedOperationException();
    }

    public iterator insert(iterator I, type$iterator<?, T> From, type$iterator<?, T> To) {
        int NumOverwritten;
        assert (this.checkAlive());
        int InsertElt = I.$sub(this.begin());
        if (I.$eq(this.end())) {
            this.append(From, To);
            return this.begin().$add(InsertElt);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        int NumToInsert = std.distance(From, To);
        this.reserve(this.size() + NumToInsert);
        I = this.begin().$add(InsertElt);
        if (NumToInsert == 0) {
            return I;
        }
        if (this.end().$sub((iterator<T>)I) >= NumToInsert) {
            iterator<T> OldEnd = this.end();
            this.append((type$iterator<?, T>)this.end().$sub(NumToInsert), (type$iterator<?, T>)this.end());
            std.copy_backward(I, OldEnd.$sub(NumToInsert), OldEnd, this.isDataPointerLike());
            std.copy(From, To, I, this.isDataPointerLike());
            return I;
        }
        iterator<T> OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        std.copy(I, OldEnd, this.end().$sub(NumOverwritten), this.isDataPointerLike());
        From = Native.$tryClone(From);
        iterator J = Native.$Clone(I);
        for (NumOverwritten = OldEnd.$sub((iterator<T>)I); NumOverwritten > 0; --NumOverwritten) {
            J.star$ref().$set(From.$star());
            J.$preInc();
            From.$preInc();
        }
        std.copy(From, To, OldEnd, this.isDataPointerLike());
        return I;
    }

    public void append(type$iterator<?, T> in_start, type$iterator<?, T> in_end) {
        assert (this.checkAlive());
        int NumInputs = std.distance(in_start, in_end);
        if (NumInputs == 0) {
            return;
        }
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        type$iterator<?, type$iterator<?, T>> iter = Native.$Clone(in_start);
        while (!iter.$eq(in_end)) {
            ++this.end;
            this.$set(this.end - 1, iter.$star());
            iter.$preInc();
        }
    }

    public void append(int NumInputs, T Elt) {
        assert (this.checkAlive());
        assert (NumInputs >= 0);
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        for (int i = 0; i < NumInputs; ++i) {
            ++this.end;
            this.$set(this.end - 1, Elt);
        }
    }

    @Override
    public boolean $eq(std.vector<T> RHS) {
        assert (this.checkAlive());
        assert (RHS.checkAlive());
        if (this.size() != RHS.size()) {
            return false;
        }
        return std.equal(this.begin(), this.end(), (type$iterator)RHS.begin());
    }

    @Override
    public boolean $noteq(std.vector<T> RHS) {
        return !this.$eq(RHS);
    }

    @Override
    public boolean $less(Object obj) {
        assert (this.checkAlive());
        assert (((StdVector)obj).checkAlive());
        return std.lexicographical_compare(this.begin(), this.end(), ((StdVector)obj).begin(), ((StdVector)obj).end());
    }

    @Override
    public boolean $lesseq(Object obj) {
        return this.$less(obj) || this.$eq((std.vector)obj);
    }

    @Override
    public type$ref<T> ref$at(int idx) {
        assert (this.checkAlive());
        assert (this.checkIndex(idx));
        return NativePointer.create_type$ref(this.array, idx);
    }

    public T $at(int idx) {
        assert (this.checkAlive());
        assert (this.checkIndex(idx));
        return this.array[idx];
    }

    public T $at$Const(int idx) {
        assert (this.checkAlive());
        assert (this.checkIndex(idx));
        return this.array[idx];
    }

    public T $set(int idx, T value) {
        assert (this.checkAlive());
        assert (this.checkIndex(idx));
        assert (NativeTrace.assertArrayHasMutableContent(this.array, this));
        this.array[idx] = this.defaultValue == null ? value : Native.$tryAssign(this.array[idx], value, this.isDataPointerLike());
        return this.array[idx];
    }

    protected final T $set$move(int idx, T value) {
        assert (this.checkAlive());
        assert (this.checkIndex(idx));
        assert (NativeTrace.assertArrayHasMutableContent(this.array, this));
        this.array[idx] = this.defaultValue == null ? value : Native.$tryMove(this.array[idx], value, this.isDataPointerLike());
        return this.array[idx];
    }

    public boolean empty() {
        assert (this.checkAlive());
        return this.size() == 0;
    }

    @Override
    public void $destroy() {
        this.destroy_range(0, this.size());
        this.setEnd(0);
        this.set$destroyed();
    }

    @Override
    public final void push_back_T$C$R(T val) {
        assert (this.checkAlive());
        this.push_back(val);
    }

    @Override
    public final void push_back_T$RR(T val) {
        assert (this.checkAlive());
        if (this.size() >= this.capacity()) {
            this.grow(2 * this.capacity() + 1);
        }
        ++this.end;
        this.$set$move(this.end - 1, val);
    }

    @Override
    public void push_back(T val) {
        assert (this.checkAlive());
        if (this.size() >= this.capacity()) {
            this.grow(2 * this.capacity() + 1);
        }
        ++this.end;
        this.$set(this.end - 1, val);
    }

    public final void emplace_back(T val) {
        assert (this.checkAlive());
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        int index = this.size();
        this.array[index] = val;
        this.setEnd(index + 1);
    }

    public final void emplace_back() {
        assert (this.checkAlive());
        this.push_back(this.$getDefaultVal());
    }

    public void pop_back() {
        assert (this.checkAlive());
        this.destroy_range(this.size() - 1, this.size());
        this.setEnd(this.size() - 1);
    }

    public T pop_back_val() {
        assert (this.checkAlive());
        T val = this.back();
        this.setEnd(this.end - 1);
        return val;
    }

    public final iterator<T> begin() {
        assert (this.checkAlive());
        return new iterator(this, 0, false);
    }

    public final iterator<T> cbegin() {
        return this.begin$Const();
    }

    public final iterator<T> begin$Const() {
        assert (this.checkAlive());
        return this.begin();
    }

    public final iterator<T> end() {
        assert (this.checkAlive());
        return new iterator(this, this.end, false);
    }

    public final iterator<T> cend() {
        return this.end$Const();
    }

    public final iterator<T> end$Const() {
        assert (this.checkAlive());
        return this.end();
    }

    public std.reverse_iterator<T> rbegin() {
        assert (this.checkAlive());
        return new std.reverse_iterator(this.end());
    }

    public final std.reverse_iterator<T> rbegin$Const() {
        assert (this.checkAlive());
        return this.rbegin();
    }

    public std.reverse_iterator<T> rend() {
        assert (this.checkAlive());
        return new std.reverse_iterator(this.begin());
    }

    public final std.reverse_iterator<T> rend$Const() {
        assert (this.checkAlive());
        return this.rend();
    }

    public type$ptr<T> data() {
        assert (this.checkAlive());
        return NativePointer.create_type$ptr(this.array);
    }

    public T front() {
        assert (this.checkAlive());
        assert (this.checkIndex(0));
        return this.array[0];
    }

    public final T front$Const() {
        assert (this.checkAlive());
        return this.front();
    }

    public T back() {
        assert (this.checkAlive());
        assert (this.checkIndex(this.end - 1));
        return this.array[this.end - 1];
    }

    public final T back$Const() {
        assert (this.checkAlive());
        return this.back();
    }

    public type$ref<T> ref$front() {
        return new type$ref<T>(){
            private final T stored;
            private final int index = 0;
            {
                assert (StdVector.this.checkAlive());
                assert (StdVector.this.checkIndex(0));
                this.stored = StdVector.this.array[0];
                this.index = 0;
            }

            @Override
            public T $deref() {
                assert (StdVector.this.checkAlive());
                assert (StdVector.this.checkIndex(0));
                return this.stored;
            }

            @Override
            public T $set(T value) {
                assert (StdVector.this.checkAlive());
                assert (StdVector.this.checkIndex(0));
                assert (NativeTrace.assertArrayHasMutableContent(StdVector.this.array, this));
                StdVector.this.array[0] = StdVector.this.defaultValue == null ? value : Native.$tryAssign(StdVector.this.array[0], value, StdVector.this.isDataPointerLike());
                return StdVector.this.array[0];
            }

            @Override
            public type$ptr<T> deref$ptr() {
                assert (StdVector.this.checkAlive());
                assert (StdVector.this.checkIndex(0));
                return (type$ptr)StdVector.this.data().$add(0);
            }
        };
    }

    public type$ref<T> ref$back() {
        return new type$ref<T>(){
            private final T stored;
            private final int index;
            {
                assert (StdVector.this.checkAlive());
                assert (StdVector.this.checkIndex(StdVector.this.end - 1));
                this.stored = StdVector.this.array[StdVector.this.end - 1];
                this.index = StdVector.this.end - 1;
            }

            @Override
            public T $deref() {
                assert (StdVector.this.checkAlive());
                assert (StdVector.this.checkIndex(this.index));
                return this.stored;
            }

            @Override
            public T $set(T value) {
                assert (StdVector.this.checkAlive());
                assert (StdVector.this.checkIndex(this.index));
                assert (NativeTrace.assertArrayHasMutableContent(StdVector.this.array, this));
                StdVector.this.array[this.index] = StdVector.this.defaultValue == null ? value : Native.$tryAssign(StdVector.this.array[this.index], value, StdVector.this.isDataPointerLike());
                return StdVector.this.array[this.index];
            }

            @Override
            public type$ptr<T> deref$ptr() {
                assert (StdVector.this.checkAlive());
                assert (StdVector.this.checkIndex(this.index));
                return (type$ptr)StdVector.this.data().$add(this.index);
            }
        };
    }

    @Override
    public int size() {
        assert (this.checkAlive());
        return this.end;
    }

    public int max_size() {
        assert (this.checkAlive());
        return Integer.MAX_VALUE;
    }

    public int capacity() {
        assert (this.checkAlive());
        return this.array.length;
    }

    @Override
    public int $sizeof() {
        int oneElemSize = NativeType.sizeof(this.defaultValue);
        for (T elem : this.array) {
            if (elem == this.defaultValue) continue;
            oneElemSize = NativeType.sizeof(elem);
            break;
        }
        return this.capacity() * oneElemSize;
    }

    public type$ptr<T> ptr$at(int idx) {
        assert (this.checkAlive());
        assert (this.checkIndex(idx));
        return NativePointer.create_type$ptr(this.array, idx);
    }

    @Override
    public std.vector<T> clone() {
        assert (this.checkAlive());
        std.vector out = new std.vector((std.vector)this);
        assert (this.getClass() == out.getClass()) : "forgot to override clone in " + out.getClass();
        return out;
    }

    @Override
    public std.vector<T> move() {
        assert (this.checkAlive());
        std.vector out = new std.vector(JavaDifferentiators.JD.Move.INSTANCE, (std.vector)this);
        assert (this.getClass() == out.getClass()) : "forgot to override move in " + out.getClass();
        return out;
    }

    public void set_size(int N) {
        assert (this.checkAlive());
        assert (N >= 0);
        assert (N <= this.capacity());
        this.setEnd(N);
    }

    private void destroy_range(int from, int to) {
        for (int i = from; i < to; ++i) {
            if (this.defaultValue != null) {
                Native.destroy(this.array[i]);
            }
            this.array[i] = null;
        }
    }

    private void destroy_range(iterator _from, iterator _to) {
        this.destroy_range(_from.$sub(this.begin()), _to.$sub(this.begin()));
    }

    protected void grow(int newSize) {
        this.array = NativePointer.copyOf$Object(this.array, newSize);
    }

    private void grow() {
        this.grow(this.capacity() > 0 ? this.capacity() * 2 : 1);
    }

    private void setEnd(int to) {
        this.end = to;
    }

    private void setEnd(iterator to) {
        this.setEnd(to.$sub(this.begin()));
    }

    @Override
    public Iterator<T> iterator() {
        assert (this.checkAlive());
        return new JavaIterator(this.begin(), this.end());
    }

    public boolean isDataPointerLike() {
        return this.defaultValue == null;
    }

    public String toString() {
        String arrName = NativeTrace.getArrayName(this.array);
        if (this.end == 0) {
            return arrName + (super.is$destroyed() ? "DESTROYED " : "") + "<EMPTY>";
        }
        StringBuilder out = new StringBuilder(arrName);
        if (super.is$destroyed()) {
            out.append("DESTROYED");
        }
        out.append("\n").append(this.getClass().getSimpleName()).append("{\nend = " + this.end + '\n');
        String fmt = "%" + (int)Math.ceil(Math.log10(this.end + 1)) + "d";
        for (int i = 0; i < this.end; ++i) {
            T element = this.array[i];
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append(element).append('\n');
        }
        out.append("}").append(this.getClass().getSimpleName()).append("}\n");
        return out.toString();
    }

    private T $getDefaultVal() {
        if (this.defaultValue != null) {
            T res = this.defaultValue.get();
            assert (res != null) : "If stored type is pointer then pass null as a supplier! Nonnull supplier must provide nonull values.";
            return res;
        }
        return null;
    }

    protected final boolean checkIndex(int index) {
        assert (index < this.end) : "invalid index " + index + " when size is " + this.end;
        return true;
    }

    protected final boolean checkAlive() {
        return this.check$Alive();
    }

    public static final class iterator<T>
    implements type$iterator<iterator<T>, T>,
    Native.assignable<iterator<T>>,
    NativeMoveable<iterator<T>>,
    Native.ComparableLowerGreater {
        private final boolean _const;
        private final StdVector<T> delegate;
        private int index;

        public iterator(StdVector<T> delegate, int index, boolean makeConst) {
            assert (delegate.checkAlive());
            this.delegate = delegate;
            this.index = index;
            this._const = makeConst;
        }

        public iterator(iterator<T> other) {
            assert (other.delegate.checkAlive());
            this.delegate = other.delegate;
            this.index = other.index;
            this._const = other._const;
        }

        public iterator(JavaDifferentiators.JD.Move _dparam, iterator<T> other) {
            assert (other.delegate.checkAlive());
            this.delegate = other.delegate;
            this.index = other.index;
            this._const = other._const;
        }

        @Override
        public iterator<T> $assign(iterator<T> other) {
            assert (this.delegate.checkAlive());
            assert (this.delegate == other.delegate);
            this.index = other.index;
            return this;
        }

        @Override
        public iterator<T> $assignMove(iterator<T> other) {
            assert (this.delegate.checkAlive());
            assert (this.delegate == other.delegate);
            this.index = other.index;
            return this;
        }

        @Override
        public T $arrow() {
            assert (this.delegate.checkAlive());
            return this.$at(0);
        }

        @Override
        public T $star() {
            assert (this.delegate.checkAlive());
            return this.$at(0);
        }

        @Override
        public type$ref<T> star$ref() {
            assert (this.delegate.checkAlive());
            return this.ref$at(0);
        }

        @Override
        public int $sub(iterator<T> iter) {
            assert (this.delegate.checkAlive());
            assert (this.delegate == iter.delegate);
            return this.index - iter.index;
        }

        @Override
        public iterator<T> $preInc() {
            assert (this.delegate.checkAlive());
            assert (!this._const);
            ++this.index;
            return this;
        }

        @Override
        public iterator<T> $preDec() {
            assert (this.delegate.checkAlive());
            assert (!this._const);
            --this.index;
            return this;
        }

        @Override
        public iterator<T> $postInc() {
            assert (this.delegate.checkAlive());
            assert (!this._const);
            iterator<T> cloned = new iterator<T>(this.delegate, this.index, false);
            ++this.index;
            return cloned;
        }

        @Override
        public iterator<T> $postDec() {
            assert (this.delegate.checkAlive());
            assert (!this._const);
            iterator<T> cloned = new iterator<T>(this.delegate, this.index, false);
            --this.index;
            return cloned;
        }

        @Override
        public iterator<T> $inc(int amount) {
            assert (this.delegate.checkAlive());
            assert (!this._const);
            this.index += amount;
            return this;
        }

        @Override
        public iterator<T> $dec(int amount) {
            assert (this.delegate.checkAlive());
            assert (!this._const);
            this.index -= amount;
            return this;
        }

        @Override
        public iterator<T> $add(int amount) {
            assert (this.delegate.checkAlive());
            return new iterator<T>(this.delegate, this.index + amount, false);
        }

        @Override
        public iterator<T> $sub(int amount) {
            assert (this.delegate.checkAlive());
            return new iterator<T>(this.delegate, this.index - amount, false);
        }

        public boolean $noteq(Object other) {
            assert (this.delegate.checkAlive());
            assert (((iterator)other).delegate.checkAlive());
            assert (this.delegate == ((iterator)other).delegate);
            return this.index != ((iterator)other).index;
        }

        public boolean $eq(Object other) {
            assert (this.delegate.checkAlive());
            assert (((iterator)other).delegate.checkAlive());
            assert (this.delegate == ((iterator)other).delegate);
            return this.index == ((iterator)other).index;
        }

        @Override
        public iterator<T> move() {
            assert (this.delegate.checkAlive());
            return new iterator<T>(JavaDifferentiators.JD.Move.INSTANCE, this);
        }

        @Override
        public iterator<T> clone() {
            assert (this.delegate.checkAlive());
            return new iterator<T>(this.delegate, this.index, false);
        }

        @Override
        public iterator<T> const_clone() {
            assert (this.delegate.checkAlive());
            return new iterator<T>(this.delegate, this.index, true);
        }

        @Override
        public boolean $less(Object obj) {
            assert (this.delegate.checkAlive());
            assert (((iterator)obj).delegate.checkAlive());
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index < ((iterator)obj).index;
        }

        @Override
        public boolean $lesseq(Object obj) {
            assert (this.delegate.checkAlive());
            assert (((iterator)obj).delegate.checkAlive());
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index <= ((iterator)obj).index;
        }

        @Override
        public boolean $greater(Object obj) {
            assert (this.delegate.checkAlive());
            assert (((iterator)obj).delegate.checkAlive());
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index > ((iterator)obj).index;
        }

        @Override
        public boolean $greatereq(Object obj) {
            assert (this.delegate.checkAlive());
            assert (((iterator)obj).delegate.checkAlive());
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index >= ((iterator)obj).index;
        }

        public T $at(int index) {
            assert (this.delegate.checkAlive());
            return this.delegate.$at(this.index + index);
        }

        public type$ref<T> ref$at(int index) {
            assert (this.delegate.checkAlive());
            return this.delegate.ref$at(this.index + index);
        }

        public type$ptr<T> toPointer() {
            assert (this.delegate.checkAlive());
            return NativePointer.create_type$ptr(this.delegate.array, this.index);
        }

        public int $index() {
            assert (this.delegate.checkAlive());
            assert (this.delegate.checkIndex(this.index));
            return this.index;
        }

        public String toString() {
            return "[" + (((StdVector)this.delegate).is$destroyed() ? "DESTROYED " : "") + this.index + "] from\n" + this.delegate.toString();
        }
    }
}

