/*
 * Decompiled with CFR 0.152.
 */
package org.clank.java.stdimpl.aliases;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import org.clank.java.impl.AlteredHashMap;
import org.clank.java.impl.CloneableIterator;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.java.std_unordered_map;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.JavaIterator;
import org.clank.support.aliases.type$iterator;
import org.clank.support.aliases.type$ref;
import org.clank.support.type$ptr$inout;

public class StdUnorderedMapTypePtr<K, V>
extends NativeTrace.CreateDestroy.Tracker
implements Iterable<std_pair.pairTypePtr<K, V>>,
Native.NativePOD<std_unordered_map.unordered_mapTypePtr<K, V>>,
Destructors.ClassWithDestructor {
    protected final std.hash<K> HashFun;
    protected final std.binary_functionBoolean<K> EqualFun;
    protected final Supplier<V> valueSupplier;
    protected AlteredHashMap<WrappedKey<K>, std_pair.pairTypePtr<K, V>> javaMap;

    public StdUnorderedMapTypePtr(std.hash<K> HashFun, std.binary_functionBoolean<K> EqualFun, Supplier<V> valueSupplier) {
        this.HashFun = HashFun;
        this.EqualFun = EqualFun;
        this.javaMap = new AlteredHashMap();
        this.valueSupplier = valueSupplier;
    }

    public StdUnorderedMapTypePtr(std_unordered_map.unordered_mapTypePtr<K, V> other) {
        this(other.HashFun, other.EqualFun, other.valueSupplier);
        this.$assign(other);
    }

    public StdUnorderedMapTypePtr(JavaDifferentiators.JD.Move $Param, std_unordered_map.unordered_mapTypePtr<K, V> other) {
        this(other.HashFun, other.EqualFun, other.valueSupplier);
        this.swap(other);
    }

    @Override
    public final std_unordered_map.unordered_mapTypePtr<K, V> $assign(std_unordered_map.unordered_mapTypePtr<K, V> other) {
        assert (this.check$Alive());
        assert (this.HashFun == other.HashFun);
        assert (this.EqualFun == other.EqualFun);
        this.javaMap.clear();
        for (std_pair.pairTypePtr<K, V> val : other) {
            this.javaMap.put(new WrappedKey<Object>(this.$this(), this.$cloneKeyIfNeed(val.first)), Native.$Clone(val));
        }
        return this.$this();
    }

    public final iterator<K, V> begin() {
        assert (this.check$Alive());
        return new iterator((std_unordered_map.unordered_mapTypePtr)this.$this());
    }

    public final iterator<K, V> begin$Const() {
        return this.begin();
    }

    public final iterator<K, V> end() {
        assert (this.check$Alive());
        return new iterator(JavaDifferentiators.JD.Misc.INSTANCE, this.$this());
    }

    public final iterator<K, V> end$Const() {
        return this.end();
    }

    public final boolean empty() {
        assert (this.check$Alive());
        return this.javaMap.isEmpty();
    }

    public final int size() {
        assert (this.check$Alive());
        return this.javaMap.size();
    }

    public final void clear() {
        assert (this.check$Alive());
        if (!this.isKeyPointerLike() || !this.isDataPointerLike()) {
            for (Map.Entry<WrappedKey<K>, std_pair.pairTypePtr<K, V>> entry : this.javaMap.entrySet()) {
                if (!this.isKeyPointerLike()) {
                    Native.destroy(entry.getKey());
                }
                Native.destroy(entry.getValue());
            }
        }
        this.javaMap.clear();
    }

    public final std_pair.pairTypeBool<iterator<K, V>> insert(std_pair.pairTypePtr<K, V> value) {
        assert (this.check$Alive());
        WrappedKey<Object> keyToSearch = new WrappedKey<Object>(this.$this(), value.first);
        Map.Entry<WrappedKey<K>, std_pair.pairTypePtr<K, V>> existing = this.javaMap.getNode(keyToSearch);
        if (existing != null) {
            return std.make_pair_T_bool(new iterator(this.$this(), existing), false);
        }
        WrappedKey<Object> keyToInsert = new WrappedKey<Object>(this.$this(), this.$cloneKeyIfNeed(value.first));
        this.javaMap.put(keyToInsert, Native.$Clone(value));
        existing = this.javaMap.getNode(keyToInsert);
        return std.make_pair_T_bool(new iterator(this.$this(), existing), true);
    }

    public final std_pair.pairTypeBool<iterator<K, V>> insert$T(std_pair.pairTypePtr<K, V> value) {
        assert (this.check$Alive());
        return this.insert(value);
    }

    public final std_pair.pairTypeBool<iterator<K, V>> insert$T$RR(std_pair.pairTypePtr<K, V> value) {
        assert (this.check$Alive());
        WrappedKey<Object> keyToSearch = new WrappedKey<Object>(this.$this(), value.first);
        Map.Entry<WrappedKey<K>, std_pair.pairTypePtr<K, V>> existing = this.javaMap.getNode(keyToSearch);
        if (existing != null) {
            return std.make_pair_T_bool(new iterator(this.$this(), existing), false);
        }
        WrappedKey<Object> keyToInsert = new WrappedKey<Object>(this.$this(), this.$cloneKeyIfNeed(value.first));
        this.javaMap.put(keyToInsert, Native.$Move(value));
        existing = this.javaMap.getNode(keyToInsert);
        return std.make_pair_T_bool(new iterator(this.$this(), existing), true);
    }

    public final std_pair.pairTypeBool<iterator<K, V>> emplace(std_pair.pairTypePtr<K, V> value) {
        assert (this.check$Alive());
        WrappedKey<Object> keyToSearch = new WrappedKey<Object>(this.$this(), value.first);
        Map.Entry<WrappedKey<K>, std_pair.pairTypePtr<K, V>> existing = this.javaMap.getNode(keyToSearch);
        if (existing != null) {
            return std.make_pair_T_bool(new iterator(this.$this(), existing), false);
        }
        WrappedKey<Object> keyToInsert = new WrappedKey<Object>(this.$this(), this.$cloneKeyIfNeed(value.first));
        this.javaMap.put(keyToInsert, value);
        existing = this.javaMap.getNode(keyToInsert);
        return std.make_pair_T_bool(new iterator(this.$this(), existing), true);
    }

    public int erase(K key) {
        assert (this.check$Alive());
        iterator<K, V> pos = this.find(key);
        if (pos.$noteq(this.end())) {
            this.erase(pos);
            return 1;
        }
        return 0;
    }

    public iterator<K, V> erase(iterator<K, V> pos) {
        assert (this.check$Alive());
        Native.destroy((Destructors.ClassWithDestructor)pos.$star());
        return ((iterator)pos).remove();
    }

    public final iterator<K, V> find(K key) {
        assert (this.check$Alive());
        WrappedKey<K> keyToSearch = new WrappedKey<K>(this.$this(), key);
        Map.Entry<WrappedKey<K>, std_pair.pairTypePtr<K, V>> existing = this.javaMap.getNode(keyToSearch);
        if (existing != null) {
            return new iterator(this.$this(), existing);
        }
        return this.end();
    }

    public final iterator<K, V> find$Const(K key) {
        return this.find(key);
    }

    public final boolean count(K key) {
        return this.find(key).$noteq(this.end());
    }

    public final void swap(std_unordered_map.unordered_mapTypePtr<K, V> other) {
        assert (this.check$Alive());
        assert (this.HashFun == other.HashFun);
        assert (this.EqualFun == other.EqualFun);
        AlteredHashMap<WrappedKey<K>, std_pair.pairTypePtr<K, V>> tmp = this.javaMap;
        this.javaMap = other.javaMap;
        other.javaMap = tmp;
    }

    public V at(K key) {
        assert (this.check$Alive());
        return this.$at(key);
    }

    public V $at_T$C$R(K key) {
        assert (this.check$Alive());
        return this.$at(key);
    }

    public V $at_T$RR(K key) {
        assert (this.check$Alive());
        return this.$at(key);
    }

    public V $at(K key) {
        assert (this.check$Alive());
        std_pair.pairTypePtr<K, V> out = this.javaMap.get(new WrappedKey<K>(this.$this(), key));
        if (out == null) {
            out = std.make_pair_T_Ptr(this.$cloneKeyIfNeed(key), this.valueSupplier.get());
            this.javaMap.put(new WrappedKey<K>(this.$this(), this.$cloneKeyIfNeed(key)), out);
        }
        return (V)out.second;
    }

    public type$ref<V> ref$at(K key) {
        assert (this.check$Alive());
        final WrappedKey<K> wrappedKey = new WrappedKey<K>(this.$this(), this.$cloneKeyIfNeed(key));
        if (!this.javaMap.containsKey(wrappedKey)) {
            this.javaMap.put(wrappedKey, std.make_pair_T_Ptr(this.$cloneKeyIfNeed(key), this.valueSupplier.get()));
        }
        return new type$ptr$inout<V>(){

            @Override
            protected V $star$impl() {
                assert (StdUnorderedMapTypePtr.this.check$Alive());
                return StdUnorderedMapTypePtr.this.javaMap.get((Object)wrappedKey).second;
            }

            @Override
            protected V $set$impl(V value) {
                assert (StdUnorderedMapTypePtr.this.check$Alive());
                StdUnorderedMapTypePtr.this.javaMap.get((Object)wrappedKey).second = Native.$tryAssign(StdUnorderedMapTypePtr.this.javaMap.get((Object)wrappedKey).second, value, StdUnorderedMapTypePtr.this.isDataPointerLike());
                return value;
            }
        };
    }

    public final V $set(K key, V value) {
        return this.ref$at(key).$set(value);
    }

    public final int bucket_count() {
        return this.javaMap.bucketsNumber();
    }

    public final int bucket(K key) {
        return this.javaMap.bucketForKey(new WrappedKey<K>(this.$this(), key));
    }

    @Override
    public final Iterator<std_pair.pairTypePtr<K, V>> iterator() {
        assert (this.check$Alive());
        return new JavaIterator<std_pair.pairTypePtr<K, V>>(this.begin(), this.end());
    }

    @Override
    public std_unordered_map.unordered_mapTypePtr<K, V> clone() {
        assert (this.check$Alive());
        return new std_unordered_map.unordered_mapTypePtr<K, V>(this.$this());
    }

    @Override
    public void $destroy() {
        assert (this.check$Alive());
        this.clear();
        super.set$destroyed();
    }

    private final boolean isKeyPointerLike() {
        return false;
    }

    private final K $cloneKeyIfNeed(K Key) {
        return this.isKeyPointerLike() ? Key : Native.$tryClone(Key);
    }

    private final boolean isDataPointerLike() {
        return true;
    }

    private final V $cloneValIfNeed(V Val) {
        return this.isDataPointerLike() ? Val : Native.$tryClone(Val);
    }

    private final std_unordered_map.unordered_mapTypePtr<K, V> $this() {
        return (std_unordered_map.unordered_mapTypePtr)this;
    }

    private static final class WrappedKey<K> {
        private final std_unordered_map.unordered_mapTypePtr<K, ?> map;
        private final K key;

        public WrappedKey(std_unordered_map.unordered_mapTypePtr<K, ?> map, K key) {
            this.map = map;
            this.key = key;
        }

        public int hashCode() {
            return this.map.HashFun.$call(this.key);
        }

        public boolean equals(Object obj) {
            WrappedKey other = (WrappedKey)obj;
            return this.map.EqualFun.$call(this.key, other.key);
        }
    }

    public static final class iterator<K, V>
    implements type$iterator<iterator<K, V>, std_pair.pairTypePtr<K, V>> {
        private final std_unordered_map.unordered_mapTypePtr<K, V> map;
        private final CloneableIterator<Map.Entry<WrappedKey<K>, std_pair.pairTypePtr<K, V>>> delegate;
        private Map.Entry<WrappedKey<K>, std_pair.pairTypePtr<K, V>> currentEntry;

        private iterator(std_unordered_map.unordered_mapTypePtr<K, V> map) {
            this.map = map;
            this.delegate = map.javaMap.entrySetIterator();
            this.currentEntry = this.computeNext();
        }

        private iterator(std_unordered_map.unordered_mapTypePtr<K, V> map, Map.Entry<WrappedKey<K>, std_pair.pairTypePtr<K, V>> entry) {
            this.map = map;
            this.delegate = map.javaMap.entrySetIterator(entry);
            this.currentEntry = entry;
        }

        private iterator(JavaDifferentiators.JD.Misc end, std_unordered_map.unordered_mapTypePtr<K, V> map) {
            this.map = map;
            this.delegate = null;
            this.currentEntry = null;
        }

        public iterator(iterator<K, V> other) {
            this.map = other.map;
            this.delegate = CloneableIterator.clone(other.delegate);
            this.currentEntry = other.currentEntry;
        }

        @Override
        public std_pair.pairTypePtr<K, V> $star() {
            return this.currentEntry.getValue();
        }

        @Override
        public iterator<K, V> $preInc() {
            if (this.currentEntry == null) {
                throw new NoSuchElementException();
            }
            this.currentEntry = this.computeNext();
            return this;
        }

        public boolean $eq(Object other) {
            iterator otherIter = (iterator)other;
            return this.map == otherIter.map && this.currentEntry == otherIter.currentEntry;
        }

        public boolean $noteq(Object other) {
            return !this.$eq(other);
        }

        @Override
        public iterator<K, V> clone() {
            return new iterator<K, V>(this);
        }

        private final iterator<K, V> remove() {
            this.delegate.remove();
            return ((iterator)this.clone()).$preInc();
        }

        private final Map.Entry<WrappedKey<K>, std_pair.pairTypePtr<K, V>> computeNext() {
            if (this.delegate.hasNext()) {
                return (Map.Entry)this.delegate.next();
            }
            return null;
        }
    }
}

