/*
 * Decompiled with CFR 0.152.
 */
package org.clank.java.stdimpl.aliases;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.clank.java.std;
import org.clank.java.std_map;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.JavaIterator;
import org.clank.support.aliases.type$iterator;
import org.clank.support.aliases.type$ptr;
import org.clank.support.aliases.type$ref;

public abstract class StdMapUIntPtr<ValueT>
extends NativeTrace.CreateDestroy.Tracker
implements Native.NativePOD<std_map.mapUIntPtr<ValueT>>,
Iterable<std_pair.pairUIntPtr<ValueT>>,
Destructors.ClassWithDestructor {
    protected ValueT defaultValue;
    protected TreeMap<Integer, std_pair.pairUIntPtr<ValueT>> treeMap;

    protected StdMapUIntPtr(ValueT defaultValue) {
        this(null, defaultValue);
    }

    protected StdMapUIntPtr(Comparator<Integer> comparator, ValueT defaultValue) {
        if (comparator == null) {
            comparator = Native::$compare_type_uint;
        }
        this.treeMap = new TreeMap(comparator);
        assert (defaultValue == null) : "non cloneable class for defaultValue " + NativeTrace.getIdentityStr(defaultValue);
        this.defaultValue = defaultValue;
    }

    protected StdMapUIntPtr(std_map.mapUIntPtr<ValueT> other) {
        this(other.treeMap.comparator(), other.defaultValue);
        this.$assign(other);
    }

    protected StdMapUIntPtr(JavaDifferentiators.JD.Move _dparam, std_map.mapUIntPtr<ValueT> other) {
        this(other.treeMap.comparator(), other.defaultValue);
        this.$assign(other);
        other.$destroy();
        other.treeMap = null;
    }

    public Comparator<? super Integer> keyComparator() {
        return this.treeMap.comparator();
    }

    @Override
    public std_map.mapUIntPtr<ValueT> $assign(std_map.mapUIntPtr<ValueT> other) {
        assert (other.checkAlive());
        assert (this.checkAlive());
        this.clear();
        for (Map.Entry entry : other.treeMap.entrySet()) {
            this.treeMap.put(this.$cloneKeyIfNeed((Integer)entry.getKey()), Native.$Clone((std_pair.pairUIntPtr)entry.getValue()));
        }
        return (std_map.mapUIntPtr)this;
    }

    public void swap(std_map.mapUIntPtr<ValueT> other) {
        assert (other.checkAlive());
        assert (this.checkAlive());
        TreeMap<Integer, std_pair.pairUIntPtr<ValueT>> tmpMap = this.treeMap;
        this.treeMap = other.treeMap;
        other.treeMap = tmpMap;
        ValueT tmpDefVal = this.defaultValue;
        this.defaultValue = other.defaultValue;
        other.defaultValue = tmpDefVal;
    }

    public ValueT $at_T$C$R(Integer key) {
        assert (this.checkAlive());
        return this.$at(key);
    }

    public ValueT $at_T$RR(Integer key) {
        assert (this.checkAlive());
        return this.$at(key);
    }

    public ValueT $at(Integer key) {
        assert (this.checkAlive());
        std_pair.pairUIntPtr<ValueT> out = this.treeMap.get(key);
        if (out == null) {
            out = std.make_pair_uint_Ptr(this.$cloneKeyIfNeed(key), this.$cloneValIfNeed(this.defaultValue));
            this.treeMap.put(this.$cloneKeyIfNeed(key), out);
        }
        return (ValueT)out.second;
    }

    public void $set(Integer key, ValueT val) {
        assert (this.checkAlive());
        this.treeMap.put(this.$cloneKeyIfNeed(key), std.make_pair_uint_Ptr(this.$cloneKeyIfNeed(key), this.$cloneValIfNeed(val)));
    }

    public type$ref<ValueT> ref$at(final Integer key) {
        assert (this.checkAlive());
        if (!this.treeMap.containsKey(key)) {
            this.treeMap.put(this.$cloneKeyIfNeed(key), std.make_pair_uint_Ptr(this.$cloneKeyIfNeed(key), this.$cloneValIfNeed(this.defaultValue)));
        }
        return new type$ref<ValueT>(){

            @Override
            public ValueT $deref() {
                assert (StdMapUIntPtr.this.checkAlive());
                return StdMapUIntPtr.this.treeMap.get((Object)key).second;
            }

            @Override
            public ValueT $set(ValueT value) {
                assert (StdMapUIntPtr.this.checkAlive());
                StdMapUIntPtr.this.treeMap.get((Object)key).second = Native.$tryAssign(StdMapUIntPtr.this.treeMap.get((Object)key).second, value, StdMapUIntPtr.this.isDataPointerLike());
                return value;
            }

            @Override
            public type$ptr<ValueT> deref$ptr() {
                assert (StdMapUIntPtr.this.checkAlive());
                throw new UnsupportedOperationException("Not supported.");
            }
        };
    }

    public int size() {
        assert (this.checkAlive());
        return this.treeMap.size();
    }

    public boolean empty() {
        assert (this.checkAlive());
        return this.treeMap.isEmpty();
    }

    public void clear() {
        assert (this.checkAlive());
        if (!this.isKeyPointerLike() || !this.isDataPointerLike()) {
            for (Map.Entry<Integer, std_pair.pairUIntPtr<ValueT>> entry : this.treeMap.entrySet()) {
                if (!this.isKeyPointerLike()) {
                    Native.destroy(entry.getKey());
                }
                Native.destroy(entry.getValue());
            }
        }
        this.treeMap.clear();
    }

    public std_pair.pairTypeBool<iterator<ValueT>> insert$T$RR(std_pair.pairUIntPtr<ValueT> val) {
        assert (this.checkAlive());
        Integer Key = this.$cloneKeyIfNeed(val.first);
        boolean newElement = !this.treeMap.containsKey(Key);
        this.treeMap.put(Key, Native.$Move(val));
        return std.make_pair_Ptr_bool(this.find(Key), newElement);
    }

    public final std_pair.pairTypeBool<iterator<ValueT>> insert$T(std_pair.pairUIntPtr<ValueT> val) {
        assert (this.checkAlive());
        return this.insert(val);
    }

    public std_pair.pairTypeBool<iterator<ValueT>> insert(std_pair.pairUIntPtr<ValueT> val) {
        assert (this.checkAlive());
        boolean newElement = !this.treeMap.containsKey(val.first);
        this.treeMap.put(this.$cloneKeyIfNeed(val.first), Native.$Clone(val));
        return std.make_pair_Ptr_bool(this.find(val.first), newElement);
    }

    public void insert(type$iterator<?, std_pair.pairUIntPtr<ValueT>> I, type$iterator<?, std_pair.pairUIntPtr<ValueT>> E) {
        assert (this.checkAlive());
        while (Native.$noteq_iter(I, E)) {
            std_pair.pairUIntPtr<ValueT> val = I.$star();
            this.treeMap.put(this.$cloneKeyIfNeed(val.first), Native.$Clone(val));
            I.$preInc();
        }
    }

    public void erase(iterator<ValueT> position) {
        assert (this.checkAlive());
        Native.destroy((Destructors.ClassWithDestructor)position.$star());
        ((iterator)position).erase();
    }

    public boolean erase(Integer key) {
        assert (this.checkAlive());
        if (!this.treeMap.containsKey(key)) {
            return false;
        }
        Map.Entry<Integer, std_pair.pairUIntPtr<ValueT>> entry = this.treeMap.ceilingEntry(key);
        if (!this.isKeyPointerLike()) {
            Native.destroy(entry.getKey());
        }
        Native.destroy(entry.getValue());
        this.treeMap.remove(key);
        return true;
    }

    public iterator<ValueT> lower_bound(Integer key) {
        assert (this.checkAlive());
        Integer lowerBoundKey = this.treeMap.ceilingKey(key);
        return lowerBoundKey != null ? this.find(lowerBoundKey) : this.end();
    }

    public iterator<ValueT> upper_bound(Integer key) {
        assert (this.checkAlive());
        Integer upperBoundKey = this.treeMap.higherKey(key);
        return upperBoundKey != null ? this.find(upperBoundKey) : this.end();
    }

    public iterator<ValueT> begin$Const() {
        assert (this.checkAlive());
        return new iterator(this.treeMap, this.treeMap.firstEntry(), this.defaultValue, true);
    }

    public iterator<ValueT> end$Const() {
        assert (this.checkAlive());
        return new iterator(this.treeMap, null, this.defaultValue, true);
    }

    public iterator<ValueT> begin() {
        assert (this.checkAlive());
        return new iterator(this.treeMap, this.treeMap.firstEntry(), this.defaultValue, false);
    }

    public iterator<ValueT> end() {
        assert (this.checkAlive());
        return new iterator(this.treeMap, null, this.defaultValue, false);
    }

    @Override
    public Iterator<std_pair.pairUIntPtr<ValueT>> iterator() {
        assert (this.checkAlive());
        return new JavaIterator<std_pair.pairUIntPtr<ValueT>>(this.begin(), this.end());
    }

    public boolean count(Integer key) {
        assert (this.checkAlive());
        return this.treeMap.containsKey(key);
    }

    public boolean replaceValueReference(Integer key, ValueT val) {
        assert (this.checkAlive());
        std_pair.pairUIntPtr<ValueT> entry = this.treeMap.get(key);
        assert (entry != null) : "must be called only for existing entry " + key + " => " + val;
        entry.second = val;
        return true;
    }

    public final iterator<ValueT> find$Const(Integer key) {
        assert (this.checkAlive());
        return this.find(key);
    }

    public iterator<ValueT> find(Integer key) {
        assert (this.checkAlive());
        if (!this.treeMap.containsKey(key)) {
            return this.end();
        }
        return new iterator(this.treeMap, this.treeMap.ceilingEntry(key), this.defaultValue, false);
    }

    @Override
    public boolean $eq(std_map.mapUIntPtr<ValueT> other) {
        if (this.size() != other.size()) {
            return false;
        }
        return std.equal(this.begin(), this.end(), other.begin(), false);
    }

    @Override
    public std_map.mapUIntPtr<ValueT> clone() {
        assert (this.checkAlive());
        std_map.mapUIntPtr out = new std_map.mapUIntPtr((std_map.mapUIntPtr)this);
        assert (this.getClass() == out.getClass()) : "forgot to override clone in " + out.getClass();
        return out;
    }

    @Override
    public void $destroy() {
        assert (this.checkAlive());
        this.clear();
        super.set$destroyed();
    }

    private boolean isKeyPointerLike() {
        return false;
    }

    private Integer $cloneKeyIfNeed(Integer Key) {
        return this.isKeyPointerLike() ? Key : Native.$tryClone(Key);
    }

    private boolean isDataPointerLike() {
        return true;
    }

    private ValueT $cloneValIfNeed(ValueT Val) {
        return this.isDataPointerLike() ? Val : Native.$tryClone(Val);
    }

    public String toString() {
        return "StdMapUIntPtr " + (super.is$destroyed() ? "DESTROYED" : "") + "{" + this.treeMap + "}";
    }

    protected final boolean checkAlive() {
        return this.check$Alive();
    }

    public static class iterator<ValueT>
    implements type$iterator<iterator<ValueT>, std_pair.pairUIntPtr<ValueT>> {
        private final ValueT defaultValue;
        private final TreeMap<Integer, std_pair.pairUIntPtr<ValueT>> map;
        private final boolean _const;
        private Map.Entry<Integer, std_pair.pairUIntPtr<ValueT>> currentEntry;

        public iterator(iterator<ValueT> other) {
            this.defaultValue = Native.$tryClone(other.defaultValue);
            this.map = Native.$tryClone(other.map);
            this.currentEntry = Native.$tryClone(other.currentEntry);
            this._const = other._const;
        }

        public iterator(JavaDifferentiators.JD.Move _dparam, iterator<ValueT> other) {
            this.defaultValue = other.defaultValue;
            this.map = other.map;
            this.currentEntry = other.currentEntry;
            this._const = other._const;
        }

        private iterator(TreeMap<Integer, std_pair.pairUIntPtr<ValueT>> map, Map.Entry<Integer, std_pair.pairUIntPtr<ValueT>> curr, ValueT defaultValue, boolean asConst) {
            this.defaultValue = defaultValue;
            this.map = map;
            this.currentEntry = curr;
            this._const = asConst;
        }

        private Integer getKey() {
            return this.currentEntry.getKey();
        }

        private void erase() {
            this.map.remove(this.currentEntry.getKey());
        }

        @Override
        public std_pair.pairUIntPtr<ValueT> $arrow() {
            return this.currentEntry.getValue();
        }

        @Override
        public std_pair.pairUIntPtr<ValueT> $star() {
            return this.currentEntry.getValue();
        }

        @Override
        public type$ref<std_pair.pairUIntPtr<ValueT>> star$ref() {
            return new type$ref<std_pair.pairUIntPtr<ValueT>>(){
                private final Map.Entry<Integer, std_pair.pairUIntPtr<ValueT>> localEntry;
                {
                    this.localEntry = currentEntry;
                }

                @Override
                public std_pair.pairUIntPtr<ValueT> $deref() {
                    return this.localEntry.getValue();
                }

                @Override
                public std_pair.pairUIntPtr<ValueT> $set(std_pair.pairUIntPtr<ValueT> value) {
                    assert (map.comparator().compare(value.first, this.localEntry.getKey()) == 0) : "Trying to change key of entry via iterator!";
                    this.localEntry.getValue().second = Native.$tryAssign(this.localEntry.getValue().second, value.second, this.isDataPointerLike());
                    return value;
                }

                @Override
                public type$ptr<std_pair.pairUIntPtr<ValueT>> deref$ptr() {
                    throw new UnsupportedOperationException("Not supported.");
                }
            };
        }

        @Override
        public iterator<ValueT> $preInc() {
            this.currentEntry = this.map.higherEntry(this.currentEntry.getKey());
            return this;
        }

        @Override
        public iterator<ValueT> $postInc() {
            iterator cloned = Native.$Clone(this);
            this.$preInc();
            return cloned;
        }

        @Override
        public iterator<ValueT> clone() {
            return new iterator<ValueT>(this.map, this.currentEntry, this.defaultValue, false);
        }

        @Override
        public iterator<ValueT> const_clone() {
            return new iterator<ValueT>(this.map, this.currentEntry, this.defaultValue, true);
        }

        public boolean $eq(Object other) {
            if (other instanceof iterator) {
                iterator otherIter = (iterator)other;
                if (otherIter.map == this.map) {
                    if (otherIter.currentEntry == null) {
                        return this.currentEntry == null;
                    }
                    if (this.currentEntry == null) {
                        return otherIter.currentEntry == null;
                    }
                    return Native.$eq(otherIter.currentEntry.getKey(), this.currentEntry.getKey());
                }
            }
            return false;
        }

        public boolean $noteq(Object other) {
            return !this.$eq(other);
        }

        @Override
        public int $sub(iterator<ValueT> iter) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public iterator<ValueT> $preDec() {
            this.currentEntry = this.currentEntry == null ? this.map.lastEntry() : this.map.lowerEntry(this.currentEntry.getKey());
            return this;
        }

        @Override
        public iterator<ValueT> $postDec() {
            iterator cloned = Native.$Clone(this);
            this.$preDec();
            return cloned;
        }

        @Override
        public iterator<ValueT> $inc(int amount) {
            if (amount == 0) {
                return this;
            }
            if (amount > 0) {
                do {
                    this.$preInc();
                } while (--amount > 0);
                return this;
            }
            return this.$dec(-amount);
        }

        @Override
        public iterator<ValueT> $dec(int amount) {
            if (amount == 0) {
                return this;
            }
            if (amount > 0) {
                do {
                    this.$preDec();
                } while (--amount > 0);
                return this;
            }
            return this.$inc(-amount);
        }

        @Override
        public iterator<ValueT> $add(int amount) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public iterator<ValueT> $sub(int amount) {
            throw new UnsupportedOperationException("Not supported.");
        }

        private boolean isDataPointerLike() {
            return true;
        }
    }
}

