/*
 * Decompiled with CFR 0.152.
 */
package org.clank.java.stdimpl;

import org.clank.java.std;
import org.clank.java.stdimpl.aliases.StdVectorChar;
import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativeMoveable;
import org.clank.support.NativePointer;
import org.clank.support.NativeSwappable;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.char$iterator;
import org.clank.support.aliases.char$ptr;
import org.clank.support.aliases.ulong$ptr;

public abstract class StdString
implements Native.NativeComparable,
Native.ComparableLowerGreater,
Comparable<std.string>,
NativeSwappable,
NativeMoveable<std.string>,
Native.OpCapable,
NativeCloneable<std.string>,
Native.assignable<std.string>,
Destructors.ClassWithDestructor {
    public static int npos = Integer.MAX_VALUE;
    public static final byte TERM = 0;
    private static final byte[] TERM_ARRAY = new byte[]{0};
    public static final std.string EMPTY;
    protected std.vectorChar array;
    private final boolean _const;

    protected StdString() {
        this.array = new std.vectorChar(TERM_ARRAY, 1);
        this._const = false;
    }

    protected StdString(byte[] ar) {
        this.array = new std.vectorChar(ar, std.strlen(ar));
        this._const = false;
        this._postModUpdate();
    }

    protected StdString(char$iterator<?> data, int length) {
        this.array = new std.vectorChar(data, length);
        this._const = false;
        this._postModUpdate();
    }

    protected StdString(int __n, char __c) {
        this.array = new std.vectorChar(__n, (byte)__c);
        this._const = false;
        this._postModUpdate();
    }

    protected StdString(int __n, byte __c) {
        this.array = new std.vectorChar(__n, __c);
        this._const = false;
        this._postModUpdate();
    }

    protected StdString(CharSequence value) {
        this.array = new std.vectorChar();
        this.array.reserve(value.length() + 1);
        for (int i = 0; i < value.length(); ++i) {
            this.array.append(1, (byte)value.charAt(i));
        }
        this._const = false;
        this._postModUpdate();
    }

    protected StdString(std.string other) {
        this.array = Native.$tryClone(other.array);
        this._const = false;
    }

    protected StdString(JavaDifferentiators.JD.Move _dparam, std.string other) {
        std.vectorChar tmp = this.array;
        this.array = other.array;
        other.array = tmp;
        this._const = false;
    }

    protected StdString(char$ptr value) {
        this(value, std.strlen(value));
    }

    protected StdString(char$ptr value, int length) {
        this(value, 0, length);
    }

    protected StdString(char$iterator<?> begin, char$iterator<?> end) {
        this(begin, end.$sub(begin));
    }

    protected StdString(char$ptr from, int StartIdx, int length) {
        this(from, StartIdx, length, false);
    }

    protected StdString(char$ptr from, int StartIdx, int length, boolean _const) {
        byte[] ar;
        if (length == 0) {
            assert (TERM_ARRAY != null) : "TERM_ARRAY is not yet initialized?";
            ar = TERM_ARRAY;
        } else {
            ar = NativePointer.new$char(length + 1, new byte[0]);
            int i = 0;
            while (i < length) {
                ar[i++] = from.$at(StartIdx++);
            }
            ar[length] = 0;
        }
        this.array = new std.vectorChar(ar, length + 1);
        this._const = _const;
    }

    protected StdString(byte[] from, int StartIdx, int length, boolean _const) {
        byte[] ar;
        if (length == 0) {
            assert (TERM_ARRAY != null) : "TERM_ARRAY is not yet initialized?";
            ar = TERM_ARRAY;
        } else {
            ar = NativePointer.new$char(length + 1, new byte[0]);
            System.arraycopy(from, StartIdx, ar, 0, length);
            ar[length] = 0;
        }
        this.array = new std.vectorChar(ar, length + 1);
        this._const = _const;
    }

    public std.string assign(std.string other) {
        assert (!this._isConst()) : "This string cannot be modified!";
        this.array.$assign(other.array);
        return (std.string)this;
    }

    @Override
    public std.string $assign(std.string other) {
        return this.assign(other);
    }

    @Override
    public std.string $assign(CharSequence other) {
        assert (!this._isConst()) : "This string cannot be modified!";
        this.$assign(new std.string(other));
        return (std.string)this;
    }

    @Override
    public std.string $assign(char$ptr value) {
        assert (!this._isConst()) : "This string cannot be modified!";
        this.$assign(new std.string(value));
        return (std.string)this;
    }

    public final std.string $assign_T$C$P(char$ptr value) {
        return this.$assign(value);
    }

    public final std.string $assign_T$C$P(CharSequence value) {
        return this.$assign(value);
    }

    public final std.string assign$T(ulong$ptr begin, ulong$ptr end) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    @Override
    public void swap(NativeSwappable RHS) {
        this.swap((std.string)RHS);
    }

    public void swap(std.string str) {
        assert (this != str);
        assert (!this._const);
        assert (!str._const);
        assert (this.array != str.array);
        std.vectorChar other = this.array;
        this.array = str.array;
        str.array = other;
    }

    public char$ptr c_str() {
        return this.array.data();
    }

    public char$ptr data() {
        return this.array.data();
    }

    public char$ptr begin() {
        return this.array.data();
    }

    public char$ptr begin$Const() {
        return this.array.data();
    }

    public char$ptr end() {
        return (char$ptr)this.begin().$add(this.length());
    }

    public char$ptr end$Const() {
        return (char$ptr)this.begin().$add(this.length());
    }

    public std.reverse_iteratorChar rbegin() {
        return new std.reverse_iteratorChar(this.end());
    }

    public std.reverse_iteratorChar rbegin$Const() {
        return new std.reverse_iteratorChar(this.end());
    }

    public std.reverse_iteratorChar rend() {
        return new std.reverse_iteratorChar(this.begin());
    }

    public std.reverse_iteratorChar rend$Const() {
        return new std.reverse_iteratorChar(this.begin());
    }

    @Override
    public void $destroy() {
    }

    public void reserve(int size) {
        this.array.reserve(size + 1);
        this._postModUpdate();
    }

    public void resize(int size) {
        this.resize(size, (byte)0);
    }

    public void resize(int size, char defaultValue) {
        this.resize(size, NativePointer.$(defaultValue));
    }

    public void resize(int size, byte defaultValue) {
        assert (this.array.size() > 0);
        this.array.pop_back();
        this.array.resize(size + 1, defaultValue);
        this.array.$set(size, (byte)0);
        assert (this.size() == size);
    }

    public int size() {
        return this.length();
    }

    public int max_size() {
        return Integer.MAX_VALUE;
    }

    public int length() {
        return this.array.size() - 1;
    }

    public int capacity() {
        return this.array.capacity() - 1;
    }

    public boolean empty() {
        assert (this.length() >= 0);
        return this.length() == 0;
    }

    public std.string assign(int __n, byte __c) {
        assert (!this._isConst()) : "This string cannot be modified!";
        return this._M_replace_aux(0, this.size(), __n, __c);
    }

    public std.string assign(char$ptr begin, char$ptr end) {
        assert (!this._isConst()) : "This string cannot be modified!";
        this.$assign(new std.string(begin, end));
        return (std.string)this;
    }

    public std.string assign(char$ptr __s, int __n) {
        assert (!this._isConst()) : "This string cannot be modified!";
        this.$assign(new std.string(__s, (char$iterator)__s.$add(__n)));
        return (std.string)this;
    }

    public std.string assign(char$ptr __s) {
        assert (!this._isConst()) : "This string cannot be modified!";
        this.$assign(new std.string(__s));
        return (std.string)this;
    }

    public std.string assign$T(char$iterator begin, char$iterator end) {
        assert (!this._isConst()) : "This string cannot be modified!";
        this.$assign(new std.string(begin, end));
        return (std.string)this;
    }

    public char$ptr erase(char$ptr __position) {
        assert (!this._isConst()) : "This string cannot be modified!";
        return this.erase(this.convertPtrToIter(__position)).star$ref().deref$ptr();
    }

    public char$ptr erase(char$ptr __first, char$ptr __last) {
        assert (!this._isConst()) : "This string cannot be modified!";
        return this.erase(this.convertPtrToIter(__first), this.convertPtrToIter(__last)).star$ref().deref$ptr();
    }

    public std.string erase() {
        assert (!this._isConst()) : "This string cannot be modified!";
        return this.erase(0, npos);
    }

    public std.string erase(int __pos) {
        assert (!this._isConst()) : "This string cannot be modified!";
        return this.erase(__pos, npos);
    }

    public std.string erase(int __pos, int __n) {
        assert (!this._isConst()) : "This string cannot be modified!";
        StdVectorChar.iterator first = this.array.begin().$add(__pos);
        StdVectorChar.iterator last = __n != npos ? first.$add(__n) : this.array.end();
        this.erase(first, last);
        return (std.string)this;
    }

    public char$ptr insert(char$ptr __p, char __c) {
        assert (!this._isConst()) : "This string cannot be modified!";
        char$ptr result = this.array.insert(this.convertPtrToIter(__p), (byte)__c).star$ref().deref$ptr();
        this._postModUpdate();
        return result;
    }

    public char$ptr insert(char$ptr __p, char$iterator<?> __k1, char$iterator<?> __k2) {
        assert (!this._isConst()) : "This string cannot be modified!";
        char$ptr result = this.array.insert(this.convertPtrToIter(__p), __k1, __k2).star$ref().deref$ptr();
        this._postModUpdate();
        return result;
    }

    public std.string append(char$iterator<?> __first, char$iterator<?> __last) {
        assert (!this._isConst()) : "This string cannot be modified!";
        char$ptr _M_iend = this._M_iend();
        return this.replace(_M_iend, _M_iend, __first, 0, __last.$sub(__first));
    }

    public std.string append(char$iterator<?> __first, int Size) {
        std.string string2;
        assert (!this._isConst()) : "This string cannot be modified!";
        if (Size == 0) {
            string2 = (std.string)this;
        } else {
            char$ptr _M_iend = this._M_iend();
            string2 = this.replace(_M_iend, _M_iend, __first, 0, Size);
        }
        return string2;
    }

    public std.string append(char$ptr __first, int __firstStartIdx, int Size) {
        std.string string2;
        assert (!this._isConst()) : "This string cannot be modified!";
        if (Size == 0) {
            string2 = (std.string)this;
        } else {
            char$ptr _M_iend = this._M_iend();
            string2 = this.replace(_M_iend, _M_iend, __first, __firstStartIdx, Size);
        }
        return string2;
    }

    public std.string append(byte[] __first, int __firstStartIdx, int Size) {
        std.string string2;
        assert (!this._isConst()) : "This string cannot be modified!";
        if (Size == 0) {
            string2 = (std.string)this;
        } else {
            char$ptr _M_iend = this._M_iend();
            string2 = this.replace(_M_iend, _M_iend, __first, __firstStartIdx, Size);
        }
        return string2;
    }

    public std.string append(char$ptr __extra) {
        assert (!this._isConst()) : "This string cannot be modified!";
        char$ptr _M_iend = this._M_iend();
        return this.replace(_M_iend, _M_iend, __extra, 0, std.strlen(__extra));
    }

    public void push_back(byte c) {
        assert (!this._isConst()) : "This string cannot be modified!";
        this.array.insert(this.array.begin().$add(this.length()), c);
        this._postModUpdate();
    }

    public void clear() {
        assert (!this._isConst()) : "This string cannot be modified!";
        this.array = new std.vectorChar();
        this._postModUpdate();
    }

    public std.string $addassign(byte c) {
        assert (!this._isConst()) : "This string cannot be modified!";
        this.push_back(c);
        return (std.string)this;
    }

    public final std.string $addassign_T(byte c) {
        return this.$addassign(c);
    }

    public std.string $addassign(char c) {
        assert (!this._isConst()) : "This string cannot be modified!";
        return this.$addassign(NativePointer.$(c));
    }

    public std.string $addassign(std.string extra) {
        assert (!this._isConst()) : "This string cannot be modified!";
        this.array.insert(this.array.begin().$add(this.length()), extra.begin(), extra.end());
        this._postModUpdate();
        return (std.string)this;
    }

    public std.string $addassign(char$ptr extra) {
        assert (!this._isConst()) : "This string cannot be modified!";
        this.array.insert(this.array.begin().$add(this.length()), extra, (char$iterator)extra.$add(std.strlen(extra)));
        this._postModUpdate();
        return (std.string)this;
    }

    public final std.string $addassign_T$C$P(CharSequence extra) {
        assert (!this._isConst()) : "This string cannot be modified!";
        return this.$addassign(NativePointer.create_char$ptr(extra));
    }

    public final std.string $addassign_T$C$P(char$ptr extra) {
        assert (!this._isConst()) : "This string cannot be modified!";
        return this.$addassign(extra);
    }

    public std.string $addassign(CharSequence extra) {
        assert (!this._isConst()) : "This string cannot be modified!";
        return this.$addassign(NativePointer.create_char$ptr(extra));
    }

    public byte back() {
        return this.array.$at(this.size() - 1);
    }

    public byte $at(int val) {
        return this.array.$at(val);
    }

    public byte $at$Const(int val) {
        return this.array.$at(val);
    }

    public byte $set(int idx, byte val) {
        assert (!this._isConst()) : "This string cannot be modified!";
        return this.array.$set(idx, val);
    }

    public std.string substr(int idx) {
        return new std.string((char$iterator)this.begin().$add(idx), this.end());
    }

    public std.string substr(int __pos, int __n) {
        if (__n == npos) {
            return this.substr(__pos);
        }
        return new std.string((char$iterator)this.begin().$add(__pos), (char$iterator)this.begin().$add(__pos + __n));
    }

    public std.string replace(int __pos, int __n1, char$ptr __s, int __n2) {
        assert (!this._isConst()) : "This string cannot be modified!";
        char$ptr _M_data = this._M_data();
        int n = __n1 = __n1 == npos ? this.size() - __pos : __n1;
        if (this._M_disjunct(__s)) {
            return this._M_replace_safe(__pos, __n1, __s, __n2);
        }
        boolean __left = __s.$index() + __n2 <= _M_data.$index() + __pos;
        if (__left || _M_data.$index() + __pos + __n1 <= __s.$index()) {
            int __off = __s.$sub(_M_data);
            __off = __left ? __off : __off + __n2 - __n1;
            this._M_mutate(__pos, __n1, __n2);
            _M_data = this._M_data();
            this._M_copy(_M_data, __pos, _M_data, __off, __n2);
            this._postModUpdate();
            return (std.string)this;
        }
        std.string __tmp = new std.string(__s, __n2);
        return this._M_replace_safe(__pos, __n1, __tmp._M_data(), __n2);
    }

    public std.string replace(int __pos, int __n1, CharSequence __s, int __n2) {
        assert (!this._isConst()) : "This string cannot be modified!";
        return this.replace(__pos, __n1, NativePointer.create_char$ptr(__s), __n2);
    }

    public std.string replace(int __pos, int __n1, char$ptr __s) {
        assert (!this._isConst()) : "This string cannot be modified!";
        return this.replace(__pos, __n1, __s, std.strlen(__s));
    }

    public std.string replace(int __pos, int __n, std.string __str) {
        assert (!this._isConst()) : "This string cannot be modified!";
        return this.replace(__pos, __n, __str._M_data(), __str.size());
    }

    public std.string replace(int __pos, int __n, CharSequence __str) {
        assert (!this._isConst()) : "This string cannot be modified!";
        return this.replace(__pos, __n, NativePointer.create_char$ptr(__str));
    }

    public std.string replace(int __pos1, int __n1, std.string __str, int __pos2, int __n2) {
        assert (!this._isConst()) : "This string cannot be modified!";
        return this.replace(__pos1, __n1, (char$ptr)__str._M_data().$add(__str._M_check(__pos2, "basic_string::replace")), __str._M_limit(__pos2, __n2));
    }

    public std.string replace(int __pos, int __n1, int __n2, byte __c) {
        assert (!this._isConst()) : "This string cannot be modified!";
        return this._M_replace_aux(this._M_check(__pos, "basic_string::replace"), this._M_limit(__pos, __n1), __n2, __c);
    }

    public std.string replace(int __pos, int __n1, int __n2, char __c) {
        assert (!this._isConst()) : "This string cannot be modified!";
        return this.replace(__pos, __n1, __n2, (byte)__c);
    }

    public std.string replace(char$ptr __i1, char$ptr __i2, std.string __str) {
        assert (!this._isConst()) : "This string cannot be modified!";
        return this.replace(__i1, __i2, __str._M_data(), __str.size());
    }

    public std.string replace(char$ptr __i1, char$ptr __i2, char$ptr __s, int __n) {
        assert (!this._isConst()) : "This string cannot be modified!";
        return this.replace(__i1.$sub(this._M_ibegin()), __i2.$sub(__i1), __s, __n);
    }

    public std.string replace(char$ptr __i1, char$ptr __i2, CharSequence __s, int __n) {
        assert (!this._isConst()) : "This string cannot be modified!";
        return this.replace(__i1.$sub(this._M_ibegin()), __i2.$sub(__i1), NativePointer.create_char$ptr(__s), __n);
    }

    public std.string replace(char$ptr __i1, char$ptr __i2, char$ptr __s) {
        assert (!this._isConst()) : "This string cannot be modified!";
        return this.replace(__i1, __i2, __s, std.strlen(__s));
    }

    public std.string replace(char$ptr __i1, char$ptr __i2, CharSequence __s) {
        assert (!this._isConst()) : "This string cannot be modified!";
        return this.replace(__i1, __i2, NativePointer.create_char$ptr(__s), __s.length());
    }

    public std.string replace(char$ptr __i1, char$ptr __i2, int __n, byte __c) {
        assert (!this._isConst()) : "This string cannot be modified!";
        return this._M_replace_aux(__i1.$sub(this._M_ibegin()), __i2.$sub(__i1), __n, __c);
    }

    public std.string replace(char$ptr __i1, char$ptr __i2, int __n, char __c) {
        assert (!this._isConst()) : "This string cannot be modified!";
        return this.replace(__i1, __i2, __n, (byte)__c);
    }

    public std.string replace(char$ptr __i1, char$ptr __i2, char$iterator<?> __k1, char$iterator<?> __k2) {
        assert (!this._isConst()) : "This string cannot be modified!";
        return this.replace(__i1, __i2, __k1, 0, __k2.$sub(__k1));
    }

    public std.string replace(char$ptr __i1, char$ptr __i2, char$iterator<?> __k1, int __k1_Idx, int Size) {
        assert (!this._isConst()) : "This string cannot be modified!";
        return this._M_replace_dispatch(__i1, __i2, __k1, __k1_Idx, Size);
    }

    public std.string replace(char$ptr __i1, char$ptr __i2, byte[] __k1, int __k1_Idx, int Size) {
        assert (!this._isConst()) : "This string cannot be modified!";
        return this._M_replace_dispatch(__i1, __i2, __k1, __k1_Idx, Size);
    }

    public int find(char$ptr __s, int __pos, int __n) {
        int __size = this.size();
        char$ptr __data = this._M_data();
        if (__n == 0) {
            return __pos <= __size ? __pos : npos;
        }
        if (__n <= __size) {
            while (__pos <= __size - __n) {
                if (Native.$eq(__data.$at(__pos), __s.$at(0)) && std.strncmp((char$ptr)__data.$add(__pos + 1), (char$ptr)__s.$add(1), __n - 1) == 0) {
                    return __pos;
                }
                ++__pos;
            }
        }
        return npos;
    }

    public int find(CharSequence __s, int __pos, int __n) {
        return this.find(NativePointer.create_char$ptr(__s), __pos, __n);
    }

    public int find(std.string __str) {
        return this.find(__str, 0);
    }

    public int find(std.string __str, int __pos) {
        return this.find(__str.data(), __pos, __str.size());
    }

    public int find(char$ptr __s) {
        return this.find(__s, 0);
    }

    public int find_T$C$P_size_type$_CharT(String __s) {
        return this.find(__s);
    }

    public final int find_T$C$P_rebind$_CharT(CharSequence __s) {
        return this.find(__s);
    }

    public int find(CharSequence __s) {
        return this.find(NativePointer.create_char$ptr(__s));
    }

    public int find(char$ptr __s, int __pos) {
        return this.find(__s, __pos, std.strlen(__s));
    }

    public int find(CharSequence __s, int __pos) {
        return this.find(NativePointer.create_char$ptr(__s), __pos);
    }

    public int find(byte __c) {
        return this.find(__c, 0);
    }

    public int find(char __c) {
        return this.find((byte)__c);
    }

    public int find_first_of(byte __c) {
        return this.find_first_of(__c, 0);
    }

    public int find_first_of(byte __c, int __pos) {
        return this.find(__c, __pos);
    }

    public int find_first_of_T_$_CharT(byte __c, int __pos) {
        return this.find(__c, __pos);
    }

    public int find_first_of(std.string __str) {
        return this.find_first_of(__str, 0);
    }

    public int find_first_of(std.string __str, int __pos) {
        return this.find_first_of(__str.data(), __pos, __str.size());
    }

    public int find_first_of(char$ptr __s, int __pos, int __n) {
        char$ptr string2 = this.data();
        int i = __pos;
        while (Native.$bool(string2) && string2.$at(i) != 0) {
            int j;
            for (j = 0; j < __n && string2.$at(i) != __s.$at(j); ++j) {
            }
            if (j != __n) break;
            ++i;
        }
        return i < this.length() ? i : npos;
    }

    public int find_first_of(char$ptr __s) {
        return this.find_first_of(__s, 0);
    }

    public int find_first_of(char$ptr __s, int __pos) {
        return this.find_first_of(__s, __pos, std.strlen(__s));
    }

    public int find_last_of(std.string __str) {
        return this.find_last_of(__str, std.string.npos);
    }

    public int find_last_of(std.string __str, int __pos) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public int find_last_of(char$ptr __s, int __pos, int __n) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public int find_last_of(char$ptr __s) {
        return this.find_last_of(__s, std.string.npos);
    }

    public int find_last_of(char$ptr __s, int __pos) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public int find_last_of(byte __c) {
        return this.find_last_of(__c, std.string.npos);
    }

    public int find_last_of(byte __c, int __pos) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public int find(byte __c, int __pos) {
        int __ret = npos;
        int __size = this.size();
        if (__pos < __size) {
            char$ptr __to;
            char$ptr __data = this._M_data();
            int __n = __size - __pos;
            char$ptr __from = (char$ptr)__data.$add(__pos);
            char$ptr __p = std.find(__from, __to = (char$ptr)__data.$add(__pos + __n), __c);
            if (__p.$noteq(__to)) {
                __ret = __p.$sub(__data);
            }
        }
        return __ret;
    }

    public int find(char __c, int __pos) {
        return this.find((byte)__c, __pos);
    }

    public int rfind(std.string __str) {
        return this.rfind(__str, npos);
    }

    public int rfind(std.string __str, int __pos) {
        return this.rfind(__str.data(), __pos, __str.size());
    }

    public int rfind(char$ptr __s, int __pos, int __n) {
        int __size = this.size();
        if (__n <= __size) {
            __pos = std.min(__size - __n, __pos);
            char$ptr __data = this._M_data();
            do {
                if (std.strncmp((char$ptr)__data.$add(__pos), __s, __n) != 0) continue;
                return __pos;
            } while (__pos-- > 0);
        }
        return npos;
    }

    public int rfind(CharSequence __s, int __pos, int __n) {
        return this.rfind(NativePointer.create_char$ptr(__s), __pos, __n);
    }

    public int rfind(char$ptr __s) {
        return this.rfind(__s, npos);
    }

    public int rfind(CharSequence __s) {
        return this.rfind(NativePointer.create_char$ptr(__s));
    }

    public int rfind(char$ptr __s, int __pos) {
        return this.rfind(__s, __pos, std.strlen(__s));
    }

    public int rfind(CharSequence __s, int __pos) {
        return this.rfind(NativePointer.create_char$ptr(__s), __pos);
    }

    public int rfind(byte __c) {
        return this.rfind(__c, npos);
    }

    public int rfind(char __c) {
        return this.rfind((byte)__c);
    }

    public int rfind(byte __c, int __pos) {
        block3: {
            int __size = this.size();
            if (__size > 0) {
                if (--__size > __pos) {
                    __size = __pos;
                }
                do {
                    int n = ++__size;
                    --__size;
                    if (n <= 0) break block3;
                } while (!Native.$eq(this._M_data().$at(__size), __c));
                return __size;
            }
        }
        return npos;
    }

    public int rfind(char __c, int __pos) {
        return this.rfind((byte)__c, __pos);
    }

    public int compare(std.string __str) {
        return this.compareTo(__str);
    }

    public boolean $eq(Object __other) {
        if (!(__other instanceof std.string)) {
            return false;
        }
        std.string other = (std.string)__other;
        if (this.length() == other.length()) {
            for (int i = 0; i < this.length(); ++i) {
                if (this.array.$at(i) == other.array.$at(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean $noteq(Object other) {
        return !this.$eq(other);
    }

    @Override
    public int compareTo(std.string o) {
        if (this.$less(o)) {
            return -1;
        }
        if (o.$less(this)) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean $less(Object __other) {
        StdString other = (StdString)__other;
        return std.lexicographical_compare(this.begin(), this.end(), other.begin(), other.end());
    }

    @Override
    public boolean $lesseq(Object obj) {
        return !((StdString)obj).$less(this);
    }

    @Override
    public boolean $greater(Object obj) {
        return ((StdString)obj).$less(this);
    }

    @Override
    public boolean $greatereq(Object obj) {
        return !this.$less((StdString)obj);
    }

    @Override
    public Boolean $op(Native.OpCapable.Op k, Object obj) {
        if (Native.OpCapable.Op.EQ == k) {
            if (obj instanceof StdString) {
                return this.$eq((StdString)obj);
            }
            if (obj instanceof CharSequence) {
                return this.$eq(new std.string((CharSequence)obj));
            }
            if (obj instanceof char$iterator) {
                return this.$eq(new std.string((char$iterator)obj, std.strlen((char$iterator)obj)));
            }
            return null;
        }
        assert (false) : "can not check " + (Object)((Object)k) + " for " + obj.getClass();
        return null;
    }

    @Override
    public std.string $assignMove(std.string other) {
        assert (!this._isConst()) : "This string cannot be modified!";
        this.array = other.array;
        other.array = null;
        return (std.string)this;
    }

    @Override
    public std.string clone() {
        return new std.string((std.string)this);
    }

    @Override
    public std.string move() {
        return new std.string(JavaDifferentiators.JD.Move.INSTANCE, (std.string)this);
    }

    public String toString() {
        return "[string size=" + this.length() + "+'0']\n" + this.toJavaString();
    }

    public String toJavaString() {
        return Casts.toJavaString(this.array.$array(), 0, this.length());
    }

    protected char$ptr _M_data() {
        return this.data();
    }

    protected char$ptr _M_ibegin() {
        return this.data();
    }

    protected char$ptr _M_iend() {
        return (char$ptr)this.data().$add(this.size());
    }

    protected int _M_limit(int __pos, int __off) {
        boolean __testoff = __off < this.size() - __pos;
        return __testoff ? __off : this.size() - __pos;
    }

    protected boolean _M_disjunct(char$ptr __s) {
        return !__s.isComparableTo(this._M_data()) || __s.$less(this.data()) || ((char$ptr)this.data().$add(this.size())).$less(__s);
    }

    protected std.string _M_replace_aux(int __pos1, int __n1, int __n2, byte __c) {
        assert (this._M_check_length(__n1, __n2, "basic_string::_M_replace_aux"));
        this._M_mutate(__pos1, __n1, __n2);
        if (__n2 > 0) {
            std.memset((char$ptr)this._M_data().$add(__pos1), __c, __n2);
        }
        this._postModUpdate();
        return (std.string)this;
    }

    protected std.string _M_replace_safe(int __pos1, int __n1, char$ptr __s, int __n2) {
        this._M_mutate(__pos1, __n1, __n2);
        if (__n2 > 0) {
            this._M_copy(this._M_data(), __pos1, __s, 0, __n2);
        }
        this._postModUpdate();
        return (std.string)this;
    }

    protected std.string _M_replace_dispatch(char$ptr __i1, char$ptr __i2, char$iterator<?> __k1, char$iterator<?> __k2) {
        return this._M_replace_dispatch(__i1, __i2, __k1, 0, __k2.$sub(__k1));
    }

    protected std.string _M_replace_dispatch(char$ptr __i1, char$ptr __i2, char$iterator<?> __from, int __fromIdx, int Size) {
        std.string __s;
        std.string string2 = __s = Size == 0 ? EMPTY : new std.string(__from, __fromIdx, Size);
        assert (Size == __s.size()) : "" + Size + " vs. " + __s.size();
        int __n1 = __i2.$sub(__i1);
        assert (this._M_check_length(__n1, __s.size(), "basic_string::_M_replace_dispatch"));
        return this._M_replace_safe(__i1.$sub(this._M_ibegin()), __n1, __s._M_data(), Size);
    }

    protected std.string _M_replace_dispatch(char$ptr __i1, char$ptr __i2, byte[] __from, int __fromIdx, int Size) {
        std.string __s;
        std.string string2 = __s = Size == 0 ? EMPTY : new std.string(__from, __fromIdx, Size);
        assert (Size == __s.size()) : "" + Size + " vs. " + __s.size();
        int __n1 = __i2.$sub(__i1);
        assert (this._M_check_length(__n1, __s.size(), "basic_string::_M_replace_dispatch"));
        return this._M_replace_safe(__i1.$sub(this._M_ibegin()), __n1, __s._M_data(), Size);
    }

    protected void _M_mutate(int __pos, int __len1, int __len2) {
        int __old_size = this.size();
        int __new_size = __old_size + __len2 - __len1;
        int __how_much = __old_size - __pos - __len1;
        if (__new_size > this.capacity()) {
            this.array.reserve(__new_size + 1);
        }
        if (__how_much > 0 && __len1 != __len2) {
            char$ptr _M_data = this._M_data();
            if (__len2 > __len1) {
                int downToIdx = __pos + __len1;
                int fromIdx = downToIdx + __how_much;
                int destIdx = __pos + __len2 + __how_much;
                std.copy_backward(_M_data, downToIdx, fromIdx, _M_data, destIdx);
            } else {
                int fromIdx = __pos + __len1;
                int toIdx = fromIdx + __how_much;
                int destIdx = __pos + __len2;
                std.copy(_M_data, fromIdx, toIdx, _M_data, destIdx);
            }
        }
        this.array.set_size(__new_size);
    }

    protected void _M_copy(char$ptr __d, int __dIdx, char$ptr __s, int __sIdx, int __n) {
        std.copy(__s, __sIdx, __sIdx + __n, __d, __dIdx);
    }

    protected void _M_move(char$ptr __d, int __dIdx, char$ptr __s, int __sIdx, int __n) {
        std.copy(__s, __sIdx, __sIdx + __n, __d, __dIdx);
    }

    protected int _M_check(int __pos, CharSequence __s) {
        if (__pos > this.size()) {
            throw new RuntimeException(__s.toString());
        }
        return __pos;
    }

    private boolean _M_check_length(int __n1, int __n2, CharSequence __s) {
        if (this.max_size() - (this.size() - __n1) < __n2) {
            throw new RuntimeException(__s.toString());
        }
        return true;
    }

    private StdVectorChar.iterator convertPtrToIter(char$ptr ptr2) {
        return this.array.begin().$add(ptr2.$sub(this.begin()));
    }

    private void _postModUpdate() {
        if (this.array.empty() || this.array.$at(this.array.size() - 1) != 0) {
            this.array.append(1, (byte)0);
        }
    }

    private char$iterator erase(StdVectorChar.iterator __position) {
        assert (!this._isConst()) : "This string cannot be modified!";
        StdVectorChar.iterator res = this.array.erase(__position);
        this._postModUpdate();
        return res;
    }

    private char$iterator erase(StdVectorChar.iterator __first, StdVectorChar.iterator __last) {
        assert (!this._isConst()) : "This string cannot be modified!";
        StdVectorChar.iterator res = this.array.erase(__first, __last);
        this._postModUpdate();
        return res;
    }

    private boolean _isConst() {
        return this._const;
    }

    static {
        assert (NativeTrace.registerArrayWithImmutableContent(TERM_ARRAY, "StdString.TERM_ARRAY"));
        EMPTY = new std.string((char$iterator<?>)NativePointer.$EMPTY, 0, std.strlen(NativePointer.$EMPTY), true);
    }
}

