/*
 * Decompiled with CFR 0.152.
 */
package org.clank.java.stdimpl;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.JavaIterator;
import org.clank.support.aliases.type$iterator;
import org.clank.support.aliases.type$ptr;
import org.clank.support.aliases.type$ref;

@Deprecated
public abstract class StdMap<KeyT, ValueT>
extends NativeTrace.CreateDestroy.Tracker
implements Native.NativePOD<StdMap<KeyT, ValueT>>,
Iterable<std_pair.pair<KeyT, ValueT>>,
Destructors.ClassWithDestructor {
    protected ValueT defaultValue;
    protected TreeMap<KeyT, std_pair.pair<KeyT, ValueT>> treeMap;

    protected StdMap(ValueT defaultValue) {
        this(null, defaultValue);
    }

    protected StdMap(Comparator<KeyT> comparator, ValueT defaultValue) {
        this.treeMap = new TreeMap(comparator != null ? comparator : new DefaultComparator());
        assert (defaultValue == null || Native.$tryClone(defaultValue) != defaultValue) : "non cloneable class for defaultValue " + NativeTrace.getIdentityStr(defaultValue);
        this.defaultValue = defaultValue;
    }

    protected StdMap(StdMap<KeyT, ValueT> other) {
        this(other.treeMap.comparator(), other.defaultValue);
        this.$assign(other);
    }

    protected StdMap(JavaDifferentiators.JD.Move _dparam, StdMap<KeyT, ValueT> other) {
        this(other.treeMap.comparator(), other.defaultValue);
        this.$assign(other);
        other.$destroy();
        other.treeMap = null;
    }

    @Override
    public StdMap<KeyT, ValueT> $assign(StdMap<KeyT, ValueT> other) {
        assert (other.checkAlive());
        assert (this.checkAlive());
        this.clear();
        for (Map.Entry<KeyT, std_pair.pair<KeyT, ValueT>> entry : other.treeMap.entrySet()) {
            this.treeMap.put(entry.getKey(), std.make_pair(entry.getKey(), this.isDataPointerLike() ? entry.getValue().second : Native.$tryClone(entry.getValue().second)));
        }
        return this;
    }

    public void swap(StdMap<KeyT, ValueT> other) {
        assert (other.checkAlive());
        assert (this.checkAlive());
        TreeMap<KeyT, std_pair.pair<KeyT, ValueT>> tmpMap = this.treeMap;
        this.treeMap = other.treeMap;
        other.treeMap = tmpMap;
        ValueT tmpDefVal = this.defaultValue;
        this.defaultValue = other.defaultValue;
        other.defaultValue = tmpDefVal;
    }

    public ValueT $at_T$C$R(KeyT key) {
        assert (this.checkAlive());
        return this.$at(key);
    }

    public ValueT $at_T$RR(KeyT key) {
        assert (this.checkAlive());
        return this.$at(key);
    }

    public ValueT $at(KeyT key) {
        assert (this.checkAlive());
        std_pair.pair<KeyT, ValueT> out = this.treeMap.get(key);
        if (out == null) {
            out = std.make_pair(key, Native.$tryClone(this.defaultValue));
            this.treeMap.put(key, out);
        }
        return (ValueT)out.second;
    }

    public void $set(KeyT key, ValueT val) {
        assert (this.checkAlive());
        this.treeMap.put(key, std.make_pair(key, this.isDataPointerLike() ? val : Native.$tryClone(val)));
    }

    public type$ref<ValueT> ref$at(final KeyT key) {
        assert (this.checkAlive());
        if (!this.treeMap.containsKey(key)) {
            this.treeMap.put(key, std.make_pair(key, Native.$tryClone(this.defaultValue)));
        }
        return new type$ref<ValueT>(){

            @Override
            public ValueT $deref() {
                assert (StdMap.this.checkAlive());
                return StdMap.this.treeMap.get((Object)key).second;
            }

            @Override
            public ValueT $set(ValueT value) {
                assert (StdMap.this.checkAlive());
                StdMap.this.treeMap.get((Object)key).second = StdMap.this.isDataPointerLike() ? value : Native.$tryClone(value);
                return value;
            }

            @Override
            public type$ptr<ValueT> deref$ptr() {
                assert (StdMap.this.checkAlive());
                throw new UnsupportedOperationException("Not supported.");
            }
        };
    }

    public int size() {
        assert (this.checkAlive());
        return this.treeMap.size();
    }

    public boolean empty() {
        assert (this.checkAlive());
        return this.treeMap.isEmpty();
    }

    public void clear() {
        assert (this.checkAlive());
        if (!this.isDataPointerLike()) {
            for (Map.Entry<KeyT, std_pair.pair<KeyT, ValueT>> entry : this.treeMap.entrySet()) {
                Native.destroy(entry.getValue().second);
            }
        }
        this.treeMap.clear();
    }

    public std_pair.pairTypeBool<iterator<KeyT, ValueT>> insert$T$RR(std_pair.pair<KeyT, ValueT> val) {
        assert (this.checkAlive());
        boolean newElement = !this.treeMap.containsKey(val.first);
        this.treeMap.put(val.first, std.make_pair(val.first, this.isDataPointerLike() ? val.second : Native.$tryMove(val.second)));
        return std.make_pair_T_bool(this.find(val.first), newElement);
    }

    public final std_pair.pairTypeBool<iterator<KeyT, ValueT>> insert$T(std_pair.pair<KeyT, ValueT> val) {
        assert (this.checkAlive());
        return this.insert(val);
    }

    public std_pair.pairTypeBool<iterator<KeyT, ValueT>> insert(std_pair.pair<KeyT, ValueT> val) {
        assert (this.checkAlive());
        boolean newElement = !this.treeMap.containsKey(val.first);
        this.treeMap.put(val.first, std.make_pair(val.first, this.isDataPointerLike() ? val.second : Native.$tryClone(val.second)));
        return std.make_pair_T_bool(this.find(val.first), newElement);
    }

    public void insert(type$iterator<?, std_pair.pair<KeyT, ValueT>> I, type$iterator<?, std_pair.pair<KeyT, ValueT>> E) {
        assert (this.checkAlive());
        while (Native.$noteq_iter(I, E)) {
            std_pair.pair<KeyT, ValueT> val = I.$star();
            this.treeMap.put(val.first, std.make_pair(val.first, this.isDataPointerLike() ? val.second : Native.$tryClone(val.second)));
            I.$preInc();
        }
    }

    public void erase(iterator<KeyT, ValueT> position) {
        assert (this.checkAlive());
        if (!this.isDataPointerLike()) {
            Native.destroy(((std_pair.pair)position.$star()).second);
        }
        ((iterator)position).erase();
    }

    public boolean erase(KeyT key) {
        assert (this.checkAlive());
        if (!this.treeMap.containsKey(key)) {
            return false;
        }
        if (!this.isDataPointerLike()) {
            Native.destroy(this.treeMap.get(key).second);
        }
        this.treeMap.remove(key);
        return true;
    }

    public iterator<KeyT, ValueT> lower_bound(KeyT key) {
        assert (this.checkAlive());
        KeyT lowerBoundKey = this.treeMap.ceilingKey(key);
        return lowerBoundKey != null ? this.find(lowerBoundKey) : this.end();
    }

    public iterator<KeyT, ValueT> upper_bound(KeyT key) {
        assert (this.checkAlive());
        iterator<KeyT, ValueT> upperBound = this.lower_bound(key);
        while (upperBound.$noteq(this.end()) && this.treeMap.comparator().compare(key, ((iterator)upperBound).getKey()) >= 0) {
            upperBound.$preInc();
        }
        return upperBound;
    }

    public iterator<KeyT, ValueT> begin$Const() {
        assert (this.checkAlive());
        return new iterator(this.treeMap, this.treeMap.firstEntry(), this.defaultValue, true);
    }

    public iterator<KeyT, ValueT> end$Const() {
        assert (this.checkAlive());
        return new iterator(this.treeMap, null, this.defaultValue, true);
    }

    public iterator<KeyT, ValueT> begin() {
        assert (this.checkAlive());
        return new iterator(this.treeMap, this.treeMap.firstEntry(), this.defaultValue, false);
    }

    public iterator<KeyT, ValueT> end() {
        assert (this.checkAlive());
        return new iterator(this.treeMap, null, this.defaultValue, false);
    }

    @Override
    public Iterator<std_pair.pair<KeyT, ValueT>> iterator() {
        assert (this.checkAlive());
        return new JavaIterator<std_pair.pair<KeyT, ValueT>>(this.begin(), this.end());
    }

    public boolean count(KeyT key) {
        assert (this.checkAlive());
        return this.treeMap.containsKey(key);
    }

    public boolean replaceValueReference(KeyT key, ValueT val) {
        assert (this.checkAlive());
        std_pair.pair<KeyT, ValueT> entry = this.treeMap.get(key);
        assert (entry != null) : "must be called only for existing entry " + key + " => " + val;
        entry.second = val;
        return true;
    }

    public final iterator<KeyT, ValueT> find$Const(KeyT key) {
        assert (this.checkAlive());
        return this.find(key);
    }

    public iterator<KeyT, ValueT> find(KeyT key) {
        assert (this.checkAlive());
        if (!this.treeMap.containsKey(key)) {
            return this.end();
        }
        return new iterator(this.treeMap, this.treeMap.ceilingEntry(key), this.defaultValue, false);
    }

    @Override
    public StdMap<KeyT, ValueT> clone() {
        assert (this.checkAlive());
        throw new UnsupportedOperationException("forgot to override clone in " + this.getClass());
    }

    @Override
    public void $destroy() {
        assert (this.checkAlive());
        this.clear();
        super.set$destroyed();
    }

    private boolean isDataPointerLike() {
        return this.defaultValue == null;
    }

    public String toString() {
        return "StdMap " + (super.is$destroyed() ? "DESTROYED" : "") + "{" + this.treeMap + "}";
    }

    protected final boolean checkAlive() {
        return this.check$Alive();
    }

    public static class iterator<KeyT, ValueT>
    implements type$iterator<iterator<KeyT, ValueT>, std_pair.pair<KeyT, ValueT>> {
        private final ValueT defaultValue;
        private final TreeMap<KeyT, std_pair.pair<KeyT, ValueT>> map;
        private final boolean _const;
        private Map.Entry<KeyT, std_pair.pair<KeyT, ValueT>> currentEntry;

        public iterator(iterator<KeyT, ValueT> other) {
            this.defaultValue = Native.$tryClone(other.defaultValue);
            this.map = Native.$tryClone(other.map);
            this.currentEntry = Native.$tryClone(other.currentEntry);
            this._const = other._const;
        }

        public iterator(JavaDifferentiators.JD.Move _dparam, iterator<KeyT, ValueT> other) {
            this.defaultValue = other.defaultValue;
            this.map = other.map;
            this.currentEntry = other.currentEntry;
            this._const = other._const;
        }

        private iterator(TreeMap<KeyT, std_pair.pair<KeyT, ValueT>> map, Map.Entry<KeyT, std_pair.pair<KeyT, ValueT>> curr, ValueT defaultValue, boolean asConst) {
            this.defaultValue = defaultValue;
            this.map = map;
            this.currentEntry = curr;
            this._const = asConst;
        }

        private KeyT getKey() {
            return this.currentEntry.getKey();
        }

        private void erase() {
            this.map.remove(this.currentEntry.getKey());
        }

        @Override
        public std_pair.pair<KeyT, ValueT> $arrow() {
            return this.currentEntry.getValue();
        }

        @Override
        public std_pair.pair<KeyT, ValueT> $star() {
            return this.currentEntry.getValue();
        }

        @Override
        public type$ref<std_pair.pair<KeyT, ValueT>> star$ref() {
            return new type$ref<std_pair.pair<KeyT, ValueT>>(){
                private final Map.Entry<KeyT, std_pair.pair<KeyT, ValueT>> localEntry;
                {
                    this.localEntry = currentEntry;
                }

                @Override
                public std_pair.pair<KeyT, ValueT> $deref() {
                    return this.localEntry.getValue();
                }

                @Override
                public std_pair.pair<KeyT, ValueT> $set(std_pair.pair<KeyT, ValueT> value) {
                    assert (map.comparator().compare(value.first, this.localEntry.getKey()) == 0) : "Trying to change key of entry via iterator!";
                    this.localEntry.getValue().second = Native.$tryAssign(this.localEntry.getValue().second, value.second, this.isDataPointerLike());
                    return value;
                }

                @Override
                public type$ptr<std_pair.pair<KeyT, ValueT>> deref$ptr() {
                    throw new UnsupportedOperationException("Not supported.");
                }
            };
        }

        @Override
        public iterator<KeyT, ValueT> $preInc() {
            this.currentEntry = this.map.higherEntry(this.currentEntry.getKey());
            return this;
        }

        @Override
        public iterator<KeyT, ValueT> $postInc() {
            iterator cloned = Native.$Clone(this);
            this.$preInc();
            return cloned;
        }

        @Override
        public iterator<KeyT, ValueT> clone() {
            return new iterator<KeyT, ValueT>(this.map, this.currentEntry, this.defaultValue, false);
        }

        @Override
        public iterator<KeyT, ValueT> const_clone() {
            return new iterator<KeyT, ValueT>(this.map, this.currentEntry, this.defaultValue, true);
        }

        public boolean $eq(Object other) {
            if (other instanceof iterator) {
                iterator otherIter = (iterator)other;
                if (otherIter.map == this.map) {
                    if (otherIter.currentEntry == null) {
                        return this.currentEntry == null;
                    }
                    if (this.currentEntry == null) {
                        return otherIter.currentEntry == null;
                    }
                    return Native.$eq(otherIter.currentEntry.getKey(), this.currentEntry.getKey());
                }
            }
            return false;
        }

        public boolean $noteq(Object other) {
            return !this.$eq(other);
        }

        @Override
        public int $sub(iterator<KeyT, ValueT> iter) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public iterator<KeyT, ValueT> $preDec() {
            this.currentEntry = this.currentEntry == null ? this.map.lastEntry() : this.map.lowerEntry(this.currentEntry.getKey());
            return this;
        }

        @Override
        public iterator<KeyT, ValueT> $postDec() {
            iterator cloned = Native.$Clone(this);
            this.$preDec();
            return cloned;
        }

        @Override
        public iterator<KeyT, ValueT> $inc(int amount) {
            if (amount == 0) {
                return this;
            }
            if (amount > 0) {
                do {
                    this.$preInc();
                } while (--amount > 0);
                return this;
            }
            return this.$dec(-amount);
        }

        @Override
        public iterator<KeyT, ValueT> $dec(int amount) {
            if (amount == 0) {
                return this;
            }
            if (amount > 0) {
                do {
                    this.$preDec();
                } while (--amount > 0);
                return this;
            }
            return this.$inc(-amount);
        }

        @Override
        public iterator<KeyT, ValueT> $add(int amount) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public iterator<KeyT, ValueT> $sub(int amount) {
            throw new UnsupportedOperationException("Not supported.");
        }

        private boolean isDataPointerLike() {
            return this.defaultValue == null;
        }
    }

    private static class DefaultComparator<KeyT>
    implements Comparator<KeyT> {
        private DefaultComparator() {
        }

        @Override
        public int compare(KeyT o1, KeyT o2) {
            if (o1 instanceof Native.ComparableLower) {
                if (((Native.ComparableLower)o1).$less(o2)) {
                    return -1;
                }
                return ((Native.ComparableLower)o2).$less(o1) ? 1 : 0;
            }
            if (o1 instanceof Comparable) {
                return ((Comparable)o1).compareTo(o2);
            }
            throw new UnsupportedOperationException("NO ComparableLower: " + o1.getClass() + " vs. " + o2.getClass());
        }
    }
}

