/*
 * Decompiled with CFR 0.152.
 */
package org.clank.java;

import java.util.ArrayList;
import java.util.Iterator;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.JavaIterator;
import org.clank.support.aliases.NativeContainer;
import org.clank.support.aliases.type$iterator;
import org.clank.support.void$ptr;

public interface std_deque {

    public static class deque<T>
    implements NativeContainer<T>,
    Destructors.ClassWithDestructor,
    Iterable<T> {
        private ArrayList<T> deque = new ArrayList();
        private final boolean isDataPointerLike;

        public deque(boolean isDataPointerLike) {
            this.isDataPointerLike = isDataPointerLike;
        }

        public <From> deque(boolean isDataPointerLike, type$iterator<?, From> beg, type$iterator<?, From> end, NativeCallback.Converter<From, T> converter) {
            this(isDataPointerLike);
            if (!beg.$eq(end)) {
                beg = Native.$Clone(beg);
                while (beg.$noteq(end)) {
                    this.push_back(converter.$call(beg.$star()));
                    beg.$preInc();
                }
            }
        }

        public deque(deque<T> Other) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void push_back(T val) {
            assert (val == null || !(val instanceof void$ptr)) : "need to clone?" + val.getClass();
            this.push_back_impl(val);
        }

        @Override
        public void push_back_T$RR(T val) {
            this.deque.add(Native.$tryMove(null, val, this.isDataPointerLike));
        }

        @Override
        public void push_back_T$C$R(T val) {
            assert (val == null || !(val instanceof void$ptr)) : "need to clone?" + val.getClass();
            this.push_back_impl(val);
        }

        private void push_back_impl(T val) {
            this.deque.add(Native.$tryAssign(null, val, this.isDataPointerLike));
        }

        public boolean empty() {
            return this.deque.isEmpty();
        }

        public T front() {
            return this.deque.get(0);
        }

        public T back() {
            return this.deque.get(this.deque.size() - 1);
        }

        public T pop_front() {
            return this.deque.remove(0);
        }

        @Override
        public void $destroy() {
            if (!this.empty() && !this.isDataPointerLike) {
                for (T t : this.deque) {
                    Destructors.$destroy(t);
                }
            }
        }

        public void swap(deque<T> other) {
            assert (this.isDataPointerLike == other.isDataPointerLike);
            ArrayList<T> impl2 = this.deque;
            this.deque = other.deque;
            other.deque = impl2;
        }

        public iterator<T> begin() {
            return new iterator(this.deque, 0);
        }

        public iterator<T> begin$Const() {
            return new iterator(this.deque, 0);
        }

        public iterator<T> end() {
            return new iterator(this.deque, this.deque.size());
        }

        public iterator<T> end$Const() {
            return new iterator(this.deque, this.deque.size());
        }

        public void insert$T(type$iterator<?, T> position, type$iterator<?, T> beg, type$iterator<?, T> end) {
            block5: {
                if (!Native.$noteq_ptr(beg, end)) break block5;
                assert (position instanceof iterator);
                int index = ((iterator)position).i;
                if (position.$eq(this.end())) {
                    beg = Native.$Clone(beg);
                    while (beg.$noteq(end)) {
                        this.push_back_impl(beg.$star());
                        beg.$preInc();
                    }
                } else {
                    end = Native.$Clone(end);
                    while (beg.$noteq(end)) {
                        T element = end.$star();
                        this.deque.add(index, Native.$tryAssign(null, element, this.isDataPointerLike));
                        end.$preDec();
                    }
                }
            }
        }

        public int size() {
            return this.deque.size();
        }

        public T $at(int i) {
            return this.deque.get(i);
        }

        public void push_front_T$C$R(T U) {
            this.deque.add(0, Native.$tryAssign(null, U, this.isDataPointerLike));
        }

        @Override
        public Iterator<T> iterator() {
            return new JavaIterator(this.begin(), this.end());
        }

        public String toString() {
            StringBuilder out = new StringBuilder(this.isDataPointerLike ? "PTRs " : "TYPEs ");
            out.append("size=").append(this.deque.size());
            for (int i = 0; i < this.deque.size(); ++i) {
                out.append("\n[").append(i).append("]");
                T elem = this.deque.get(i);
                if (this.isDataPointerLike) {
                    out.append(NativeTrace.getIdentityStr(elem));
                    continue;
                }
                out.append(String.valueOf(elem));
            }
            return out.toString();
        }

        public void emplace_back(Object ... Args) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void push_front_T$RR(T $AddrOf) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public static class iterator<T>
        implements type$iterator<iterator<T>, T>,
        Native.assignable<iterator<T>> {
            private ArrayList<T> delegate;
            private int i = 0;

            private iterator(ArrayList<T> delegate, int i) {
                this.delegate = delegate;
                this.i = i;
            }

            public iterator(iterator<T> other) {
                this.delegate = other.delegate;
                this.i = other.i;
            }

            @Override
            public T $star() {
                return this.delegate.get(this.i);
            }

            @Override
            public iterator<T> clone() {
                return new iterator<T>(this);
            }

            @Override
            public iterator<T> $preInc() {
                ++this.i;
                return this;
            }

            @Override
            public int $sub(iterator<T> iter) {
                return this.i - iter.i;
            }

            public boolean $eq(Object other) {
                return this.$eq((iterator)other);
            }

            public boolean $eq(iterator<T> other) {
                return this.i == other.i;
            }

            @Override
            public iterator<T> $assign(iterator<T> $Prm0) {
                this.delegate = $Prm0.delegate;
                this.i = $Prm0.i;
                return this;
            }

            public String toString() {
                return "[" + this.i + "] in " + this.delegate;
            }
        }
    }
}

