/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.model.llm.definitions;

import ai.grazie.model.cloud.exceptions.ExtensionsKt;
import ai.grazie.model.llm.chat.LLMChatRole;
import ai.grazie.model.llm.chat.v5.LLMChat;
import ai.grazie.model.llm.definitions.ChatDefinition;
import ai.grazie.model.llm.definitions.LLMFeatureDefinition;
import ai.grazie.model.llm.definitions.ParameterDefinition;
import ai.grazie.model.llm.definitions.RoleDefinition;
import ai.grazie.utils.attributes.Attributes;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012$\b\u0002\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b0\u0007\u00a2\u0006\u0002\u0010\fJ$\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\n2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u001cJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J%\u0010\u001f\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b0\u0007H\u00c6\u0003JC\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052$\b\u0002\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b0\u0007H\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\t\u0010'\u001a\u00020\u001aH\u00d6\u0001J\u0016\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020,R-\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006-"}, d2={"Lai/grazie/model/llm/definitions/ChatDefinition;", "Lai/grazie/model/llm/definitions/LLMFeatureDefinition;", "roleDefinition", "Lai/grazie/model/llm/definitions/RoleDefinition;", "parameterDefinition", "Lai/grazie/model/llm/definitions/ParameterDefinition;", "options", "", "Lai/grazie/utils/attributes/Attributes$Key;", "Lkotlin/Function1;", "Lai/grazie/utils/attributes/Attributes;", "Lai/grazie/model/llm/definitions/OptionConfigurer;", "(Lai/grazie/model/llm/definitions/RoleDefinition;Lai/grazie/model/llm/definitions/ParameterDefinition;Ljava/util/Map;)V", "getOptions", "()Ljava/util/Map;", "getParameterDefinition", "()Lai/grazie/model/llm/definitions/ParameterDefinition;", "getRoleDefinition", "()Lai/grazie/model/llm/definitions/RoleDefinition;", "supportedRoles", "", "Lai/grazie/model/llm/chat/LLMChatRole;", "getSupportedRoles", "()Ljava/util/Set;", "applyOptions", "profileName", "", "attributes", "", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "validateChat", "", "name", "chat", "Lai/grazie/model/llm/chat/v5/LLMChat;", "model-llm"})
@SourceDebugExtension(value={"SMAP\nChatDefinition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatDefinition.kt\nai/grazie/model/llm/definitions/ChatDefinition\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1789#2,3:81\n*S KotlinDebug\n*F\n+ 1 ChatDefinition.kt\nai/grazie/model/llm/definitions/ChatDefinition\n*L\n42#1:81,3\n*E\n"})
public final class ChatDefinition
implements LLMFeatureDefinition {
    @NotNull
    private final RoleDefinition roleDefinition;
    @NotNull
    private final ParameterDefinition parameterDefinition;
    @NotNull
    private final Map<Attributes.Key, Function1<Attributes, Attributes>> options;

    public ChatDefinition(@NotNull RoleDefinition roleDefinition, @NotNull ParameterDefinition parameterDefinition, @NotNull Map<Attributes.Key, ? extends Function1<? super Attributes, ? extends Attributes>> options) {
        Intrinsics.checkNotNullParameter((Object)roleDefinition, (String)"roleDefinition");
        Intrinsics.checkNotNullParameter((Object)parameterDefinition, (String)"parameterDefinition");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        this.roleDefinition = roleDefinition;
        this.parameterDefinition = parameterDefinition;
        this.options = options;
    }

    public /* synthetic */ ChatDefinition(RoleDefinition roleDefinition, ParameterDefinition parameterDefinition, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        this(roleDefinition, parameterDefinition, map);
    }

    @NotNull
    public final RoleDefinition getRoleDefinition() {
        return this.roleDefinition;
    }

    @Override
    @NotNull
    public ParameterDefinition getParameterDefinition() {
        return this.parameterDefinition;
    }

    @NotNull
    public final Map<Attributes.Key, Function1<Attributes, Attributes>> getOptions() {
        return this.options;
    }

    public final void validateChat(@NotNull String name, @NotNull LLMChat chat) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
        ExtensionsKt.requireOrBadRequest((!(chat.getMessages().length == 0) ? 1 : 0) != 0, (Function0)validateChat.1.INSTANCE);
        this.roleDefinition.validateMessages(name, chat.getMessages());
    }

    @NotNull
    public final Set<LLMChatRole> getSupportedRoles() {
        return this.roleDefinition.getSupportedRoles();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Attributes applyOptions(@NotNull String profileName, @NotNull Attributes attributes, @NotNull List<? extends Attributes.Key> options) {
        Intrinsics.checkNotNullParameter((Object)profileName, (String)"profileName");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Iterable $this$fold$iv = options;
        boolean $i$f$fold = false;
        Attributes accumulator$iv = attributes;
        for (Object element$iv : $this$fold$iv) {
            void option;
            Attributes.Key key = (Attributes.Key)element$iv;
            Attributes acc = accumulator$iv;
            boolean bl = false;
            Function1<Attributes, Attributes> configurator = this.options.get(option);
            ExtensionsKt.requireNotNullOrBadRequest(configurator, (Function0)((Function0)new Function0<String>((Attributes.Key)option, profileName){
                final /* synthetic */ Attributes.Key $option;
                final /* synthetic */ String $profileName;
                {
                    this.$option = $option;
                    this.$profileName = $profileName;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Option " + this.$option.getFqdn() + "} is not supported for " + this.$profileName + " profile";
                }
            }));
            accumulator$iv = (Attributes)configurator.invoke((Object)acc);
        }
        return accumulator$iv;
    }

    @NotNull
    public final RoleDefinition component1() {
        return this.roleDefinition;
    }

    @NotNull
    public final ParameterDefinition component2() {
        return this.parameterDefinition;
    }

    @NotNull
    public final Map<Attributes.Key, Function1<Attributes, Attributes>> component3() {
        return this.options;
    }

    @NotNull
    public final ChatDefinition copy(@NotNull RoleDefinition roleDefinition, @NotNull ParameterDefinition parameterDefinition, @NotNull Map<Attributes.Key, ? extends Function1<? super Attributes, ? extends Attributes>> options) {
        Intrinsics.checkNotNullParameter((Object)roleDefinition, (String)"roleDefinition");
        Intrinsics.checkNotNullParameter((Object)parameterDefinition, (String)"parameterDefinition");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        return new ChatDefinition(roleDefinition, parameterDefinition, options);
    }

    public static /* synthetic */ ChatDefinition copy$default(ChatDefinition chatDefinition, RoleDefinition roleDefinition, ParameterDefinition parameterDefinition, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            roleDefinition = chatDefinition.roleDefinition;
        }
        if ((n & 2) != 0) {
            parameterDefinition = chatDefinition.parameterDefinition;
        }
        if ((n & 4) != 0) {
            map = chatDefinition.options;
        }
        return chatDefinition.copy(roleDefinition, parameterDefinition, map);
    }

    @NotNull
    public String toString() {
        return "ChatDefinition(roleDefinition=" + this.roleDefinition + ", parameterDefinition=" + this.parameterDefinition + ", options=" + this.options + ")";
    }

    public int hashCode() {
        int result = this.roleDefinition.hashCode();
        result = result * 31 + this.parameterDefinition.hashCode();
        result = result * 31 + ((Object)this.options).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ChatDefinition)) {
            return false;
        }
        ChatDefinition chatDefinition = (ChatDefinition)other;
        if (!Intrinsics.areEqual((Object)this.roleDefinition, (Object)chatDefinition.roleDefinition)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.parameterDefinition, (Object)chatDefinition.parameterDefinition)) {
            return false;
        }
        return Intrinsics.areEqual(this.options, chatDefinition.options);
    }
}

