/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lexer.html;

import fleet.com.intellij.html.embedding.HtmlEmbeddedContentProvider;
import fleet.com.intellij.html.embedding.HtmlEmbeddedContentSupport;
import fleet.com.intellij.html.embedding.HtmlEmbedment;
import fleet.com.intellij.lexer.DelegateLexer;
import fleet.com.intellij.lexer.Lexer;
import fleet.com.intellij.lexer.LexerPosition;
import fleet.com.intellij.lexer.RestartableLexer;
import fleet.com.intellij.lexer.TokenIterator;
import fleet.com.intellij.lexer.html.HtmlDefaultEmbeddedContentSupport;
import fleet.com.intellij.openapi.util.Pair;
import fleet.com.intellij.openapi.util.TextRange;
import fleet.com.intellij.psi.TokenType;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import fleet.com.intellij.psi.xml.XmlTokenType;
import fleet.com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseHtmlLexer
extends DelegateLexer
implements RestartableLexer {
    protected static final int BASE_STATE_MASK = 63;
    private static final int CONTENT_PROVIDER_HAS_STATE = 64;
    private static final int IS_WITHIN_TAG_STATE = 128;
    protected static final int BASE_STATE_SHIFT = 9;
    protected static final TokenSet ATTRIBUTE_EMBEDMENT_TOKENS = TokenSet.create((IElementType[])new IElementType[]{XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN, XmlTokenType.XML_ENTITY_REF_TOKEN, XmlTokenType.XML_CHAR_ENTITY_REF});
    protected static final TokenSet TAG_EMBEDMENT_START_TOKENS = TokenSet.create((IElementType[])new IElementType[]{XmlTokenType.XML_DATA_CHARACTERS, XmlTokenType.XML_CDATA_START, XmlTokenType.XML_COMMENT_START, XmlTokenType.XML_START_TAG_START, XmlTokenType.XML_REAL_WHITE_SPACE, XmlTokenType.XML_END_TAG_START, TokenType.WHITE_SPACE, XmlTokenType.XML_ENTITY_REF_TOKEN, XmlTokenType.XML_CHAR_ENTITY_REF});
    private boolean isWithinTag = false;
    protected final boolean caseInsensitive;
    private final List<HtmlEmbeddedContentProvider> myEmbeddedContentProviders;
    private final TokenSet myTagEmbedmentStartTokens;
    private final TokenSet myAttributeEmbedmentTokens;
    private HtmlEmbedment myHtmlEmbedmentInfo;
    static final TokenSet TOKENS_TO_MERGE = TokenSet.create((IElementType[])new IElementType[]{XmlTokenType.XML_COMMENT_CHARACTERS, XmlTokenType.XML_WHITE_SPACE, XmlTokenType.XML_REAL_WHITE_SPACE, XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN, XmlTokenType.XML_DATA_CHARACTERS, XmlTokenType.XML_TAG_CHARACTERS});

    protected BaseHtmlLexer(@NotNull Lexer _baseLexer, boolean _caseInsensitive) {
        super(_baseLexer);
        this.caseInsensitive = _caseInsensitive;
        List<HtmlEmbeddedContentSupport> supports = this.getEmbeddedContentSupportList();
        this.myEmbeddedContentProviders = supports.stream().map(factory -> factory.createEmbeddedContentProviders(this)).flatMap(Collection::stream).filter(this::acceptEmbeddedContentProvider).toList();
        this.myTagEmbedmentStartTokens = this.createTagEmbedmentStartTokenSet();
        this.myAttributeEmbedmentTokens = this.createAttributeEmbedmentTokenSet();
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        super.start(buffer, startOffset, endOffset, initialState & 0x3F);
        if ((initialState & 0x40) != 0) {
            throw new IllegalStateException("Cannot restore HTML Lexer to a position, in which an embedded content provider has state. Use restoreLocation() method.");
        }
        this.isWithinTag = (initialState & 0x80) != 0;
        this.myHtmlEmbedmentInfo = null;
        this.myEmbeddedContentProviders.forEach(provider -> provider.restoreState(null));
        this.broadcastToken();
    }

    public boolean isRestartableState(int state) {
        return (state & 0x40) == 0;
    }

    public int getStartState() {
        return 0;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState, TokenIterator tokenIterator) {
        this.start(buffer, startOffset, endOffset, initialState);
    }

    public void advance() {
        if (this.myHtmlEmbedmentInfo != null) {
            this.restartAfterEmbedment(this.myHtmlEmbedmentInfo.getRange().getEndOffset(), this.myHtmlEmbedmentInfo.getBaseLexerState());
        } else {
            super.advance();
        }
        this.broadcastToken();
        this.myHtmlEmbedmentInfo = null;
    }

    protected void restartAfterEmbedment(int offset, int baseLexerState) {
        this.myDelegate.start(this.myDelegate.getBufferSequence(), offset, this.myDelegate.getBufferEnd(), baseLexerState);
    }

    @NotNull
    protected TokenSet createTagEmbedmentStartTokenSet() {
        return TAG_EMBEDMENT_START_TOKENS;
    }

    @NotNull
    protected TokenSet createAttributeEmbedmentTokenSet() {
        return ATTRIBUTE_EMBEDMENT_TOKENS;
    }

    public int getStateForRestartDuringEmbedmentScan() {
        return 0;
    }

    private void broadcastToken() {
        IElementType type = this.myDelegate.getTokenType();
        if (type != null) {
            TextRange textRange = new TextRange(this.myDelegate.getTokenStart(), this.myDelegate.getTokenEnd());
            this.myEmbeddedContentProviders.forEach(provider -> provider.handleToken(type, textRange));
            if (type == XmlTokenType.XML_NAME && this.isHtmlTagState(super.getState())) {
                this.isWithinTag = true;
            } else if (type == XmlTokenType.XML_TAG_END || type == XmlTokenType.XML_EMPTY_ELEMENT_END) {
                this.isWithinTag = false;
            }
        }
    }

    public int getState() {
        int state = super.getState();
        if (this.myHtmlEmbedmentInfo != null || ContainerUtil.find(this.myEmbeddedContentProviders, provider -> provider.hasState()) != null) {
            state |= 0x40;
        }
        if (this.isWithinTag) {
            state |= 0x80;
        }
        return state;
    }

    @Nullable
    protected HtmlEmbedment acquireHtmlEmbedmentInfo() {
        IElementType type = this.myDelegate.getTokenType();
        if (type != null) {
            for (HtmlEmbeddedContentProvider provider : this.myEmbeddedContentProviders) {
                HtmlEmbedment embedment = provider.createEmbedment(type);
                if (embedment == null) continue;
                this.myEmbeddedContentProviders.forEach(HtmlEmbeddedContentProvider::clearEmbedment);
                return embedment;
            }
        }
        return null;
    }

    @NotNull
    public LexerPosition getCurrentPosition() {
        return new HtmlLexerPosition(this.getTokenStart(), this.getState() & 0xFFFFFFBF, this.myDelegate.getCurrentPosition(), this.myEmbeddedContentProviders.stream().map(provider -> new Pair(provider, provider.getState())).filter(pair -> pair.second != null).collect(Collectors.toMap(p -> (HtmlEmbeddedContentProvider)p.first, p -> p.second)));
    }

    public void restore(@NotNull LexerPosition position) {
        super.restore(position);
        this.myDelegate.restore(((HtmlLexerPosition)position).myDelegateLexerPosition);
        Map<HtmlEmbeddedContentProvider, Object> providersState = ((HtmlLexerPosition)position).myProvidersState;
        this.myEmbeddedContentProviders.forEach(provider -> provider.restoreState(providersState.get(provider)));
    }

    protected void skipEmbedment(@NotNull HtmlEmbedment embedment) {
        this.myHtmlEmbedmentInfo = embedment;
    }

    protected int getBaseStateShift() {
        return 9;
    }

    protected boolean isWithinTag() {
        return this.isWithinTag;
    }

    protected boolean isAttributeEmbedmentToken(@NotNull IElementType tokenType, @NotNull CharSequence attributeName) {
        return this.myAttributeEmbedmentTokens.contains(tokenType);
    }

    protected boolean isTagEmbedmentStartToken(@NotNull IElementType tokenType, @NotNull CharSequence tagName) {
        return this.myTagEmbedmentStartTokens.contains(tokenType);
    }

    @NotNull
    protected List<HtmlEmbeddedContentSupport> getEmbeddedContentSupportList() {
        ArrayList<HtmlEmbeddedContentSupport> supports = new ArrayList<HtmlEmbeddedContentSupport>();
        try {
            HtmlEmbeddedContentSupport.Companion.getContentSupports().filter(support -> support.isEnabled(this)).forEach(supports::add);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        supports.add(new HtmlDefaultEmbeddedContentSupport());
        return supports;
    }

    protected boolean acceptEmbeddedContentProvider(@NotNull HtmlEmbeddedContentProvider provider) {
        return true;
    }

    public boolean isPossiblyCustomTagName(@NotNull CharSequence tagName) {
        return false;
    }

    protected boolean isHtmlTagState(int state) {
        return state == 6 || state == 8;
    }

    private static class HtmlLexerPosition
    implements LexerPosition {
        private final int myOffset;
        private final int myState;
        final LexerPosition myDelegateLexerPosition;
        final Map<HtmlEmbeddedContentProvider, Object> myProvidersState;

        HtmlLexerPosition(int offset, int state, LexerPosition delegateLexerPosition, Map<HtmlEmbeddedContentProvider, Object> providersState) {
            this.myOffset = offset;
            this.myState = state;
            this.myDelegateLexerPosition = delegateLexerPosition;
            this.myProvidersState = providersState;
        }

        public int getOffset() {
            return this.myOffset;
        }

        public int getState() {
            return this.myState;
        }
    }
}

