/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lang.xml;

import fleet.com.intellij.lang.ASTNode;
import fleet.com.intellij.lang.ParserDefinition;
import fleet.com.intellij.lang.PsiParser;
import fleet.com.intellij.lexer.Lexer;
import fleet.com.intellij.lexer.html.XmlLexer;
import fleet.com.intellij.openapi.project.Project;
import fleet.com.intellij.psi.FileViewProvider;
import fleet.com.intellij.psi.PsiElement;
import fleet.com.intellij.psi.PsiFile;
import fleet.com.intellij.psi.impl.source.parsing.xml.XmlParser;
import fleet.com.intellij.psi.tree.IFileElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import fleet.com.intellij.psi.xml.XmlElementType;
import fleet.com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NotNull;

public class XMLParserDefinition
implements ParserDefinition {
    public static ParserDefinition.SpaceRequirements canStickTokensTogetherByLexerInXml(ASTNode left, ASTNode right) {
        if (left.getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN || right.getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
            return ParserDefinition.SpaceRequirements.MUST_NOT;
        }
        if (left.getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER && right.getElementType() == XmlTokenType.XML_NAME) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        if (left.getElementType() == XmlTokenType.XML_NAME && right.getElementType() == XmlTokenType.XML_NAME) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        if (left.getElementType() == XmlTokenType.XML_TAG_NAME && right.getElementType() == XmlTokenType.XML_NAME) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        return ParserDefinition.SpaceRequirements.MAY;
    }

    @NotNull
    public Lexer createLexer(Project project) {
        return new XmlLexer();
    }

    @NotNull
    public PsiParser createParser(Project project) {
        return new XmlParser();
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        return XmlElementType.XML_FILE;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return XmlTokenType.COMMENTS;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        return XmlTokenType.WHITESPACES;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        return TokenSet.EMPTY;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        throw new IllegalStateException();
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        throw new IllegalStateException();
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return XMLParserDefinition.canStickTokensTogetherByLexerInXml(left, right);
    }
}

