/*
 * Decompiled with CFR 0.152.
 */
package noria.impl;

import androidx.compose.runtime.RememberObserver;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import noria.impl.SlotKind;
import noria.impl.Trace;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\f\u001a\u00020\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003J\b\u0010\u000f\u001a\u00020\rH\u0002J\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0001J\u0006\u0010\u0011\u001a\u00020\u0003J\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0003J\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0001J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0006\u0010\u0019\u001a\u00020\rJ\u000e\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0003J\u0006\u0010\u001b\u001a\u00020\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u00010\bj\b\u0012\u0004\u0012\u00020\u0001`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lnoria/impl/TraceWriter;", "", "initialCapacity", "", "(I)V", "destroyables", "Lit/unimi/dsi/fastutil/ints/IntArrayList;", "objects", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "slots", "stack", "balance", "", "b", "checkThread", "child", "childrenCount", "close", "Lnoria/impl/Trace;", "enterIntScope", "key", "enterKeyScope", "enterScope", "keySlot", "exitScope", "id", "recycle", "Companion", "fleet.noria.cells"})
public final class TraceWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IntArrayList slots;
    @NotNull
    private final ArrayList<Object> objects;
    @NotNull
    private final IntArrayList destroyables;
    @NotNull
    private final IntArrayList stack;
    @NotNull
    private static final ArrayList<TraceWriter> cache = new ArrayList();

    public TraceWriter(int initialCapacity) {
        this.slots = new IntArrayList(initialCapacity);
        this.objects = new ArrayList(initialCapacity);
        this.destroyables = new IntArrayList(initialCapacity);
        this.stack = new IntArrayList(initialCapacity);
    }

    public final void recycle() {
        if (cache.size() < 100) {
            this.slots.clear();
            this.objects.clear();
            this.destroyables.clear();
            this.stack.clear();
            cache.add(this);
        }
    }

    public final int childrenCount() {
        return this.objects.size();
    }

    private final void checkThread() {
    }

    public final void enterIntScope(int key2) {
        this.enterScope(SlotKind.makeSlot(key2, 0));
    }

    public final void enterKeyScope(@NotNull Object key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        int keyIndex = this.objects.size();
        this.objects.add(key2);
        this.enterScope(SlotKind.makeSlot(keyIndex, 1));
    }

    private final void enterScope(int keySlot) {
        this.checkThread();
        this.slots.add(keySlot);
        this.stack.push(this.slots.size());
        this.slots.add(-1);
    }

    public final void exitScope() {
        this.checkThread();
        int ret = this.stack.popInt();
        this.slots.set(ret, this.slots.size());
    }

    public final void id(int id) {
        this.checkThread();
        this.slots.add(SlotKind.makeSlot(id, 3));
    }

    public final void child(@NotNull Object child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        this.checkThread();
        int childIndex = this.objects.size();
        if (child instanceof RememberObserver) {
            this.destroyables.add(childIndex);
        }
        this.objects.add(child);
        this.slots.add(SlotKind.makeSlot(childIndex, 2));
    }

    @NotNull
    public final Trace close() {
        int[] nArray = this.slots.toIntArray();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"toIntArray(...)");
        Object[] objectArray = this.objects.toArray();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"toArray(...)");
        int[] nArray2 = this.destroyables.toIntArray();
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"toIntArray(...)");
        return new Trace(nArray, objectArray, nArray2);
    }

    public final void balance(int b) {
        if (!(b >= 0 && this.balance() >= b)) {
            boolean bl = false;
            String string = "TraceWriter was already corrupted? " + b + " : " + this.balance();
            throw new IllegalArgumentException(string.toString());
        }
        while (this.balance() > b) {
            this.exitScope();
        }
        if (!(this.balance() == b)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final int balance() {
        return this.stack.size();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\u0005R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lnoria/impl/TraceWriter$Companion;", "", "()V", "cache", "Ljava/util/ArrayList;", "Lnoria/impl/TraceWriter;", "Lkotlin/collections/ArrayList;", "alloc", "fleet.noria.cells"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TraceWriter alloc() {
            return cache.isEmpty() ? new TraceWriter(100) : (TraceWriter)CollectionsKt.removeLast((List)cache);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

