/*
 * Decompiled with CFR 0.152.
 */
package noria.impl;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import noria.impl.Lambda;
import noria.impl.LambdaWithPath;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0000\u001a\u0018\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0000\u001a\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000*\f\b\u0000\u0010\u0011\"\u00020\f2\u00020\f\u00a8\u0006\u0012"}, d2={"CHILD_PARENT", "", "EQUAL", "OLDER_YOUNGER", "PARENT_CHILD", "YOUNGER_OLDER", "checkPath", "a", "Lnoria/impl/LambdaWithPath;", "b", "comparePaths", "p1", "", "p2", "resolvePath", "lambda", "Lnoria/impl/Lambda;", "Path", "fleet.noria.cells"})
public final class LambdaWithPathKt {
    public static final int PARENT_CHILD = 0;
    public static final int CHILD_PARENT = 1;
    public static final int EQUAL = 2;
    public static final int YOUNGER_OLDER = 3;
    public static final int OLDER_YOUNGER = 4;

    @NotNull
    public static final LambdaWithPath resolvePath(@NotNull Lambda lambda) {
        Intrinsics.checkNotNullParameter((Object)lambda, (String)"lambda");
        int[] path = new int[lambda.getDepth() + 1];
        for (Lambda currentLambda = lambda; currentLambda != null; currentLambda = currentLambda.getParent()) {
            path[currentLambda.getDepth()] = currentLambda.getOrder();
        }
        return new LambdaWithPath(path, lambda);
    }

    public static final int comparePaths(@NotNull int[] p1, @NotNull int[] p2) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        for (int i = 0; i < p1.length && i < p2.length; ++i) {
            if (p1[i] == p2[i]) continue;
            return Intrinsics.compare((int)p1[i], (int)p2[i]);
        }
        return Intrinsics.compare((int)p1.length, (int)p2.length);
    }

    public static final int checkPath(@NotNull LambdaWithPath a, @NotNull LambdaWithPath b) {
        int n;
        int i;
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (a.getLambda() == b.getLambda()) {
            return 2;
        }
        int[] aPath = a.getPath();
        int[] bPath = b.getPath();
        for (i = 0; i < aPath.length && i < bPath.length; ++i) {
            int ai = aPath[i];
            int bi = bPath[i];
            if (ai < bi) {
                return 4;
            }
            if (ai <= bi) continue;
            return 3;
        }
        int n2 = i;
        if (n2 == aPath.length) {
            n = 0;
        } else if (n2 == bPath.length) {
            n = 1;
        } else {
            String string = Arrays.toString(aPath);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = Arrays.toString(bPath);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            throw new IllegalStateException(("paths are equal but cells are not! " + string + " " + string2).toString());
        }
        return n;
    }
}

