/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.code.snippets;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.toml.TomlParser;
import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.DbContext;
import com.jetbrains.rhizomedb.EntitiesKt;
import com.jetbrains.rhizomedb.LegacyEntity;
import com.jetbrains.rhizomedb.Q;
import com.jetbrains.rhizomedb.impl.EntitiesImplKt;
import fleet.api.workspace.document.LanguageId;
import fleet.common.document.EditorEntity;
import fleet.frontend.code.snippets.ExternalSnippetsProvider;
import fleet.frontend.code.snippets.ExternalSnippetsProviderEntity;
import fleet.frontend.code.snippets.SnippetDescriptor;
import fleet.frontend.code.snippets.SnippetDescriptorKt;
import fleet.frontend.code.snippets.SnippetsEntity;
import fleet.kernel.plugins.ContributionScope;
import fleet.util.logging.KLogger;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KMutableProperty1;
import kotlin.reflect.KProperty1;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r2\u0006\u0010\u0010\u001a\u00020\u0011\u001a&\u0010\u0012\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0018\u00010\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0000\u001a\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e*\u0004\u0018\u00010\u0016H\u0002\u001a\u0012\u0010\u0017\u001a\u00020\u0018*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0007\u001a2\u0010\u001b\u001a\u00020\u0018*\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00142\u001e\u0010\u001b\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r0\u001c\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u001d"}, d2={"logger", "Lfleet/util/logging/KLogger;", "getLogger", "()Lfleet/util/logging/KLogger;", "logger$delegate", "Lkotlin/Lazy;", "availableExternalSnippetsProvider", "Lfleet/frontend/code/snippets/ExternalSnippetsProvider;", "editorEntity", "Lfleet/common/document/EditorEntity;", "lineTextUpToCaret", "", "readSnippetsFromToml", "", "", "Lfleet/frontend/code/snippets/SnippetDescriptor;", "inputStream", "Ljava/io/InputStream;", "snippetsByLanguage", "languageId", "Lfleet/api/workspace/document/LanguageId;", "asListOfStrings", "", "externalSnippetsProvider", "", "Lfleet/kernel/plugins/ContributionScope;", "provider", "snippets", "Lkotlin/Function0;", "fleet.code.frontend"})
@SourceDebugExtension(value={"SMAP\nSnippetDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SnippetDescriptor.kt\nfleet/frontend/code/snippets/SnippetDescriptorKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Entities.kt\ncom/jetbrains/rhizomedb/EntitiesKt\n+ 4 CollectionsUtil.kt\nfleet/util/CollectionsUtilKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 KLogger.kt\nfleet/util/logging/KLogger\n+ 7 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,128:1\n1#2:129\n1#2:164\n287#3,2:130\n49#4,10:132\n1549#5:142\n1620#5,3:143\n288#5,2:146\n1603#5,9:152\n1855#5:161\n1856#5:165\n1612#5:166\n1477#5:167\n1502#5,3:168\n1505#5,3:178\n1238#5,2:183\n1045#5:185\n1241#5:186\n17#6,2:148\n37#6,2:150\n37#6,2:162\n37#6,2:187\n372#7,7:171\n453#7:181\n403#7:182\n*S KotlinDebug\n*F\n+ 1 SnippetDescriptor.kt\nfleet/frontend/code/snippets/SnippetDescriptorKt\n*L\n77#1:164\n32#1:130,2\n32#1:132,10\n36#1:142\n36#1:143,3\n36#1:146,2\n77#1:152,9\n77#1:161\n77#1:165\n77#1:166\n89#1:167\n89#1:168,3\n89#1:178,3\n90#1:183,2\n91#1:185\n90#1:186\n61#1:148,2\n67#1:150,2\n86#1:162,2\n95#1:187,2\n89#1:171,7\n90#1:181\n90#1:182\n*E\n"})
public final class SnippetDescriptorKt {
    @NotNull
    private static final Lazy logger$delegate = LazyKt.lazy((Function0)logger.2.INSTANCE);

    public static final void snippets(@NotNull ContributionScope $this$snippets, @NotNull LanguageId languageId, @NotNull Function0<? extends Map<String, ? extends List<SnippetDescriptor>>> snippets2) {
        Intrinsics.checkNotNullParameter((Object)$this$snippets, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        Intrinsics.checkNotNullParameter(snippets2, (String)"snippets");
        ChangeScope.DefaultImpls.new$default((ChangeScope)((ChangeScope)$this$snippets), (KClass)Reflection.getOrCreateKotlinClass(SnippetsEntity.class), (int)0, (Function1)((Function1)new Function1<SnippetsEntity, Unit>(languageId, snippets2){
            final /* synthetic */ LanguageId $languageId;
            final /* synthetic */ Function0<Map<String, List<SnippetDescriptor>>> $snippets;
            {
                this.$languageId = $languageId;
                this.$snippets = $snippets;
                super(1);
            }

            public final void invoke(@NotNull SnippetsEntity $this$new) {
                Intrinsics.checkNotNullParameter((Object)$this$new, (String)"$this$new");
                $this$new.setLanguageId(this.$languageId);
                $this$new.setSnippets((Map)this.$snippets.invoke());
            }
        }), (int)2, null);
    }

    public static final void externalSnippetsProvider(@NotNull ContributionScope $this$externalSnippetsProvider, @NotNull ExternalSnippetsProvider provider) {
        Intrinsics.checkNotNullParameter((Object)$this$externalSnippetsProvider, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        ChangeScope.DefaultImpls.new$default((ChangeScope)((ChangeScope)$this$externalSnippetsProvider), (KClass)Reflection.getOrCreateKotlinClass(ExternalSnippetsProviderEntity.class), (int)0, (Function1)((Function1)new Function1<ExternalSnippetsProviderEntity, Unit>(provider){
            final /* synthetic */ ExternalSnippetsProvider $provider;
            {
                this.$provider = $provider;
                super(1);
            }

            public final void invoke(@NotNull ExternalSnippetsProviderEntity $this$new) {
                Intrinsics.checkNotNullParameter((Object)$this$new, (String)"$this$new");
                $this$new.setProvider(this.$provider);
            }
        }), (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Map<String, List<SnippetDescriptor>> snippetsByLanguage(@Nullable LanguageId languageId) {
        Map<String, List<SnippetDescriptor>> map2;
        LanguageId languageId2 = languageId;
        if (languageId2 != null) {
            void $this$singleOrNullOrThrowWithMessage$iv$iv;
            LanguageId it = languageId2;
            boolean bl = false;
            KMutableProperty1 prop$iv = (KMutableProperty1)snippetsByLanguage.1.1.INSTANCE;
            boolean $i$f$lookupOne = false;
            Iterable iterable = EntitiesImplKt.lookupImpl((Q)DbContext.Companion.getThreadBound().getImpl(), (KProperty1)((KProperty1)prop$iv), (Object)it, (KClass)Reflection.getOrCreateKotlinClass(SnippetsEntity.class));
            boolean $i$f$singleOrNullOrThrowWithMessage = false;
            Object single$iv$iv = null;
            boolean found$iv$iv = false;
            for (Object element$iv$iv : $this$singleOrNullOrThrowWithMessage$iv$iv) {
                if (found$iv$iv) {
                    Object t = element$iv$iv;
                    Object var12_12 = single$iv$iv;
                    boolean bl2 = false;
                    String string = " searched prop " + prop$iv + " and value " + it;
                    String string2 = "Collection contains more than one matching element: " + var12_12 + ", " + t + " " + string;
                    throw new IllegalArgumentException(string2);
                }
                single$iv$iv = element$iv$iv;
                found$iv$iv = true;
            }
            SnippetsEntity snippetsEntity = (SnippetsEntity)((LegacyEntity)single$iv$iv);
            map2 = snippetsEntity != null ? snippetsEntity.getSnippets() : null;
        } else {
            map2 = null;
        }
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final ExternalSnippetsProvider availableExternalSnippetsProvider(@NotNull EditorEntity editorEntity, @NotNull String lineTextUpToCaret) {
        Object v0;
        block2: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)editorEntity, (String)"editorEntity");
            Intrinsics.checkNotNullParameter((Object)lineTextUpToCaret, (String)"lineTextUpToCaret");
            Iterable $this$map$iv = EntitiesKt.byEntityType((KClass)Reflection.getOrCreateKotlinClass(ExternalSnippetsProviderEntity.class));
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ExternalSnippetsProviderEntity externalSnippetsProviderEntity = (ExternalSnippetsProviderEntity)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getProvider());
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ExternalSnippetsProvider it = (ExternalSnippetsProvider)element$iv;
                boolean bl = false;
                if (!it.isAvailable(editorEntity, lineTextUpToCaret)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    private static final KLogger getLogger() {
        Lazy lazy = logger$delegate;
        return (KLogger)lazy.getValue();
    }

    private static final List<String> asListOfStrings(Object $this$asListOfStrings) {
        Object object;
        try {
            List list;
            object = $this$asListOfStrings;
            if (object instanceof List) {
                Intrinsics.checkNotNull((Object)$this$asListOfStrings, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
                list = (List)$this$asListOfStrings;
            } else if (object instanceof String) {
                list = CollectionsKt.listOf((Object)$this$asListOfStrings);
            } else {
                KLogger this_$iv = SnippetDescriptorKt.getLogger();
                boolean $i$f$warn = false;
                if (this_$iv.isWarnEnabled()) {
                    KLogger kLogger = this_$iv;
                    boolean bl = false;
                    kLogger.warn((Object)("Can't convert " + $this$asListOfStrings + " into a list of strings"));
                }
                list = CollectionsKt.emptyList();
            }
            object = list;
        }
        catch (Exception e) {
            KLogger this_$iv = SnippetDescriptorKt.getLogger();
            boolean $i$f$warn = false;
            if (this_$iv.isWarnEnabled()) {
                Throwable throwable = e;
                KLogger kLogger = this_$iv;
                boolean bl = false;
                String string = "Can't convert " + $this$asListOfStrings + " into a list of strings";
                kLogger.warn(throwable, (Object)string);
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, List<SnippetDescriptor>> readSnippetsFromToml(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Object object = inputStream;
        Charset charset = Charsets.UTF_8;
        Object object2 = new InputStreamReader((InputStream)object, charset);
        int n = 8192;
        String content = TextStreamsKt.readText((Reader)(object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n)));
        try {
            void $this$mapValuesTo$iv$iv;
            Object key$iv$iv;
            Object $this$groupByTo$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            Set set = ((CommentedConfig)new TomlParser().parse(content)).entrySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"entrySet(...)");
            Iterable $this$mapNotNull$iv = set;
            boolean $i$f$mapNotNull = false;
            object2 = $this$mapNotNull$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Map it$iv$iv;
                Object map2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                CommentedConfig.Entry e = (CommentedConfig.Entry)element$iv$iv;
                boolean bl2 = false;
                try {
                    map2 = ((Config)e.getValue()).valueMap();
                    String string = (String)CollectionsKt.firstOrNull(SnippetDescriptorKt.asListOfStrings(map2.get("prefix")));
                    if (string == null) {
                        string = "";
                    }
                    String string2 = CollectionsKt.joinToString$default((Iterable)SnippetDescriptorKt.asListOfStrings(map2.get("body")), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                    String string3 = e.getKey();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getKey(...)");
                    map2 = new SnippetDescriptor(string, string2, string3, (String)map2.get("description"), false, 16, null);
                }
                catch (Exception e2) {
                    KLogger this_$iv = SnippetDescriptorKt.getLogger();
                    boolean $i$f$warn = false;
                    if (this_$iv.isWarnEnabled()) {
                        Throwable throwable = e2;
                        KLogger kLogger = this_$iv;
                        boolean bl3 = false;
                        String string = "Can't parse snippets";
                        kLogger.warn(throwable, (Object)string);
                    }
                    map2 = null;
                }
                if (map2 == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$groupBy$iv = (List)destination$iv$iv;
            boolean $i$f$groupBy = false;
            $this$mapNotNullTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            $this$forEach$iv$iv$iv = $this$groupByTo$iv$iv.iterator();
            while ($this$forEach$iv$iv$iv.hasNext()) {
                Object object3;
                Object element$iv$iv = $this$forEach$iv$iv$iv.next();
                SnippetDescriptor it = (SnippetDescriptor)element$iv$iv;
                boolean bl = false;
                key$iv$iv = it.getPrefix();
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl5 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object3 = answer$iv$iv$iv;
                } else {
                    object3 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object3;
                list$iv$iv.add(element$iv$iv);
            }
            Object $this$mapValues$iv = destination$iv$iv;
            boolean $i$f$mapValues = false;
            $this$groupByTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                key$iv$iv = (Map.Entry)element$iv$iv$iv;
                Object object4 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Object object5 = object4;
                boolean bl6 = false;
                List values = (List)entry.getValue();
                Iterable $this$sortedBy$iv = values;
                boolean $i$f$sortedBy = false;
                List list = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        SnippetDescriptor it = (SnippetDescriptor)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getKey());
                        it = (SnippetDescriptor)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getKey())));
                    }
                });
                object5.put(k, list);
            }
            object = destination$iv$iv;
        }
        catch (ParsingException e) {
            KLogger this_$iv = SnippetDescriptorKt.getLogger();
            boolean $i$f$warn = false;
            if (this_$iv.isWarnEnabled()) {
                Throwable throwable = e;
                KLogger kLogger = this_$iv;
                boolean bl = false;
                String string = "Can't parse snippets";
                kLogger.warn(throwable, (Object)string);
            }
            return MapsKt.emptyMap();
        }
        return object;
    }
}

