/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.grazie.frontend;

import andel.text.IntersectionType;
import andel.text.TextRange;
import andel.text.TextRangeKt;
import fleet.ast.SyntexNodeExtKt;
import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import fleet.com.jetbrains.lang.syntax.SyntaxNodeExtKt;
import fleet.plugins.grazie.frontend.AstTextContent;
import fleet.plugins.grazie.frontend.AstToken;
import fleet.plugins.grazie.frontend.TextContent;
import fleet.plugins.grazie.frontend.TextContentBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010#\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0002 !BC\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\t\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\u0010\u001a\u00020\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00120\tJ\u001a\u0010\u0013\u001a\u00020\u000f2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00120\tJ\u001a\u0010\u0015\u001a\u00020\u000f2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00120\tJ$\u0010\u0017\u001a\u00020\u000f2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00120\t2\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J\u000e\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u001bJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\nR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lfleet/plugins/grazie/frontend/TextContentBuilder;", "", "indentChars", "", "", "suffixChars", "range", "Landel/text/TextRange;", "classifier", "Lkotlin/Function1;", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "Lfleet/plugins/grazie/frontend/TextContent$ExclusionKind;", "<init>", "(Ljava/util/Set;Ljava/util/Set;Landel/text/TextRange;Lkotlin/jvm/functions/Function1;)V", "withRange", "", "withUnknown", "unknown", "", "excluding", "excluded", "withMarkup", "markup", "appendClassifier", "predicate", "kind", "removeIndents", "", "removeLineSuffixes", "build", "Lfleet/plugins/grazie/frontend/AstTextContent;", "root", "Companion", "TextContentCollector", "fleet.plugins.grazie.frontend"})
@SourceDebugExtension(value={"SMAP\nTextContentBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextContentBuilder.kt\nfleet/plugins/grazie/frontend/TextContentBuilder\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,104:1\n37#2,2:105\n*S KotlinDebug\n*F\n+ 1 TextContentBuilder.kt\nfleet/plugins/grazie/frontend/TextContentBuilder\n*L\n60#1:105,2\n*E\n"})
public final class TextContentBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<Character> indentChars;
    @NotNull
    private final Set<Character> suffixChars;
    @Nullable
    private TextRange range;
    @NotNull
    private Function1<? super SyntaxNode, ? extends TextContent.ExclusionKind> classifier;

    public TextContentBuilder(@NotNull Set<Character> indentChars, @NotNull Set<Character> suffixChars, @Nullable TextRange range, @NotNull Function1<? super SyntaxNode, ? extends TextContent.ExclusionKind> classifier) {
        Intrinsics.checkNotNullParameter(indentChars, (String)"indentChars");
        Intrinsics.checkNotNullParameter(suffixChars, (String)"suffixChars");
        Intrinsics.checkNotNullParameter(classifier, (String)"classifier");
        this.indentChars = indentChars;
        this.suffixChars = suffixChars;
        this.range = range;
        this.classifier = classifier;
    }

    public final void withRange(@NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this.range = range;
    }

    public final void withUnknown(@NotNull Function1<? super SyntaxNode, Boolean> unknown) {
        Intrinsics.checkNotNullParameter(unknown, (String)"unknown");
        this.appendClassifier(unknown, TextContent.ExclusionKind.Unknown);
    }

    public final void excluding(@NotNull Function1<? super SyntaxNode, Boolean> excluded) {
        Intrinsics.checkNotNullParameter(excluded, (String)"excluded");
        this.appendClassifier(excluded, TextContent.ExclusionKind.Exclude);
    }

    public final void withMarkup(@NotNull Function1<? super SyntaxNode, Boolean> markup2) {
        Intrinsics.checkNotNullParameter(markup2, (String)"markup");
        this.appendClassifier(markup2, TextContent.ExclusionKind.Markup);
    }

    private final void appendClassifier(Function1<? super SyntaxNode, Boolean> predicate, TextContent.ExclusionKind kind) {
        Function1<? super SyntaxNode, ? extends TextContent.ExclusionKind> prev = this.classifier;
        this.classifier = (Function1)new Function1<SyntaxNode, TextContent.ExclusionKind>(prev, predicate, kind){
            final /* synthetic */ Function1<SyntaxNode, TextContent.ExclusionKind> $prev;
            final /* synthetic */ Function1<SyntaxNode, Boolean> $predicate;
            final /* synthetic */ TextContent.ExclusionKind $kind;
            {
                this.$prev = $prev;
                this.$predicate = $predicate;
                this.$kind = $kind;
                super(1);
            }

            public final TextContent.ExclusionKind invoke(SyntaxNode e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TextContent.ExclusionKind exclusionKind = (TextContent.ExclusionKind)((Object)this.$prev.invoke((Object)e));
                if (exclusionKind == null) {
                    exclusionKind = (Boolean)this.$predicate.invoke((Object)e) != false ? this.$kind : null;
                }
                return exclusionKind;
            }
        };
    }

    public final void removeIndents(@NotNull String indentChars) {
        Intrinsics.checkNotNullParameter((Object)indentChars, (String)"indentChars");
        int n = indentChars.length();
        for (int i = 0; i < n; ++i) {
            char element = indentChars.charAt(i);
            this.indentChars.add(Character.valueOf(element));
        }
    }

    public final void removeLineSuffixes(@NotNull String suffixChars) {
        Intrinsics.checkNotNullParameter((Object)suffixChars, (String)"suffixChars");
        int n = suffixChars.length();
        for (int i = 0; i < n; ++i) {
            char element = suffixChars.charAt(i);
            this.suffixChars.add(Character.valueOf(element));
        }
    }

    @Nullable
    public final AstTextContent build(@NotNull SyntaxNode root) {
        AstTextContent astTextContent;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        List<AstToken> tokens = new TextContentCollector(root, this.range, this.classifier).collect();
        if (tokens.isEmpty()) {
            astTextContent = null;
        } else {
            Collection $this$toTypedArray$iv = tokens;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            astTextContent = ((AstTextContent)((AstTextContent)new AstTextContent(root, thisCollection$iv.toArray(new AstToken[0])).removeIndents((Set)this.indentChars)).removeLineSuffixes((Set)this.suffixChars)).trimWhitespace();
        }
        return astTextContent;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lfleet/plugins/grazie/frontend/TextContentBuilder$Companion;", "", "<init>", "()V", "Default", "Lfleet/plugins/grazie/frontend/TextContentBuilder;", "getDefault", "()Lfleet/plugins/grazie/frontend/TextContentBuilder;", "fleet.plugins.grazie.frontend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TextContentBuilder getDefault() {
            return new TextContentBuilder(new LinkedHashSet(), new LinkedHashSet(), null, (Function1<? super SyntaxNode, ? extends TextContent.ExclusionKind>)((Function1)Default.1.INSTANCE));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u000fj\u0002`\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lfleet/plugins/grazie/frontend/TextContentBuilder$TextContentCollector;", "", "root", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "range", "Landel/text/TextRange;", "classifier", "Lkotlin/Function1;", "Lfleet/plugins/grazie/frontend/TextContent$ExclusionKind;", "<init>", "(Lfleet/com/jetbrains/lang/syntax/SyntaxNode;Landel/text/TextRange;Lkotlin/jvm/functions/Function1;)V", "tokens", "", "Lfleet/plugins/grazie/frontend/AstToken;", "rootStart", "", "Landel/text/CharOffset;", "fileValueRange", "currentStart", "exclusionStarted", "", "visitElement", "element", "collect", "", "fleet.plugins.grazie.frontend"})
    @SourceDebugExtension(value={"SMAP\nTextContentBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextContentBuilder.kt\nfleet/plugins/grazie/frontend/TextContentBuilder$TextContentCollector\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,104:1\n1317#2,2:105\n*S KotlinDebug\n*F\n+ 1 TextContentBuilder.kt\nfleet/plugins/grazie/frontend/TextContentBuilder$TextContentCollector\n*L\n89#1:105,2\n*E\n"})
    private static final class TextContentCollector {
        @NotNull
        private final SyntaxNode root;
        @NotNull
        private final Function1<SyntaxNode, TextContent.ExclusionKind> classifier;
        @NotNull
        private final List<AstToken> tokens;
        private final long rootStart;
        @NotNull
        private final TextRange fileValueRange;
        private long currentStart;

        public TextContentCollector(@NotNull SyntaxNode root, @Nullable TextRange range, @NotNull Function1<? super SyntaxNode, ? extends TextContent.ExclusionKind> classifier) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter(classifier, (String)"classifier");
            this.root = root;
            this.classifier = classifier;
            this.tokens = new ArrayList();
            this.rootStart = SyntexNodeExtKt.getTextRange((SyntaxNode)this.root).getStart();
            TextRange textRange = range;
            if (textRange == null) {
                textRange = TextRangeKt.shift((TextRange)new TextRange(0, this.root.getText().length()), (long)this.rootStart);
            }
            this.fileValueRange = textRange;
            this.currentStart = this.fileValueRange.getStart();
        }

        private final void exclusionStarted(TextRange range) {
            if (range.getStart() != this.currentStart) {
                TextRange tokenRange = new TextRange(this.currentStart, range.getStart());
                this.tokens.add(new AstToken(this.root, TextRangeKt.shift((TextRange)tokenRange, (long)(-this.rootStart)), AstToken.Kind.Text));
            }
            this.currentStart = range.getEnd();
        }

        private final void visitElement(SyntaxNode element) {
            Pair pair = TextRangeKt.intersect((TextRange)SyntexNodeExtKt.getTextRange((SyntaxNode)element), (TextRange)this.fileValueRange);
            TextRange range = (TextRange)pair.component1();
            IntersectionType type = (IntersectionType)pair.component2();
            if (type != IntersectionType.Inside) {
                return;
            }
            TextContent.ExclusionKind kind = (TextContent.ExclusionKind)((Object)this.classifier.invoke((Object)element));
            if (kind == TextContent.ExclusionKind.Exclude) {
                this.exclusionStarted(range);
            } else if (kind != null) {
                this.exclusionStarted(range);
                AstToken.Kind tokenKind = kind == TextContent.ExclusionKind.Markup ? AstToken.Kind.Markup : AstToken.Kind.Unknown;
                this.tokens.add(new AstToken(this.root, TextRangeKt.shift((TextRange)new TextRange(range.getStart(), range.getStart()), (long)(-this.rootStart)), tokenKind));
            } else {
                Sequence $this$forEach$iv = SyntaxNodeExtKt.children((SyntaxNode)element);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SyntaxNode it = (SyntaxNode)element$iv;
                    boolean bl = false;
                    this.visitElement(it);
                }
            }
        }

        @NotNull
        public final List<AstToken> collect() {
            this.visitElement(this.root);
            this.exclusionStarted(new TextRange(this.fileValueRange.getEnd(), this.fileValueRange.getEnd()));
            return CollectionsKt.toList((Iterable)this.tokens);
        }
    }
}

