/*
 * Decompiled with CFR 0.152.
 */
package fleet.net;

import fleet.net.HttpProxyConfiguration;
import fleet.util.logging.KLogger;
import fleet.util.logging.KLoggers;
import io.ktor.client.HttpClient;
import io.ktor.client.engine.HttpClientEngine;
import io.ktor.client.engine.HttpClientEngineCapability;
import io.ktor.client.engine.HttpClientEngineConfig;
import io.ktor.client.request.HttpRequestData;
import io.ktor.client.request.HttpResponseData;
import io.ktor.http.URLProtocol;
import io.ktor.http.Url;
import io.ktor.util.InternalAPI;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineDispatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&B-\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0097@\u00a2\u0006\u0002\u0010\"J\u0010\u0010#\u001a\u00020\u00012\u0006\u0010$\u001a\u00020%H\u0002R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0017\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00190\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006'"}, d2={"Lfleet/net/ProxyDelegatingClientEngine;", "Lio/ktor/client/engine/HttpClientEngine;", "httpProxyConfiguration", "Lfleet/net/HttpProxyConfiguration;", "delegateEngine", "httpProxyEngine", "httpsProxyEngine", "<init>", "(Lfleet/net/HttpProxyConfiguration;Lio/ktor/client/engine/HttpClientEngine;Lio/ktor/client/engine/HttpClientEngine;Lio/ktor/client/engine/HttpClientEngine;)V", "getHttpProxyConfiguration", "()Lfleet/net/HttpProxyConfiguration;", "config", "Lio/ktor/client/engine/HttpClientEngineConfig;", "getConfig", "()Lio/ktor/client/engine/HttpClientEngineConfig;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "getDispatcher", "()Lkotlinx/coroutines/CoroutineDispatcher;", "supportedCapabilities", "", "Lio/ktor/client/engine/HttpClientEngineCapability;", "getSupportedCapabilities", "()Ljava/util/Set;", "close", "", "execute", "Lio/ktor/client/request/HttpResponseData;", "data", "Lio/ktor/client/request/HttpRequestData;", "(Lio/ktor/client/request/HttpRequestData;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "selectEngine", "url", "Lio/ktor/http/Url;", "Companion", "fleet.util.network"})
@SourceDebugExtension(value={"SMAP\nHttpProxyExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpProxyExtensions.kt\nfleet/net/ProxyDelegatingClientEngine\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KLogger.kt\nfleet/util/logging/KLogger\n+ 4 KLoggers.kt\nfleet/util/logging/KLoggersKt\n*L\n1#1,159:1\n2669#2,7:160\n10#3,2:167\n25#4:169\n*S KotlinDebug\n*F\n+ 1 HttpProxyExtensions.kt\nfleet/net/ProxyDelegatingClientEngine\n*L\n130#1:160,7\n141#1:167,2\n156#1:169\n*E\n"})
final class ProxyDelegatingClientEngine
implements HttpClientEngine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final HttpProxyConfiguration httpProxyConfiguration;
    @NotNull
    private final HttpClientEngine delegateEngine;
    @Nullable
    private final HttpClientEngine httpProxyEngine;
    @Nullable
    private final HttpClientEngine httpsProxyEngine;
    @NotNull
    private static final KLogger logger;

    public ProxyDelegatingClientEngine(@Nullable HttpProxyConfiguration httpProxyConfiguration, @NotNull HttpClientEngine delegateEngine, @Nullable HttpClientEngine httpProxyEngine, @Nullable HttpClientEngine httpsProxyEngine) {
        Intrinsics.checkNotNullParameter((Object)delegateEngine, (String)"delegateEngine");
        this.httpProxyConfiguration = httpProxyConfiguration;
        this.delegateEngine = delegateEngine;
        this.httpProxyEngine = httpProxyEngine;
        this.httpsProxyEngine = httpsProxyEngine;
    }

    @Nullable
    public final HttpProxyConfiguration getHttpProxyConfiguration() {
        return this.httpProxyConfiguration;
    }

    @NotNull
    public HttpClientEngineConfig getConfig() {
        return this.delegateEngine.getConfig();
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.delegateEngine.getCoroutineContext();
    }

    @NotNull
    public CoroutineDispatcher getDispatcher() {
        return this.delegateEngine.getDispatcher();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<HttpClientEngineCapability<?>> getSupportedCapabilities() {
        Object[] objectArray = new Set[3];
        objectArray[0] = this.delegateEngine.getSupportedCapabilities();
        HttpClientEngine httpClientEngine2 = this.httpProxyEngine;
        objectArray[1] = httpClientEngine2 != null ? httpClientEngine2.getSupportedCapabilities() : null;
        HttpClientEngine httpClientEngine3 = this.httpsProxyEngine;
        objectArray[2] = httpClientEngine3 != null ? httpClientEngine3.getSupportedCapabilities() : null;
        Iterable $this$reduce$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void p1;
            Iterable iterable = (Iterable)iterator$iv.next();
            Set p0 = (Set)accumulator$iv;
            boolean $i$f$_get_supportedCapabilities_$stub_for_inlining = false;
            boolean bl = false;
            accumulator$iv = CollectionsKt.intersect((Iterable)p0, (Iterable)p1);
        }
        return (Set)accumulator$iv;
    }

    public void close() {
        block1: {
            this.delegateEngine.close();
            HttpClientEngine httpClientEngine2 = this.httpProxyEngine;
            if (httpClientEngine2 != null) {
                httpClientEngine2.close();
            }
            HttpClientEngine httpClientEngine3 = this.httpsProxyEngine;
            if (httpClientEngine3 == null) break block1;
            httpClientEngine3.close();
        }
    }

    @InternalAPI
    @Nullable
    public Object execute(@NotNull HttpRequestData data, @NotNull Continuation<? super HttpResponseData> $completion) {
        HttpClientEngine selectedEngine = this.selectEngine(data.getUrl());
        KLogger this_$iv = logger;
        boolean $i$f$debug = false;
        if (this_$iv.isDebugEnabled()) {
            KLogger kLogger = this_$iv;
            boolean bl = false;
            kLogger.debug((Object)("executing http request to host " + data.getUrl().getHost() + " using engine with proxy settings: " + selectedEngine.getConfig().getProxy()));
        }
        return selectedEngine.execute(data, $completion);
    }

    private final HttpClientEngine selectEngine(Url url) {
        HttpClientEngine httpClientEngine2;
        HttpProxyConfiguration httpProxyConfiguration = this.httpProxyConfiguration;
        boolean bl = httpProxyConfiguration != null ? httpProxyConfiguration.proxyDisabledFor(url.getHost()) : false;
        if (bl) {
            return this.delegateEngine;
        }
        URLProtocol uRLProtocol = url.getProtocol();
        if (Intrinsics.areEqual((Object)uRLProtocol, (Object)URLProtocol.Companion.getHTTP())) {
            httpClientEngine2 = this.httpProxyEngine;
            if (httpClientEngine2 == null) {
                httpClientEngine2 = this.delegateEngine;
            }
        } else if (Intrinsics.areEqual((Object)uRLProtocol, (Object)URLProtocol.Companion.getHTTPS())) {
            httpClientEngine2 = this.httpsProxyEngine;
            if (httpClientEngine2 == null) {
                httpClientEngine2 = this.delegateEngine;
            }
        } else {
            httpClientEngine2 = this.delegateEngine;
        }
        return httpClientEngine2;
    }

    @InternalAPI
    public void install(@NotNull HttpClient client) {
        HttpClientEngine.DefaultImpls.install((HttpClientEngine)this, (HttpClient)client);
    }

    static {
        boolean $i$f$logger = false;
        logger = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(ProxyDelegatingClientEngine.class));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lfleet/net/ProxyDelegatingClientEngine$Companion;", "", "<init>", "()V", "logger", "Lfleet/util/logging/KLogger;", "fleet.util.network"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

