/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.lang.parsing.builder;

import fleet.com.intellij.lang.ITokenTypeRemapper;
import fleet.com.intellij.lang.LighterASTNode;
import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.lang.SyntaxTreeBuilder;
import fleet.com.intellij.lang.TokenWrapper;
import fleet.com.intellij.lang.WhitespaceSkippedCallback;
import fleet.com.intellij.lang.WhitespacesAndCommentsBinder;
import fleet.com.intellij.lang.WhitespacesBinders;
import fleet.com.intellij.openapi.diagnostic.Logger;
import fleet.com.intellij.openapi.util.UserDataHolderBase;
import fleet.com.intellij.psi.ITokenSequence;
import fleet.com.intellij.psi.TokenType;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.ILazyParseableElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import fleet.com.intellij.util.containers.IntStack;
import fleet.com.jetbrains.lang.parsing.builder.ASTMarkers;
import fleet.com.jetbrains.lang.parsing.builder.ASTMarkersImpl;
import fleet.com.jetbrains.lang.parsing.builder.ChameleonRef;
import fleet.com.jetbrains.lang.parsing.builder.MarkerOptionalData;
import fleet.com.jetbrains.lang.parsing.builder.MarkerPool;
import fleet.com.jetbrains.lang.parsing.builder.MarkerProduction;
import java.util.AbstractList;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkerPsiBuilder
extends UserDataHolderBase
implements PsiBuilder {
    static final Logger LOG = Logger.getInstance(MarkerPsiBuilder.class);
    int myCurrentLexemeIndex;
    private final Lexeme myCurrentLexeme = new Lexeme();
    private final TokenSet myWhitespaces;
    private TokenSet myComments;
    final CharSequence myText;
    private boolean myDebugMode;
    final int myLexemeCount;
    boolean myTokenTypeChecked;
    private ITokenTypeRemapper myRemapper;
    private WhitespaceSkippedCallback myWhitespaceSkippedCallback;
    private IElementType myCachedTokenType;
    private final MarkerPool myPool = new MarkerPool(this);
    final MarkerOptionalData myOptionalData = new MarkerOptionalData();
    final MarkerProduction myProduction = new MarkerProduction(this.myPool, this.myOptionalData);
    public final ITokenSequence myTokens;
    final int myStartLexeme;
    private static final String UNBALANCED_MESSAGE = "Unbalanced tree. Most probably caused by unbalanced markers. Try calling setDebugMode(true) against PsiBuilder passed to identify exact location of the problem";
    private ASTMarkersImpl myTree = null;

    public MarkerPsiBuilder(@NotNull CharSequence text, @NotNull ITokenSequence tokens, @NotNull TokenSet whitespaceTokens, @NotNull TokenSet commentTokens, int startLexeme, int lexemeCount) {
        this.myText = text;
        this.myStartLexeme = startLexeme;
        this.myWhitespaces = whitespaceTokens;
        this.myComments = commentTokens;
        this.myTokens = tokens;
        this.myLexemeCount = lexemeCount + startLexeme;
        this.myCurrentLexemeIndex = startLexeme;
        this.updateCurrentLexeme();
    }

    @Override
    public boolean isWhitespaceOrComment(@NotNull IElementType elementType) {
        return this.myWhitespaces.contains(elementType) || this.myComments.contains(elementType);
    }

    @Override
    public void enforceCommentTokens(@NotNull TokenSet tokens) {
        this.myComments = tokens;
    }

    @Override
    @NotNull
    public TokenSet getCommentTokens() {
        return this.myComments;
    }

    @Override
    @Nullable
    public PsiBuilder.Marker getLatestDoneMarker() {
        for (int index = this.myProduction.size() - 1; index >= 0; --index) {
            StartMarker marker = this.myProduction.getDoneMarkerAt(index);
            if (marker == null) continue;
            return marker;
        }
        return null;
    }

    @NotNull
    private PsiBuilder.Marker precede(StartMarker marker) {
        assert (marker.myLexemeIndex >= 0) : "Preceding disposed marker";
        if (this.myDebugMode) {
            this.myProduction.assertNoDoneMarkerAround(marker);
        }
        StartMarker pre = this.createMarker(marker.myLexemeIndex);
        this.myProduction.addBefore(pre, marker);
        return pre;
    }

    @Override
    @NotNull
    public CharSequence getOriginalText() {
        return this.myText;
    }

    @Override
    @Nullable
    public IElementType getTokenType() {
        IElementType cached = this.myCachedTokenType;
        if (cached == null) {
            this.myCachedTokenType = cached = this.calcTokenType();
        }
        return cached;
    }

    void clearCachedTokenType() {
        this.myCachedTokenType = null;
    }

    private IElementType remapCurrentToken() {
        if (this.myCachedTokenType != null) {
            return this.myCachedTokenType;
        }
        if (this.myRemapper != null) {
            this.remapCurrentToken(this.myRemapper.filter(this.myCurrentLexeme.tokenType, this.myCurrentLexeme.startOffset, this.myCurrentLexeme.endOffset, this.myText));
        }
        return this.myCurrentLexeme.tokenType;
    }

    private IElementType calcTokenType() {
        if (this.eof()) {
            return null;
        }
        if (this.myRemapper != null) {
            this.skipWhitespace();
        }
        return this.myCurrentLexeme.tokenType;
    }

    private IElementType getLexType(int index) {
        return this.myTokens.lexType(index);
    }

    @Override
    public void setTokenTypeRemapper(ITokenTypeRemapper remapper) {
        this.myRemapper = remapper;
        this.myTokenTypeChecked = false;
        this.clearCachedTokenType();
    }

    void updateCurrentLexeme() {
        if (this.myCurrentLexemeIndex < this.myLexemeCount) {
            this.myCurrentLexeme.tokenType = this.myTokens.lexType(this.myCurrentLexemeIndex);
            this.myCurrentLexeme.startOffset = this.myTokens.lexStart(this.myCurrentLexemeIndex);
            this.myCurrentLexeme.endOffset = this.myTokens.lexStart(this.myCurrentLexemeIndex + 1);
        } else {
            this.myCurrentLexeme.tokenType = TokenType.BAD_CHARACTER;
            this.myCurrentLexeme.endOffset = this.myCurrentLexeme.startOffset = this.myTokens.lexStart(this.myCurrentLexemeIndex);
        }
    }

    @Override
    public void remapCurrentToken(IElementType type) {
        if (this.myCurrentLexemeIndex < this.myLexemeCount) {
            this.myTokens.remap(this.myCurrentLexemeIndex, type);
            this.updateCurrentLexeme();
            this.clearCachedTokenType();
        }
    }

    @Override
    @Nullable
    public IElementType lookAhead(int steps) {
        int cur = this.shiftOverWhitespaceForward(this.myCurrentLexemeIndex);
        while (steps > 0) {
            cur = this.shiftOverWhitespaceForward(cur + 1);
            --steps;
        }
        return cur < this.myLexemeCount ? this.getLexType(cur) : null;
    }

    private int shiftOverWhitespaceForward(int lexIndex) {
        while (lexIndex < this.myLexemeCount && this.isWhitespaceOrComment(this.getLexType(lexIndex))) {
            ++lexIndex;
        }
        return lexIndex;
    }

    @Override
    public IElementType rawLookup(int steps) {
        int cur = this.myCurrentLexemeIndex + steps;
        return cur < this.myLexemeCount && cur >= 0 ? this.getLexType(cur) : null;
    }

    @Override
    public int rawTokenTypeStart(int steps) {
        int cur = this.myCurrentLexemeIndex + steps;
        if (cur < 0) {
            return -1;
        }
        if (cur >= this.myLexemeCount) {
            return this.getOriginalText().length();
        }
        return this.getLexemeStart(cur);
    }

    @Override
    public int rawTokenIndex() {
        return this.myCurrentLexemeIndex;
    }

    @Override
    public void setWhitespaceSkippedCallback(@Nullable WhitespaceSkippedCallback callback) {
        this.myWhitespaceSkippedCallback = callback;
    }

    @Override
    public void advanceLexer() {
        if (this.eof()) {
            return;
        }
        this.myTokenTypeChecked = false;
        ++this.myCurrentLexemeIndex;
        this.updateCurrentLexeme();
        this.clearCachedTokenType();
    }

    @Override
    public void rawAdvanceLexer(int steps) {
        if (steps < 0) {
            throw new IllegalArgumentException("Steps must be a positive integer - lexer can only be advanced. Use Marker.rollbackTo if you want to rollback PSI building.");
        }
        if (steps == 0) {
            return;
        }
        this.myCurrentLexemeIndex += steps;
        if (this.myCurrentLexemeIndex > this.myLexemeCount || this.myCurrentLexemeIndex < 0) {
            this.myCurrentLexemeIndex = this.myLexemeCount;
        }
        this.myTokenTypeChecked = false;
        this.updateCurrentLexeme();
        this.clearCachedTokenType();
    }

    private void skipWhitespace() {
        while (this.myCurrentLexemeIndex < this.myLexemeCount && this.isWhitespaceOrComment(this.remapCurrentToken())) {
            this.onSkip(this.myCurrentLexeme.tokenType, this.myCurrentLexeme.startOffset, this.myCurrentLexemeIndex + 1 < this.myLexemeCount ? this.myCurrentLexeme.endOffset : this.myText.length());
            ++this.myCurrentLexemeIndex;
            this.updateCurrentLexeme();
            this.clearCachedTokenType();
        }
    }

    private void onSkip(IElementType type, int start, int end) {
        if (this.myWhitespaceSkippedCallback != null) {
            this.myWhitespaceSkippedCallback.onSkip(type, start, end);
        }
    }

    @Override
    public int getCurrentOffset() {
        if (this.eof()) {
            return this.getOriginalText().length();
        }
        return this.myCurrentLexeme.startOffset;
    }

    private int getLexemeStart(int idx) {
        return this.myTokens.lexStart(idx);
    }

    @Override
    @Nullable
    public String getTokenText() {
        if (this.eof()) {
            return null;
        }
        IElementType type = this.getTokenType();
        if (type instanceof TokenWrapper) {
            return ((TokenWrapper)type).getValue();
        }
        return this.myText.subSequence(this.myCurrentLexeme.startOffset, this.myCurrentLexeme.endOffset).toString();
    }

    @Override
    @NotNull
    public PsiBuilder.Marker mark() {
        if (!this.myProduction.isEmpty()) {
            this.skipWhitespace();
        }
        StartMarker marker = this.createMarker(this.myCurrentLexemeIndex);
        this.myProduction.addMarker(marker);
        return marker;
    }

    @NotNull
    private StartMarker createMarker(int lexemeIndex) {
        StartMarker marker = this.myPool.allocateStartMarker();
        marker.myLexemeIndex = lexemeIndex;
        if (this.myDebugMode) {
            this.myOptionalData.notifyAllocated(marker.markerId);
        }
        return marker;
    }

    @Override
    public final boolean eof() {
        if (!this.myTokenTypeChecked) {
            this.myTokenTypeChecked = true;
            this.skipWhitespace();
        }
        return this.myCurrentLexemeIndex >= this.myLexemeCount;
    }

    private void rollbackTo(@NotNull StartMarker marker) {
        assert (marker.myLexemeIndex >= 0) : "The marker is already disposed";
        if (this.myDebugMode) {
            this.myProduction.assertNoDoneMarkerAround(marker);
        }
        this.myCurrentLexemeIndex = marker.myLexemeIndex;
        this.updateCurrentLexeme();
        this.myTokenTypeChecked = true;
        this.myProduction.rollbackTo(marker);
        this.clearCachedTokenType();
    }

    private void processDone(@NotNull StartMarker marker, @Nullable String errorMessage, @Nullable StartMarker before) {
        int doneLexeme;
        this.doValidityChecks(marker, before);
        if (errorMessage != null) {
            this.myOptionalData.setErrorMessage(marker.markerId, errorMessage);
        }
        int n = doneLexeme = before == null ? this.myCurrentLexemeIndex : before.myLexemeIndex;
        if (marker.myType.isLeftBound() && this.isEmpty(marker.myLexemeIndex, doneLexeme)) {
            marker.setCustomEdgeTokenBinders(WhitespacesBinders.DEFAULT_RIGHT_BINDER, null);
        }
        marker.myDoneLexeme = doneLexeme;
        this.myProduction.addDone(marker, before);
    }

    private boolean isEmpty(int startIdx, int endIdx) {
        for (int i = startIdx; i < endIdx; ++i) {
            IElementType token = this.getLexType(i);
            if (this.isWhitespaceOrComment(token)) continue;
            return false;
        }
        return true;
    }

    private void doValidityChecks(@NotNull StartMarker marker, @Nullable StartMarker before) {
        if (marker.isDone()) {
            LOG.error("Marker already done.");
        }
        if (this.myDebugMode) {
            this.myProduction.doHeavyChecksOnMarkerDone(marker, before);
        }
    }

    @Override
    public void error(@NotNull String messageText) {
        ProductionMarker lastMarker = this.myProduction.getStartMarkerAt(this.myProduction.size() - 1);
        if (lastMarker instanceof ErrorItem && lastMarker.myLexemeIndex == this.myCurrentLexemeIndex) {
            return;
        }
        ErrorItem marker = this.myPool.allocateErrorItem();
        marker.myMessage = messageText;
        marker.myLexemeIndex = this.myCurrentLexemeIndex;
        this.myProduction.addMarker(marker);
    }

    void assertMarkersBalanced(boolean condition, @Nullable ProductionMarker marker) {
        if (condition) {
            return;
        }
        this.reportUnbalancedMarkers(marker);
    }

    private void reportUnbalancedMarkers(@Nullable ProductionMarker marker) {
        int index = marker != null ? marker.getStartIndex() + 1 : this.myTokens.getLexemeCount();
        String context = index < this.myTokens.getLexemeCount() ? this.myText.subSequence(Math.max(0, this.getLexemeStart(index) - 1000), this.getLexemeStart(index)) : "<none>";
        LOG.error("Unbalanced tree. Most probably caused by unbalanced markers. Try calling setDebugMode(true) against PsiBuilder passed to identify exact location of the problem\ncontext: '" + context + "'");
    }

    void balanceWhiteSpaces() {
        RelativeTokenTypesView wsTokens = new RelativeTokenTypesView();
        RelativeTokenTextView tokenTextGetter = new RelativeTokenTextView();
        int lastIndex = 0;
        int size = this.myProduction.size() - 1;
        for (int i = 1; i < size; ++i) {
            int wsStartIndex;
            ProductionMarker starting = this.myProduction.getStartMarkerAt(i);
            if (starting instanceof StartMarker) {
                this.assertMarkersBalanced(((StartMarker)starting).isDone(), starting);
            }
            boolean done = starting == null;
            ProductionMarker item = starting != null ? starting : (ProductionMarker)Objects.requireNonNull(this.myProduction.getDoneMarkerAt(i));
            WhitespacesAndCommentsBinder binder = item.getBinder(done);
            int lexemeIndex = item.getLexemeIndex(done);
            boolean recursive = binder instanceof WhitespacesAndCommentsBinder.RecursiveBinder;
            int prevProductionLexIndex = recursive ? 0 : this.myProduction.getLexemeIndexAt(i - 1);
            for (wsStartIndex = Math.max(lexemeIndex, lastIndex); wsStartIndex > prevProductionLexIndex && this.isWhitespaceOrComment(this.getLexType(wsStartIndex - 1)); --wsStartIndex) {
            }
            int wsEndIndex = this.shiftOverWhitespaceForward(lexemeIndex);
            if (wsStartIndex != wsEndIndex) {
                wsTokens.configure(wsStartIndex, wsEndIndex);
                tokenTextGetter.configure(wsStartIndex);
                boolean atEnd = wsStartIndex == 0 || wsEndIndex == this.myLexemeCount;
                lexemeIndex = wsStartIndex + binder.getEdgePosition(wsTokens, atEnd, tokenTextGetter);
                item.setLexemeIndex(lexemeIndex, done);
                if (recursive) {
                    this.myProduction.confineMarkersToMaxLexeme(i, lexemeIndex);
                }
            } else if (lexemeIndex < wsStartIndex) {
                lexemeIndex = wsStartIndex;
                item.setLexemeIndex(wsStartIndex, done);
            }
            lastIndex = lexemeIndex;
        }
    }

    @Nullable
    public static String getErrorMessage(@NotNull LighterASTNode node) {
        if (node instanceof ErrorItem) {
            return ((ErrorItem)node).myMessage;
        }
        if (node instanceof StartMarker) {
            StartMarker marker = (StartMarker)node;
            if (marker.myType == TokenType.ERROR_ELEMENT) {
                return marker.myBuilder.myOptionalData.getDoneError(marker.markerId);
            }
        }
        return null;
    }

    @Override
    public void setDebugMode(boolean dbgMode) {
        this.myDebugMode = dbgMode;
    }

    @Override
    @NotNull
    public List<SyntaxTreeBuilder.Production> getProductions() {
        return new AbstractList<SyntaxTreeBuilder.Production>(){

            @Override
            public SyntaxTreeBuilder.Production get(int index) {
                return MarkerPsiBuilder.this.myProduction.getMarkerAt(index);
            }

            @Override
            public int size() {
                return MarkerPsiBuilder.this.myProduction.size();
            }
        };
    }

    @NotNull
    public ASTMarkers getRoot() {
        return this.prepareLightTree();
    }

    @NotNull
    private ASTMarkers prepareLightTree() {
        int i;
        if (this.myProduction.isEmpty()) {
            LOG.error("Parser produced no markers. Text:\n" + this.myText);
        }
        if (this.myTree != null) {
            return this.myTree;
        }
        this.myOptionalData.compact();
        this.myTokenTypeChecked = true;
        this.balanceWhiteSpaces();
        this.myTree = new ASTMarkersImpl();
        int lastErrorIndex = -1;
        int maxDepth = 0;
        int curDepth = 0;
        boolean insideChameleon = false;
        int markersInsideChameleon = 0;
        StartMarker curNode = null;
        Stack<StartMarker> nodes = new Stack<StartMarker>();
        IntStack productionIndices = new IntStack();
        IntStack markerIndices = new IntStack();
        for (i = 0; i < this.myProduction.size(); ++i) {
            int prevLexemeIndex;
            ProductionMarker item = this.myProduction.getStartMarkerAt(i);
            if (item instanceof StartMarker) {
                if (insideChameleon) {
                    ++markersInsideChameleon;
                    continue;
                }
                StartMarker marker = (StartMarker)item;
                int index = this.myTree.pushBack();
                this.myTree.setMarker(index, marker.markerId, (byte)1, this.myOptionalData.isCollapsed(marker.markerId), null, marker.myType);
                if (marker.myType instanceof ILazyParseableElementType && this.myOptionalData.isCollapsed(marker.markerId)) {
                    this.myTree.setChameleon(marker.myLexemeIndex - this.myStartLexeme, new ChameleonRef());
                    insideChameleon = true;
                }
                nodes.push(marker);
                markerIndices.push(index);
                productionIndices.push(i);
                curNode = marker;
                if (++curDepth <= maxDepth) continue;
                maxDepth = curDepth;
                continue;
            }
            if (item instanceof ErrorItem) {
                ErrorItem errorItem = (ErrorItem)item;
                int curToken = item.myLexemeIndex;
                if (curToken == lastErrorIndex) continue;
                prevLexemeIndex = i > 0 ? this.myProduction.getLexemeIndexAt(i - 1) : 0;
                int startLexeme = errorItem.getStartIndex();
                int endLexeme = errorItem.getEndIndex();
                lastErrorIndex = curToken;
                int index = this.myTree.pushBack();
                this.myTree.setMarker(index, errorItem.markerId, (byte)3, false, errorItem.myMessage, errorItem.getTokenType());
                this.myTree.setLexemeInfo(index, endLexeme - startLexeme, startLexeme - prevLexemeIndex);
                continue;
            }
            if (insideChameleon) {
                if (markersInsideChameleon != 0) {
                    --markersInsideChameleon;
                    continue;
                }
                insideChameleon = false;
            }
            this.assertMarkersBalanced(this.myProduction.getDoneMarkerAt(i) == curNode, item);
            curNode = (StartMarker)nodes.pop();
            int productionStart = productionIndices.pop();
            int markersStart = markerIndices.pop();
            prevLexemeIndex = markersStart > 0 ? this.myProduction.getLexemeIndexAt(productionStart - 1) : 0;
            int index = this.myTree.pushBack();
            this.myTree.setMarker(index, curNode.markerId, (byte)2, this.myOptionalData.isCollapsed(curNode.markerId), null, curNode.myType);
            int startLexeme = this.myProduction.getLexemeIndexAt(productionStart);
            int endLexeme = this.myProduction.getLexemeIndexAt(i);
            this.myTree.setLexemeInfo(index, endLexeme - startLexeme, startLexeme - prevLexemeIndex);
            this.myTree.setLexemeInfo(markersStart, endLexeme - startLexeme, startLexeme - prevLexemeIndex);
            this.myTree.setMarkersCount(index, index - markersStart);
            this.myTree.setMarkersCount(markersStart, index - markersStart);
            --curDepth;
        }
        for (i = 0; i < this.myLexemeCount - this.myStartLexeme; ++i) {
            if (!(this.myTokens.lexType(this.myStartLexeme + i) instanceof ILazyParseableElementType)) continue;
            this.myTree.setChameleon(i, new ChameleonRef());
        }
        this.clearCachedTokenType();
        return this.myTree;
    }

    private static class Lexeme {
        IElementType tokenType;
        int startOffset;
        int endOffset;

        private Lexeme() {
        }
    }

    static class StartMarker
    extends ProductionMarker
    implements PsiBuilder.Marker {
        IElementType myType;
        String myError;
        int myDoneLexeme = -1;
        ProductionMarker myFirstChild;
        ProductionMarker myLastChild;

        StartMarker(int markerId, MarkerPsiBuilder builder) {
            super(markerId, builder);
        }

        @Override
        void clean() {
            super.clean();
            this.myBuilder.myOptionalData.clean(this.markerId);
            this.myType = null;
            this.myDoneLexeme = -1;
            this.myLastChild = null;
            this.myFirstChild = null;
        }

        @Override
        public int getEndOffset() {
            return this.myBuilder.getLexemeStart(this.getEndIndex());
        }

        @Override
        public int getEndIndex() {
            return this.myDoneLexeme;
        }

        @Override
        @Nullable
        public String getErrorMessage() {
            return this.myError;
        }

        @Override
        @NotNull
        WhitespacesAndCommentsBinder getBinder(boolean done) {
            return this.myBuilder.myOptionalData.getBinder(this.markerId, done);
        }

        @Override
        void setLexemeIndex(int lexemeIndex, boolean done) {
            if (done) {
                this.myDoneLexeme = lexemeIndex;
            } else {
                this.myLexemeIndex = lexemeIndex;
            }
        }

        @Override
        int getLexemeIndex(boolean done) {
            return done ? this.myDoneLexeme : this.myLexemeIndex;
        }

        public void addChild(@NotNull ProductionMarker node) {
            if (this.myFirstChild == null) {
                this.myFirstChild = node;
            } else {
                this.myLastChild.myNext = node;
            }
            this.myLastChild = node;
        }

        @Override
        @NotNull
        public PsiBuilder.Marker precede() {
            return this.myBuilder.precede(this);
        }

        @Override
        public void drop() {
            this.myBuilder.myProduction.dropMarker(this);
        }

        @Override
        public void rollbackTo() {
            this.myBuilder.rollbackTo(this);
        }

        @Override
        public void done(@NotNull IElementType type) {
            if (type == TokenType.ERROR_ELEMENT) {
                LOG.warn("Error elements with empty message are discouraged. Please use builder.error() instead", new RuntimeException());
            }
            this.myType = type;
            this.myBuilder.processDone(this, null, null);
        }

        @Override
        public void collapse(@NotNull IElementType type) {
            this.done(type);
            this.myBuilder.myOptionalData.markCollapsed(this.markerId);
        }

        @Override
        public void doneBefore(@NotNull IElementType type, @NotNull PsiBuilder.Marker before) {
            if (type == TokenType.ERROR_ELEMENT) {
                LOG.warn("Error elements with empty message are discouraged. Please use builder.errorBefore() instead", new RuntimeException());
            }
            this.myType = type;
            this.myBuilder.processDone(this, null, (StartMarker)before);
        }

        @Override
        public void doneBefore(@NotNull IElementType type, @NotNull PsiBuilder.Marker before, @NotNull String errorMessage) {
            StartMarker marker = (StartMarker)before;
            ErrorItem errorItem = this.myBuilder.myPool.allocateErrorItem();
            errorItem.myMessage = errorMessage;
            errorItem.myLexemeIndex = marker.myLexemeIndex;
            this.myBuilder.myProduction.addBefore(errorItem, marker);
            this.doneBefore(type, marker);
        }

        @Override
        public void error(@NotNull String message) {
            this.myType = TokenType.ERROR_ELEMENT;
            this.myError = message;
            this.myBuilder.processDone(this, message, null);
        }

        @Override
        public void errorBefore(@NotNull String message, @NotNull PsiBuilder.Marker before) {
            this.myType = TokenType.ERROR_ELEMENT;
            this.myBuilder.processDone(this, message, (StartMarker)before);
        }

        @Override
        public IElementType getTokenType() {
            return this.myType;
        }

        @Override
        public void setCustomEdgeTokenBinders(WhitespacesAndCommentsBinder left, WhitespacesAndCommentsBinder right) {
            if (left != null) {
                this.myBuilder.myOptionalData.assignBinder(this.markerId, left, false);
            }
            if (right != null) {
                this.myBuilder.myOptionalData.assignBinder(this.markerId, right, true);
            }
        }

        public String toString() {
            if (this.myLexemeIndex < 0) {
                return "<dropped>";
            }
            boolean isDone = this.isDone();
            CharSequence originalText = this.myBuilder.getOriginalText();
            int startOffset = this.getStartOffset();
            int endOffset = isDone ? this.getEndOffset() : this.myBuilder.getCurrentOffset();
            CharSequence text = originalText.subSequence(startOffset, endOffset);
            return isDone ? text.toString() : text + "\u2026";
        }

        boolean isDone() {
            return this.myDoneLexeme != -1;
        }
    }

    static abstract class ProductionMarker
    implements SyntaxTreeBuilder.Production {
        final int markerId;
        protected final MarkerPsiBuilder myBuilder;
        protected int myLexemeIndex = -1;
        protected ProductionMarker myNext;

        ProductionMarker(int markerId, @NotNull MarkerPsiBuilder builder) {
            this.markerId = markerId;
            this.myBuilder = builder;
        }

        void clean() {
            this.myLexemeIndex = -1;
            this.myNext = null;
        }

        @Override
        public int getStartOffset() {
            return this.myBuilder.getLexemeStart(this.myLexemeIndex);
        }

        @Override
        public int getStartIndex() {
            return this.myLexemeIndex;
        }

        @Override
        public int getEndIndex() {
            throw new UnsupportedOperationException("Shall not be called on this kind of markers");
        }

        @Override
        public boolean isCollapsed() {
            return this.myBuilder.myOptionalData.isCollapsed(this.markerId);
        }

        @NotNull
        abstract WhitespacesAndCommentsBinder getBinder(boolean var1);

        abstract void setLexemeIndex(int var1, boolean var2);

        abstract int getLexemeIndex(boolean var1);
    }

    static class ErrorItem
    extends ProductionMarker {
        String myMessage;

        ErrorItem(int markerId, MarkerPsiBuilder builder) {
            super(markerId, builder);
        }

        @Override
        void clean() {
            super.clean();
            this.myMessage = null;
        }

        @Override
        @NotNull
        public WhitespacesAndCommentsBinder getBinder(boolean done) {
            assert (!done);
            return WhitespacesBinders.DEFAULT_RIGHT_BINDER;
        }

        @Override
        void setLexemeIndex(int lexemeIndex, boolean done) {
            assert (!done);
            this.myLexemeIndex = lexemeIndex;
        }

        @Override
        int getLexemeIndex(boolean done) {
            assert (!done);
            return this.myLexemeIndex;
        }

        @Override
        public int getEndOffset() {
            return this.getStartOffset();
        }

        @Override
        public int getEndIndex() {
            return this.getStartIndex();
        }

        @Override
        @Nullable
        public String getErrorMessage() {
            return this.myMessage;
        }

        @Override
        @NotNull
        public IElementType getTokenType() {
            return TokenType.ERROR_ELEMENT;
        }
    }

    private final class RelativeTokenTypesView
    extends AbstractList<IElementType> {
        private int myStart;
        private int mySize;

        private RelativeTokenTypesView() {
        }

        private void configure(int start, int end) {
            this.myStart = start;
            this.mySize = end - start;
        }

        @Override
        public IElementType get(int index) {
            return MarkerPsiBuilder.this.getLexType(this.myStart + index);
        }

        @Override
        public int size() {
            return this.mySize;
        }
    }

    private final class RelativeTokenTextView
    implements WhitespacesAndCommentsBinder.TokenTextGetter {
        private int myStart;

        private RelativeTokenTextView() {
        }

        private void configure(int start) {
            this.myStart = start;
        }

        @Override
        @NotNull
        public CharSequence get(int i) {
            int idx = this.myStart + i;
            return MarkerPsiBuilder.this.myText.subSequence(MarkerPsiBuilder.this.myTokens.lexStart(idx), MarkerPsiBuilder.this.myTokens.lexStart(idx + 1));
        }
    }
}

