/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.lang.parsing.builder;

import fleet.com.intellij.util.containers.IntStack;
import fleet.com.jetbrains.lang.parsing.builder.MarkerPsiBuilder;
import java.util.ArrayList;

final class MarkerPool
extends ArrayList<MarkerPsiBuilder.ProductionMarker> {
    private final MarkerPsiBuilder myBuilder;
    private final IntStack myFreeStartMarkers = new IntStack();
    private final IntStack myFreeErrorItems = new IntStack();

    MarkerPool(MarkerPsiBuilder builder) {
        this.myBuilder = builder;
        this.add(null);
    }

    MarkerPsiBuilder.StartMarker allocateStartMarker() {
        if (this.myFreeStartMarkers.size() > 0) {
            return (MarkerPsiBuilder.StartMarker)this.get(this.myFreeStartMarkers.pop());
        }
        MarkerPsiBuilder.StartMarker marker = new MarkerPsiBuilder.StartMarker(this.size(), this.myBuilder);
        this.add(marker);
        return marker;
    }

    MarkerPsiBuilder.ErrorItem allocateErrorItem() {
        if (this.myFreeErrorItems.size() > 0) {
            return (MarkerPsiBuilder.ErrorItem)this.get(this.myFreeErrorItems.pop());
        }
        MarkerPsiBuilder.ErrorItem item = new MarkerPsiBuilder.ErrorItem(this.size(), this.myBuilder);
        this.add(item);
        return item;
    }

    void freeMarker(MarkerPsiBuilder.ProductionMarker marker) {
        marker.clean();
        (marker instanceof MarkerPsiBuilder.StartMarker ? this.myFreeStartMarkers : this.myFreeErrorItems).push(marker.markerId);
    }
}

