/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.lang.parsing.builder;

import fleet.com.intellij.psi.TokenType;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.jetbrains.lang.parsing.builder.ASTMarkers;
import fleet.com.jetbrains.lang.parsing.builder.ChameleonRef;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\u0018\u0000 F2\u00020\u0001:\u0004FGHIB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0012\u0012\u0006\u0010\u0003\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u000eH\u0016J\u001a\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00070\u00180\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000eH\u0016J\u0018\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J \u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u0000H\u0002J\u0018\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u0000H\u0002J\u0010\u0010&\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u000eH\u0016J\u0012\u0010'\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001b\u001a\u00020\u000eH\u0016J\u000e\u0010(\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000eJ\u000e\u0010)\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000eJ\u0010\u0010*\u001a\u00020+2\u0006\u0010\u001b\u001a\u00020\u000eH\u0016J\u0010\u0010,\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000eH\u0016J\u0010\u0010-\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000eH\u0016J\u0010\u0010.\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000eH\u0016J!\u0010/\u001a\u00020\u00002\u0017\u00100\u001a\u0013\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020!01\u00a2\u0006\u0002\b3H\u0016J\u0006\u00104\u001a\u00020\u000eJ\u0018\u00105\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u000eH\u0002J\u0018\u00106\u001a\u00020!2\u0006\u00107\u001a\u00020\u000e2\u0006\u00108\u001a\u00020\u000eH\u0002J \u00109\u001a\u00020!2\u0006\u0010:\u001a\u00020\u000e2\u0006\u00107\u001a\u00020\u000e2\u0006\u00108\u001a\u00020\u000eH\u0002J \u0010;\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u0000H\u0002J\u0016\u0010<\u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010=\u001a\u00020\u0007J\u001e\u0010>\u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u000e2\u0006\u0010?\u001a\u00020\u000eJ:\u0010@\u001a\u00020!2\u0006\u0010A\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010'\u001a\u0004\u0018\u00010\f2\b\u0010&\u001a\u0004\u0018\u00010\nJ\u0016\u0010B\u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010C\u001a\u00020\u000eJ \u0010D\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\b\u0010E\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006J"}, d2={"Lfleet/com/jetbrains/lang/parsing/builder/ASTMarkersImpl;", "Lfleet/com/jetbrains/lang/parsing/builder/ASTMarkers;", "()V", "origin", "(Lfleet/com/jetbrains/lang/parsing/builder/ASTMarkersImpl;)V", "chameleonsMap", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "Lfleet/com/jetbrains/lang/parsing/builder/ChameleonRef;", "elementTypes", "Lit/unimi/dsi/fastutil/objects/ObjectArrayList;", "Lfleet/com/intellij/psi/tree/IElementType;", "errorMessages", "", "nextId", "", "packer", "Lfleet/com/jetbrains/lang/parsing/builder/ASTMarkersImpl$Packer;", "size", "getSize", "()I", "chameleonAt", "lexemeIndex", "chameleons", "", "Lkotlin/Pair;", "collapsed", "", "i", "computeIdsForNewMarkers", "astMarkers", "oldId2newId", "Lit/unimi/dsi/fastutil/ints/Int2IntOpenHashMap;", "copyNewAstMarkers", "", "start", "end", "copyNewChameleons", "startLexeme", "elementType", "errorMessage", "hasError", "id", "kind", "", "lexemeCount", "lexemeRelOffset", "markersCount", "mutate", "mutator", "Lkotlin/Function1;", "Lfleet/com/jetbrains/lang/parsing/builder/ASTMarkers$MutableContext;", "Lkotlin/ExtensionFunctionType;", "pushBack", "removeMarkersFromMaps", "renumber", "insertedStart", "insertedEnd", "renumberIfNeeded", "nextNewId", "renumberNewMarkers", "setChameleon", "reference", "setLexemeInfo", "relOffset", "setMarker", "index", "setMarkersCount", "descCount", "substituteImpl", "toString", "Companion", "LexemeInfo", "MutableContextImpl", "Packer", "ij-parsing-core"})
@SourceDebugExtension(value={"SMAP\nASTMarkersImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ASTMarkersImpl.kt\nfleet/com/jetbrains/lang/parsing/builder/ASTMarkersImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,422:1\n1#2:423\n766#3:424\n857#3,2:425\n1851#3,2:427\n1851#3,2:431\n1851#3,2:433\n1851#3,2:435\n1851#3,2:437\n1860#3,3:439\n211#4,2:429\n*S KotlinDebug\n*F\n+ 1 ASTMarkersImpl.kt\nfleet/com/jetbrains/lang/parsing/builder/ASTMarkersImpl\n*L\n114#1:424\n114#1:425,2\n115#1:427,2\n125#1:431,2\n140#1:433,2\n164#1:435,2\n174#1:437,2\n235#1:439,3\n116#1:429,2\n*E\n"})
public final class ASTMarkersImpl
implements ASTMarkers {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Packer packer;
    @NotNull
    private final ObjectArrayList<IElementType> elementTypes;
    @NotNull
    private final Int2ObjectOpenHashMap<String> errorMessages;
    @NotNull
    private final Int2ObjectOpenHashMap<ChameleonRef> chameleonsMap;
    private int nextId;
    private static final int DEFAULT_CAPACITY = 256;

    public ASTMarkersImpl() {
        this.packer = new Packer();
        this.elementTypes = new ObjectArrayList(256);
        this.errorMessages = new Int2ObjectOpenHashMap();
        this.chameleonsMap = new Int2ObjectOpenHashMap();
        this.nextId = 0;
    }

    private ASTMarkersImpl(ASTMarkersImpl origin) {
        this.packer = origin.packer.copy();
        ObjectArrayList objectArrayList = origin.elementTypes.clone();
        Intrinsics.checkNotNullExpressionValue((Object)objectArrayList, (String)"clone(...)");
        this.elementTypes = objectArrayList;
        Int2ObjectOpenHashMap int2ObjectOpenHashMap = origin.errorMessages.clone();
        Intrinsics.checkNotNullExpressionValue((Object)int2ObjectOpenHashMap, (String)"clone(...)");
        this.errorMessages = int2ObjectOpenHashMap;
        Int2ObjectOpenHashMap int2ObjectOpenHashMap2 = origin.chameleonsMap.clone();
        Intrinsics.checkNotNullExpressionValue((Object)int2ObjectOpenHashMap2, (String)"clone(...)");
        this.chameleonsMap = int2ObjectOpenHashMap2;
        this.nextId = origin.nextId;
    }

    @Override
    public int getSize() {
        return this.packer.getSize();
    }

    @Override
    public byte kind(int i) {
        return this.packer.kind(i);
    }

    @Override
    @Nullable
    public String errorMessage(int i) {
        return this.hasError(i) ? (String)this.errorMessages.get(this.id(i)) : null;
    }

    public final boolean hasError(int i) {
        return this.packer.hasErrors(i);
    }

    public final int id(int i) {
        return this.packer.id(i);
    }

    @Override
    public int lexemeCount(int i) {
        return this.packer.lexemeInfo(i).getCount();
    }

    @Override
    public int lexemeRelOffset(int i) {
        return this.packer.lexemeInfo(i).getRelOffset();
    }

    @Override
    public boolean collapsed(int i) {
        return this.packer.collapsed(i);
    }

    @Override
    public int markersCount(int i) {
        return this.packer.markersCount(i);
    }

    @Override
    @NotNull
    public IElementType elementType(int i) {
        Object object = this.elementTypes.get(i);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (IElementType)object;
    }

    @Override
    @NotNull
    public ChameleonRef chameleonAt(int lexemeIndex) {
        Object object = this.chameleonsMap.get(lexemeIndex);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (ChameleonRef)object;
    }

    @Override
    @NotNull
    public List<Pair<Integer, ChameleonRef>> chameleons() {
        return MapsKt.toList((Map)((Map)this.chameleonsMap));
    }

    private final void substituteImpl(ASTMarkers astMarkers, int i, int lexemeIndex) {
        if (!(astMarkers instanceof ASTMarkersImpl)) {
            boolean $i$a$-check-ASTMarkersImpl$substituteImpl$22 = false;
            String $i$a$-check-ASTMarkersImpl$substituteImpl$22 = "unexpected class: " + astMarkers.getClass();
            throw new IllegalStateException($i$a$-check-ASTMarkersImpl$substituteImpl$22.toString());
        }
        if (!(this.kind(i) == 1)) {
            String $i$a$-check-ASTMarkersImpl$substituteImpl$22 = "Check failed.";
            throw new IllegalStateException($i$a$-check-ASTMarkersImpl$substituteImpl$22.toString());
        }
        int start = i;
        int end = i + this.markersCount(i);
        int relOffset = this.lexemeRelOffset(i);
        Int2IntOpenHashMap oldId2newId = new Int2IntOpenHashMap();
        this.copyNewChameleons(lexemeIndex, (ASTMarkersImpl)astMarkers);
        this.removeMarkersFromMaps(start, end);
        int newNextId = this.computeIdsForNewMarkers((ASTMarkersImpl)astMarkers, oldId2newId);
        this.copyNewAstMarkers(start, end, (ASTMarkersImpl)astMarkers);
        this.renumberIfNeeded(newNextId, start, start + astMarkers.getSize());
        this.renumberNewMarkers(start, oldId2newId, (ASTMarkersImpl)astMarkers);
        int count = this.lexemeCount(i);
        this.setLexemeInfo(i, count, relOffset);
        this.setLexemeInfo(i + astMarkers.getSize() - 1, count, relOffset);
        this.nextId += newNextId;
    }

    /*
     * WARNING - void declaration
     */
    private final void copyNewChameleons(int startLexeme, ASTMarkersImpl astMarkers) {
        Object element$iv;
        void $this$filterTo$iv$iv;
        Set set = this.chameleonsMap.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterator iterator2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Integer it = (Integer)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!(startLexeme <= it && it < startLexeme + astMarkers.lexemeCount(0))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Object $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            Integer it = (Integer)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.chameleonsMap.remove(it.intValue());
        }
        $this$forEach$iv = (Map)astMarkers.chameleonsMap;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object = element$iv = iterator2.next();
            boolean bl = false;
            Integer k = (Integer)object.getKey();
            ChameleonRef v = (ChameleonRef)object.getValue();
            ((Map)this.chameleonsMap).put(k + startLexeme, v);
        }
    }

    private final void renumberNewMarkers(int start, Int2IntOpenHashMap oldId2newId, ASTMarkersImpl astMarkers) {
        int offset = this.nextId;
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)start, (int)(start + astMarkers.getSize()));
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int index = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            int oldId = this.id(index);
            int newId = oldId2newId.get(oldId) + offset;
            if (this.hasError(index)) {
                Integer n = newId;
                ((Map)this.errorMessages).put(n, astMarkers.errorMessages.get(oldId));
            }
            this.packer.setId(index, newId);
        }
    }

    private final int computeIdsForNewMarkers(ASTMarkersImpl astMarkers, Int2IntOpenHashMap oldId2newId) {
        Ref.IntRef nextNewId = new Ref.IntRef();
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)astMarkers.getSize());
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int index = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            oldId2newId.computeIfAbsent(astMarkers.id(index), arg_0 -> ASTMarkersImpl.computeIdsForNewMarkers$lambda$6$lambda$5(nextNewId, arg_0));
        }
        return nextNewId.element;
    }

    private final void renumberIfNeeded(int nextNewId, int insertedStart, int insertedEnd) {
        if (this.packer.getShortMode() && this.nextId + nextNewId > 65535) {
            this.nextId = 0;
            this.renumber(insertedStart, insertedEnd);
        }
    }

    private final void copyNewAstMarkers(int start, int end, ASTMarkersImpl astMarkers) {
        this.elementTypes.removeElements(start, end + 1);
        this.elementTypes.addElements(start, astMarkers.elementTypes.toArray((Object[])IElementType.EMPTY_ARRAY));
        this.packer.replace(start, end + 1, astMarkers.packer);
    }

    private final void removeMarkersFromMaps(int start, int end) {
        Iterable $this$forEach$iv = (Iterable)new IntRange(start, end);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int index = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            int currentId = this.id(index);
            if (!this.hasError(index)) continue;
            this.errorMessages.remove(currentId);
        }
    }

    private final void renumber(int insertedStart, int insertedEnd) {
        Int2IntOpenHashMap renumberMap = new Int2IntOpenHashMap();
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)this.getSize());
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int index = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            if (insertedStart <= index ? index < insertedEnd : false) continue;
            int newId = renumberMap.computeIfAbsent(this.id(index), arg_0 -> ASTMarkersImpl.renumber$lambda$9$lambda$8(this, index, arg_0));
            this.packer.setId(index, newId);
        }
    }

    public final void setChameleon(int lexemeIndex, @NotNull ChameleonRef reference) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Integer n = lexemeIndex;
        ((Map)this.chameleonsMap).put(n, reference);
    }

    public final void setMarkersCount(int i, int descCount) {
        this.packer.setMarkersCount(i, descCount);
    }

    public final void setLexemeInfo(int i, int lexemeCount, int relOffset) {
        this.packer.setLexemeInfo(i, lexemeCount, relOffset);
    }

    public final int pushBack() {
        int i = this.getSize();
        this.packer.pushBack();
        this.elementTypes.add(i, (Object)TokenType.ERROR_ELEMENT);
        return i;
    }

    public final void setMarker(int index, int id, byte kind, boolean collapsed, @Nullable String errorMessage, @Nullable IElementType elementType) {
        if (this.kind(index) != 0) {
            throw new AssertionError();
        }
        if (id + 1 > this.nextId) {
            this.nextId = id + 1;
        }
        this.packer.setInitialInfo(index, id, kind, collapsed, errorMessage != null);
        if (errorMessage != null) {
            this.errorMessages.put(id, (Object)errorMessage);
        }
        if (elementType != null) {
            this.elementTypes.set(index, (Object)elementType);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u2411 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int depth = 0;
        Iterable $this$forEachIndexed$iv = (Iterable)this.elementTypes;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void type;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IElementType iElementType = (IElementType)item$iv;
            int index = n;
            boolean bl2 = false;
            if (this.kind(index) == 2) {
                depth += -1;
            }
            $this$toString_u24lambda_u2411.append(StringsKt.repeat((CharSequence)"  ", (int)depth) + (IElementType)type + " " + this.kind(index) + " ");
            $this$toString_u24lambda_u2411.append("e=" + this.hasError(index) + " ");
            $this$toString_u24lambda_u2411.append("c=" + this.collapsed(index) + " ");
            $this$toString_u24lambda_u2411.append("lo=" + this.lexemeRelOffset(index) + " ");
            $this$toString_u24lambda_u2411.append("lc" + this.lexemeCount(index) + " ");
            StringBuilder stringBuilder2 = $this$toString_u24lambda_u2411.append("mc=" + this.markersCount(index));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
            if (this.kind(index) != 1) continue;
            ++depth;
        }
        StringBuilder stringBuilder3 = $this$toString_u24lambda_u2411.append("{");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        for (Map.Entry entry : ((Map)this.chameleonsMap).entrySet()) {
            Integer t = (Integer)entry.getKey();
            ChameleonRef u = (ChameleonRef)entry.getValue();
            StringBuilder stringBuilder4 = $this$toString_u24lambda_u2411.append(t + " -> " + u);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
        }
        StringBuilder stringBuilder5 = $this$toString_u24lambda_u2411.append("}");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Override
    @NotNull
    public ASTMarkersImpl mutate(@NotNull Function1<? super ASTMarkers.MutableContext, Unit> mutator) {
        Intrinsics.checkNotNullParameter(mutator, (String)"mutator");
        MutableContextImpl mutableContextImpl = new MutableContextImpl();
        mutator.invoke((Object)mutableContextImpl);
        return mutableContextImpl.getAst();
    }

    private static final int computeIdsForNewMarkers$lambda$6$lambda$5(Ref.IntRef $nextNewId, int it) {
        Intrinsics.checkNotNullParameter((Object)$nextNewId, (String)"$nextNewId");
        int n = $nextNewId.element;
        $nextNewId.element = n + 1;
        return n;
    }

    private static final int renumber$lambda$9$lambda$8(ASTMarkersImpl this$0, int $index, int oldId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int n = this$0.nextId;
        this$0.nextId = n + 1;
        int currentId = n;
        if (this$0.hasError($index)) {
            Integer n2 = currentId;
            ((Map)this$0.errorMessages).put(n2, this$0.errorMessages.remove(oldId));
        }
        return currentId;
    }

    public /* synthetic */ ASTMarkersImpl(ASTMarkersImpl origin, DefaultConstructorMarker $constructor_marker) {
        this(origin);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lfleet/com/jetbrains/lang/parsing/builder/ASTMarkersImpl$Companion;", "", "()V", "DEFAULT_CAPACITY", "", "ij-parsing-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lfleet/com/jetbrains/lang/parsing/builder/ASTMarkersImpl$LexemeInfo;", "", "relOffset", "", "count", "(II)V", "getCount", "()I", "getRelOffset", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "ij-parsing-core"})
    public static final class LexemeInfo {
        private final int relOffset;
        private final int count;

        public LexemeInfo(int relOffset, int count) {
            this.relOffset = relOffset;
            this.count = count;
        }

        public final int getRelOffset() {
            return this.relOffset;
        }

        public final int getCount() {
            return this.count;
        }

        public final int component1() {
            return this.relOffset;
        }

        public final int component2() {
            return this.count;
        }

        @NotNull
        public final LexemeInfo copy(int relOffset, int count) {
            return new LexemeInfo(relOffset, count);
        }

        public static /* synthetic */ LexemeInfo copy$default(LexemeInfo lexemeInfo, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = lexemeInfo.relOffset;
            }
            if ((n3 & 2) != 0) {
                n2 = lexemeInfo.count;
            }
            return lexemeInfo.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "LexemeInfo(relOffset=" + this.relOffset + ", count=" + this.count + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.relOffset);
            result = result * 31 + Integer.hashCode(this.count);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LexemeInfo)) {
                return false;
            }
            LexemeInfo lexemeInfo = (LexemeInfo)other;
            if (this.relOffset != lexemeInfo.relOffset) {
                return false;
            }
            return this.count == lexemeInfo.count;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\u00020\b2\u0018\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\nH\u0016J \u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0016J \u0010\u0012\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\fH\u0016J \u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lfleet/com/jetbrains/lang/parsing/builder/ASTMarkersImpl$MutableContextImpl;", "Lfleet/com/jetbrains/lang/parsing/builder/ASTMarkers$MutableContext;", "(Lfleet/com/jetbrains/lang/parsing/builder/ASTMarkersImpl;)V", "ast", "Lfleet/com/jetbrains/lang/parsing/builder/ASTMarkersImpl;", "getAst", "()Lfleet/com/jetbrains/lang/parsing/builder/ASTMarkersImpl;", "changeChameleons", "", "pairs", "", "Lkotlin/Pair;", "", "Lfleet/com/jetbrains/lang/parsing/builder/ChameleonRef;", "changeLexCount", "startMarker", "endMarker", "lexCount", "changeMarkerCount", "markerCount", "substitute", "i", "lexemeIndex", "astMarkers", "Lfleet/com/jetbrains/lang/parsing/builder/ASTMarkers;", "ij-parsing-core"})
    private final class MutableContextImpl
    implements ASTMarkers.MutableContext {
        @NotNull
        private final ASTMarkersImpl ast;

        public MutableContextImpl() {
            this.ast = new ASTMarkersImpl(ASTMarkersImpl.this, null);
        }

        @NotNull
        public final ASTMarkersImpl getAst() {
            return this.ast;
        }

        @Override
        public void substitute(int i, int lexemeIndex, @NotNull ASTMarkers astMarkers) {
            Intrinsics.checkNotNullParameter((Object)astMarkers, (String)"astMarkers");
            this.ast.substituteImpl(astMarkers, i, lexemeIndex);
        }

        @Override
        public void changeChameleons(@NotNull List<Pair<Integer, ChameleonRef>> pairs) {
            Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
            this.ast.chameleonsMap.clear();
            for (Pair<Integer, ChameleonRef> pair : pairs) {
                int key = ((Number)pair.component1()).intValue();
                ChameleonRef value = (ChameleonRef)pair.component2();
                Integer n = key;
                ((Map)this.ast.chameleonsMap).put(n, value);
            }
        }

        @Override
        public void changeLexCount(int startMarker, int endMarker, int lexCount) {
            int relOffset = this.ast.lexemeRelOffset(startMarker);
            this.ast.setLexemeInfo(startMarker, lexCount, relOffset);
            this.ast.setLexemeInfo(endMarker, lexCount, relOffset);
        }

        @Override
        public void changeMarkerCount(int startMarker, int endMarker, int markerCount) {
            this.ast.setMarkersCount(startMarker, markerCount);
            this.ast.setMarkersCount(endMarker, markerCount);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0002\u0018\u0000 *2\u00020\u0001:\u0001*B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0012\u0012\u0006\u0010\u0003\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u000fJ\u0006\u0010\u0014\u001a\u00020\u0000J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u000fJ\u000e\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fJ\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u000fJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u000fJ\u000e\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fJ\u0006\u0010\u001f\u001a\u00020\u0016J\u001e\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u0000J\u0016\u0010$\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000fJ.\u0010%\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bJ\u001e\u0010&\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u000fJ\u0016\u0010)\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006+"}, d2={"Lfleet/com/jetbrains/lang/parsing/builder/ASTMarkersImpl$Packer;", "", "()V", "origin", "(Lfleet/com/jetbrains/lang/parsing/builder/ASTMarkersImpl$Packer;)V", "ints", "Lit/unimi/dsi/fastutil/ints/IntArrayList;", "<set-?>", "", "longMode", "getLongMode", "()Z", "shortMode", "getShortMode", "size", "", "getSize", "()I", "collapsed", "i", "copy", "grow", "", "hasErrors", "id", "index", "kind", "", "lexemeInfo", "Lfleet/com/jetbrains/lang/parsing/builder/ASTMarkersImpl$LexemeInfo;", "markersCount", "pushBack", "replace", "start", "end", "packer", "setId", "setInitialInfo", "setLexemeInfo", "count", "relOffset", "setMarkersCount", "Companion", "ij-parsing-core"})
    @SourceDebugExtension(value={"SMAP\nASTMarkersImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ASTMarkersImpl.kt\nfleet/com/jetbrains/lang/parsing/builder/ASTMarkersImpl$Packer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,422:1\n1#2:423\n1851#3,2:424\n*S KotlinDebug\n*F\n+ 1 ASTMarkersImpl.kt\nfleet/com/jetbrains/lang/parsing/builder/ASTMarkersImpl$Packer\n*L\n365#1:424,2\n*E\n"})
    private static final class Packer {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final IntArrayList ints;
        private boolean longMode;
        private static final int KIND_MASK = 3;
        private static final int MAX_SHORT_ID_VALUE = 65535;
        private static final int MAX_SHORT_LEXEME_VALUE = 65535;
        private static final int MAX_SHORT_MARKERS_COUNT = 4095;
        private static final int MAX_LONG_MARKERS_COUNT = 0xFFFFFFF;

        public Packer() {
            this.ints = new IntArrayList(256);
        }

        private Packer(Packer origin) {
            this.longMode = origin.longMode;
            IntArrayList intArrayList = origin.ints.clone();
            Intrinsics.checkNotNullExpressionValue((Object)intArrayList, (String)"clone(...)");
            this.ints = intArrayList;
        }

        public final boolean getLongMode() {
            return this.longMode;
        }

        public final boolean getShortMode() {
            return !this.longMode;
        }

        private final int index(int i) {
            return this.longMode ? i * 4 : i * 2;
        }

        public final byte kind(int i) {
            return (byte)(this.ints.getInt(this.index(i)) & 3);
        }

        @NotNull
        public final LexemeInfo lexemeInfo(int i) {
            LexemeInfo lexemeInfo;
            int index = this.index(i);
            if (this.longMode) {
                lexemeInfo = new LexemeInfo(this.ints.getInt(index + 2), this.ints.getInt(index + 3));
            } else {
                int packed = this.ints.getInt(index + 1);
                lexemeInfo = new LexemeInfo(packed & 0xFFFF, packed >>> 16);
            }
            return lexemeInfo;
        }

        public final boolean collapsed(int i) {
            return (this.ints.getInt(this.index(i)) & 4) == 4;
        }

        public final boolean hasErrors(int i) {
            return (this.ints.getInt(this.index(i)) & 8) == 8;
        }

        public final int id(int i) {
            int index = this.index(i);
            return this.longMode ? this.ints.getInt(index + 1) : this.ints.getInt(index) >>> 16;
        }

        public final int markersCount(int i) {
            return this.ints.getInt(this.index(i)) >>> 4 & (this.longMode ? 0xFFFFFFF : 4095);
        }

        public final int getSize() {
            return this.ints.size() / (this.longMode ? 4 : 2);
        }

        public final void setLexemeInfo(int i, int count, int relOffset) {
            if (this.getShortMode() && (relOffset > 65535 || count > 65535)) {
                this.grow();
            }
            int index = this.index(i);
            if (this.longMode) {
                this.ints.set(index + 2, relOffset);
                this.ints.set(index + 3, count);
            } else {
                this.ints.set(index + 1, relOffset | count << 16);
            }
        }

        public final void setMarkersCount(int i, int count) {
            if (this.getShortMode() && count > 4095) {
                this.grow();
            }
            if (!(count <= 0xFFFFFFF)) {
                boolean bl = false;
                String string = "markers count " + count + " is bigger than 268435455";
                throw new IllegalStateException(string.toString());
            }
            int index = this.index(i);
            this.ints.set(index, this.ints.getInt(index) & ~(4095 << 4) | count << 4);
        }

        public final void setInitialInfo(int i, int id, byte kind, boolean collapsed, boolean hasErrors) {
            int hasErrorInt;
            int collapsedInt = collapsed ? 4 : 0;
            int n = hasErrorInt = hasErrors ? 8 : 0;
            if (this.getShortMode() && id > 65535) {
                this.grow();
            }
            int index = this.index(i);
            this.ints.set(index, kind + collapsedInt + hasErrorInt);
            this.setId(i, id);
        }

        public final void setId(int i, int id) {
            int index = this.index(i);
            if (this.longMode) {
                this.ints.set(index + 1, id);
            } else {
                this.ints.set(index, this.ints.getInt(index) & 0xFFFF | id << 16);
            }
        }

        public final void replace(int start, int end, @NotNull Packer packer) {
            Intrinsics.checkNotNullParameter((Object)packer, (String)"packer");
            if (this.longMode && !packer.longMode) {
                packer.grow();
            }
            if (!this.longMode && packer.longMode) {
                this.grow();
            }
            this.ints.removeElements(this.index(start), this.index(end));
            this.ints.addElements(this.index(start), packer.ints.toIntArray());
        }

        private final void grow() {
            if (!this.getShortMode()) {
                boolean $i$a$-check-ASTMarkersImpl$Packer$grow$22 = false;
                String $i$a$-check-ASTMarkersImpl$Packer$grow$22 = "Already in long mode";
                throw new IllegalStateException($i$a$-check-ASTMarkersImpl$Packer$grow$22.toString());
            }
            int end = this.getSize() - 1;
            int $i$a$-check-ASTMarkersImpl$Packer$grow$22 = this.ints.size();
            int n = 0;
            while (n < $i$a$-check-ASTMarkersImpl$Packer$grow$22) {
                int it = n++;
                boolean bl = false;
                this.ints.push(0);
            }
            this.longMode = true;
            Iterable $this$forEach$iv = (Iterable)RangesKt.downTo((int)end, (int)0);
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                int element$iv;
                int i = element$iv = ((IntIterator)iterator2).nextInt();
                boolean bl = false;
                int firstInt = this.ints.getInt(i * 2);
                int secondInt = this.ints.getInt(i * 2 + 1);
                this.setInitialInfo(i, firstInt >>> 16, (byte)(firstInt & 3), (firstInt & 4) == 4, (firstInt & 8) == 8);
                this.setMarkersCount(i, firstInt >>> 4 & 0xFFF);
                this.setLexemeInfo(i, secondInt >>> 16, secondInt & 0xFFFF);
            }
        }

        public final void pushBack() {
            int n = this.longMode ? 4 : 2;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                this.ints.push(0);
            }
        }

        @NotNull
        public final Packer copy() {
            return new Packer(this);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lfleet/com/jetbrains/lang/parsing/builder/ASTMarkersImpl$Packer$Companion;", "", "()V", "KIND_MASK", "", "MAX_LONG_MARKERS_COUNT", "MAX_SHORT_ID_VALUE", "MAX_SHORT_LEXEME_VALUE", "MAX_SHORT_MARKERS_COUNT", "ij-parsing-core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

