/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.util.text;

import java.nio.CharBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CharArrayUtil {
    public static void getChars(@NotNull CharSequence src, @NotNull char[] dst, int dstOffset) {
        CharArrayUtil.getChars(src, dst, dstOffset, src.length());
    }

    public static void getChars(@NotNull CharSequence src, @NotNull char[] dst, int dstOffset, int len) {
        CharArrayUtil.getChars(src, dst, 0, dstOffset, len);
    }

    public static void getChars(@NotNull CharSequence src, @NotNull char[] dst, int srcOffset, int dstOffset, int len) {
        int i = 0;
        int max = srcOffset + len;
        for (int j = srcOffset; j < max && i < dst.length; ++i, ++j) {
            dst[i + dstOffset] = src.charAt(j);
        }
    }

    public static char @NotNull [] fromSequence(@NotNull CharSequence seq, int start, int end) {
        char[] result = new char[end - start];
        CharArrayUtil.getChars(seq, result, start, 0, end - start);
        return result;
    }

    @Nullable
    public static char[] fromSequenceWithoutCopying(@Nullable CharSequence seq) {
        CharBuffer buffer;
        if (seq instanceof CharBuffer && (buffer = (CharBuffer)seq).hasArray() && !buffer.isReadOnly() && buffer.arrayOffset() == 0 && buffer.position() == 0) {
            return buffer.array();
        }
        return null;
    }

    public static int shiftForward(@NotNull CharSequence buffer, int offset, @NotNull String chars) {
        return CharArrayUtil.shiftForward(buffer, offset, buffer.length(), chars);
    }

    public static int shiftForward(@NotNull CharSequence buffer, int startOffset, int endOffset, @NotNull String chars) {
        int limit = Math.min(endOffset, buffer.length());
        for (int offset = startOffset; offset < limit; ++offset) {
            int i;
            char c = buffer.charAt(offset);
            for (i = 0; i < chars.length() && c != chars.charAt(i); ++i) {
            }
            if (i < chars.length()) continue;
            return offset;
        }
        return endOffset;
    }

    public static int shiftBackward(@NotNull CharSequence buffer, int offset, @NotNull String chars) {
        return CharArrayUtil.shiftBackward(buffer, 0, offset, chars);
    }

    public static int shiftBackward(@NotNull CharSequence buffer, int minOffset, int maxOffset, @NotNull String chars) {
        int offset;
        if (maxOffset >= buffer.length()) {
            return maxOffset;
        }
        for (offset = maxOffset; offset >= minOffset; --offset) {
            int i;
            char c = buffer.charAt(offset);
            for (i = 0; i < chars.length() && c != chars.charAt(i); ++i) {
            }
            if (i == chars.length()) break;
        }
        return offset;
    }

    public static int shiftBackwardUntil(@NotNull CharSequence buffer, int offset, @NotNull String chars) {
        if (offset >= buffer.length()) {
            return offset;
        }
        while (offset >= 0) {
            int i;
            char c = buffer.charAt(offset);
            for (i = 0; i < chars.length() && c != chars.charAt(i); ++i) {
            }
            if (i < chars.length()) break;
            --offset;
        }
        return offset;
    }

    public static boolean regionMatches(@NotNull char[] buffer, int start, int end, @NotNull CharSequence s) {
        int len = s.length();
        if (start + len > end) {
            return false;
        }
        if (start < 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (buffer[start + i] == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean regionMatches(@NotNull CharSequence buffer, int start, int end, @NotNull CharSequence s) {
        int len = s.length();
        if (start + len > end) {
            return false;
        }
        if (start < 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (buffer.charAt(start + i) == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static int indexOf(@NotNull char[] buffer, @NotNull String pattern, int fromIndex) {
        char[] chars = pattern.toCharArray();
        int limit = buffer.length - chars.length + 1;
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        block0: for (int i = fromIndex; i < limit; ++i) {
            for (int j = 0; j < chars.length; ++j) {
                if (chars[j] != buffer[i + j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int indexOf(@NotNull CharSequence buffer, @NotNull CharSequence pattern, int fromIndex) {
        return CharArrayUtil.indexOf(buffer, pattern, fromIndex, buffer.length());
    }

    public static int indexOf(@NotNull CharSequence buffer, @NotNull CharSequence pattern, int fromIndex, int toIndex) {
        int patternLength = pattern.length();
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        int limit = toIndex - patternLength + 1;
        block0: for (int i = fromIndex; i < limit; ++i) {
            for (int j = 0; j < patternLength; ++j) {
                if (pattern.charAt(j) != buffer.charAt(i + j)) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static boolean containLineBreaks(@NotNull CharSequence seq) {
        return CharArrayUtil.containLineBreaks(seq, 0, seq.length());
    }

    public static boolean containLineBreaks(@Nullable CharSequence seq, int fromOffset, int endOffset) {
        if (seq == null) {
            return false;
        }
        for (int i = fromOffset; i < endOffset; ++i) {
            char c = seq.charAt(i);
            if (c != '\n' && c != '\r') continue;
            return true;
        }
        return false;
    }
}

