/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.openapi.util.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

public class FileUtilRt {
    public static final int THREAD_LOCAL_BUFFER_LENGTH = 20480;
    protected static final ThreadLocal<byte[]> BUFFER = ThreadLocal.withInitial(() -> new byte[20480]);

    @NotNull
    public static byte[] loadBytes(@NotNull InputStream stream) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        FileUtilRt.copy(stream, buffer);
        return buffer.toByteArray();
    }

    public static void copy(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) throws IOException {
        int read;
        byte[] buffer = FileUtilRt.getThreadLocalBuffer();
        while ((read = inputStream.read(buffer)) >= 0) {
            outputStream.write(buffer, 0, read);
        }
    }

    @NotNull
    public static byte[] getThreadLocalBuffer() {
        return BUFFER.get();
    }
}

