/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lang;

import fleet.com.intellij.lang.WhitespacesAndCommentsBinder;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class WhitespacesBinders {
    public static final WhitespacesAndCommentsBinder DEFAULT_LEFT_BINDER = new WhitespacesAndCommentsBinder(){

        @Override
        public int getEdgePosition(List<? extends IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
            return tokens.size();
        }
    };
    public static final WhitespacesAndCommentsBinder DEFAULT_RIGHT_BINDER;
    public static final WhitespacesAndCommentsBinder GREEDY_LEFT_BINDER;
    public static final WhitespacesAndCommentsBinder GREEDY_RIGHT_BINDER;

    private WhitespacesBinders() {
    }

    public static WhitespacesAndCommentsBinder leadingCommentsBinder(final @NotNull TokenSet commentTypes) {
        return new WhitespacesAndCommentsBinder(){

            @Override
            public int getEdgePosition(List<? extends IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
                int i;
                for (i = 0; i < tokens.size() && !commentTypes.contains(tokens.get(i)); ++i) {
                }
                return i;
            }
        };
    }

    public static WhitespacesAndCommentsBinder trailingCommentsBinder(final @NotNull TokenSet commentTypes) {
        return new WhitespacesAndCommentsBinder(){

            @Override
            public int getEdgePosition(List<? extends IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
                int i;
                for (i = tokens.size() - 1; i >= 0 && !commentTypes.contains(tokens.get(i)); --i) {
                }
                return i + 1;
            }
        };
    }

    static {
        GREEDY_LEFT_BINDER = DEFAULT_RIGHT_BINDER = new WhitespacesAndCommentsBinder(){

            @Override
            public int getEdgePosition(List<? extends IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
                return 0;
            }
        };
        GREEDY_RIGHT_BINDER = DEFAULT_LEFT_BINDER;
    }
}

