/*
 * Decompiled with CFR 0.152.
 */
package fleet.util.logging.slf4j;

import fleet.util.logging.KLogger;
import fleet.util.logging.KLoggerFactory;
import fleet.util.logging.slf4j.JVMLogger;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\tH\u0002J\u0014\u0010\n\u001a\u00020\u00042\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0014\u0010\n\u001a\u00020\u00042\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016\u00a8\u0006\r"}, d2={"Lfleet/util/logging/slf4j/Slf4jKLoggerFactory;", "Lfleet/util/logging/KLoggerFactory;", "()V", "defaultLogger", "Lfleet/util/logging/KLogger;", "clazz", "Ljava/lang/Class;", "name", "", "Lkotlin/reflect/KClass;", "logger", "owner", "", "fleet.util.logging.api"})
public final class Slf4jKLoggerFactory
implements KLoggerFactory {
    @Override
    @NotNull
    public KLogger logger(@NotNull KClass<?> owner) {
        Intrinsics.checkNotNullParameter(owner, (String)"owner");
        return this.defaultLogger(owner);
    }

    @Override
    @NotNull
    public KLogger logger(@NotNull Class<?> owner) {
        Intrinsics.checkNotNullParameter(owner, (String)"owner");
        return this.defaultLogger(JvmClassMappingKt.getKotlinClass(owner));
    }

    @Override
    @NotNull
    public KLogger logger(@NotNull Object owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        return this.defaultLogger(JvmClassMappingKt.getKotlinClass(owner.getClass()));
    }

    @Override
    @NotNull
    public KLogger logger(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.defaultLogger(name);
    }

    private final KLogger defaultLogger(String name) {
        Logger slf4jLogger = LoggerFactory.getLogger((String)name);
        Intrinsics.checkNotNull((Object)slf4jLogger);
        return new KLogger(new JVMLogger(slf4jLogger));
    }

    private final KLogger defaultLogger(KClass<?> clazz) {
        return this.defaultLogger(JvmClassMappingKt.getJavaClass(clazz));
    }

    private final KLogger defaultLogger(Class<?> clazz) {
        Logger slf4jLogger = LoggerFactory.getLogger(clazz);
        Intrinsics.checkNotNull((Object)slf4jLogger);
        return new KLogger(new JVMLogger(slf4jLogger));
    }
}

