/*
 * Decompiled with CFR 0.152.
 */
package fleet.util.bifurcan.utils;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0006J\u000e\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0006J\u001e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lfleet/util/bifurcan/utils/Bits;", "", "()V", "deBruijnIndex", "", "bitOffset", "", "n", "", "branchingBit", "a", "b", "highestBit", "isPowerOfTwo", "", "log2Ceil", "log2Floor", "lowestBit", "maskAbove", "bits", "maskBelow", "slice", "start", "end", "fleet.util.core"})
public final class Bits {
    @NotNull
    public static final Bits INSTANCE = new Bits();
    @NotNull
    private static final byte[] deBruijnIndex;

    private Bits() {
    }

    public final int bitOffset(long n) {
        return deBruijnIndex[0xFF & (int)(n * 157587932685088877L >>> 58)];
    }

    public final long lowestBit(long n) {
        return n & -n;
    }

    public final int lowestBit(int n) {
        return n & -n;
    }

    public final long highestBit(long n) {
        return Long.highestOneBit(n);
    }

    public final int highestBit(int n) {
        return Integer.highestOneBit(n);
    }

    public final int log2Floor(long n) {
        return this.bitOffset(this.highestBit(n));
    }

    public final int log2Ceil(long n) {
        int log2 = this.log2Floor(n);
        return this.isPowerOfTwo(n) ? log2 : log2 + 1;
    }

    public final long maskBelow(int bits) {
        return (1L << bits) - 1L;
    }

    public final long maskAbove(int bits) {
        return 0xFFFFFFFFFFFFFFFFL & (this.maskBelow(bits) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public final int branchingBit(long a, long b) {
        return a == b ? -1 : this.bitOffset(this.highestBit(a ^ b));
    }

    public final boolean isPowerOfTwo(long n) {
        return (n & n - 1L) == 0L;
    }

    public final long slice(long n, int start2, int end) {
        return n >> start2 & this.maskBelow(end - start2);
    }

    static {
        byte[] byArray = new byte[]{0, 1, 2, 53, 3, 7, 54, 27, 4, 38, 41, 8, 34, 55, 48, 28, 62, 5, 39, 46, 44, 42, 22, 9, 24, 35, 59, 56, 49, 18, 29, 11, 63, 52, 6, 26, 37, 40, 33, 47, 61, 45, 43, 21, 23, 58, 17, 10, 51, 25, 36, 32, 60, 20, 57, 16, 50, 31, 19, 15, 30, 14, 13, 12};
        deBruijnIndex = byArray;
    }
}

