/*
 * Decompiled with CFR 0.152.
 */
package fleet.util.bifurcan.nodes;

import fleet.util.bifurcan.utils.Bits;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0001J5\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0011J(\u0010\u0012\u001a\u00020\u00012\b\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lfleet/util/bifurcan/nodes/ListNodes;", "", "()V", "BRANCH_MASK", "", "MAX_BRANCHES", "SHIFT_INCREMENT", "pushLast", "Lfleet/util/bifurcan/nodes/ListNodes$Node;", "a", "b", "editor", "set", "", "elements", "idx", "value", "([Ljava/lang/Object;ILjava/lang/Object;)[Ljava/lang/Object;", "slice", "node", "start", "", "end", "Node", "fleet.util.core"})
public final class ListNodes {
    @NotNull
    public static final ListNodes INSTANCE = new ListNodes();
    private static final int SHIFT_INCREMENT = 5;
    public static final int MAX_BRANCHES = 32;
    private static final int BRANCH_MASK = 31;

    private ListNodes() {
    }

    @NotNull
    public final Object slice(@Nullable Object node, @NotNull Object editor, long start2, long end) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (node instanceof Object[]) {
            Object[] objectArray = (Object[])node;
            int n = (int)start2;
            int n2 = (int)end;
            return ArraysKt.copyOfRange((Object[])objectArray, (int)n, (int)n2);
        }
        Node node2 = (Node)node;
        Intrinsics.checkNotNull((Object)node2);
        return node2.slice((int)start2, (int)end, editor);
    }

    @NotNull
    public final Object[] set(@NotNull Object[] elements, int idx, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        Object[] ary = new Object[elements.length];
        ArraysKt.copyInto$default((Object[])elements, (Object[])ary, (int)0, (int)0, (int)0, (int)8, null);
        ary[idx] = value;
        return ary;
    }

    @NotNull
    public final Node pushLast(@NotNull Node a, @NotNull Object b, @NotNull Object editor) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return b instanceof Node ? a.pushLast((Node)b, editor) : a.pushLast((Object[])b, editor);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\u0016\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0014\u0018\u0000 92\u00020\u0001:\u00019B\u0019\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0012\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0012\u0010\u001f\u001a\u00020\u00002\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001H\u0002J\u0016\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001J\u0015\u0010\"\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000fJ\b\u0010#\u001a\u00020\u001eH\u0002J\u0010\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&H\u0002J\u0015\u0010'\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010(\u001a\u00020\u00012\u0006\u0010%\u001a\u00020&2\u0006\u0010)\u001a\u00020\bJ\u0010\u0010*\u001a\u00020&2\u0006\u0010%\u001a\u00020\u0004H\u0002J\u0010\u0010+\u001a\u00020\u00002\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001J\u0010\u0010,\u001a\u00020\u00002\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001J\u001a\u0010-\u001a\u00020\u00002\b\u0010!\u001a\u0004\u0018\u00010\u00002\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001J'\u0010-\u001a\u00020\u00002\u0010\u0010.\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\r2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010/J\u0018\u00100\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u00002\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001J'\u00100\u001a\u00020\u00002\u0010\u0010.\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\r2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010/J\u0018\u00101\u001a\u00020\u00012\u0006\u0010%\u001a\u00020&2\u0006\u0010)\u001a\u00020\bH\u0002J\"\u00102\u001a\u00020\u00002\b\u0010\u0002\u001a\u0004\u0018\u00010\u00012\u0006\u0010%\u001a\u00020&2\b\u00103\u001a\u0004\u0018\u00010\u0001J\u0006\u00104\u001a\u00020&J\u001e\u00105\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u0001J\b\u00108\u001a\u00020\u001eH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\t\"\u0004\b\n\u0010\u000bR$\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\rX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0012\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0003\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006:"}, d2={"Lfleet/util/bifurcan/nodes/ListNodes$Node;", "", "editor", "shift", "", "(Ljava/lang/Object;I)V", "(I)V", "isStrict", "", "()Z", "setStrict", "(Z)V", "nodes", "", "getNodes", "()[Ljava/lang/Object;", "setNodes", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "numNodes", "offsets", "", "getOffsets", "()[J", "setOffsets", "([J)V", "", "getShift", "()B", "assertInvariants", "", "clone", "concat", "node", "first", "grow", "indexOf", "idx", "", "last", "nth", "returnChunk", "offset", "popFirst", "popLast", "pushFirst", "chunk", "([Ljava/lang/Object;Ljava/lang/Object;)Lfleet/util/bifurcan/nodes/ListNodes$Node;", "pushLast", "relaxedNth", "set", "value", "size", "slice", "start", "end", "updateStrict", "Companion", "fleet.util.core"})
    public static final class Node {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final byte shift;
        private boolean isStrict;
        private int numNodes;
        @Nullable
        private Object editor;
        @NotNull
        private long[] offsets = new long[2];
        @NotNull
        private Object[] nodes = new Object[2];
        @NotNull
        private static final Node EMPTY = new Node(new Object(), 5);

        public final byte getShift() {
            return this.shift;
        }

        public final boolean isStrict() {
            return this.isStrict;
        }

        public final void setStrict(boolean bl) {
            this.isStrict = bl;
        }

        @NotNull
        public final long[] getOffsets() {
            return this.offsets;
        }

        public final void setOffsets(@NotNull long[] lArray) {
            Intrinsics.checkNotNullParameter((Object)lArray, (String)"<set-?>");
            this.offsets = lArray;
        }

        @NotNull
        public final Object[] getNodes() {
            return this.nodes;
        }

        public final void setNodes(@NotNull Object[] objectArray) {
            Intrinsics.checkNotNullParameter((Object)objectArray, (String)"<set-?>");
            this.nodes = objectArray;
        }

        public Node(@Nullable Object editor, int shift) {
            this.editor = editor;
            this.shift = (byte)shift;
            this.numNodes = 0;
            this.offsets = new long[2];
            this.nodes = new Object[2];
        }

        private Node(int shift) {
            this.shift = (byte)shift;
        }

        public final void assertInvariants() {
            if (this.shift == 5) {
                int n = this.numNodes;
                for (int i = 0; i < n; ++i) {
                    if (this.nodes[i] instanceof Object[]) continue;
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
            } else {
                int n = this.numNodes;
                for (int i = 0; i < n; ++i) {
                    Object object = this.nodes[i];
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type fleet.util.bifurcan.nodes.ListNodes.Node");
                    if (((Node)object).shift == this.shift - 5) continue;
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
            }
        }

        @Nullable
        public final Object[] first() {
            if (this.numNodes == 0) {
                return null;
            }
            Node n = this;
            while (true) {
                Node node = n;
                Intrinsics.checkNotNull((Object)node);
                if (node.shift <= 5) break;
                n = (Node)n.nodes[0];
            }
            return (Object[])n.nodes[0];
        }

        @Nullable
        public final Object[] last() {
            if (this.numNodes == 0) {
                return null;
            }
            Node n = this;
            while (n.shift > 5) {
                Object object = n.nodes[n.numNodes - 1];
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type fleet.util.bifurcan.nodes.ListNodes.Node");
                n = (Node)object;
            }
            return (Object[])n.nodes[n.numNodes - 1];
        }

        @NotNull
        public final Object nth(long idx, boolean returnChunk) {
            if (!this.isStrict) {
                return this.relaxedNth(idx, returnChunk);
            }
            Node n = this;
            while (n.shift > 5) {
                int nodeIdx = (int)(idx >>> n.shift & 0x1FL);
                Object object = n.nodes[nodeIdx];
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type fleet.util.bifurcan.nodes.ListNodes.Node");
                n = (Node)object;
                if (n.isStrict) continue;
                return n.relaxedNth(idx, returnChunk);
            }
            Object object = n.nodes[(int)(idx >>> 5 & 0x1FL)];
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any>");
            Object[] chunk = (Object[])object;
            return returnChunk ? chunk : chunk[(int)(idx & 0x1FL)];
        }

        private final Object relaxedNth(long idx, boolean returnChunk) {
            int nodeIdx;
            long idx2 = idx;
            idx2 &= Bits.INSTANCE.maskBelow(this.shift + 5);
            Node n = this;
            while (n.shift > 5) {
                nodeIdx = n.indexOf(idx2);
                idx2 -= n.offset(nodeIdx);
                Object object = n.nodes[nodeIdx];
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type fleet.util.bifurcan.nodes.ListNodes.Node");
                n = (Node)object;
            }
            nodeIdx = n.indexOf(idx2);
            Object object = n.nodes[nodeIdx];
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any>");
            Object[] chunk = (Object[])object;
            return returnChunk ? chunk : chunk[(int)(idx2 - n.offset(nodeIdx))];
        }

        private final int indexOf(long idx) {
            int estimate = (int)(this.shift > 60 ? 0L : idx >>> this.shift & 0x1FL);
            if (this.isStrict) {
                return estimate;
            }
            int n = this.nodes.length;
            for (int i = estimate; i < n; ++i) {
                if (idx >= this.offsets[i]) continue;
                return i;
            }
            return -1;
        }

        private final long offset(int idx) {
            return idx == 0 ? 0L : this.offsets[idx - 1];
        }

        @NotNull
        public final Node set(@Nullable Object editor, long idx, @Nullable Object value) {
            if (editor != this.editor) {
                return this.clone(editor).set(editor, idx, value);
            }
            int nodeIdx = this.indexOf(idx);
            if (this.shift == 5) {
                Object object = this.nodes[nodeIdx];
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
                this.nodes[nodeIdx] = INSTANCE.set((Object[])object, (int)(idx - this.offset(nodeIdx)), value);
            } else {
                Node node = (Node)this.nodes[nodeIdx];
                Intrinsics.checkNotNull((Object)node);
                this.nodes[nodeIdx] = node.set(editor, idx - this.offset(nodeIdx), value);
            }
            return this;
        }

        public final long size() {
            return this.numNodes == 0 ? 0L : this.offsets[this.numNodes - 1];
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Node concat(@NotNull Node node, @NotNull Object editor) {
            Node node2;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            if (this.size() == 0L) {
                return node;
            }
            if (node.size() == 0L) {
                return this;
            }
            if (this.shift == node.shift) {
                void var3_3;
                Node newNode = editor == this.editor ? this : this.clone(editor);
                int n = node.numNodes;
                for (int i = 0; i < n; ++i) {
                    Object object = node.nodes[i];
                    Intrinsics.checkNotNull((Object)object);
                    newNode = INSTANCE.pushLast(newNode, object, editor);
                }
                node2 = var3_3;
            } else {
                node2 = this.shift < node.shift ? node.pushFirst(this, editor) : this.pushLast(node, editor);
            }
            return node2;
        }

        @NotNull
        public final Node slice(int start2, int end, @NotNull Object editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            if (start2 == end) {
                return EMPTY;
            }
            if ((long)start2 == 0L && (long)end == this.size()) {
                return this;
            }
            int startIdx = this.indexOf(start2);
            int endIdx = this.indexOf(end - 1);
            Node rn = EMPTY;
            if (startIdx == endIdx) {
                long offset = this.offset(startIdx);
                Object child = INSTANCE.slice(this.nodes[startIdx], editor, (long)start2 - offset, (long)end - offset);
                if (this.shift > 5) {
                    Intrinsics.checkNotNull((Object)child, (String)"null cannot be cast to non-null type fleet.util.bifurcan.nodes.ListNodes.Node");
                    return (Node)child;
                }
                rn = INSTANCE.pushLast(rn, child, editor);
            } else {
                long sLower = this.offset(startIdx);
                long sUpper = this.offset(startIdx + 1);
                rn = INSTANCE.pushLast(rn, INSTANCE.slice(this.nodes[startIdx], editor, (long)start2 - sLower, sUpper - sLower), editor);
                for (int i = startIdx + 1; i < endIdx; ++i) {
                    Object object = this.nodes[i];
                    Intrinsics.checkNotNull((Object)object);
                    rn = INSTANCE.pushLast(rn, object, editor);
                }
                long eLower = this.offset(endIdx);
                rn = INSTANCE.pushLast(rn, INSTANCE.slice(this.nodes[endIdx], editor, 0L, (long)end - eLower), editor);
            }
            return rn;
        }

        @NotNull
        public final Node pushLast(@Nullable Object[] chunk, @Nullable Object editor) {
            Node parent;
            int i;
            if (this.size() == 0L && this.shift > 5) {
                return this.pushLast(Node.Companion.from(editor, chunk), editor);
            }
            Node[] stack = new Node[this.shift / 5];
            stack[0] = this;
            int n = stack.length;
            for (i = 1; i < n; ++i) {
                Node n2;
                Node node = n2 = stack[i - 1];
                Intrinsics.checkNotNull((Object)node);
                stack[i] = node.nodes[n2.numNodes - 1];
            }
            Node node = stack[stack.length - 1];
            Intrinsics.checkNotNull((Object)node);
            if (node.numNodes == 32) {
                return this.numNodes == 32 ? new Node(editor, this.shift + 5).pushLast(this, editor).pushLast(chunk, editor) : this.pushLast(Node.Companion.from(editor, chunk), editor);
            }
            n = stack.length;
            for (i = 0; i < n; ++i) {
                Node node2 = stack[i];
                Intrinsics.checkNotNull((Object)node2);
                if (node2.editor == editor) continue;
                Node node3 = stack[i];
                Intrinsics.checkNotNull((Object)node3);
                stack[i] = node3.clone(editor);
            }
            Node node4 = parent = stack[stack.length - 1];
            Intrinsics.checkNotNull((Object)node4);
            if (node4.nodes.length == parent.numNodes) {
                parent.grow();
            }
            parent.offsets[parent.numNodes] = parent.size();
            n = parent.numNodes;
            parent.numNodes = n + 1;
            int n3 = stack.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                Node n4;
                Node node5 = n4 = stack[i2];
                Intrinsics.checkNotNull((Object)node5);
                int lastIdx = node5.numNodes - 1;
                n4.nodes[lastIdx] = i2 == stack.length - 1 ? chunk : stack[i2 + 1];
                long[] lArray = n4.offsets;
                long l = lArray[lastIdx];
                Intrinsics.checkNotNull((Object)chunk);
                lArray[lastIdx] = l + (long)chunk.length;
                n4.updateStrict();
            }
            Node node6 = stack[0];
            Intrinsics.checkNotNull((Object)node6);
            return node6;
        }

        @NotNull
        public final Node pushFirst(@Nullable Object[] chunk, @Nullable Object editor) {
            Node parent;
            int i;
            if (this.size() == 0L && this.shift > 5) {
                return this.pushLast(chunk, editor);
            }
            Node[] stack = new Node[this.shift / 5];
            stack[0] = this;
            int n = stack.length;
            for (i = 1; i < n; ++i) {
                Node n2;
                Node node = n2 = stack[i - 1];
                Intrinsics.checkNotNull((Object)node);
                stack[i] = node.nodes[0];
            }
            Node node = stack[stack.length - 1];
            Intrinsics.checkNotNull((Object)node);
            if (node.numNodes == 32) {
                return this.numNodes == 32 ? new Node(editor, this.shift + 5).pushLast(chunk, editor).pushLast(this, editor) : this.pushFirst(Node.Companion.from(editor, chunk), editor);
            }
            n = stack.length;
            for (i = 0; i < n; ++i) {
                Node node2 = stack[i];
                Intrinsics.checkNotNull((Object)node2);
                if (node2.editor == editor) continue;
                Node node3 = stack[i];
                Intrinsics.checkNotNull((Object)node3);
                stack[i] = node3.clone(editor);
            }
            Node node4 = parent = stack[stack.length - 1];
            Intrinsics.checkNotNull((Object)node4);
            if (node4.nodes.length == parent.numNodes) {
                parent.grow();
            }
            ArraysKt.copyInto((Object[])parent.nodes, (Object[])parent.nodes, (int)1, (int)0, (int)parent.numNodes);
            ArraysKt.copyInto((long[])parent.offsets, (long[])parent.offsets, (int)1, (int)0, (int)parent.numNodes);
            parent.offsets[0] = 0L;
            n = parent.numNodes;
            parent.numNodes = n + 1;
            int n3 = stack.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                Node n4;
                Node node5 = n4 = stack[i2];
                Intrinsics.checkNotNull((Object)node5);
                node5.nodes[0] = i2 == stack.length - 1 ? chunk : stack[i2 + 1];
                int n5 = n4.numNodes;
                for (int j = 0; j < n5; ++j) {
                    long[] lArray = n4.offsets;
                    int n6 = j;
                    lArray[n6] = lArray[n6] + (chunk != null ? (long)chunk.length : 0L);
                }
                n4.updateStrict();
            }
            Node node6 = stack[0];
            Intrinsics.checkNotNull((Object)node6);
            return node6;
        }

        @NotNull
        public final Node pushLast(@NotNull Node node, @Nullable Object editor) {
            Node parent;
            int i;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (node.size() == 0L) {
                return this;
            }
            if (this.size() == 0L && this.shift - node.shift > 5) {
                return this.pushLast(Node.Companion.from(editor, node.shift + 5, node), editor);
            }
            if (this.shift < node.shift) {
                return node.pushFirst(this, editor);
            }
            if (this.shift == node.shift) {
                return Node.Companion.from(editor, this.shift + 5, this, node);
            }
            Node[] stack = new Node[this.numNodes == 0 ? 1 : (this.shift - node.shift) / 5];
            stack[0] = this;
            int n = stack.length;
            for (i = 1; i < n; ++i) {
                Node n2;
                Node node2 = n2 = stack[i - 1];
                Intrinsics.checkNotNull((Object)node2);
                stack[i] = node2.nodes[n2.numNodes - 1];
            }
            Node node3 = stack[stack.length - 1];
            Intrinsics.checkNotNull((Object)node3);
            if (node3.numNodes == 32) {
                return this.pushLast(Node.Companion.from(editor, node.shift + 5, node), editor);
            }
            n = stack.length;
            for (i = 0; i < n; ++i) {
                Node node4 = stack[i];
                Intrinsics.checkNotNull((Object)node4);
                if (node4.editor == editor) continue;
                Node node5 = stack[i];
                Intrinsics.checkNotNull((Object)node5);
                stack[i] = node5.clone(editor);
            }
            Node node6 = parent = stack[stack.length - 1];
            Intrinsics.checkNotNull((Object)node6);
            if (node6.nodes.length == parent.numNodes) {
                parent.grow();
            }
            parent.offsets[parent.numNodes] = parent.size();
            n = parent.numNodes;
            parent.numNodes = n + 1;
            long nSize = node.size();
            int n3 = stack.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                Node n4;
                Node node7 = n4 = stack[i2];
                Intrinsics.checkNotNull((Object)node7);
                int lastIdx = node7.numNodes - 1;
                n4.nodes[lastIdx] = i2 == stack.length - 1 ? node : stack[i2 + 1];
                this.assertInvariants();
                long[] lArray = n4.offsets;
                lArray[lastIdx] = lArray[lastIdx] + nSize;
                n4.updateStrict();
            }
            Node node8 = stack[0];
            Intrinsics.checkNotNull((Object)node8);
            return node8;
        }

        @NotNull
        public final Node pushFirst(@Nullable Node node, @Nullable Object editor) {
            Node parent;
            int i;
            if (!(this.size() > 0L)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            Node node2 = node;
            Intrinsics.checkNotNull((Object)node2);
            if (node2.size() == 0L) {
                return this;
            }
            if (this.shift < node.shift) {
                return node.pushLast(this, editor);
            }
            if (this.shift == node.shift) {
                return Node.Companion.from(editor, this.shift + 5, node, this);
            }
            Node[] stack = new Node[this.numNodes == 0 ? 1 : (this.shift - node.shift) / 5];
            stack[0] = this;
            int n = stack.length;
            for (i = 1; i < n; ++i) {
                Node n2;
                Node node3 = n2 = stack[i - 1];
                Intrinsics.checkNotNull((Object)node3);
                stack[i] = node3.nodes[0];
            }
            Node node4 = stack[stack.length - 1];
            Intrinsics.checkNotNull((Object)node4);
            if (node4.numNodes == 32) {
                return this.pushFirst(Node.Companion.from(editor, node.shift + 5, node), editor);
            }
            n = stack.length;
            for (i = 0; i < n; ++i) {
                Node node5 = stack[i];
                Intrinsics.checkNotNull((Object)node5);
                if (node5.editor == editor) continue;
                Node node6 = stack[i];
                Intrinsics.checkNotNull((Object)node6);
                stack[i] = node6.clone(editor);
            }
            Node node7 = parent = stack[stack.length - 1];
            Intrinsics.checkNotNull((Object)node7);
            if (node7.nodes.length == parent.numNodes) {
                parent.grow();
            }
            ArraysKt.copyInto((Object[])parent.nodes, (Object[])parent.nodes, (int)1, (int)0, (int)parent.numNodes);
            ArraysKt.copyInto((long[])parent.offsets, (long[])parent.offsets, (int)1, (int)0, (int)parent.numNodes);
            n = parent.numNodes;
            parent.numNodes = n + 1;
            parent.offsets[0] = 0L;
            long nSize = node.size();
            int n3 = stack.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                Node n4;
                Node node8 = n4 = stack[i2];
                Intrinsics.checkNotNull((Object)node8);
                node8.nodes[0] = i2 == stack.length - 1 ? node : stack[i2 + 1];
                int j = 0;
                int n5 = n4.numNodes;
                while (j < n5) {
                    long[] lArray = n4.offsets;
                    int n6 = j++;
                    lArray[n6] = lArray[n6] + nSize;
                }
                n4.updateStrict();
            }
            Node node9 = stack[0];
            Intrinsics.checkNotNull((Object)node9);
            return node9;
        }

        @NotNull
        public final Node popFirst(@Nullable Object editor) {
            Node parent;
            Node[] stack = new Node[this.shift / 5];
            stack[0] = editor == this.editor ? this : this.clone(editor);
            int n = stack.length;
            for (int i = 1; i < n; ++i) {
                Node n2;
                Node node = n2 = stack[i - 1];
                Intrinsics.checkNotNull((Object)node);
                stack[i] = node.nodes[0];
            }
            Node node = parent = stack[stack.length - 1];
            Intrinsics.checkNotNull((Object)node);
            Object[] chunk = (Object[])node.nodes[0];
            int n3 = stack.length;
            block1: for (int i = 0; i < n3; ++i) {
                Node n4 = stack[i];
                int j = 0;
                Node node2 = n4;
                Intrinsics.checkNotNull((Object)node2);
                int n5 = node2.numNodes;
                while (j < n5) {
                    long[] lArray = n4.offsets;
                    int n6 = j++;
                    long l = lArray[n6];
                    Intrinsics.checkNotNull((Object)chunk);
                    lArray[n6] = l - (long)chunk.length;
                }
                n4.updateStrict();
                if (n4.offsets[0] == 0L) {
                    int n7 = n4.numNodes;
                    n4.numNodes = n7 + -1;
                    ArraysKt.copyInto((Object[])n4.nodes, (Object[])n4.nodes, (int)0, (int)1, (int)(n4.numNodes + 1));
                    ArraysKt.copyInto((long[])n4.offsets, (long[])n4.offsets, (int)0, (int)1, (int)(n4.numNodes + 1));
                    n4.nodes[n4.numNodes] = null;
                    n4.offsets[n4.numNodes] = 0L;
                    n4.updateStrict();
                    if (i != 0) break;
                    while (true) {
                        Node node3 = stack[0];
                        Intrinsics.checkNotNull((Object)node3);
                        if (node3.shift <= 5) break block1;
                        Node node4 = stack[0];
                        Intrinsics.checkNotNull((Object)node4);
                        if (node4.numNodes != 1) break block1;
                        Node node5 = stack[0];
                        Intrinsics.checkNotNull((Object)node5);
                        stack[0] = node5.nodes[0];
                    }
                }
                Node node6 = stack[i + 1];
                Intrinsics.checkNotNull((Object)node6);
                if (node6.editor != editor) {
                    Node node7 = stack[i + 1];
                    Intrinsics.checkNotNull((Object)node7);
                    stack[i + 1] = node7.clone(editor);
                }
                n4.nodes[0] = stack[i + 1];
            }
            Node node8 = stack[0];
            Intrinsics.checkNotNull((Object)node8);
            return node8;
        }

        @NotNull
        public final Node popLast(@Nullable Object editor) {
            Node parent;
            Node[] stack = new Node[this.shift / 5];
            stack[0] = editor == this.editor ? this : this.clone(editor);
            int n = stack.length;
            for (int i = 1; i < n; ++i) {
                Node n2;
                Node node = n2 = stack[i - 1];
                Intrinsics.checkNotNull((Object)node);
                stack[i] = node.nodes[n2.numNodes - 1];
            }
            Node node = parent = stack[stack.length - 1];
            Intrinsics.checkNotNull((Object)node);
            Object[] chunk = (Object[])node.nodes[parent.numNodes - 1];
            int n3 = stack.length;
            block1: for (int i = 0; i < n3; ++i) {
                Node n4;
                Node node2 = n4 = stack[i];
                Intrinsics.checkNotNull((Object)node2);
                int lastIdx = node2.numNodes - 1;
                long[] lArray = n4.offsets;
                long l = lArray[lastIdx];
                Intrinsics.checkNotNull((Object)chunk);
                lArray[lastIdx] = l - (long)chunk.length;
                if (n4.offset(lastIdx + 1) == n4.offset(lastIdx)) {
                    int n5 = n4.numNodes;
                    n4.numNodes = n5 + -1;
                    n4.nodes[n4.numNodes] = null;
                    n4.offsets[n4.numNodes] = 0L;
                    n4.updateStrict();
                    if (i != 0) break;
                    while (true) {
                        Node node3 = stack[0];
                        Intrinsics.checkNotNull((Object)node3);
                        if (node3.shift <= 5) break block1;
                        Node node4 = stack[0];
                        Intrinsics.checkNotNull((Object)node4);
                        if (node4.numNodes != 1) break block1;
                        Node node5 = stack[0];
                        Intrinsics.checkNotNull((Object)node5);
                        stack[0] = node5.nodes[0];
                    }
                }
                Node node6 = stack[i + 1];
                Intrinsics.checkNotNull((Object)node6);
                if (node6.editor != editor) {
                    Node node7 = stack[i + 1];
                    Intrinsics.checkNotNull((Object)node7);
                    stack[i + 1] = node7.clone(editor);
                }
                n4.nodes[lastIdx] = stack[i + 1];
                n4.updateStrict();
            }
            Node node8 = stack[0];
            Intrinsics.checkNotNull((Object)node8);
            return node8;
        }

        private final void grow() {
            long[] o = new long[this.offsets.length << 1];
            ArraysKt.copyInto((long[])this.offsets, (long[])o, (int)0, (int)0, (int)this.offsets.length);
            this.offsets = o;
            Object[] n = new Object[this.nodes.length << 1];
            ArraysKt.copyInto((Object[])this.nodes, (Object[])n, (int)0, (int)0, (int)this.nodes.length);
            this.nodes = n;
        }

        private final void updateStrict() {
            this.isStrict = this.numNodes <= 1 || this.offset(this.numNodes - 1) == (long)(this.numNodes - 1) * (1L << this.shift);
        }

        private final Node clone(Object editor) {
            Node n = new Node(this.shift);
            n.editor = editor;
            n.numNodes = this.numNodes;
            long[] lArray = Arrays.copyOf(this.offsets, this.offsets.length);
            Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(...)");
            n.offsets = lArray;
            Object[] objectArray = Arrays.copyOf(this.nodes, this.nodes.length);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
            n.nodes = objectArray;
            return n;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u00012\u0010\u0010\t\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\nH\u0002\u00a2\u0006\u0002\u0010\u000bJ\"\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0004H\u0002J*\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lfleet/util/bifurcan/nodes/ListNodes$Node$Companion;", "", "()V", "EMPTY", "Lfleet/util/bifurcan/nodes/ListNodes$Node;", "getEMPTY", "()Lfleet/util/bifurcan/nodes/ListNodes$Node;", "from", "editor", "child", "", "(Ljava/lang/Object;[Ljava/lang/Object;)Lfleet/util/bifurcan/nodes/ListNodes$Node;", "shift", "", "a", "b", "fleet.util.core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Node getEMPTY() {
                return EMPTY;
            }

            private final Node from(Object editor, int shift, Node child) {
                return new Node(editor, shift).pushLast(child, editor);
            }

            private final Node from(Object editor, int shift, Node a, Node b) {
                return new Node(editor, shift).pushLast(a, editor).pushLast(b, editor);
            }

            private final Node from(Object editor, Object[] child) {
                return new Node(editor, 5).pushLast(child, editor);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

