/*
 * Decompiled with CFR 0.152.
 */
package fleet.util;

import fleet.preferences.FleetPropertiesKt;
import fleet.util.Random;
import fleet.util.logging.KLogger;
import fleet.util.logging.KLoggers;
import fleet.util.serialization.DelegateSerializer;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=Serializer.class)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0002\r\u000eB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lfleet/util/UID;", "", "id", "", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "equals", "", "other", "hashCode", "", "toString", "Companion", "Serializer", "fleet.util.core"})
@SourceDebugExtension(value={"SMAP\nUID.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UID.kt\nfleet/util/UID\n+ 2 KLogger.kt\nfleet/util/logging/KLogger\n+ 3 KLoggers.kt\nfleet/util/logging/KLoggersKt\n*L\n1#1,60:1\n37#2,2:61\n22#3:63\n*S KotlinDebug\n*F\n+ 1 UID.kt\nfleet/util/UID\n*L\n17#1:61,2\n26#1:63\n*E\n"})
public final class UID {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private static final KLogger logger;
    @NotNull
    private static final Regex uidRegex;
    public static final int MAX_LENGTH = 36;
    private static final int LEN = 20;
    private static final int RADIX = 32;

    /*
     * WARNING - void declaration
     */
    private UID(String id) {
        this.id = id;
        if (this.id.length() > 36) {
            void this_$iv;
            KLogger kLogger = logger;
            Throwable t$iv = new Throwable();
            boolean $i$f$warn = false;
            if (this_$iv.isWarnEnabled()) {
                Throwable throwable = t$iv;
                void var6_6 = this_$iv;
                boolean bl = false;
                String string = "Invalid UID format: \"" + this.id + "\", UID is a random [A-Za-z0-9_-] string, case-sensitive, no more than 36 characters long. This will be a hard error in the future.";
                var6_6.warn(throwable, (Object)string);
            }
        }
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof UID && Intrinsics.areEqual((Object)this.id, (Object)((UID)other).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @NotNull
    public String toString() {
        return this.id;
    }

    public /* synthetic */ UID(String id, DefaultConstructorMarker $constructor_marker) {
        this(id);
    }

    static {
        boolean $i$f$logger = false;
        logger = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(UID.class));
        uidRegex = new Regex("^([A-Za-z0-9_-]{1,36})$");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\fJ\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u0011H\u00c6\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lfleet/util/UID$Companion;", "", "()V", "LEN", "", "MAX_LENGTH", "RADIX", "logger", "Lfleet/util/logging/KLogger;", "uidRegex", "Lkotlin/text/Regex;", "fromString", "Lfleet/util/UID;", "id", "", "random", "serializer", "Lkotlinx/serialization/KSerializer;", "fleet.util.core"})
    @SourceDebugExtension(value={"SMAP\nUID.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UID.kt\nfleet/util/UID$Companion\n+ 2 KLogger.kt\nfleet/util/logging/KLogger\n*L\n1#1,60:1\n41#2,2:61\n*S KotlinDebug\n*F\n+ 1 UID.kt\nfleet/util/UID$Companion\n*L\n40#1:61,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UID random() {
            Random $this$random_u24lambda_u240 = Random.INSTANCE;
            boolean bl = false;
            String string = new BigInteger($this$random_u24lambda_u240.nextBytes(16)).toString(32);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return new UID(StringsKt.take((String)StringsKt.drop((String)string, (int)1), (int)20), null);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final UID fromString(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Companion $this$fromString_u24lambda_u242 = this;
            boolean bl = false;
            if (FleetPropertiesKt.isFleetInternalDefaultValue()) {
                CharSequence charSequence = id;
                if (!uidRegex.matches(charSequence)) {
                    void this_$iv;
                    charSequence = logger;
                    Throwable t$iv = new Throwable();
                    boolean $i$f$error = false;
                    if (this_$iv.isErrorEnabled()) {
                        Throwable throwable = t$iv;
                        void var8_8 = this_$iv;
                        boolean bl2 = false;
                        String string = "Invalid UID format: \"" + id + "\", UID is a random [A-Za-z0-9_-] string, case-sensitive, no more than 36 characters long. This will be a hard error in the future.";
                        var8_8.error(throwable, (Object)string);
                    }
                }
            }
            return new UID(id, null);
        }

        @NotNull
        public final KSerializer<UID> serializer() {
            return Serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lfleet/util/UID$Serializer;", "Lfleet/util/serialization/DelegateSerializer;", "Lfleet/util/UID;", "", "()V", "fleet.util.core"})
    public static final class Serializer
    extends DelegateSerializer<UID, String> {
        @NotNull
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
            super(1.INSTANCE, BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE), 2.INSTANCE);
        }
    }
}

