/*
 * Decompiled with CFR 0.152.
 */
package fleet.org.jetbrains.plugins.less.parser;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.psi.css.impl.CssElementTypes;
import fleet.com.intellij.psi.css.impl.parsing.CssMathParser;
import fleet.com.intellij.psi.css.impl.parsing.CssParser;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.org.jetbrains.plugins.less.lexer.LESSTokenTypes;
import fleet.org.jetbrains.plugins.less.parser.LESSParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LessMathParser
extends CssMathParser {
    @NotNull
    private final LESSParser myParser;

    public LessMathParser(@NotNull LESSParser parser) {
        super((CssParser)parser);
        this.myParser = parser;
    }

    public boolean parse() {
        boolean ok = this.parseEscapeStringsAsTerms();
        if (ok && this.getTokenType() == CssElementTypes.CSS_RPAREN) {
            return true;
        }
        if (super.parse()) {
            ok = true;
            this.parseEscapeStringsAsTerms();
        }
        return ok;
    }

    protected boolean parseTerm(@Nullable IElementType prevOperation) {
        boolean result = this.parseTermInner(prevOperation);
        if (this.myParser.parseEscapeString()) {
            while (this.myParser.parseEscapeString()) {
            }
            this.parseTerm(prevOperation);
            return true;
        }
        return result;
    }

    private boolean parseTermInner(@Nullable IElementType prevOperation) {
        if (this.getTokenType() == LESSTokenTypes.VARIABLE) {
            this.myParser.parseVariable();
            return true;
        }
        return super.parseTerm(prevOperation);
    }

    private boolean parseEscapeStringsAsTerms() {
        if (this.parseEscapeStringAsTerm()) {
            while (this.parseEscapeStringAsTerm()) {
            }
            return true;
        }
        return false;
    }

    private boolean parseEscapeStringAsTerm() {
        PsiBuilder.Marker m = this.mark();
        if (this.myParser.parseEscapeString()) {
            m.done(CssElementTypes.CSS_TERM);
            return true;
        }
        m.rollbackTo();
        return false;
    }
}

