/*
 * Decompiled with CFR 0.152.
 */
package fleet.diff.frontend;

import andel.intervals.Interval;
import andel.intervals.Intervals;
import andel.intervals.IntervalsFactory;
import andel.lines.Interline;
import andel.lines.Line;
import andel.lines.LineBasedHeight;
import andel.lines.LinesCache;
import andel.text.Text;
import andel.text.TextRange;
import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.EntitiesKt;
import com.jetbrains.rhizomedb.Entity;
import fleet.common.document.EditorEntity;
import fleet.common.document.UnsharedHackKt;
import fleet.diff.DiffChange;
import fleet.diff.DiffType;
import fleet.diff.SideBySideDiffFragment;
import fleet.diff.SideBySideDiffFragmentType;
import fleet.diff.SideBySideDiffKt;
import fleet.diff.frontend.DiffInterline;
import fleet.diff.frontend.DiffMarkup;
import fleet.diff.frontend.DiffModalEntity;
import fleet.diff.frontend.InlineDiffKt;
import fleet.diff.frontend.RevertGutterWidget;
import fleet.diff.frontend.RevertWidgetKt;
import fleet.frontend.document.DocumentMarkupEntity;
import fleet.frontend.editor.EditorEntityExtKt;
import fleet.frontend.editor.EditorLayoutEntity;
import fleet.kernel.SharedChangeScope;
import fleet.kernel.plugins.PluginScope;
import fleet.kernel.plugins.WorkerKt;
import fleet.util.AtomicExtensionsKt;
import fleet.util.AtomicRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlinx.coroutines.CoroutineScope;
import noria.model.EditorSchemeKt;
import noria.model.components.editor.TextAttributesKey;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a$\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001aN\u0010\b\u001a\u00020\t*\u00020\n2\u0010\u0010\u000b\u001a\f\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u001a\u0014\u0010\u0019\u001a\u00020\u0003*\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a8\u0006\u001a"}, d2={"toInterval", "Landel/intervals/Interval;", "", "Lnoria/model/components/editor/TextAttributesKey;", "range", "Landel/text/TextRange;", "type", "Lfleet/diff/DiffType;", "createDiffInterline", "Lfleet/diff/frontend/DiffInterline;", "Lcom/jetbrains/rhizomedb/ChangeScope;", "diff", "", "Lfleet/diff/SideBySideDiffFragment;", "Lfleet/diff/SideBySideDiffFragments;", "leftEditor", "Lfleet/common/document/EditorEntity;", "rightEditor", "binding", "Landel/lines/Interline$Binding;", "closeable", "", "revertible", "pluginScope", "Lfleet/kernel/plugins/PluginScope;", "toTextAttributeKey", "fleet.diff.frontend"})
@SourceDebugExtension(value={"SMAP\nDiffInterline.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffInterline.kt\nfleet/diff/frontend/DiffInterlineKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n1#2:173\n1549#3:174\n1620#3,3:175\n1549#3:178\n1620#3,3:179\n*S KotlinDebug\n*F\n+ 1 DiffInterline.kt\nfleet/diff/frontend/DiffInterlineKt\n*L\n70#1:174\n70#1:175,3\n82#1:178\n82#1:179,3\n*E\n"})
public final class DiffInterlineKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DiffInterline createDiffInterline(@NotNull ChangeScope $this$createDiffInterline, @NotNull List<SideBySideDiffFragment> diff, @NotNull EditorEntity leftEditor2, @NotNull EditorEntity rightEditor2, @NotNull Interline.Binding binding, boolean closeable, boolean revertible, @NotNull PluginScope pluginScope) {
        Intervals intervals;
        Object[] $this$map$iv;
        TextAttributesKey rightColor;
        Iterable it;
        Collection collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv2;
        Intrinsics.checkNotNullParameter((Object)$this$createDiffInterline, (String)"<this>");
        Intrinsics.checkNotNullParameter(diff, (String)"diff");
        Intrinsics.checkNotNullParameter((Object)leftEditor2, (String)"leftEditor");
        Intrinsics.checkNotNullParameter((Object)rightEditor2, (String)"rightEditor");
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        Intrinsics.checkNotNullParameter((Object)pluginScope, (String)"pluginScope");
        if (!(!((Collection)diff).isEmpty())) {
            boolean $i$a$-require-DiffInterlineKt$createDiffInterline$22 = false;
            String $i$a$-require-DiffInterlineKt$createDiffInterline$22 = "can't create diff interline for an empty diff";
            throw new IllegalArgumentException($i$a$-require-DiffInterlineKt$createDiffInterline$22.toString());
        }
        Text leftText = leftEditor2.getDocument().getText();
        Text rightText = rightEditor2.getDocument().getText();
        List diffChanges = SideBySideDiffKt.getChanges(diff, (Text)leftText, (Text)rightText);
        TextRange leftEditRange = SideBySideDiffKt.leftEditRange(diff, (Text)leftText);
        TextRange leftPaintRange = SideBySideDiffKt.leftPaintRange(diff, (Text)leftText);
        long leftId = AtomicExtensionsKt.incrementAndGet((AtomicRef)EditorLayoutEntity.Companion.getNextId());
        Iterable iterable = diffChanges;
        IntervalsFactory intervalsFactory = Intervals.Companion.keepingCollapsed();
        boolean $i$f$map = false;
        void var18_20 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            DiffChange diffChange = (DiffChange)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DiffInterlineKt.toInterval(it.getLeftRange(), it.getLeftType()));
        }
        Intervals leftIntervals = intervalsFactory.fromIntervals((Iterable)((List)destination$iv$iv)).addIntervals((Iterable)CollectionsKt.listOf((Object)new Interval((Object)leftId, leftEditRange, false, false, (Object)EditorSchemeKt.getEditorScheme().getTransparent())));
        TextRange rightEditRange = SideBySideDiffKt.rightEditRange(diff, (Text)rightText);
        TextRange rightPaintRange = SideBySideDiffKt.rightPaintRange(diff, (Text)rightText);
        boolean isDeletion = SideBySideDiffKt.getType(diff) == SideBySideDiffFragmentType.DELETED;
        long rightId = AtomicExtensionsKt.incrementAndGet((AtomicRef)EditorLayoutEntity.Companion.getNextId());
        TextAttributesKey textAttributesKey = rightColor = isDeletion ? EditorSchemeKt.getEditorScheme().getText() : EditorSchemeKt.getEditorScheme().getDiffModifiedWithBorder();
        if (!isDeletion) {
            void $this$mapTo$iv$iv2;
            it = diffChanges;
            intervalsFactory = Intervals.Companion.keepingCollapsed();
            boolean $i$f$map2 = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it2;
                DiffChange diffChange = (DiffChange)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(DiffInterlineKt.toInterval(it2.getRightRange(), it2.getRightType()));
            }
            intervals = intervalsFactory.fromIntervals((Iterable)((List)destination$iv$iv2));
        } else {
            intervals = Intervals.Companion.keepingCollapsed().empty();
        }
        $this$map$iv = new Interval[]{new Interval((Object)rightId, rightEditRange, false, false, (Object)EditorSchemeKt.getEditorScheme().getTransparent()), new Interval((Object)AtomicExtensionsKt.incrementAndGet((AtomicRef)EditorLayoutEntity.Companion.getNextId()), rightPaintRange, false, false, (Object)rightColor)};
        Intervals rightIntervals = intervals.addIntervals((Iterable)CollectionsKt.listOf((Object[])$this$map$iv));
        long interlineId = AtomicExtensionsKt.incrementAndGet((AtomicRef)EditorLayoutEntity.Companion.getNextId());
        DiffModalEntity diffModal2 = InlineDiffKt.diffModal($this$createDiffInterline, rightEditor2, rightId, closeable, revertible, interlineId);
        WorkerKt.onDispose((Entity)((Entity)diffModal2), (CoroutineScope)((CoroutineScope)pluginScope), (Function0)((Function0)new Function0<Unit>(pluginScope, leftEditor2){
            final /* synthetic */ PluginScope $pluginScope;
            final /* synthetic */ EditorEntity $leftEditor;
            {
                this.$pluginScope = $pluginScope;
                this.$leftEditor = $leftEditor;
                super(0);
            }

            public final void invoke() {
                this.$pluginScope.changeAsync((Function1)new Function1<ChangeScope, Unit>(this.$leftEditor){
                    final /* synthetic */ EditorEntity $leftEditor;
                    {
                        this.$leftEditor = $leftEditor;
                        super(1);
                    }

                    public final void invoke(@NotNull ChangeScope $this$changeAsync) {
                        Intrinsics.checkNotNullParameter((Object)$this$changeAsync, (String)"$this$changeAsync");
                        if (EntitiesKt.exists((Entity)((Entity)this.$leftEditor))) {
                            UnsharedHackKt.maybeShared((ChangeScope)$this$changeAsync, (Entity)((Entity)this.$leftEditor.getDocument()), (Function1)((Function1)new Function1<SharedChangeScope, Unit>(this.$leftEditor){
                                final /* synthetic */ EditorEntity $leftEditor;
                                {
                                    this.$leftEditor = $leftEditor;
                                    super(1);
                                }

                                public final void invoke(@NotNull SharedChangeScope $this$maybeShared) {
                                    Intrinsics.checkNotNullParameter((Object)$this$maybeShared, (String)"$this$maybeShared");
                                    $this$maybeShared.delete((Entity)this.$leftEditor);
                                }
                            }));
                        }
                    }
                });
            }
        }));
        RevertGutterWidget widget2 = revertible ? RevertWidgetKt.inlineRevertWidget(leftIntervals, leftId, leftEditor2.getDocument(), rightIntervals, rightId, rightEditor2, (Function1<? super ChangeScope, Unit>)((Function1)new Function1<ChangeScope, Unit>(diffModal2){
            final /* synthetic */ DiffModalEntity $diffModal;
            {
                this.$diffModal = $diffModal;
                super(1);
            }

            public final void invoke(@NotNull ChangeScope $this$inlineRevertWidget) {
                Intrinsics.checkNotNullParameter((Object)$this$inlineRevertWidget, (String)"$this$inlineRevertWidget");
                $this$inlineRevertWidget.delete((Entity)this.$diffModal);
            }
        })) : null;
        ChangeScope.DefaultImpls.new$default((ChangeScope)$this$createDiffInterline, (KClass)Reflection.getOrCreateKotlinClass(DiffMarkup.class), (int)0, (Function1)((Function1)new Function1<DiffMarkup, Unit>(leftEditor2, diffModal2, (Intervals<Long, TextAttributesKey>)leftIntervals, closeable, isDeletion, widget2, leftId, leftPaintRange){
            final /* synthetic */ EditorEntity $leftEditor;
            final /* synthetic */ DiffModalEntity $diffModal;
            final /* synthetic */ Intervals<Long, TextAttributesKey> $leftIntervals;
            final /* synthetic */ boolean $closeable;
            final /* synthetic */ boolean $isDeletion;
            final /* synthetic */ RevertGutterWidget $widget;
            final /* synthetic */ long $leftId;
            final /* synthetic */ TextRange $leftPaintRange;
            {
                this.$leftEditor = $leftEditor;
                this.$diffModal = $diffModal;
                this.$leftIntervals = $leftIntervals;
                this.$closeable = $closeable;
                this.$isDeletion = $isDeletion;
                this.$widget = $widget;
                this.$leftId = $leftId;
                this.$leftPaintRange = $leftPaintRange;
                super(1);
            }

            public final void invoke(@NotNull DiffMarkup $this$new) {
                Intrinsics.checkNotNullParameter((Object)$this$new, (String)"$this$new");
                $this$new.setEditor(this.$leftEditor);
                $this$new.setDiffModalEntity(this.$diffModal);
                $this$new.setDocument(this.$leftEditor.getDocument());
                $this$new.setIntervals(this.$leftIntervals);
                $this$new.setGutterWidgets(this.$closeable && this.$isDeletion && this.$widget != null ? Intervals.Companion.fromSingle((Object)this.$leftId, this.$leftPaintRange, true, true, (Object)this.$widget) : Intervals.Companion.empty());
                $this$new.setLayer(300);
                $this$new.setDebugName("Diff line status");
            }
        }), (int)2, null);
        diffModal2.setMarkup((DocumentMarkupEntity)ChangeScope.DefaultImpls.new$default((ChangeScope)$this$createDiffInterline, (KClass)Reflection.getOrCreateKotlinClass(DiffMarkup.class), (int)0, (Function1)((Function1)new Function1<DiffMarkup, Unit>(rightEditor2, diffModal2, (Intervals<Long, TextAttributesKey>)rightIntervals, closeable, isDeletion, widget2, leftId, rightPaintRange){
            final /* synthetic */ EditorEntity $rightEditor;
            final /* synthetic */ DiffModalEntity $diffModal;
            final /* synthetic */ Intervals<Long, TextAttributesKey> $rightIntervals;
            final /* synthetic */ boolean $closeable;
            final /* synthetic */ boolean $isDeletion;
            final /* synthetic */ RevertGutterWidget $widget;
            final /* synthetic */ long $leftId;
            final /* synthetic */ TextRange $rightPaintRange;
            {
                this.$rightEditor = $rightEditor;
                this.$diffModal = $diffModal;
                this.$rightIntervals = $rightIntervals;
                this.$closeable = $closeable;
                this.$isDeletion = $isDeletion;
                this.$widget = $widget;
                this.$leftId = $leftId;
                this.$rightPaintRange = $rightPaintRange;
                super(1);
            }

            public final void invoke(@NotNull DiffMarkup $this$new) {
                Intrinsics.checkNotNullParameter((Object)$this$new, (String)"$this$new");
                $this$new.setEditor(this.$rightEditor);
                $this$new.setDiffModalEntity(this.$diffModal);
                $this$new.setDocument(this.$rightEditor.getDocument());
                $this$new.setIntervals(this.$rightIntervals);
                $this$new.setGutterWidgets(this.$closeable && !this.$isDeletion && this.$widget != null ? Intervals.Companion.fromSingle((Object)this.$leftId, this.$rightPaintRange, true, true, (Object)this.$widget) : Intervals.Companion.empty());
                $this$new.setLayer(300);
                $this$new.setDebugName("Diff line status");
            }
        }), (int)2, null));
        EditorLayoutEntity editorLayoutEntity = EditorEntityExtKt.getLayout((EditorEntity)leftEditor2);
        Intrinsics.checkNotNull((Object)editorLayoutEntity);
        LinesCache linesCache = editorLayoutEntity.getLinesCache();
        Line lastLine = linesCache.line(leftPaintRange.getEnd());
        long l = LineBasedHeight.minus-RJHVaDk((long)LineBasedHeight.plus-RJHVaDk((long)lastLine.getLineTop-x8klknc(), (long)lastLine.getLineHeight-x8klknc()), (long)linesCache.line(leftPaintRange.getStart()).getLineTop-x8klknc());
        return new DiffInterline(binding, l, interlineId, diffModal2, leftEditor2, rightEditor2, leftPaintRange, closeable, isDeletion, null);
    }

    @NotNull
    public static final TextAttributesKey toTextAttributeKey(@NotNull DiffType $this$toTextAttributeKey, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)$this$toTextAttributeKey, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toTextAttributeKey.ordinal()]) {
            case 1 -> {
                if (range.isEmpty()) {
                    yield EditorSchemeKt.getEditorScheme().getDiffAddedEmpty();
                }
                yield EditorSchemeKt.getEditorScheme().getDiffAddedWord();
            }
            case 2 -> {
                if (range.isEmpty()) {
                    yield EditorSchemeKt.getEditorScheme().getDiffDeletedEmpty();
                }
                yield EditorSchemeKt.getEditorScheme().getDiffDeletedWord();
            }
            case 3 -> {
                if (range.isEmpty()) {
                    yield EditorSchemeKt.getEditorScheme().getTransparent();
                }
                yield EditorSchemeKt.getEditorScheme().getDiffModifiedWord();
            }
            default -> throw new IllegalStateException("Unreachable".toString());
        };
    }

    private static final Interval<Long, TextAttributesKey> toInterval(TextRange range, DiffType type) {
        return new Interval((Object)AtomicExtensionsKt.incrementAndGet((AtomicRef)EditorLayoutEntity.Companion.getNextId()), range.getStart(), range.getEnd(), true, true, (Object)DiffInterlineKt.toTextAttributeKey(type, range));
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DiffType.values().length];
            try {
                nArray[DiffType.ADDED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DiffType.DELETED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DiffType.MODIFIED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

