/*
 * Decompiled with CFR 0.152.
 */
package fleet.mercury.frontend.execution;

import com.jetbrains.rhizomedb.EntitiesKt;
import fleet.api.FileAddress;
import fleet.api.FileAddressKt;
import fleet.common.document.DocumentEntity;
import fleet.common.document.DocumentEntityKt;
import fleet.common.document.EditorEntity;
import fleet.common.fs.ConfiguratorId;
import fleet.common.fs.SharedProjectRootEntity;
import fleet.common.fs.SharedProjectRootsKt;
import fleet.common.run.api.RunConfigEntity;
import fleet.common.run.api.RunNodeStatus;
import fleet.frontend.FeatureFlags;
import fleet.mercury.frontend.execution.MercuryBuildKt;
import fleet.protocol.run.TaskType;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import noria.model.ActionId;
import noria.model.ActionRegistrar;
import noria.model.PresenterScope;
import noria.model.Requirement;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0002\u001aQ\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013\u001a\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\bH\u0002\u00a8\u0006\u0016"}, d2={"buildGradleProjectAction", "", "Lnoria/model/ActionRegistrar;", "buildXcodeProjectAction", "findBuildActionContext", "Lkotlin/Pair;", "Lfleet/api/FileAddress;", "Lfleet/common/fs/SharedProjectRootEntity;", "Lnoria/model/PresenterScope;", "editorEntity", "Lnoria/model/Requirement;", "Lfleet/common/document/EditorEntity;", "configuratorId", "Lfleet/common/fs/ConfiguratorId;", "extension", "", "type", "", "Lfleet/protocol/run/TaskType;", "(Lnoria/model/PresenterScope;Lnoria/model/Requirement;Lfleet/common/fs/ConfiguratorId;Ljava/lang/String;[Lfleet/protocol/run/TaskType;)Lkotlin/Pair;", "hideAction", "", "fleet.plugins.mercury.frontend"})
@SourceDebugExtension(value={"SMAP\nMercuryBuild.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MercuryBuild.kt\nfleet/mercury/frontend/execution/MercuryBuildKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,157:1\n1747#2,3:158\n*S KotlinDebug\n*F\n+ 1 MercuryBuild.kt\nfleet/mercury/frontend/execution/MercuryBuildKt\n*L\n129#1:158,3\n*E\n"})
public final class MercuryBuildKt {
    public static final void buildGradleProjectAction(@NotNull ActionRegistrar $this$buildGradleProjectAction) {
        Intrinsics.checkNotNullParameter((Object)$this$buildGradleProjectAction, (String)"<this>");
        $this$buildGradleProjectAction.action(new ActionId("mercury/build/build-gradle-project"), "Build Gradle Project", (Function1)buildGradleProjectAction.1.INSTANCE);
    }

    public static final void buildXcodeProjectAction(@NotNull ActionRegistrar $this$buildXcodeProjectAction) {
        Intrinsics.checkNotNullParameter((Object)$this$buildXcodeProjectAction, (String)"<this>");
        $this$buildXcodeProjectAction.action(new ActionId("mercury/build/build-xcode-project"), "Build Xcode Project", (Function1)buildXcodeProjectAction.1.INSTANCE);
    }

    private static final Pair<FileAddress, SharedProjectRootEntity> findBuildActionContext(PresenterScope $this$findBuildActionContext, Requirement<EditorEntity> editorEntity, ConfiguratorId configuratorId, String extension, TaskType ... type) {
        boolean isBuildRunning;
        block8: {
            if (!FeatureFlags.INSTANCE.getKmpBuildActions()) {
                return (Pair)MercuryBuildKt.hideAction($this$findBuildActionContext);
            }
            Iterable $this$any$iv = EntitiesKt.byEntityType((KClass)Reflection.getOrCreateKotlinClass(RunConfigEntity.class));
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    RunConfigEntity it = (RunConfigEntity)element$iv;
                    boolean bl = false;
                    if (!(ArraysKt.contains((Object[])type, (Object)it.getType()) && it.status() == RunNodeStatus.RUNNING)) continue;
                    v0 = true;
                    break block8;
                }
                v0 = isBuildRunning = false;
            }
        }
        if (isBuildRunning) {
            return (Pair)MercuryBuildKt.hideAction($this$findBuildActionContext);
        }
        FileAddress contextFile = DocumentEntityKt.getLocationFileAddress((DocumentEntity)((EditorEntity)$this$findBuildActionContext.getValue(editorEntity)).getDocument());
        if (contextFile == null) {
            return (Pair)MercuryBuildKt.hideAction($this$findBuildActionContext);
        }
        if (!Intrinsics.areEqual((Object)FileAddressKt.getExtension((FileAddress)contextFile), (Object)extension)) {
            return (Pair)MercuryBuildKt.hideAction($this$findBuildActionContext);
        }
        ConfiguratorId[] configuratorIdArray = new ConfiguratorId[]{configuratorId};
        SharedProjectRootEntity projectRoot = (SharedProjectRootEntity)SequencesKt.singleOrNull((Sequence)SharedProjectRootsKt.findProjectRoots((FileAddress)contextFile, (ConfiguratorId[])configuratorIdArray));
        if (projectRoot == null) {
            return (Pair)MercuryBuildKt.hideAction($this$findBuildActionContext);
        }
        return TuplesKt.to((Object)contextFile, (Object)projectRoot);
    }

    private static final Void hideAction(PresenterScope $this$hideAction) {
        $this$hideAction.setHidden(true);
        return null;
    }

    public static final /* synthetic */ Pair access$findBuildActionContext(PresenterScope $receiver, Requirement editorEntity, ConfiguratorId configuratorId, String extension, TaskType ... type) {
        return MercuryBuildKt.findBuildActionContext($receiver, (Requirement<EditorEntity>)editorEntity, configuratorId, extension, type);
    }
}

