/*
 * Decompiled with CFR 0.152.
 */
package fleet.net;

import fleet.net.HttpProxyConfiguration;
import fleet.net.HttpProxyExtensionsKt;
import fleet.net.ProxyAuthenticationPluginConfig;
import fleet.util.logging.KLogger;
import fleet.util.logging.KLoggers;
import io.ktor.client.plugins.api.ClientPlugin;
import io.ktor.client.plugins.api.CreatePluginUtilsKt;
import io.ktor.http.URLProtocol;
import io.ktor.http.URLUtilsKt;
import io.ktor.http.Url;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002\u001a\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0006H\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006H\u0002\u001a\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0006*\u00020\u0013H\u0002\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0014"}, d2={"ProxyAuthenticationPlugin", "Lio/ktor/client/plugins/api/ClientPlugin;", "Lfleet/net/ProxyAuthenticationPluginConfig;", "getProxyAuthenticationPlugin", "()Lio/ktor/client/plugins/api/ClientPlugin;", "proxyBasicAuthenticationToken", "", "protocol", "Lio/ktor/http/URLProtocol;", "config", "Lfleet/net/HttpProxyConfiguration;", "reportInvalidProxySettings", "", "e", "", "proxyUrl", "sanitizeUrl", "url", "base64BasicAuthentication", "Lio/ktor/http/Url;", "fleet.util.network"})
@SourceDebugExtension(value={"SMAP\nHttpProxyExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpProxyExtensions.kt\nfleet/net/HttpProxyExtensionsKt\n+ 2 KLoggers.kt\nfleet/util/logging/KLoggersKt\n+ 3 KLogger.kt\nfleet/util/logging/KLogger\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n22#2:160\n17#3,2:161\n1#4:163\n*S KotlinDebug\n*F\n+ 1 HttpProxyExtensions.kt\nfleet/net/HttpProxyExtensionsKt\n*L\n67#1:160\n67#1:161,2\n*E\n"})
public final class HttpProxyExtensionsKt {
    @NotNull
    private static final ClientPlugin<ProxyAuthenticationPluginConfig> ProxyAuthenticationPlugin = CreatePluginUtilsKt.createClientPlugin((String)"ProxyAuthenticationPlugin", (Function0)ProxyAuthenticationPlugin.1.INSTANCE, (Function1)ProxyAuthenticationPlugin.2.INSTANCE);

    private static final String sanitizeUrl(String url) {
        return !StringsKt.contains$default((CharSequence)url, (CharSequence)"://", (boolean)false, (int)2, null) ? "http://" + url : url;
    }

    private static final void reportInvalidProxySettings(Throwable e, String proxyUrl) {
        Throwable throwable = e;
        if (throwable instanceof IllegalStateException ? true : throwable instanceof IllegalArgumentException) {
            boolean $i$f$logger = false;
            KLogger this_$iv = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(HttpProxyConfiguration.class));
            boolean $i$f$warn = false;
            if (this_$iv.isWarnEnabled()) {
                KLogger kLogger = this_$iv;
                boolean bl = false;
                kLogger.warn((Object)("Can not parse URL config: " + proxyUrl + ". Skipping proxy settings"));
            }
        } else {
            throw e;
        }
    }

    @NotNull
    public static final ClientPlugin<ProxyAuthenticationPluginConfig> getProxyAuthenticationPlugin() {
        return ProxyAuthenticationPlugin;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String proxyBasicAuthenticationToken(URLProtocol protocol, HttpProxyConfiguration config) {
        if (config == null) {
            return null;
        }
        URLProtocol uRLProtocol = protocol;
        String proxyUrl = Intrinsics.areEqual((Object)uRLProtocol, (Object)URLProtocol.Companion.getHTTP()) ? config.getHttpProxyUrl() : (Intrinsics.areEqual((Object)uRLProtocol, (Object)URLProtocol.Companion.getHTTPS()) ? config.getHttpsProxyUrl() : null);
        try {
            if (proxyUrl == null) return null;
            String it = proxyUrl;
            boolean bl = false;
            uRLProtocol = URLUtilsKt.Url((String)HttpProxyExtensionsKt.sanitizeUrl(it));
            if (uRLProtocol == null) return null;
            String string = HttpProxyExtensionsKt.base64BasicAuthentication((Url)uRLProtocol);
            return string;
        }
        catch (Throwable e) {
            HttpProxyExtensionsKt.reportInvalidProxySettings(e, proxyUrl);
            return null;
        }
    }

    private static final String base64BasicAuthentication(Url $this$base64BasicAuthentication) {
        String string;
        if ($this$base64BasicAuthentication.getUser() != null && $this$base64BasicAuthentication.getPassword() != null) {
            Base64.Encoder encoder = Base64.getEncoder();
            String string2 = $this$base64BasicAuthentication.getUser() + ":" + $this$base64BasicAuthentication.getPassword();
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            string = encoder.encodeToString(byArray);
        } else {
            string = null;
        }
        return string;
    }

    public static final /* synthetic */ String access$sanitizeUrl(String url) {
        return HttpProxyExtensionsKt.sanitizeUrl(url);
    }

    public static final /* synthetic */ void access$reportInvalidProxySettings(Throwable e, String proxyUrl) {
        HttpProxyExtensionsKt.reportInvalidProxySettings(e, proxyUrl);
    }

    public static final /* synthetic */ String access$proxyBasicAuthenticationToken(URLProtocol protocol, HttpProxyConfiguration config) {
        return HttpProxyExtensionsKt.proxyBasicAuthenticationToken(protocol, config);
    }
}

