/*
 * Decompiled with CFR 0.152.
 */
package dev.blachut.svelte.lang.parsing.html;

import dev.blachut.svelte.lang.SvelteBundle;
import dev.blachut.svelte.lang.UtilsKt;
import dev.blachut.svelte.lang.directives.SvelteDirectiveUtil;
import dev.blachut.svelte.lang.parsing.html.SvelteBlock;
import dev.blachut.svelte.lang.parsing.html.SvelteBlockParsing;
import dev.blachut.svelte.lang.parsing.html.SvelteTagParsing;
import dev.blachut.svelte.lang.psi.SvelteElementTypes;
import dev.blachut.svelte.lang.psi.SvelteHtmlElementTypes;
import dev.blachut.svelte.lang.psi.SvelteJSLazyElementTypes;
import dev.blachut.svelte.lang.psi.SvelteTagElementTypes;
import dev.blachut.svelte.lang.psi.SvelteTokenTypes;
import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.lang.html.HtmlParsing;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.xml.XmlElementType;
import fleet.com.intellij.psi.xml.XmlTokenType;
import fleet.com.intellij.xml.psi.XmlPsiBundle;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0010H\u0014J\b\u0010\u0012\u001a\u00020\u0010H\u0014J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\fH\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001bH\u0014J\b\u0010\u001d\u001a\u00020\u0016H\u0014J\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001bH\u0014J\r\u0010 \u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b!J\b\u0010\"\u001a\u00020\u0016H\u0002R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006#"}, d2={"Ldev/blachut/svelte/lang/parsing/html/SvelteHtmlParsing;", "Lfleet/com/intellij/lang/html/HtmlParsing;", "builder", "Lfleet/com/intellij/lang/PsiBuilder;", "(Lfleet/com/intellij/lang/PsiBuilder;)V", "currentBlock", "Ldev/blachut/svelte/lang/parsing/html/SvelteBlock;", "getCurrentBlock", "()Ldev/blachut/svelte/lang/parsing/html/SvelteBlock;", "getHtmlTagElementType", "Lfleet/com/intellij/psi/tree/IElementType;", "info", "Lfleet/com/intellij/lang/html/HtmlParsing$HtmlTagInfo;", "tagLevel", "", "hasCustomTagContent", "", "hasCustomTagHeaderContent", "hasCustomTopLevelContent", "isSingleTag", "tagInfo", "parseAttribute", "", "parseAttributeExpression", "elementType", "parseAttributeValue", "parseCustomTagContent", "Lfleet/com/intellij/lang/PsiBuilder$Marker;", "xmlText", "parseCustomTagHeaderContent", "parseCustomTopLevelContent", "error", "parseRawTextContents", "parseRawTextContents$svelte_parser", "parseSvelteTag", "svelte-parser"})
public final class SvelteHtmlParsing
extends HtmlParsing {
    public SvelteHtmlParsing(@NotNull PsiBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super(builder);
    }

    private final void parseSvelteTag() {
        boolean bl;
        boolean bl2 = bl = this.token() == SvelteTokenTypes.START_MUSTACHE;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        PsiBuilder psiBuilder = this.getBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)psiBuilder, (String)"getBuilder(...)");
        Pair<IElementType, PsiBuilder.Marker> pair = SvelteTagParsing.INSTANCE.parseTag(psiBuilder);
        IElementType tagToken = (IElementType)pair.component1();
        PsiBuilder.Marker tagMarker = (PsiBuilder.Marker)pair.component2();
        SvelteBlock currentBlock2 = this.getCurrentBlock();
        if (SvelteTagElementTypes.INSTANCE.getSTART_TAGS().contains(tagToken)) {
            PsiBuilder.Marker marker = this.getBuilder().mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            SvelteBlock openedBlock = SvelteBlockParsing.INSTANCE.startBlock(tagToken, tagMarker, marker);
            this.pushItemToStack(openedBlock);
        } else if (SvelteTagElementTypes.INSTANCE.getINNER_TAGS().contains(tagToken)) {
            if (currentBlock2 != null && currentBlock2.isMatchingInnerTag(tagToken)) {
                this.flushIncompleteStackItemsWhile(tagMarker, SvelteHtmlParsing::parseSvelteTag$lambda$0);
                PsiBuilder.Marker marker = this.getBuilder().mark();
                Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
                currentBlock2.handleInnerTag(tagToken, tagMarker, marker);
            } else {
                tagMarker.precede().errorBefore(SvelteBundle.INSTANCE.message("svelte.parsing.error.unexpected.inner.tag", new Object[0]), tagMarker);
            }
        } else if (SvelteTagElementTypes.INSTANCE.getEND_TAGS().contains(tagToken)) {
            if (currentBlock2 != null && currentBlock2.isMatchingEndTag(tagToken)) {
                this.flushIncompleteStackItemsWhile(tagMarker, SvelteHtmlParsing::parseSvelteTag$lambda$1);
                this.completeTopStackItemBefore(tagMarker);
            } else {
                tagMarker.precede().errorBefore(SvelteBundle.INSTANCE.message("svelte.parsing.error.unexpected.end.tag", new Object[0]), tagMarker);
            }
        }
    }

    private final SvelteBlock getCurrentBlock() {
        Ref.ObjectRef result = new Ref.ObjectRef();
        this.processStackItems(arg_0 -> SvelteHtmlParsing._get_currentBlock_$lambda$2((Function1)new Function1<HtmlParsing.HtmlParserStackItem, Boolean>((Ref.ObjectRef<SvelteBlock>)result){
            final /* synthetic */ Ref.ObjectRef<SvelteBlock> $result;
            {
                this.$result = $result;
                super(1);
            }

            @NotNull
            public final Boolean invoke(HtmlParsing.HtmlParserStackItem it) {
                boolean bl;
                if (it instanceof SvelteBlock) {
                    this.$result.element = it;
                    bl = false;
                } else {
                    bl = true;
                }
                return bl;
            }
        }, arg_0));
        return (SvelteBlock)result.element;
    }

    public final void parseRawTextContents$svelte_parser() {
        PsiBuilder.Marker text = null;
        while (!this.getBuilder().eof()) {
            if (Intrinsics.areEqual((Object)this.getBuilder().getTokenType(), (Object)((Object)SvelteTokenTypes.START_MUSTACHE))) {
                PsiBuilder.Marker marker = text;
                if (marker != null) {
                    marker.done(XmlElementType.XML_TEXT);
                }
                text = null;
                this.parseSvelteTag();
                continue;
            }
            if (this.getCurrentBlock() != null && text == null) {
                text = this.getBuilder().mark();
            }
            this.getBuilder().advanceLexer();
        }
        PsiBuilder.Marker marker = text;
        if (marker != null) {
            marker.done(XmlElementType.XML_TEXT);
        }
        this.flushIncompleteStackItemsWhile(SvelteHtmlParsing::parseRawTextContents$lambda$3);
    }

    @NotNull
    protected IElementType getHtmlTagElementType(@NotNull HtmlParsing.HtmlTagInfo info, int tagLevel) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        return SvelteHtmlElementTypes.INSTANCE.getSVELTE_HTML_TAG();
    }

    protected boolean isSingleTag(@NotNull HtmlParsing.HtmlTagInfo tagInfo) {
        Intrinsics.checkNotNullParameter((Object)tagInfo, (String)"tagInfo");
        String string = tagInfo.getOriginalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOriginalName(...)");
        if (UtilsKt.isSvelteComponentTag(string)) {
            return false;
        }
        return super.isSingleTag(tagInfo);
    }

    protected boolean hasCustomTagContent() {
        return this.token() == SvelteTokenTypes.START_MUSTACHE;
    }

    @Nullable
    protected PsiBuilder.Marker parseCustomTagContent(@Nullable PsiBuilder.Marker xmlText) {
        HtmlParsing.terminateText((PsiBuilder.Marker)xmlText);
        this.parseSvelteTag();
        return null;
    }

    protected boolean hasCustomTopLevelContent() {
        return this.hasCustomTagContent();
    }

    @Nullable
    protected PsiBuilder.Marker parseCustomTopLevelContent(@Nullable PsiBuilder.Marker error) {
        HtmlParsing.flushError((PsiBuilder.Marker)error);
        this.parseSvelteTag();
        return null;
    }

    protected boolean hasCustomTagHeaderContent() {
        return this.token() == SvelteTokenTypes.START_MUSTACHE;
    }

    protected void parseCustomTagHeaderContent() {
        PsiBuilder.Marker att = this.mark();
        this.parseAttributeExpression((IElementType)SvelteJSLazyElementTypes.INSTANCE.getSPREAD_OR_SHORTHAND());
        att.done((IElementType)SvelteHtmlElementTypes.INSTANCE.getSVELTE_HTML_ATTRIBUTE());
    }

    protected void parseAttribute() {
        boolean bl;
        boolean bl2 = bl = this.token() == XmlTokenType.XML_NAME;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        PsiBuilder.Marker att = this.mark();
        String attributeName = this.getBuilder().getTokenText();
        this.advance();
        if (this.token() == XmlTokenType.XML_EQ) {
            this.advance();
            String string = attributeName;
            Intrinsics.checkNotNull((Object)string);
            this.parseAttributeValue(SvelteDirectiveUtil.INSTANCE.chooseValueElementType(string));
        }
        att.done((IElementType)SvelteHtmlElementTypes.INSTANCE.getSVELTE_HTML_ATTRIBUTE());
    }

    private final void parseAttributeValue(IElementType elementType) {
        PsiBuilder.Marker attValue = this.mark();
        if (this.token() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            IElementType tt;
            while ((tt = this.token()) != null && tt != XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER && tt != XmlTokenType.XML_END_TAG_START && tt != XmlTokenType.XML_EMPTY_ELEMENT_END && tt != XmlTokenType.XML_START_TAG_START) {
                if (tt == XmlTokenType.XML_BAD_CHARACTER) {
                    PsiBuilder.Marker error = this.mark();
                    this.advance();
                    error.error(XmlPsiBundle.message((String)"xml.parsing.unescaped.ampersand.or.nonterminated.character.entity.reference", (Object[])new Object[0]));
                    continue;
                }
                if (tt == XmlTokenType.XML_ENTITY_REF_TOKEN) {
                    this.parseReference();
                    continue;
                }
                if (tt == SvelteTokenTypes.START_MUSTACHE) {
                    this.parseAttributeExpression(elementType);
                    continue;
                }
                this.advance();
            }
            if (this.token() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
                this.advance();
            } else {
                this.error(XmlPsiBundle.message((String)"xml.parsing.unclosed.attribute.value", (Object[])new Object[0]));
            }
        } else {
            while (this.token() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN || this.token() == SvelteTokenTypes.START_MUSTACHE) {
                if (this.token() == SvelteTokenTypes.START_MUSTACHE) {
                    this.parseAttributeExpression(elementType);
                } else {
                    this.advance();
                }
                PsiBuilder psiBuilder = this.getBuilder();
                Intrinsics.checkNotNullExpressionValue((Object)psiBuilder, (String)"getBuilder(...)");
                if (!UtilsKt.isTokenAfterWhiteSpace(psiBuilder)) continue;
            }
        }
        attValue.done(XmlElementType.XML_ATTRIBUTE_VALUE);
    }

    private final void parseAttributeExpression(IElementType elementType) {
        PsiBuilder.Marker expressionMarker = this.mark();
        this.advance();
        PsiBuilder.Marker marker = this.getBuilder().mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker marker2 = marker;
        if (this.token() == SvelteTokenTypes.CODE_FRAGMENT) {
            this.advance();
        }
        marker2.collapse(elementType);
        this.advance();
        expressionMarker.done((IElementType)SvelteElementTypes.INSTANCE.getATTRIBUTE_EXPRESSION());
    }

    private static final boolean parseSvelteTag$lambda$0(HtmlParsing.HtmlParserStackItem it) {
        return !(it instanceof SvelteBlock);
    }

    private static final boolean parseSvelteTag$lambda$1(HtmlParsing.HtmlParserStackItem it) {
        return !(it instanceof SvelteBlock);
    }

    private static final boolean _get_currentBlock_$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean parseRawTextContents$lambda$3(HtmlParsing.HtmlParserStackItem it) {
        return true;
    }
}

