module fleet.plugins.ai.frontend {
    requires kotlin.stdlib;
    requires kotlinx.coroutines.core;
    requires kotlinx.serialization.core;
    requires kotlinx.serialization.json;
    requires fleet.frontend.ui;
    requires fleet.frontend;
    requires fleet.util.network;
    requires io.ktor.client.core;
    requires io.ktor.http;
    requires io.ktor.utils;
    requires fleet.frontend.lang;
    requires io.ktor.io;
    requires io.ktor.client.cio;
    requires io.ktor.client.auth;
    requires fleet.git.common;
    requires fleet.git.frontend;
    requires fleet.git.protocol;
    requires fleet.run.frontend;
    requires utils.ktor.jvm;
    requires client.ktor.jvm;
    requires io.ktor.server.core;
    requires io.ktor.server.host.common;
    requires io.ktor.server.cio;
    requires markdown.jvm;
    requires fleet.dock.api;
    requires skiko.awt;
    requires scheme;
    requires fleet.preferences;
    requires fleet.code.frontend;
    requires model.auth.jvm;
    requires model.cloud.jvm;
    requires model.llm.jvm;
    requires nlp.encoder.tiktoken.cl100k.base.jvm;
    requires utils.common.jvm;
    requires client.common.jvm;
    requires api.gateway.client.jvm;
    requires model.common.jvm;
    requires nlp.encoder.engine.jvm;
    requires fleet.dock.connectors;
    requires model.qa.jvm;
    requires fleet.reporting.fus.api;
    requires java.naming;
    requires fleet.plugins.authentication.frontend;
    requires fleet.navigation.frontend.api;
    requires utils.jwt.jvm;
    requires auth.model.jvm;
    requires model.quota.jvm;
    requires model.task.jvm;
    requires tbe.config.machine;
    requires fleet.bundles;
    requires code.activity.model.jvm;
    requires code.exec.model.jvm;
    requires code.files.model.jvm;
    requires code.insight.model.jvm;
    requires code.vcs.model.jvm;
    requires code.features.common.jvm;
    requires code.features.terminal.jvm;
    requires code.features.vcs.jvm;
    requires llm.provider.openai.profile.jvm;
    requires util.text.matching;
    requires model.nlp.jvm;
    requires testspark.core;
    requires fleet.common;

    exports fleet.ai.common;
    exports fleet.ai.common.prompts;
    exports fleet.ai.frontend.api;
    exports fleet.ai.frontend.api.agent.common;
    exports fleet.ai.frontend.api.internal to fleet.plugins.aiCompletion.frontend, fleet.plugins.aiCompletionExperimental.frontend, fleet.testspark.frontendImpl, fleet.plugins.grazie.frontend, fleet.plugins.ai.test, fleet.rhizomedb;
    exports fleet.ai.frontend.api.cloud to fleet.plugins.aiCompletion.frontend, fleet.plugins.aiCompletionExperimental.frontend, fleet.testspark.frontendImpl, fleet.plugins.grazie.frontend, fleet.plugins.ai.test, fleet.rhizomedb;
    exports fleet.ai.frontend.providers;
    exports fleet.ai.frontend.providers.document;
    exports fleet.ai.frontend.vcs to fleet.plugins.ai.test;
    exports fleet.ai.frontend.actions to fleet.plugins.ai.test;
    exports fleet.ai.frontend to fleet.plugins.ai.test, fleet.rhizomedb;
    exports fleet.ai.frontend.editor to fleet.plugins.ai.test, fleet.rhizomedb;
    exports fleet.ai.frontend.terminal to fleet.plugins.ai.test, fleet.rhizomedb;
    exports fleet.ai.frontend.auth to fleet.plugins.aiCompletion.frontend, fleet.plugins.ai.test, fleet.rhizomedb;
    exports fleet.ai.frontend.auth.enterprise to fleet.plugins.ai.test, fleet.rhizomedb;
    exports fleet.ai.frontend.functions to fleet.plugins.ai.test, fleet.rhizomedb;
    exports fleet.ai.frontend.api.agent.project;
    exports fleet.ai.frontend.reporting to fleet.plugins.ai.test, fleet.rhizomedb, fleet.plugins.aiCompletion.frontend, fleet.plugins.aiCompletionExperimental.frontend;
    exports fleet.ai.frontend.testspark.api to fleet.plugins.ai.test, fleet.rhizomedb;

    opens fleet.ai.frontend.api.agent.project to kotlin.reflect, kotlinx.serialization.core;
    opens fleet.ai.frontend.api.internal to kotlin.reflect, kotlinx.serialization.core;
    opens fleet.ai.frontend.functions to kotlin.reflect, kotlinx.serialization.core;

    provides Plugin with AiPlugin;

}

